/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.Calendar;
import com.sun.web.ui.component.CalendarMonth;
import com.sun.web.ui.component.ImageHyperlink;
import com.sun.web.ui.renderer.FieldRenderer;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ConversionUtilities;
import com.sun.web.ui.util.MessageUtil;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class CalendarRenderer
extends FieldRenderer {
    private static final boolean DEBUG = false;

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!(component instanceof Calendar)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), Calendar.class.getName()};
            String message = MessageUtil.getMessage("com.sun.web.ui.resources.LogMessages", "Renderer.component", params);
            throw new FacesException(message);
        }
        Calendar calendar = (Calendar)component;
        boolean readOnly = calendar.isReadOnly();
        ResponseWriter writer = context.getResponseWriter();
        String[] styles = this.getStyles(calendar, context);
        String clientId = calendar.getClientId(context);
        this.includeJsFile(writer, calendar, styles[12]);
        this.renderTableStart(calendar, styles[2], context, writer);
        UIComponent label = calendar.getLabelComponent(context, null);
        if (label != null) {
            this.renderCellStart(calendar, styles[6], writer);
            RenderingUtilities.renderComponent(label, context);
            this.renderCellEnd(writer);
        }
        if (readOnly) {
            this.renderCellStart(calendar, styles[6], writer);
            UIComponent text = calendar.getReadOnlyComponent(context);
            RenderingUtilities.renderComponent(text, context);
            if (calendar.getValue() != null) {
                this.renderPattern(calendar, styles[7], styles[2], context, writer);
            }
        } else {
            this.renderCellStart(calendar, styles[4], writer);
            this.renderInput(calendar, "text", clientId.concat("_field"), false, styles, context, writer);
            writer.write("\n");
            this.renderPattern(calendar, styles[7], styles[2], context, writer);
        }
        this.renderCellEnd(writer);
        if (!readOnly) {
            this.renderCellStart(calendar, styles[5], writer);
            ImageHyperlink link = calendar.getDatePickerLink(context);
            writer.startElement("span", (UIComponent)calendar);
            if (calendar.isDisabled()) {
                writer.writeAttribute("style", (Object)"display:none;", null);
            }
            writer.write("\n");
            link.setIcon(styles[14]);
            link.setAlt(styles[13]);
            RenderingUtilities.renderComponent((UIComponent)link, context);
            writer.endElement("span");
            writer.write("\n");
            this.renderCellEnd(writer);
        }
        this.renderTableEnd(writer);
        writer.writeText((Object)"\n", null);
        if (!readOnly) {
            CalendarMonth datePicker = calendar.getDatePicker();
            Object value = calendar.getSubmittedValue();
            if (value != null) {
                try {
                    Object dO = ConversionUtilities.convertValueToObject((UIComponent)calendar, (String)value, context);
                    datePicker.setValue(dO);
                }
                catch (Exception ex) {}
            } else if (calendar.getValue() != null) {
                datePicker.setValue(calendar.getValue());
            }
            datePicker.initCalendarControls(calendar.getJavaScriptObjectName(context));
            RenderingUtilities.renderComponent((UIComponent)datePicker, context);
            writer.write(this.getJavaScriptInitializer(calendar, styles, context));
        }
    }

    private void renderTableStart(Calendar calendar, String hiddenStyle, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("table", (UIComponent)calendar);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("title", (Object)"", null);
        writer.writeAttribute("id", (Object)calendar.getClientId(context), "id");
        String style = calendar.getStyle();
        if (style != null && style.length() > 0) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if ((style = this.getStyleClass(calendar, hiddenStyle)) != null) {
            writer.writeAttribute("class", (Object)style, "class");
        }
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)calendar);
        writer.writeText((Object)"\n", null);
    }

    private void renderCellStart(Calendar calendar, String style, ResponseWriter writer) throws IOException {
        writer.startElement("td", (UIComponent)calendar);
        writer.writeAttribute("valign", (Object)"top", null);
        writer.writeText((Object)"\n", null);
        writer.startElement("span", (UIComponent)calendar);
        writer.writeAttribute("class", (Object)style, null);
        writer.writeText((Object)"\n", null);
    }

    private void renderCellEnd(ResponseWriter writer) throws IOException {
        writer.writeText((Object)"\n", null);
        writer.endElement("span");
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
    }

    private void renderTableEnd(ResponseWriter writer) throws IOException {
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
    }

    private void renderPattern(Calendar calendar, String styleClass, String hiddenStyle, FacesContext context, ResponseWriter writer) throws IOException {
        String pattern = calendar.getDateFormatPatternHelp();
        if (pattern == null) {
            pattern = calendar.getDatePicker().getDateFormatPattern().toLowerCase();
        }
        if (pattern != null) {
            writer.startElement("br", (UIComponent)calendar);
            writer.endElement("br");
            writer.startElement("span", (UIComponent)calendar);
            String id = calendar.getClientId(context);
            id = id.concat("_pattern");
            writer.writeAttribute("id", (Object)id, null);
            String style = styleClass;
            if (calendar.isDisabled()) {
                style = style.concat(" ").concat(hiddenStyle);
            }
            writer.writeAttribute("class", (Object)style, null);
            writer.write(pattern);
            writer.endElement("span");
        }
    }

    private String getJavaScriptInitializer(Calendar calendar, String[] styles, FacesContext context) {
        String jsName = calendar.getJavaScriptObjectName(context);
        StringBuffer js = new StringBuffer(300);
        js.append("\n<script type=\"text/javascript\">\nvar ").append(jsName).append(" = new ui_Calendar(");
        int firstDay = calendar.getDatePicker().getCalendar().getFirstDayOfWeek();
        String day = null;
        if (firstDay == 1) {
            day = "0";
        } else if (firstDay == 2) {
            day = "1";
        } else if (firstDay == 6) {
            day = "5";
        } else if (firstDay == 7) {
            day = "6";
        } else if (firstDay == 3) {
            day = "2";
        } else if (firstDay == 4) {
            day = "3";
        } else if (firstDay == 5) {
            day = "4";
        }
        js.append(day).append(", '");
        js.append(calendar.getClientId(context).concat("_field")).append("', '");
        js.append(calendar.getClientId(context).concat("_pattern")).append("', '");
        js.append(calendar.getDatePickerLink(context).getClientId(context)).append("', '");
        String id = calendar.getDatePicker().getClientId(context);
        js.append(id).append("', '");
        js.append(calendar.getDatePicker().getMonthMenu().getClientId(context)).append("', '");
        js.append(calendar.getDatePicker().getYearMenu().getClientId(context)).append("', '");
        js.append(id).append(":row5").append("', '");
        js.append(styles[8]).append("', '");
        js.append(styles[9]).append("', '");
        js.append(calendar.getDatePicker().getDateFormatPattern()).append("', '");
        js.append(styles[10]).append("', '");
        js.append(styles[11]).append("', '");
        js.append(styles[15]).append("', '");
        js.append(styles[16]).append("', '");
        js.append(styles[17]).append("', '");
        js.append(styles[2]).append("');\n</script>\n");
        return js.toString();
    }

    private void includeJsFile(ResponseWriter writer, Calendar calendar, String src) throws IOException {
        writer.startElement("script", (UIComponent)calendar);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("src", (Object)src, null);
        writer.endElement("script");
        writer.write("\n");
    }

    String[] getStyles(Calendar calendar, FacesContext context) {
        Theme theme = ThemeUtilities.getTheme(context);
        String[] styles = new String[]{theme.getStyleClass("TxtFld"), theme.getStyleClass("TxtFldDis"), theme.getStyleClass("hidden"), "", "", theme.getStyleClass("CalPopFldImg"), theme.getStyleClass("CalPopFldLbl"), theme.getStyleClass("HlpFldTxt"), theme.getIcon("CALENDAR_BUTTON").getUrl(), theme.getIcon("CALENDAR_BUTTON_FLIP").getUrl(), theme.getStyleClass("DatLnk"), theme.getStyleClass("DatOthLnk"), theme.getPathToJSFile("calendar"), theme.getMessage("calendar.popupImageAlt"), "CALENDAR_BUTTON", theme.getStyleClass("DatBldLnk"), theme.getStyleClass("DatOthBldLnk"), theme.getStyleClass("DatCurLnk")};
        return styles;
    }
}

