/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.Button;
import com.sun.web.ui.component.Icon;
import com.sun.web.ui.renderer.AbstractRenderer;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ConversionUtilities;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;

public class ButtonRenderer
extends AbstractRenderer {
    private static final String[] integerAttributes = new String[]{"tabIndex"};
    private static final String[] stringAttributes = new String[]{"dir", "lang", "onClick", "onDblClick", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseUp", "onMouseMove", "style"};
    private static final String[] inputAttributes = new String[]{"alt", "align"};

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Button button = (Button)component;
        if (button.isReset()) {
            return;
        }
        String clientId = button.getClientId(context);
        Map map = context.getExternalContext().getRequestParameterMap();
        if (map.containsKey(clientId) || map.containsKey(clientId + ".x") && map.containsKey(clientId + ".y")) {
            button.queueEvent((FacesEvent)new ActionEvent((UIComponent)button));
            RenderingUtilities.setLastClientID(context, button.getPrimaryElementID(context));
        }
    }

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Button button = (Button)component;
        if (button.isEscape()) {
            writer.startElement("input", (UIComponent)button);
        } else {
            writer.startElement("button", (UIComponent)button);
        }
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Button button = (Button)component;
        writer.writeAttribute("id", (Object)button.getClientId(context), null);
        writer.writeAttribute("name", (Object)button.getClientId(context), null);
        String style = this.getStyle(button, ThemeUtilities.getTheme(context));
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)button, style);
        String js = this.getJavascript(button.getOnBlur(), "onblur");
        if (js != null) {
            writer.writeAttribute("onblur", (Object)js, "onBlur");
        }
        if ((js = this.getJavascript(button.getOnFocus(), "onfocus")) != null) {
            writer.writeAttribute("onfocus", (Object)js, "onFocus");
        }
        if ((js = this.getJavascript(button.getOnMouseOut(), "onmouseout")) != null) {
            writer.writeAttribute("onmouseout", (Object)js, "onMouseOut");
        }
        if ((js = this.getJavascript(button.getOnMouseOver(), "onmouseover")) != null) {
            writer.writeAttribute("onmouseover", (Object)js, "onMouseOver");
        }
        if (button.getToolTip() != null) {
            writer.writeAttribute("title", (Object)button.getToolTip(), "toolTip");
        }
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        this.addIntegerAttributes(context, component, writer, integerAttributes);
        ButtonRenderer.addStringAttributes(context, component, writer, stringAttributes);
        if (button.isEscape()) {
            ButtonRenderer.addStringAttributes(context, component, writer, inputAttributes);
        }
        String imageURL = button.getImageURL();
        String icon = button.getIcon();
        if (imageURL != null) {
            this.renderImageURLAttributes(context, component, writer, imageURL);
        } else if (icon != null) {
            this.renderIconAttributes(context, component, writer, icon);
        } else {
            this.renderTextAttributes(context, component, writer);
        }
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Button button = (Button)component;
        if (button.isEscape()) {
            writer.endElement("input");
        } else {
            writer.endElement("button");
        }
        StringBuffer jsBuffer = new StringBuffer(200);
        jsBuffer.append("sjwuic_assign_button(");
        jsBuffer.append("'");
        jsBuffer.append(button.getClientId(context));
        jsBuffer.append("', ");
        jsBuffer.append(button.getImageURL() != null || button.getIcon() != null ? "defaultImgButtonStrings" : "defaultButtonStrings");
        jsBuffer.append(", ");
        jsBuffer.append(!button.isPrimary());
        jsBuffer.append(", ");
        jsBuffer.append(button.isMini());
        jsBuffer.append(", ");
        jsBuffer.append(button.isDisabled());
        jsBuffer.append(");");
        writer.startElement("script", (UIComponent)button);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)jsBuffer.toString(), null);
        writer.endElement("script");
    }

    protected void renderIconAttributes(FacesContext context, UIComponent component, ResponseWriter writer, String icon) throws IOException {
        Button button = (Button)component;
        Icon child = ThemeUtilities.getTheme(context).getIcon(icon);
        writer.writeAttribute("type", (Object)"image", null);
        RenderingUtilities.renderURLAttribute(context, writer, component, "src", child.getUrl(), "icon");
    }

    protected void renderImageURLAttributes(FacesContext context, UIComponent component, ResponseWriter writer, String url) throws IOException {
        Button button = (Button)component;
        url = context.getApplication().getViewHandler().getResourceURL(context, url);
        writer.writeAttribute("type", (Object)"image", null);
        RenderingUtilities.renderURLAttribute(context, writer, component, "src", url, "imageURL");
    }

    protected void renderTextAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Button button = (Button)component;
        if (button.isReset()) {
            writer.writeAttribute("type", (Object)"reset", null);
        } else {
            writer.writeAttribute("type", (Object)"submit", null);
        }
        String text = ConversionUtilities.convertValueToString((UIComponent)button, button.getValue());
        if (text == null || text.trim().length() == 0) {
            return;
        }
        if (!button.isNoTextPadding()) {
            if (text.trim().length() <= 3) {
                text = "  " + text + "  ";
            } else if (text.trim().length() == 4) {
                text = " " + text + " ";
            }
        }
        if (button.isEscape()) {
            writer.writeAttribute("value", (Object)text, "text");
        } else {
            writer.write(text);
        }
    }

    protected String getOnBlurStyle(Button button, Theme theme) {
        String style = null;
        style = button.getImageURL() != null || button.getIcon() != null ? theme.getStyleClass("Btn3") : (button.isMini() && !button.isPrimary() ? theme.getStyleClass("Btn2Mni") : (button.isMini() ? theme.getStyleClass("Btn1Mni") : (!button.isPrimary() ? theme.getStyleClass("Btn2") : theme.getStyleClass("Btn1"))));
        return style;
    }

    protected String getOnFocusStyle(Button button, Theme theme) {
        String style = null;
        style = button.getImageURL() != null || button.getIcon() != null ? theme.getStyleClass("Btn3Hov") : (button.isMini() && !button.isPrimary() ? theme.getStyleClass("Btn2MniHov") : (button.isMini() ? theme.getStyleClass("Btn1MniHov") : (!button.isPrimary() ? theme.getStyleClass("Btn2Hov") : theme.getStyleClass("Btn1Hov"))));
        return style;
    }

    protected String getOnMouseOverStyle(Button button, Theme theme) {
        return this.getOnFocusStyle(button, theme);
    }

    protected String getOnMouseOutStyle(Button button, Theme theme) {
        return this.getOnBlurStyle(button, theme);
    }

    protected String getStyle(Button button, Theme theme) {
        String style = button.getImageURL() != null || button.getIcon() != null ? "Btn3" : (button.isMini() && !button.isPrimary() ? (button.isDisabled() ? theme.getStyleClass("Btn2MniDis") : theme.getStyleClass("Btn2Mni")) : (button.isMini() ? (button.isDisabled() ? theme.getStyleClass("Btn1MniDis") : theme.getStyleClass("Btn1Mni")) : (!button.isPrimary() ? (button.isDisabled() ? theme.getStyleClass("Btn2Dis") : theme.getStyleClass("Btn2")) : (button.isDisabled() ? theme.getStyleClass("Btn1Dis") : theme.getStyleClass("Btn1")))));
        return style;
    }

    protected String getJavascript(String value, String jsmethod) {
        if (jsmethod == null) {
            return value;
        }
        String event = "return this.my" + jsmethod + "();";
        return value != null ? value + ";" + event : event;
    }
}

