/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.Breadcrumbs;
import com.sun.web.ui.component.Hyperlink;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.LogUtil;
import com.sun.web.ui.util.MessageUtil;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class BreadcrumbsRenderer
extends Renderer {
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (null == context || null == component) {
            throw new NullPointerException();
        }
        if (!(component instanceof Breadcrumbs)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), Breadcrumbs.class.getName()};
            String message = MessageUtil.getMessage("com.sun.web.ui.resources.LogMessages", "Renderer.component", params);
            throw new FacesException(message);
        }
        if (!component.isRendered()) {
            return;
        }
        if (component.getChildCount() <= 0) {
            if (LogUtil.infoEnabled(BreadcrumbsRenderer.class)) {
                LogUtil.info((Object)BreadcrumbsRenderer.class, "Breadcrumbs.noChildren", component.getId());
            }
            return;
        }
        Breadcrumbs breadcrumbs = (Breadcrumbs)component;
        Theme theme = ThemeUtilities.getTheme(context);
        ResponseWriter writer = context.getResponseWriter();
        this.renderContainingDiv(context, breadcrumbs, theme, writer);
        Iterator crumbs = breadcrumbs.getChildren().iterator();
        while (crumbs.hasNext()) {
            Hyperlink crumb = (Hyperlink)crumbs.next();
            if (crumbs.hasNext()) {
                this.renderBreadcrumbsLink(context, crumb, theme);
                this.renderBreadcrumbsSeparator(context, breadcrumbs, theme, writer);
                continue;
            }
            this.renderBreadcrumbsText(context, crumb, theme, writer);
        }
    }

    protected void renderContainingDiv(FacesContext context, Breadcrumbs breadcrumbs, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement("div", (UIComponent)breadcrumbs);
        writer.writeAttribute("id", (Object)breadcrumbs.getClientId(context), "id");
        String tdStyle = theme.getStyleClass("BcmWhtDiv");
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)breadcrumbs, tdStyle);
        if (breadcrumbs.getStyle() != null) {
            writer.writeAttribute("style", (Object)breadcrumbs.getStyle(), "style");
        }
        writer.writeText((Object)"\n", null);
    }

    protected void renderBreadcrumbsSeparator(FacesContext context, Breadcrumbs breadcrumbs, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement("span", (UIComponent)breadcrumbs);
        String separatorStyle = theme.getStyleClass("BcmSep");
        writer.writeAttribute("class", (Object)separatorStyle, null);
        writer.write("&gt;");
        writer.endElement("span");
    }

    protected void renderBreadcrumbsLink(FacesContext context, Hyperlink link, Theme theme) throws IOException {
        String linkStyle = theme.getStyleClass("BcmLnk");
        Map attributes = link.getAttributes();
        if (attributes != null && attributes.get("styleClass") == null) {
            attributes.put("styleClass", linkStyle);
        }
        RenderingUtilities.renderComponent((UIComponent)link, context);
    }

    protected void renderBreadcrumbsText(FacesContext context, Hyperlink crumb, Theme theme, ResponseWriter writer) throws IOException {
        String pageName = crumb.getText();
        if (pageName == null || pageName.length() <= 0) {
            return;
        }
        writer.startElement("span", (UIComponent)crumb);
        String textStyle = theme.getStyleClass("BcmTxt");
        writer.writeAttribute("class", (Object)textStyle, null);
        writer.writeText((Object)pageName, null);
        writer.endElement("span");
        writer.endElement("div");
    }
}

