/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.sun.web.ui.component.Wizard;
import com.sun.web.ui.component.WizardBranch;
import com.sun.web.ui.component.WizardBranchSteps;
import com.sun.web.ui.component.WizardStep;
import com.sun.web.ui.component.WizardSubstepBranch;
import com.sun.web.ui.event.WizardEvent;
import com.sun.web.ui.model.WizardModel;
import com.sun.web.ui.model.WizardStepList;
import com.sun.web.ui.model.WizardStepListBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.faces.context.FacesContext;

public class WizardModelBase
implements WizardModel {
    private ArrayList wizardSteps;
    private WizardState wizardState = new WizardState();
    private WizardStepList wizardStepList;

    public Object saveState(FacesContext context) {
        Object[] state = new Object[3];
        int i = 0;
        state[i++] = new Integer(this.wizardState.getState());
        state[i++] = new Integer(this.wizardState.getCurrentStep());
        state[i++] = this.wizardState.getHasStepHelp();
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] _state = (Object[])state;
        int i = 0;
        this.wizardState.setState((Integer)_state[i++]);
        this.wizardState.setCurrentStep((Integer)_state[i++]);
        this.wizardState.setHasStepHelp((Boolean)_state[i++]);
    }

    public void setTransient(boolean transientFlag) {
    }

    public boolean isTransient() {
        return false;
    }

    public WizardModelBase(Wizard wizard) {
    }

    public void initialize(Wizard wizard) {
        this.wizardSteps = new ArrayList();
        List steps = (List)wizard.getSteps();
        if (steps == null) {
            steps = wizard.getChildren();
        }
        ListIterator childIterator = steps.listIterator();
        this.buildStepList(childIterator, this.wizardSteps);
        this.wizardStepList = new WizardStepListBase(this);
    }

    protected void buildStepList(ListIterator childIterator, ArrayList wizardSteps) {
        Object step = null;
        while (childIterator.hasNext()) {
            step = childIterator.next();
            if (step instanceof WizardBranch) {
                WizardBranch branch = (WizardBranch)((Object)step);
                if (branch.isTaken()) {
                    this.buildStepList(branch.getChildren().listIterator(), wizardSteps);
                    continue;
                }
                wizardSteps.add(step);
                break;
            }
            if (step instanceof WizardBranchSteps) {
                WizardBranchSteps branchSteps = (WizardBranchSteps)((Object)step);
                if (!branchSteps.isTaken()) continue;
                this.buildStepList(branchSteps.getChildren().listIterator(), wizardSteps);
                continue;
            }
            if (step instanceof WizardSubstepBranch) {
                WizardSubstepBranch substep = (WizardSubstepBranch)((Object)step);
                if (!substep.isTaken()) continue;
                this.buildStepList(substep.getChildren().listIterator(), wizardSteps);
                continue;
            }
            if (!(step instanceof WizardStep)) continue;
            if (this.wizardState.getHasStepHelp() == null && ((WizardStep)((Object)step)).getHelp() != null) {
                this.wizardState.setHasStepHelp(Boolean.TRUE);
            }
            wizardSteps.add(step);
        }
    }

    public Iterator getWizardStepIterator() {
        return this.wizardSteps.iterator();
    }

    public WizardStepList getWizardStepList() {
        return this.wizardStepList;
    }

    public WizardStep getFirstStep() {
        return (WizardStep)((Object)this.wizardSteps.get(0));
    }

    public WizardStep getLastStep() {
        return (WizardStep)((Object)this.wizardSteps.get(this.wizardSteps.size() - 1));
    }

    protected int getStepIndex(String id) {
        for (int i = 0; i < this.wizardSteps.size(); ++i) {
            WizardStep step = (WizardStep)((Object)this.wizardSteps.get(i));
            if (!id.equals(step.getId())) continue;
            return i;
        }
        return this.wizardState.getCurrentStep();
    }

    public WizardStep getNextStep(WizardStep step) {
        WizardStep next = null;
        try {
            int i = this.wizardSteps.indexOf((Object)step);
            if (i != -1) {
                next = (WizardStep)((Object)this.wizardSteps.get(++i));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return next;
    }

    public WizardStep getPreviousStep(WizardStep step) {
        WizardStep previous = null;
        try {
            int i = this.wizardSteps.indexOf((Object)step);
            if (i != -1) {
                previous = (WizardStep)((Object)this.wizardSteps.get(--i));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return previous;
    }

    public WizardStep getCurrentStep() {
        WizardStep step = null;
        try {
            step = (WizardStep)((Object)this.wizardSteps.get(this.wizardState.getCurrentStep()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return step;
    }

    public boolean isCurrentStep(WizardStep step) {
        boolean result = false;
        try {
            int i = this.wizardSteps.indexOf((Object)step);
            result = this.wizardState.getCurrentStep() == i;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean isFinishStep(WizardStep step) {
        return step.isFinish();
    }

    public boolean isResultsStep(WizardStep step) {
        return step.isResults();
    }

    public boolean isBranch(WizardStep step) {
        return step instanceof WizardBranch;
    }

    public String getPlaceholderText(WizardStep step) {
        return ((WizardBranch)step).getPlaceholderText();
    }

    public boolean isSubstep(WizardStep step) {
        return step.getParent() instanceof WizardSubstepBranch;
    }

    public boolean canGotoStep(WizardStep step) {
        int i = this.wizardSteps.indexOf((Object)step);
        return this.wizardState.getCurrentStep() > i;
    }

    public boolean isPreviousDisabled(WizardStep step) {
        WizardStep first = this.getFirstStep();
        return first.getId().equals(step.getId());
    }

    public boolean isNextDisabled(WizardStep step) {
        return false;
    }

    public boolean isFinishDisabled(WizardStep step) {
        return false;
    }

    public boolean isCancelDisabled(WizardStep step) {
        return false;
    }

    public boolean isCloseDisabled(WizardStep step) {
        return false;
    }

    public boolean hasPrevious(WizardStep step) {
        return !this.isResultsStep(step);
    }

    public boolean hasNext(WizardStep step) {
        return !this.isFinishStep(step) && !this.isResultsStep(step);
    }

    public boolean hasCancel(WizardStep step) {
        return !this.isResultsStep(step);
    }

    public boolean hasClose(WizardStep step) {
        return this.isResultsStep(step);
    }

    public boolean hasFinish(WizardStep step) {
        return this.isFinishStep(step);
    }

    public boolean hasStepHelp() {
        return this.wizardState.getHasStepHelp() == null ? false : this.wizardState.getHasStepHelp();
    }

    public boolean isComplete() {
        return this.wizardState.isComplete();
    }

    public void complete() {
        this.wizardSteps = null;
        this.wizardState.reset();
    }

    public boolean decode(int event, boolean prematureRender) {
        return prematureRender ? false : this.wizardState.decode(event);
    }

    public boolean validate(int event, boolean prematureRender) {
        return prematureRender ? false : this.wizardState.validate(event);
    }

    public boolean update(int event, boolean prematureRender) {
        return prematureRender ? false : this.wizardState.update(event);
    }

    public boolean handleEvent(WizardEvent event) {
        boolean returnValue = true;
        switch (event.getNavigationEvent()) {
            case 6: {
                this.wizardState.nextStep();
                break;
            }
            case 7: {
                this.wizardState.previousStep();
                break;
            }
            case 2: {
                int i = this.wizardState.getCurrentStep() + 1;
                if (i == this.wizardSteps.size()) {
                    this.wizardState.close();
                    break;
                }
                this.wizardState.finishStep();
                break;
            }
            case 3: {
                String gotoStepId = event.getGotoStepId();
                if (gotoStepId == null) break;
                int index = this.getStepIndex(gotoStepId);
                this.wizardState.gotoStep(index);
                break;
            }
            case 0: {
                this.wizardState.cancel();
                break;
            }
            case 1: {
                this.wizardState.close();
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
        }
        return returnValue;
    }

    class WizardState {
        static final int START = -1;
        static final int NEXT = 0;
        static final int PREVIOUS = 1;
        static final int CANCEL = 2;
        static final int FINISH = 3;
        static final int CLOSE = 4;
        static final int GOTOSTEP = 7;
        int state = -1;
        int currentStep = 0;
        Boolean hasStepHelp;

        WizardState() {
        }

        int getState() {
            return this.state;
        }

        void setState(int state) {
            this.state = state;
        }

        Boolean getHasStepHelp() {
            return this.hasStepHelp;
        }

        void setHasStepHelp(Boolean hasStepHelp) {
            this.hasStepHelp = hasStepHelp;
        }

        boolean isComplete() {
            return this.state == 4 || this.state == 2;
        }

        boolean decode(int event) {
            return true;
        }

        boolean validate(int event) {
            return event == 2 || event == 6 || event == 12;
        }

        boolean update(int event) {
            return event == 2 || event == 6 || event == 12;
        }

        void nextStep() {
            this.state = 0;
            ++this.currentStep;
        }

        void finishStep() {
            this.state = 3;
            ++this.currentStep;
        }

        void previousStep() {
            this.state = 1;
            --this.currentStep;
        }

        void gotoStep(int step) {
            this.state = 7;
            this.currentStep = step;
        }

        int getCurrentStep() {
            return this.currentStep;
        }

        void setCurrentStep(int currentStep) {
            this.currentStep = currentStep;
        }

        void reset() {
            this.state = -1;
            this.currentStep = 0;
        }

        void cancel() {
            this.state = 2;
        }

        void close() {
            this.state = 4;
        }
    }
}

