/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.Button;
import com.sun.web.ui.component.Hyperlink;
import com.sun.web.ui.component.Icon;
import com.sun.web.ui.component.StaticText;
import com.sun.web.ui.component.Tab;
import com.sun.web.ui.component.TabSet;
import com.sun.web.ui.component.WizardBase;
import com.sun.web.ui.component.WizardBranch;
import com.sun.web.ui.component.WizardStep;
import com.sun.web.ui.component.util.Util;
import com.sun.web.ui.event.WizardActionListener;
import com.sun.web.ui.event.WizardEvent;
import com.sun.web.ui.event.WizardEventListener;
import com.sun.web.ui.model.WizardModel;
import com.sun.web.ui.model.WizardModelBase;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ComponentUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;

public class Wizard
extends WizardBase
implements NamingContainer {
    private boolean stepTabActive = true;
    private transient int navigationEvent = 12;
    private transient UIComponent eventSource;
    private transient String gotoStepId;
    private static final String MODEL = "model";
    private static final Boolean WIZARD_TRUE = Boolean.TRUE;
    private static final Boolean WIZARD_FALSE = Boolean.FALSE;
    private static final String RESULTS_FACET = "results";
    private static final String NEXT_FACET = "next";
    private static final String PREVIOUS_FACET = "previous";
    private static final String FINISH_FACET = "finish";
    private static final String CANCEL_FACET = "cancel";
    private static final String CLOSE_FACET = "close";
    private static final String TABS_FACET = "tabs";
    private static final String TITLE_FACET = "title";
    private static final String INDICATOR_FACET = "stepIndicator";
    private static final String STEPS_PANE_TITLE = "stepsPaneTitle";
    private static final String USCORE = "_";
    private static final String STEP_TEXT = "stptxt";
    private static final String STEP_NUM = "stpnum";
    private static final String STEP_LINK = "stplnk";
    private static final String STEP_HELP = "stphlp";
    private static final String STEP_TITLE = "stpttl";
    private static final String STEP_TITLE_LABEL = "stpttllbl";
    private static final String STEP_DETAIL = "stpdtl";
    private static final String STEP_SUMMARY = "stpsmmy";
    private static final String STEP_PLACEHLDR = "stpplhld";
    private static final String STEP_TAB = "stptb";
    private static final String HELP_TAB = "hlptb";
    private static final String DISABLED_ATTR = "disabled";
    private static final String IMMEDIATE_ATTR = "immediate";
    private static final String MINI_ATTR = "mini";
    private static final String ESCAPE_ATTR = "escape";
    private static final String ONCLICK_ATTR = "onClick";
    private static final String WIZARD_CANCEL = "Wizard.cancel";
    private static final String WIZARD_CLOSE = "Wizard.close";
    private static final String WIZARD_FINISH = "Wizard.finish";
    private static final String WIZARD_NEXT = "Wizard.next";
    private static final String WIZARD_PREVIOUS = "Wizard.previous";
    private static final String WIZARD_STEP_TITLE_LABEL = "Wizard.stepTitleLabel";
    private static final String WIZARD_STEP_TAB = "Wizard.stepTab";
    private static final String WIZARD_HELP_TAB = "Wizard.helpTab";
    private static final String WIZARD_SKIP_LINK_ALT = "Wizard.skipLinkAlt";
    private static final String WIZARD_CURRENT_STEP_ALT = "Wizard.currentStepAlt";
    private static final String WIZARD_TAB_TOOLTIP = "Wizard.tabToolTip";
    private static final String WIZARD_PLACEHOLDER_TEXT = "Wizard.placeholderText";
    private static final String WIZARD_STEPS_PANE_TITLE = "Wizard.stepsPaneTitle";

    public WizardModel getModel() {
        WizardModel wm = super.getModel();
        if (wm == null) {
            wm = new WizardModelBase(this);
            this.setModel(wm);
        }
        return wm;
    }

    private boolean prematureRender() {
        return this.getFacesContext().getRenderResponse();
    }

    public void decode(FacesContext context) {
        super.decode(context);
        WizardEvent wizardEvent = new WizardEvent(this);
        wizardEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
        this.queueEvent(wizardEvent);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        this.decodeControls(context);
        this.decodeStep(context);
    }

    protected void decodeControls(FacesContext context) {
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            Object currentStep = null;
            UIComponent kid = (UIComponent)kids.next();
            if (kid instanceof WizardStep) continue;
            kid.processDecodes(context);
        }
    }

    protected void decodeStep(FacesContext context) {
        WizardModel wizardModel = this.getModel();
        if (wizardModel.decode(this.navigationEvent, this.prematureRender())) {
            wizardModel.getCurrentStep().processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.validateControls(context);
        this.validateStep(context);
    }

    protected void validateControls(FacesContext context) {
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (kid instanceof WizardStep) continue;
            kid.processValidators(context);
        }
    }

    protected void validateStep(FacesContext context) {
        WizardModel wizardModel = this.getModel();
        if (wizardModel.validate(this.navigationEvent, this.prematureRender())) {
            wizardModel.getCurrentStep().processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.updateControls(context);
        this.updateStep(context);
    }

    protected void updateControls(FacesContext context) {
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (kid instanceof WizardStep) continue;
            kid.processUpdates(context);
        }
    }

    protected void updateStep(FacesContext context) {
        WizardModel wizardModel = this.getModel();
        if (wizardModel.update(this.navigationEvent, this.prematureRender())) {
            wizardModel.getCurrentStep().processUpdates(context);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeBegin(context, (UIComponent)this);
        }
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        this.getModel().initialize(this);
        if (!this.isRendered()) {
            return;
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeChildren(context, (UIComponent)this);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeEnd(context, (UIComponent)this);
        }
        if (this.isComplete()) {
            this.getModel().complete();
        }
        this.navigationEvent = 12;
    }

    public Iterator getStepListIterator() {
        return this.getModel().getWizardStepList().iterator();
    }

    public boolean isComplete() {
        return this.getModel().isComplete();
    }

    public boolean isCurrentStep(WizardStep step) {
        return this.getModel().isCurrentStep(step);
    }

    public WizardStep getCurrentStep() {
        return this.getModel().getCurrentStep();
    }

    public boolean hasStepHelp() {
        return this.getModel().hasStepHelp();
    }

    public boolean hasClose() {
        WizardModel wm = this.getModel();
        return wm.hasClose(wm.getCurrentStep());
    }

    public boolean hasNext() {
        WizardModel wm = this.getModel();
        return wm.hasNext(wm.getCurrentStep());
    }

    public boolean hasPrevious() {
        WizardModel wm = this.getModel();
        return wm.hasPrevious(wm.getCurrentStep());
    }

    public boolean hasFinish() {
        WizardModel wm = this.getModel();
        return wm.hasFinish(wm.getCurrentStep());
    }

    public boolean hasCancel() {
        WizardModel wm = this.getModel();
        return wm.hasCancel(wm.getCurrentStep());
    }

    public boolean isCloseDisabled() {
        WizardModel wm = this.getModel();
        return wm.isCloseDisabled(wm.getCurrentStep());
    }

    public boolean isNextDisabled() {
        WizardModel wm = this.getModel();
        return wm.isNextDisabled(wm.getCurrentStep());
    }

    public boolean isPreviousDisabled() {
        WizardModel wm = this.getModel();
        return wm.isPreviousDisabled(wm.getCurrentStep());
    }

    public boolean isFinishDisabled() {
        WizardModel wm = this.getModel();
        return wm.isFinishDisabled(wm.getCurrentStep());
    }

    public boolean isCancelDisabled() {
        WizardModel wm = this.getModel();
        return wm.isCancelDisabled(wm.getCurrentStep());
    }

    public boolean isStepsTabActive() {
        return this.stepTabActive || !this.hasStepHelp();
    }

    public String getCurrentStepNumberString() {
        return this.getModel().getWizardStepList().getCurrentStepNumberString();
    }

    public UIComponent getCancelComponent() {
        return this.getButtonComponent(CANCEL_FACET, WIZARD_CANCEL, this.isCancelDisabled(), 0, true, this.getJavaScript(0), false);
    }

    public UIComponent getCloseComponent() {
        return this.getButtonComponent(CLOSE_FACET, WIZARD_CLOSE, this.isCloseDisabled(), 1, true, this.getJavaScript(1), true);
    }

    public UIComponent getFinishComponent() {
        return this.getButtonComponent(FINISH_FACET, WIZARD_FINISH, this.isFinishDisabled(), 2, true, this.getJavaScript(2), true);
    }

    public UIComponent getNextComponent() {
        return this.getButtonComponent(NEXT_FACET, WIZARD_NEXT, this.isNextDisabled(), 6, true, this.getJavaScript(6), true);
    }

    public UIComponent getPreviousComponent() {
        return this.getButtonComponent(PREVIOUS_FACET, WIZARD_PREVIOUS, this.isPreviousDisabled(), 7, true, this.getJavaScript(7), false);
    }

    protected UIComponent getButtonComponent(String facetName, String textKey, boolean disabled, int wizardEvent, boolean immediate, String javascript) {
        return this.getButtonComponent(facetName, textKey, disabled, wizardEvent, immediate, javascript, true);
    }

    protected UIComponent getButtonComponent(String facetName, String textKey, boolean disabled, int wizardEvent, boolean immediate, String javascript, boolean primary) {
        Button button = (Button)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (button == null) {
            button = new Button();
            button.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
            button.setImmediate(immediate);
            button.setPrimary(primary);
            button.addActionListener(new WizardActionListener(this.getId(), wizardEvent));
            ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)button);
        }
        Theme theme = ThemeUtilities.getTheme(this.getFacesContext());
        button.setText(theme.getMessage(textKey));
        button.setDisabled(disabled);
        if (javascript != null) {
            button.setOnClick(javascript);
        }
        return button;
    }

    public UIComponent getTabsComponent() {
        return this.getModel().hasStepHelp() ? this.getTabsComponent(TABS_FACET) : null;
    }

    protected UIComponent getTabsComponent(String facetName) {
        Theme theme = ThemeUtilities.getTheme(this.getFacesContext());
        TabSet tabSet = (TabSet)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (tabSet == null) {
            tabSet = new TabSet();
            tabSet.setImmediate(true);
            tabSet.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
            tabSet.setMini(true);
            List tabs = tabSet.getChildren();
            Tab steptab = this.getTab(theme, STEP_TAB, WIZARD_STEP_TAB, WIZARD_TAB_TOOLTIP, 8, this.stepTabActive, true, this.getJavaScript(8));
            tabs.add(steptab);
            Tab helptab = this.getTab(theme, HELP_TAB, WIZARD_HELP_TAB, WIZARD_TAB_TOOLTIP, 4, !this.stepTabActive, true, this.getJavaScript(4));
            tabs.add(helptab);
            tabSet.setSelected(this.stepTabActive ? steptab.getId() : helptab.getId());
            ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)tabSet);
            return tabSet;
        }
        List tabs = tabSet.getChildren();
        Iterator itabs = tabs.iterator();
        String stepsId = ComponentUtilities.createPrivateFacetId((UIComponent)this, STEP_TAB);
        String helpId = ComponentUtilities.createPrivateFacetId((UIComponent)this, HELP_TAB);
        while (itabs.hasNext()) {
            UIComponent tab = (UIComponent)itabs.next();
            if (!(tab instanceof Tab)) continue;
            String tabid = tab.getId();
            if (stepsId.equals(tabid)) {
                this.initTab((Tab)tab, theme, WIZARD_STEP_TAB, WIZARD_TAB_TOOLTIP, this.stepTabActive, true, this.getJavaScript(8));
                continue;
            }
            if (!helpId.equals(tabid)) continue;
            this.initTab((Tab)tab, theme, WIZARD_HELP_TAB, WIZARD_TAB_TOOLTIP, !this.stepTabActive, true, this.getJavaScript(4));
        }
        tabSet.setSelected(this.stepTabActive ? stepsId : helpId);
        return tabSet;
    }

    protected Tab getTab(Theme theme, String facetName, String text, String toolTip, int wizardEvent, boolean selected, boolean immediate, String javascript) {
        Tab tab = new Tab();
        tab.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
        tab.addActionListener(new WizardActionListener(this.getId(), wizardEvent));
        this.initTab(tab, theme, text, toolTip, selected, immediate, javascript);
        return tab;
    }

    private void initTab(Tab tab, Theme theme, String text, String toolTip, boolean selected, boolean immediate, String javascript) {
        text = theme.getMessage(text);
        tab.setText(text);
        tab.setToolTip(selected ? theme.getMessage(toolTip, new Object[]{text}) : text);
        tab.setImmediate(immediate);
        if (javascript != null) {
            tab.setOnClick(javascript);
        }
    }

    public UIComponent getStepIndicatorComponent() {
        UIComponent child = this.getFacet(INDICATOR_FACET);
        if (child != null) {
            return child;
        }
        Theme theme = ThemeUtilities.getTheme(this.getFacesContext());
        Icon icon = theme.getIcon("WIZARD_ARROW");
        String id = ComponentUtilities.createPrivateFacetId((UIComponent)this, INDICATOR_FACET);
        icon.setId(id);
        icon.setParent((UIComponent)this);
        icon.setHspace(4);
        String toolTip = theme.getMessage(WIZARD_CURRENT_STEP_ALT);
        icon.setToolTip(toolTip);
        icon.setAlt(toolTip);
        return icon;
    }

    public UIComponent getSteplinkComponent(String id, String text, int wizardEvent, boolean immediate, String javascript) {
        Hyperlink hlink = (Hyperlink)Util.findChild((UIComponent)this, id, null);
        if (hlink == null) {
            hlink = new Hyperlink();
            hlink.setId(id);
            hlink.addActionListener(new WizardActionListener(this.getId(), wizardEvent));
            hlink.setImmediate(immediate);
            this.getChildren().add(hlink);
        }
        hlink.setText(text);
        if (javascript != null) {
            hlink.setOnClick(javascript);
        }
        return hlink;
    }

    public UIComponent getStepsPaneComponent() {
        return null;
    }

    public UIComponent getStepListComponent() {
        return null;
    }

    public UIComponent getStepHelpComponent() {
        return null;
    }

    public UIComponent getStepTitleComponent() {
        return null;
    }

    public UIComponent getStepDetailComponent() {
        return null;
    }

    public UIComponent getTaskStepComponent() {
        return null;
    }

    public UIComponent getTaskComponent() {
        return null;
    }

    public UIComponent getTaskHeaderComponent() {
        return null;
    }

    public UIComponent getControlBarComponent() {
        return null;
    }

    public UIComponent getLeftControlBarComponent() {
        return null;
    }

    public UIComponent getRightControlBarComponent() {
        return null;
    }

    public UIComponent getStepTitleLabelTextComponent() {
        Theme theme = ThemeUtilities.getTheme(this.getFacesContext());
        WizardStep step = this.getCurrentStep();
        return this.getStepStaticTextComponent(step.getId().concat(USCORE).concat(STEP_TITLE_LABEL), theme.getMessage(WIZARD_STEP_TITLE_LABEL, new Object[]{this.getCurrentStepNumberString()}));
    }

    public UIComponent getStepTitleTextComponent() {
        WizardStep step = this.getCurrentStep();
        return this.getStepStaticTextComponent(step.getId().concat(USCORE).concat(STEP_TITLE), step.getTitle());
    }

    public UIComponent getStepDetailTextComponent() {
        WizardStep step = this.getCurrentStep();
        return this.getStepStaticTextComponent(step.getId().concat(USCORE).concat(STEP_DETAIL), step.getDetail());
    }

    public UIComponent getStepSummaryComponent(WizardStep step) {
        String stepId = step.getId();
        if (this.getModel().canGotoStep(step)) {
            String id = stepId.concat(USCORE).concat(STEP_LINK).concat(USCORE).concat(stepId);
            return this.getSteplinkComponent(id, step.getSummary(), 3, true, this.getJavaScript(3));
        }
        return this.getStepStaticTextComponent(stepId.concat(USCORE).concat(STEP_SUMMARY), step.getSummary());
    }

    public UIComponent getStepPlaceholderTextComponent(WizardStep step) {
        Theme theme = ThemeUtilities.getTheme(this.getFacesContext());
        String placeholderText = ((WizardBranch)step).getPlaceholderText();
        return this.getStepStaticTextComponent(step.getId().concat(USCORE).concat(STEP_PLACEHLDR), theme.getMessage(WIZARD_PLACEHOLDER_TEXT, new Object[]{placeholderText}));
    }

    public UIComponent getStepNumberComponent(WizardStep step, String numberString) {
        String num = numberString;
        String id = step.getId();
        id = id.concat(USCORE).concat(STEP_NUM);
        return this.getStepStaticTextComponent(id, num);
    }

    public UIComponent getStepHelpTextComponent() {
        WizardStep step = this.getCurrentStep();
        UIComponent stepHelp = this.getStepStaticTextComponent(step.getId().concat(USCORE).concat(STEP_HELP), step.getHelp());
        if (stepHelp != null) {
            stepHelp.getAttributes().put(ESCAPE_ATTR, WIZARD_FALSE);
        }
        return stepHelp;
    }

    protected UIComponent getStepStaticTextComponent(String id, String stepText) {
        StaticText text = (StaticText)this.getStaticTextComponent();
        text.setId(id);
        text.setParent((UIComponent)this);
        text.setText(stepText);
        return text;
    }

    protected UIComponent getStaticTextComponent() {
        return new StaticText();
    }

    public UIComponent getTitleComponent() {
        return this.getStaticTextComponent(TITLE_FACET, this.getTitle());
    }

    public UIComponent getStepsPaneTitleComponent() {
        Theme theme = ThemeUtilities.getTheme(this.getFacesContext());
        String title = theme.getMessage(WIZARD_STEPS_PANE_TITLE);
        UIComponent stepsPaneTitle = this.getStaticTextComponent(STEPS_PANE_TITLE, title);
        return stepsPaneTitle;
    }

    protected UIComponent getStaticTextComponent(String facetName, String text) {
        UIComponent child = this.getFacet(facetName);
        if (child != null) {
            return child;
        }
        StaticText txt = (StaticText)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (txt == null) {
            txt = new StaticText();
        }
        String id = ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName);
        txt.setId(id);
        txt.setText(text);
        ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)txt);
        return txt;
    }

    public static Wizard getWizard(UIComponent child, String wizardId) {
        return (Wizard)Wizard.findAncestor(child, wizardId);
    }

    private static UIComponent findAncestor(UIComponent descendant, String ancestorId) {
        if (ancestorId == null || descendant == null) {
            return null;
        }
        for (UIComponent parent = descendant.getParent(); parent != null; parent = parent.getParent()) {
            if (!ancestorId.equals(parent.getId())) continue;
            return parent;
        }
        return null;
    }

    public void broadcastEvent(UIComponent source, int navigationEvent) throws AbortProcessingException {
        this.navigationEvent = navigationEvent;
        this.gotoStepId = null;
        switch (navigationEvent) {
            case 0: 
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                String id = source.getId();
                String suffix = STEP_LINK.concat(USCORE);
                this.gotoStepId = id.substring(id.lastIndexOf(suffix) + suffix.length());
                break;
            }
            case 4: {
                this.stepTabActive = false;
                break;
            }
            case 8: {
                this.stepTabActive = true;
            }
        }
        throw new AbortProcessingException();
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof WizardEvent) {
            boolean result = true;
            WizardStep step = this.getCurrentStep();
            WizardEvent wizardEvent = new WizardEvent(this, this.eventSource, this.navigationEvent, this.gotoStepId);
            WizardEventListener listener = step.getEventListener();
            try {
                if (listener != null) {
                    result = listener.handleEvent(wizardEvent);
                }
                if ((listener = this.getEventListener()) != null) {
                    result = listener.handleEvent(wizardEvent);
                }
            }
            catch (Exception e) {
                result = true;
                wizardEvent.setNavigationEvent(0);
            }
            if (result) {
                this.getModel().handleEvent(wizardEvent);
            }
        }
    }

    public void processRestoreState(FacesContext context, Object state) {
        super.processRestoreState(context, state);
        this.getModel().initialize(this);
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.stepTabActive = (Boolean)values[1];
        this.restoreWizardModelState(context, values[2]);
    }

    public Object processSaveState(FacesContext context) {
        return super.processSaveState(context);
    }

    public Object saveState(FacesContext context) {
        Object modelSaveState = this.saveWizardModelState(context);
        if (modelSaveState != null) {
            this.setModel(null);
        }
        Object[] values = new Object[]{super.saveState(context), new Boolean(this.stepTabActive), modelSaveState != null ? modelSaveState : null};
        return values;
    }

    private Object saveWizardModelState(FacesContext context) {
        ValueBinding _vb = this.getValueBinding(MODEL);
        if (_vb != null) {
            return null;
        }
        WizardModel model = this.getModel();
        if (model == null) {
            return null;
        }
        return model.saveState(context);
    }

    private void restoreWizardModelState(FacesContext context, Object state) {
        if (state == null) {
            return;
        }
        WizardModelBase wm = new WizardModelBase(this);
        wm.restoreState(context, state);
        this.setModel(wm);
    }

    private String getJavaScript(int javaScriptEvent) {
        String js = null;
        WizardStep step = this.getCurrentStep();
        switch (javaScriptEvent) {
            case 6: {
                js = step.getOnNext();
                if (js != null) break;
                js = this.getOnNext();
                break;
            }
            case 7: {
                js = step.getOnPrevious();
                if (js != null) break;
                js = this.getOnPrevious();
                break;
            }
            case 0: {
                js = step.getOnCancel();
                if (js != null) break;
                js = this.getOnCancel();
                break;
            }
            case 1: {
                js = step.getOnClose();
                if (js != null) break;
                js = this.getOnClose();
                break;
            }
            case 2: {
                js = step.getOnFinish();
                if (js != null) break;
                js = this.getOnFinish();
                break;
            }
            case 3: {
                js = step.getOnStepLink();
                if (js != null) break;
                js = this.getOnStepLink();
                break;
            }
            case 4: {
                js = step.getOnHelpTab();
                if (js != null) break;
                js = this.getOnHelpTab();
                break;
            }
            case 8: {
                js = step.getOnStepsTab();
                if (js != null) break;
                js = this.getOnStepsTab();
            }
        }
        return js;
    }
}

