/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.Tree;
import com.sun.web.ui.component.TreeNodeBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.faces.component.UIComponent;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;

public class TreeNode
extends TreeNodeBase {
    private static Map topLineImageMapping = new HashMap(6);
    public static final String IMAGE_FACET_KEY = "image";
    public static final String CONTENT_FACET_KEY = "content";
    public static final String LAYOUT_KEY = "layout/treeNode.xml";

    public TreeNode() {
        this.setLayoutDefinitionKey(LAYOUT_KEY);
    }

    public List getImageKeys() {
        Stack<String> stack = new Stack<String>();
        Object value = null;
        Map attributes = null;
        boolean last = false;
        boolean first = true;
        boolean bottomNode = false;
        TreeNode node = TreeNode.getParentTreeNode((UIComponent)this);
        while (node != null) {
            attributes = node.getAttributes();
            bottomNode = ("" + attributes.get("lastChild")).equals("true");
            if (first) {
                first = false;
                if (this.getChildren().size() > 0) {
                    if (((Boolean)this.getAttributes().get("expanded")).booleanValue()) {
                        if (bottomNode) {
                            stack.push("TREE_HANDLE_DOWN_LAST");
                        } else {
                            stack.push("TREE_HANDLE_DOWN_MIDDLE");
                        }
                    } else if (bottomNode) {
                        stack.push("TREE_HANDLE_RIGHT_LAST");
                    } else {
                        stack.push("TREE_HANDLE_RIGHT_MIDDLE");
                    }
                } else if (bottomNode) {
                    stack.push("TREE_LINE_LAST_NODE");
                } else {
                    stack.push("TREE_LINE_MIDDLE_NODE");
                }
            } else {
                value = node.getAttributes().get("lastChild");
                boolean bl = last = value == null ? true : value.toString().equals("true");
                if (last || node.getChildren().size() == 0) {
                    stack.push("TREE_BLANK");
                } else {
                    stack.push("TREE_LINE_VERTICAL");
                }
            }
            node = TreeNode.getParentTreeNode((UIComponent)node);
        }
        TreeNode parent = TreeNode.getParentTreeNode((UIComponent)this);
        if (parent instanceof Tree) {
            Iterator children = parent.getChildren().iterator();
            Object child = null;
            while (children.hasNext()) {
                String imgURL;
                child = children.next();
                if (!(child instanceof TreeNode)) continue;
                if (child != this || (imgURL = parent.getImageURL()) != null && !imgURL.equals("") || parent.getFacet(IMAGE_FACET_KEY) != null) break;
                stack.push((String)topLineImageMapping.get(stack.pop()));
                break;
            }
        }
        ArrayList list = new ArrayList();
        while (!stack.empty()) {
            list.add(stack.pop());
        }
        return list;
    }

    public static TreeNode getParentTreeNode(UIComponent node) {
        for (node = node.getParent(); node != null && !(node instanceof TreeNode); node = node.getParent()) {
        }
        return (TreeNode)node;
    }

    public void toggleNode(ActionEvent event) throws AbortProcessingException {
        this.setExpanded(!this.isExpanded());
        Object src = event.getSource();
        if (src instanceof UIComponent) {
            Map attributes = ((UIComponent)src).getAttributes();
            attributes.put("icon", this.getHandleIcon((String)attributes.get("icon")));
        }
    }

    protected String getHandleIcon(String value) {
        if (value == null || value.trim().equals("")) {
            value = "TREE_HANDLE_RIGHT_TOP_NOSIBLING";
        }
        value = this.isExpanded() ? value.replaceFirst("RIGHT", "DOWN") : value.replaceFirst("DOWN", "RIGHT");
        return value;
    }

    static {
        topLineImageMapping.put("TREE_HANDLE_DOWN_MIDDLE", "TREE_HANDLE_DOWN_TOP");
        topLineImageMapping.put("TREE_HANDLE_DOWN_LAST", "TREE_HANDLE_DOWN_TOP_NOSIBLING");
        topLineImageMapping.put("TREE_HANDLE_RIGHT_MIDDLE", "TREE_HANDLE_RIGHT_TOP");
        topLineImageMapping.put("TREE_HANDLE_RIGHT_LAST", "TREE_HANDLE_RIGHT_TOP_NOSIBLING");
        topLineImageMapping.put("TREE_LINE_MIDDLE_NODE", "TREE_LINE_FIRST_NODE");
        topLineImageMapping.put("TREE_LINE_LAST_NODE", "TREE_BLANK");
    }
}

