/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.data.provider.RowKey;
import com.sun.web.ui.component.Checkbox;
import com.sun.web.ui.component.HiddenField;
import com.sun.web.ui.component.Icon;
import com.sun.web.ui.component.IconHyperlink;
import com.sun.web.ui.component.StaticText;
import com.sun.web.ui.component.Table;
import com.sun.web.ui.component.TableColumn;
import com.sun.web.ui.component.TableHeaderBase;
import com.sun.web.ui.component.TableRowGroup;
import com.sun.web.ui.event.TableSortActionListener;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.LogUtil;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class TableHeader
extends TableHeaderBase
implements NamingContainer {
    public static final String ADD_SORT_BUTTON_ID = "_addSortButton";
    public static final String ADD_SORT_BUTTON_FACET = "addSortButton";
    public static final String COLLAPSED_HIDDEN_FIELD_ID = "_collapsedHiddenField";
    public static final String COLLAPSED_HIDDEN_FIELD_FACET = "collapsedHiddenField";
    public static final String GROUP_PANEL_TOGGLE_BUTTON_ID = "_groupPanelToggleButton";
    public static final String GROUP_PANEL_TOGGLE_BUTTON_FACET = "groupPanelToggleButton";
    public static final String PRIMARY_SORT_BUTTON_ID = "_primarySortButton";
    public static final String PRIMARY_SORT_BUTTON_FACET = "primarySortButton";
    public static final String PRIMARY_SORT_LINK_ID = "_primarySortLink";
    public static final String PRIMARY_SORT_LINK_FACET = "primarySortLink";
    public static final String SELECT_MULTIPLE_TOGGLE_BUTTON_ID = "_selectMultipleToggleButton";
    public static final String SELECT_MULTIPLE_TOGGLE_BUTTON_FACET = "selectMultipleToggleButton";
    public static final String SELECT_SORT_BUTTON_ID = "_selectSortButton";
    public static final String SELECT_SORT_BUTTON_FACET = "selectSortButton";
    public static final String SORT_LEVEL_TEXT_ID = "_sortLevelText";
    public static final String SORT_LEVEL_TEXT_FACET = "sortLevelText";
    public static final String TOGGLE_SORT_BUTTON_ID = "_toggleSortButton";
    public static final String TOGGLE_SORT_BUTTON_FACET = "toggleSortButton";
    public static final String WARNING_ICON_ID = "_warningIcon";
    public static final String WARNING_ICON_FACET = "warningIcon";
    private Table table = null;
    private TableColumn tableColumn = null;
    private TableRowGroup tableRowGroup = null;
    private boolean descending = false;
    private boolean descending_set = false;
    private int selectedRowsCount = -1;
    private int sortCount = -1;
    private int sortLevel = -1;

    public int getSortCount() {
        if (this.sortCount == -1) {
            TableRowGroup group = this.getTableRowGroupAncestor();
            this.sortCount = group != null ? group.getSortCount() : 0;
        }
        return this.sortCount;
    }

    public int getSortLevel() {
        if (this.sortLevel == -1) {
            TableColumn col = this.getTableColumnAncestor();
            TableRowGroup group = this.getTableRowGroupAncestor();
            if (col != null && group != null) {
                this.sortLevel = group.getSortLevel(col.getSortCriteria());
            } else {
                this.log("getSortLevel", "Cannot obtain sort level, TableColumn or TableRowGroup is null");
            }
        }
        return this.sortLevel;
    }

    public Table getTableAncestor() {
        if (this.table == null) {
            TableHeader component = this;
            while (component != null) {
                if (!((component = component.getParent()) instanceof Table)) continue;
                this.table = (Table)((Object)component);
                break;
            }
        }
        return this.table;
    }

    public TableColumn getTableColumnAncestor() {
        if (this.tableColumn == null) {
            TableHeader component = this;
            while (component != null) {
                if (!((component = component.getParent()) instanceof TableColumn)) continue;
                this.tableColumn = (TableColumn)((Object)component);
                break;
            }
        }
        return this.tableColumn;
    }

    public TableRowGroup getTableRowGroupAncestor() {
        if (this.tableRowGroup == null) {
            TableHeader component = this;
            while (component != null) {
                if (!((component = component.getParent()) instanceof TableRowGroup)) continue;
                this.tableRowGroup = (TableRowGroup)((Object)component);
                break;
            }
        }
        return this.tableRowGroup;
    }

    public UIComponent getCollapsedHiddenField() {
        UIComponent facet = this.getFacet(COLLAPSED_HIDDEN_FIELD_FACET);
        if (facet != null) {
            return facet;
        }
        HiddenField child = new HiddenField();
        child.setId(COLLAPSED_HIDDEN_FIELD_ID);
        TableRowGroup group = this.getTableRowGroupAncestor();
        if (group != null) {
            child.setValue(new Boolean(group.isCollapsed()));
        } else {
            this.log("getCollapsedHiddenField", "Cannot set collapsed hidden field value, TableRowGroup is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getGroupPanelToggleButton() {
        UIComponent facet = this.getFacet(GROUP_PANEL_TOGGLE_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = this.getTheme();
        Table table = this.getTableAncestor();
        TableRowGroup group = this.getTableRowGroupAncestor();
        IconHyperlink child = new IconHyperlink();
        child.setId(GROUP_PANEL_TOGGLE_BUTTON_ID);
        child.setIcon(group != null && group.isCollapsed() ? "TABLE_GROUP_PANEL" : "TABLE_GROUP_PANEL_FLIP");
        child.setBorder(0);
        StringBuffer buff = new StringBuffer(128);
        if (table != null && group != null) {
            buff.append("document.getElementById('").append(table.getClientId(this.getFacesContext())).append("').toggleGroupPanel('").append(group.getClientId(this.getFacesContext())).append("'); return false");
            child.setOnClick(buff.toString());
        } else {
            this.log("getGroupPanelToggleButton", "onClick not set, Table or TableRowGroup is null");
        }
        String toolTip = group != null && group.isCollapsed() ? theme.getMessage("table.group.expand") : theme.getMessage("table.group.collapse");
        child.setAlt(toolTip);
        child.setToolTip(toolTip);
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
        } else {
            this.log("getGroupPanelToggleButton", "Tab index not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getSelectMultipleToggleButton() {
        UIComponent facet = this.getFacet(SELECT_MULTIPLE_TOGGLE_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Table table = this.getTableAncestor();
        TableRowGroup group = this.getTableRowGroupAncestor();
        Checkbox child = new Checkbox();
        child.setId(SELECT_MULTIPLE_TOGGLE_BUTTON_ID);
        child.setSelectedValue(Boolean.TRUE);
        StringBuffer buff = new StringBuffer(128);
        if (table != null && group != null) {
            buff.append("document.getElementById('").append(table.getClientId(this.getFacesContext())).append("').selectGroupRows('").append(group.getClientId(this.getFacesContext())).append("', this.checked)");
            child.setOnClick(buff.toString());
        } else {
            this.log("getSelectMultipleToggleButton", "onClick not set, Table or TableRowgroup is null");
        }
        if (group != null) {
            RowKey[] rowKeys = group.getRenderedRowKeys();
            if (rowKeys != null && rowKeys.length > 0 && rowKeys.length == this.getSelectedRowsCount()) {
                child.setSelected(Boolean.TRUE);
                child.setToolTip(this.getTheme().getMessage("table.group.deselectMultiple"));
            } else {
                child.setToolTip(this.getTheme().getMessage("table.group.selectMultiple"));
            }
        } else {
            this.log("getSelectMultipleToggleButton", "Tool tip & selected not set, TableRowGroup is null");
        }
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
        } else {
            this.log("getSelectMultipleToggleButton", "Tab index not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getWarningIcon() {
        UIComponent facet = this.getFacet(WARNING_ICON_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = this.getTheme();
        TableRowGroup group = this.getTableRowGroupAncestor();
        Icon child = theme.getIcon("ALERT_WARNING_SMALL");
        RowKey[] rowKeys = group.getRenderedRowKeys();
        int rows = this.getSelectedRowsCount();
        if (group != null && !group.isCollapsed() || rows == 0 || rowKeys != null && rowKeys.length > 0 && rowKeys.length == rows) {
            Icon placeHolder = theme.getIcon("DOT");
            placeHolder.setHeight(child.getHeight());
            placeHolder.setWidth(child.getWidth());
            child = placeHolder;
        } else {
            this.log("getWarningIcon", "Height & width not set, TableRowGroup is null");
        }
        child.setId(WARNING_ICON_ID);
        child.setBorder(0);
        String toolTip = group != null && group.isCollapsed() ? theme.getMessage("table.group.warning") : null;
        child.setAlt(toolTip);
        child.setToolTip(toolTip);
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getAddSortButton() {
        UIComponent facet = this.getFacet(ADD_SORT_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = this.getTheme();
        Table table = this.getTableAncestor();
        TableColumn col = this.getTableColumnAncestor();
        IconHyperlink child = new IconHyperlink();
        child.setId(ADD_SORT_BUTTON_ID);
        child.setIcon("TABLE_SORT_ADD");
        child.setBorder(0);
        child.setAlign("top");
        child.setStyleClass("TblHdrImgLnk");
        child.addActionListener(new TableSortActionListener());
        String toolTip = this.getTheme().getMessage("table.sort.button.add", new String[]{this.getNextSortToolTipAugment()});
        child.setToolTip(toolTip);
        if (this.isSelectHeader()) {
            child.setAlt(theme.getMessage("table.sort.alt.add", new String[]{theme.getMessage("table.select.selectionColumn")}));
        } else {
            String header = col != null && col.getHeaderText() != null ? col.getHeaderText() : "";
            child.setAlt(theme.getMessage("table.sort.alt.add", new String[]{header}));
        }
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
        } else {
            this.log("getAddSortButton", "Tab index not set, Table is null");
        }
        if (this.getSortCount() > 0 && this.getSortLevel() > 0) {
            child.getChildren().add(this.getSortLevelText());
        }
        this.getFacets().put(child.getId(), child);
        this.setSortFocus((UIComponent)child);
        return child;
    }

    public UIComponent getPrimarySortButton() {
        UIComponent facet = this.getFacet(PRIMARY_SORT_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = this.getTheme();
        Table table = this.getTableAncestor();
        TableColumn col = this.getTableColumnAncestor();
        IconHyperlink child = new IconHyperlink();
        child.setId(PRIMARY_SORT_BUTTON_ID);
        child.setIcon("TABLE_SORT_PRIMARY");
        child.setBorder(0);
        child.setAlign("top");
        child.setStyleClass("TblHdrImgLnk");
        child.addActionListener(new TableSortActionListener());
        String toolTip = theme.getMessage("table.sort.button.primary", new String[]{this.getNextSortToolTipAugment()});
        child.setToolTip(toolTip);
        if (col != null) {
            String header = col.getHeaderText() != null ? col.getHeaderText() : "";
            child.setAlt(theme.getMessage("table.sort.alt.primary", new String[]{header}));
        } else {
            this.log("getPrimarySortButton", "Alt text not set, TableColumn is null");
        }
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
        } else {
            this.log("getPrimarySortButton", "Tab index not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        this.setSortFocus((UIComponent)child);
        return child;
    }

    public UIComponent getPrimarySortLink() {
        UIComponent facet = this.getFacet(PRIMARY_SORT_LINK_FACET);
        if (facet != null) {
            return facet;
        }
        Table table = this.getTableAncestor();
        TableColumn col = this.getTableColumnAncestor();
        IconHyperlink child = new IconHyperlink();
        child.setId(PRIMARY_SORT_LINK_ID);
        child.setStyleClass("TblHdrLnk");
        child.addActionListener(new TableSortActionListener());
        String toolTip = "table.sort.link.other";
        if (this.getSortLevel() == 1 && this.getSortCount() == 1) {
            toolTip = "table.sort.link.primary";
        } else if (this.getSortCount() == 0) {
            toolTip = "table.sort.link.none";
        }
        if (col != null) {
            child.setIcon(col.getSortIcon());
            child.setText(col.getHeaderText());
            child.setImageURL(col.getSortImageURL());
            child.setToolTip(this.getTheme().getMessage(toolTip, new String[]{col.getSortToolTipAugment(col.isDescending())}));
        } else {
            this.log("getPrimarySortLink", "Tool tip, icon, text, & image URL not set, TableColumn is null");
        }
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
        } else {
            this.log("getPrimarySortLink", "Tab index not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getSelectSortButton() {
        UIComponent facet = this.getFacet(SELECT_SORT_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = this.getTheme();
        Table table = this.getTableAncestor();
        IconHyperlink child = new IconHyperlink();
        child.setId(SELECT_SORT_BUTTON_ID);
        child.setIcon("TABLE_SORT_SELECT");
        child.setBorder(0);
        child.setAlign("top");
        child.setStyleClass("TblHdrLnk");
        child.addActionListener(new TableSortActionListener());
        String toolTip = theme.getMessage("table.sort.button.primary", new String[]{this.getNextSortToolTipAugment()});
        child.setToolTip(toolTip);
        String alt = theme.getMessage("table.sort.alt.primary", new String[]{theme.getMessage("table.select.selectionColumn")});
        child.setAlt(alt);
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
        } else {
            this.log("getSelectSortButton", "Tab index not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getSortLevelText() {
        UIComponent facet = this.getFacet(SORT_LEVEL_TEXT_FACET);
        if (facet != null) {
            return facet;
        }
        StaticText child = new StaticText();
        child.setId(SORT_LEVEL_TEXT_ID);
        child.setText(Integer.toString(this.getSortLevel()));
        child.setStyleClass(this.getTheme().getStyleClass("TblHdrSrtNum"));
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getToggleSortButton() {
        UIComponent facet = this.getFacet(TOGGLE_SORT_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = this.getTheme();
        Table table = this.getTableAncestor();
        TableColumn col = this.getTableColumnAncestor();
        TableRowGroup group = this.getTableRowGroupAncestor();
        IconHyperlink child = new IconHyperlink();
        child.setId(TOGGLE_SORT_BUTTON_ID);
        child.setBorder(0);
        child.setAlign("top");
        child.addActionListener(new TableSortActionListener());
        if (table != null && col != null) {
            if (!this.isDescending() && group.isPaginated() && col.getSelectId() != null && !table.isHiddenSelectedRows()) {
                child.setDisabled(true);
            }
        } else {
            this.log("getToggleSortButton", "Disabled state not set, Table or TableColumn is null");
        }
        if (col != null) {
            child.setToolTip(theme.getMessage("table.sort.button.toggle", new String[]{col.getSortToolTipAugment(!this.isDescending())}));
            if (this.isSelectHeader()) {
                child.setAlt(theme.getMessage("table.sort.alt.primary", new String[]{theme.getMessage("table.select.selectionColumn"), col.getSortToolTipAugment(this.isDescending()), Integer.toString(this.getSortLevel())}));
            } else {
                String header = col.getHeaderText() != null ? col.getHeaderText() : "";
                child.setAlt(theme.getMessage("table.sort.alt.toggle", new String[]{header, col.getSortToolTipAugment(this.isDescending()), Integer.toString(this.getSortLevel())}));
            }
        } else {
            this.log("getToggleSortButton", "Alt text not set, TableColumn is null");
        }
        if (child.isDisabled()) {
            child.setIcon("TABLE_SORT_DESCENDING_DISABLED");
        } else if (!this.isDescending()) {
            child.setIcon("TABLE_SORT_DESCENDING");
        } else {
            child.setIcon("TABLE_SORT_ASCENDING");
        }
        if (child.isDisabled()) {
            if (this.getSortLevel() == 1) {
                child.setStyleClass("TblColHdrSrtDis");
            } else {
                child.setStyleClass("TblColHdrSelDis");
            }
        } else {
            child.setStyleClass("TblHdrImgLnk");
        }
        if (this.getSortLevel() > 0 && this.getSortCount() > 0) {
            child.getChildren().add(this.getSortLevelText());
        }
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
        } else {
            this.log("getToggleSortButton", "Tab index not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        this.setSortFocus((UIComponent)child);
        return child;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.table = null;
        this.tableColumn = null;
        this.tableRowGroup = null;
        this.descending = false;
        this.descending_set = false;
        this.selectedRowsCount = -1;
        this.sortCount = -1;
        this.sortLevel = -1;
        super.encodeBegin(context);
    }

    private String getNextSortToolTipAugment() {
        TableColumn col = this.getTableColumnAncestor();
        return col != null ? col.getSortToolTipAugment(this.isDescending()) : "";
    }

    private int getSelectedRowsCount() {
        TableRowGroup group;
        if (this.selectedRowsCount == -1 && (group = this.getTableRowGroupAncestor()) != null) {
            this.selectedRowsCount = group.getRenderedSelectedRowsCount();
        }
        return this.selectedRowsCount;
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(this.getFacesContext());
    }

    private boolean isDescending() {
        if (!this.descending_set) {
            TableColumn col = this.getTableColumnAncestor();
            TableRowGroup group = this.getTableRowGroupAncestor();
            if (col != null && group != null) {
                this.descending = this.getSortLevel() > 0 ? group.isDescendingSort(col.getSortCriteria()) : col.isDescending();
                this.descending_set = true;
            }
        }
        return this.descending;
    }

    private void log(String method, String message) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }

    private void setSortFocus(UIComponent component) {
        if (component == null) {
            return;
        }
        FacesContext context = this.getFacesContext();
        String prefix = this.getClientId(context) + ':';
        String id = RenderingUtilities.getLastClientID(context);
        if (id == null) {
            return;
        }
        if (id.equals(prefix + ADD_SORT_BUTTON_ID) || id.equals(prefix + PRIMARY_SORT_BUTTON_ID) || id.equals(prefix + TOGGLE_SORT_BUTTON_ID)) {
            RenderingUtilities.setLastClientID(context, component.getClientId(context));
        }
    }
}

