/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.data.provider.FieldKey;
import com.sun.data.provider.SortCriteria;
import com.sun.data.provider.impl.FieldIdSortCriteria;
import com.sun.web.ui.component.Icon;
import com.sun.web.ui.component.Table;
import com.sun.web.ui.component.TableColumnBase;
import com.sun.web.ui.component.TableFooter;
import com.sun.web.ui.component.TableHeader;
import com.sun.web.ui.component.TableRowGroup;
import com.sun.web.ui.faces.ValueBindingSortCriteria;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.LogUtil;
import com.sun.web.ui.util.ThemeUtilities;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class TableColumn
extends TableColumnBase
implements NamingContainer {
    public static final String COLUMN_FOOTER_ID = "_columnFooter";
    public static final String COLUMN_FOOTER_FACET = "columnFooter";
    public static final String COLUMN_HEADER_ID = "_columnHeader";
    public static final String COLUMN_HEADER_FACET = "columnHeader";
    public static final String HEADER_FACET = "header";
    public static final String EMBEDDED_ACTION_SEPARATOR_ICON_ID = "_embeddedActionSeparatorIcon";
    public static final String EMBEDDED_ACTION_SEPARATOR_ICON_FACET = "embeddedActionSeparatorIcon";
    public static final String EMPTY_CELL_ICON_ID = "_emptyCellIcon";
    public static final String EMPTY_CELL_ICON_FACET = "emptyCellIcon";
    public static final String FOOTER_FACET = "footer";
    public static final String TABLE_COLUMN_FOOTER_ID = "_tableColumnFooter";
    public static final String TABLE_COLUMN_FOOTER_FACET = "tableColumnFooter";
    public static final String TABLE_FOOTER_FACET = "tableFooter";
    private static final String REQUEST_KEY_PREFIX = "com.sun.web.ui_";
    private static final String PROPERTIES = "_properties";
    private Table table = null;

    public Table getTableAncestor() {
        if (this.table == null) {
            TableColumn component = this;
            while (component != null) {
                if (!((component = component.getParent()) instanceof Table)) continue;
                this.table = (Table)((Object)component);
                break;
            }
        }
        return this.table;
    }

    public TableColumn getTableColumnAncestor() {
        TableColumn tableColumn;
        Properties properties = this.getProperties();
        TableColumn tableColumn2 = tableColumn = properties != null ? properties.getTableColumnAncestor() : null;
        if (tableColumn == null) {
            TableColumn component = this;
            while (component != null) {
                if (!((component = component.getParent()) instanceof TableColumn)) continue;
                tableColumn = component;
                break;
            }
            if (properties != null) {
                properties.setTableColumnAncestor(tableColumn);
            }
        }
        return tableColumn;
    }

    public Iterator getTableColumnChildren() {
        ArrayList<UIComponent> tableColumnChildren;
        Properties properties = this.getProperties();
        ArrayList<UIComponent> arrayList = tableColumnChildren = properties != null ? properties.getTableColumnChildren() : null;
        if (tableColumnChildren == null) {
            tableColumnChildren = new ArrayList<UIComponent>();
            Iterator kids = this.getChildren().iterator();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                if (!(kid instanceof TableColumn)) continue;
                tableColumnChildren.add(kid);
            }
            if (properties != null) {
                properties.setTableColumnChildren(tableColumnChildren);
            }
        }
        return tableColumnChildren.iterator();
    }

    public int getColumnCount() {
        int columnCount;
        Properties properties = this.getProperties();
        int n = columnCount = properties != null ? properties.getColumnCount() : -1;
        if (columnCount == -1) {
            columnCount = this.getColumnCount(this);
            if (properties != null) {
                properties.setColumnCount(columnCount);
            }
        }
        return columnCount;
    }

    public TableRowGroup getTableRowGroupAncestor() {
        TableRowGroup tableRowGroup;
        Properties properties = this.getProperties();
        TableRowGroup tableRowGroup2 = tableRowGroup = properties != null ? properties.getTableRowGroupAncestor() : null;
        if (tableRowGroup == null) {
            TableColumn component = this;
            while (component != null) {
                if (!((component = component.getParent()) instanceof TableRowGroup)) continue;
                tableRowGroup = (TableRowGroup)((Object)component);
                break;
            }
            if (properties != null) {
                properties.setTableRowGroupAncestor(tableRowGroup);
            }
        }
        return tableRowGroup;
    }

    public UIComponent getColumnFooter() {
        UIComponent facet = this.getFacet(COLUMN_FOOTER_FACET);
        if (facet != null) {
            return facet;
        }
        TableFooter child = new TableFooter();
        child.setId(COLUMN_FOOTER_ID);
        child.setAlign(this.getAlign());
        child.setExtraHtml(this.getExtraFooterHtml());
        if (!(facet != null && facet.isRendered() || this.getFooterText() != null || this.isColumnFooterRendered())) {
            child.setRendered(false);
        } else {
            this.log("getColumnFooter", "Column footer not rendered, nothing to display");
        }
        TableRowGroup group = this.getTableRowGroupAncestor();
        if (group != null && group.isMultipleColumnFooters()) {
            Iterator kids = this.getTableColumnChildren();
            if (kids.hasNext()) {
                int colspan = this.getColumnCount();
                if (colspan > 1) {
                    child.setColSpan(colspan);
                }
            } else {
                int rowspan = this.getRowCount();
                if (rowspan > 1) {
                    child.setRowSpan(rowspan);
                }
            }
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getColumnHeader() {
        Iterator kids;
        UIComponent facet = this.getFacet(COLUMN_HEADER_FACET);
        if (facet != null) {
            return facet;
        }
        TableHeader child = new TableHeader();
        child.setId(COLUMN_HEADER_ID);
        child.setScope("col");
        child.setAlign(this.getAlign());
        child.setWidth(this.getSelectId() != null ? "3%" : null);
        child.setNoWrap(this.getSelectId() != null);
        child.setExtraHtml(this.getExtraHeaderHtml());
        boolean emptyTable = this.isEmptyTable();
        SortCriteria criteria = this.getSortCriteria();
        if (criteria != null && this.getSelectId() != null && !emptyTable) {
            child.setSelectHeader(true);
        } else if (criteria != null && this.getHeaderText() != null && !emptyTable) {
            child.setSortHeader(true);
        } else {
            this.log("getColumnHeader", "Render default column header, no SortCriteria or selectId");
        }
        if (!(facet != null && facet.isRendered() || this.getHeaderText() != null || this.isColumnHeaderRendered())) {
            this.log("getColumnHeader", "Column header not rendered, nothing to display");
            child.setRendered(false);
        }
        if ((kids = this.getTableColumnChildren()).hasNext()) {
            int colspan = this.getColumnCount();
            if (colspan > 1) {
                child.setColSpan(colspan);
            }
        } else {
            int rowspan = this.getRowCount();
            if (rowspan > 1) {
                child.setRowSpan(rowspan);
            }
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getTableColumnFooter() {
        UIComponent facet = this.getFacet(TABLE_COLUMN_FOOTER_FACET);
        if (facet != null) {
            return facet;
        }
        TableFooter child = new TableFooter();
        child.setId(TABLE_COLUMN_FOOTER_ID);
        child.setAlign(this.getAlign());
        child.setExtraHtml(this.getExtraTableFooterHtml());
        child.setTableColumnFooter(true);
        if (!(facet != null && facet.isRendered() || this.getTableFooterText() != null || this.isTableColumnFooterRendered())) {
            child.setRendered(false);
        } else {
            this.log("getTableColumnFooter", "Table column footer not rendered, nothing to display");
        }
        TableRowGroup group = this.getTableRowGroupAncestor();
        if (group != null && group.isMultipleTableColumnFooters()) {
            Iterator kids = this.getTableColumnChildren();
            if (kids.hasNext()) {
                int colspan = this.getColumnCount();
                if (colspan > 1) {
                    child.setColSpan(colspan);
                }
            } else {
                int rowspan = this.getRowCount();
                if (rowspan > 1) {
                    child.setRowSpan(rowspan);
                }
            }
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public String getAlign() {
        if (super.getAlign() != null) {
            return super.getAlign();
        }
        String result = null;
        Class type = this.getType();
        result = type != null && (type.equals(Character.class) || type.equals(String.class)) ? "left" : (type != null && (type.equals(Date.class) || type.equals(Number.class)) ? "right" : (type != null && type.equals(Boolean.class) ? "center" : "left"));
        return result;
    }

    public UIComponent getEmptyCellIcon() {
        UIComponent facet = this.getFacet(EMPTY_CELL_ICON_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = this.getTheme();
        Icon child = theme.getIcon("TABLE_EMPTY_CELL");
        child.setId(EMPTY_CELL_ICON_ID);
        child.setBorder(0);
        String toolTip = theme.getMessage("table.emptyTableCell");
        child.setToolTip(toolTip);
        child.setAlt(toolTip);
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getEmbeddedActionSeparatorIcon() {
        UIComponent facet = this.getFacet(EMBEDDED_ACTION_SEPARATOR_ICON_FACET);
        if (facet != null) {
            return facet;
        }
        Icon child = this.getTheme().getIcon("TABLE_EMBEDDED_ACTIONS_SEPARATOR");
        child.setId(EMBEDDED_ACTION_SEPARATOR_ICON_ID);
        child.setBorder(0);
        child.setAlign("top");
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public SortCriteria getSortCriteria() {
        Object key = this.getSort();
        if (key instanceof SortCriteria) {
            return (SortCriteria)key;
        }
        Object result = null;
        ValueBinding vb = this.getValueBinding("sort");
        if (vb != null) {
            ValueBindingSortCriteria vbsc = new ValueBindingSortCriteria(vb, !this.isDescending());
            TableRowGroup group = this.getTableRowGroupAncestor();
            if (group != null) {
                vbsc.setRequestMapKey(group.getSourceVar());
            }
            result = vbsc;
        } else if (key != null) {
            result = new FieldIdSortCriteria(key.toString(), !this.isDescending());
        }
        return result;
    }

    public String getSortToolTipAugment(boolean descending) {
        String result = null;
        Class type = this.getType();
        ValueBinding vb = this.getValueBinding("severity");
        result = this.getSeverity() != null || vb != null ? (descending ? "table.sort.augment.alarmDescending" : "table.sort.augment.alarmAscending") : (this.getSelectId() != null || type != null && type.equals(Boolean.class) ? (descending ? "table.sort.augment.booleanDescending" : "table.sort.augment.booleanAscending") : (type != null && type.equals(String.class) ? (descending ? "table.sort.augment.stringDescending" : "table.sort.augment.stringAscending") : (type != null && type.equals(Character.class) ? (descending ? "table.sort.augment.charDescending" : "table.sort.augment.charAscending") : (type != null && type.equals(Date.class) ? (descending ? "table.sort.augment.dateDescending" : "table.sort.augment.dateAscending") : (type != null && type.equals(Number.class) ? (descending ? "table.sort.augment.numericDescending" : "table.sort.augment.numericAscending") : (descending ? "table.sort.augment.undeterminedDescending" : "table.sort.augment.undeterminedAscending"))))));
        return this.getTheme().getMessage(result);
    }

    private int getColumnCount(TableColumn component) {
        int count = 0;
        if (component == null) {
            this.log("getColumnCount", "Cannot obtain column count, TableColumn is null");
            return count;
        }
        Iterator kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn col = (TableColumn)((Object)kids.next());
                if (!col.isRendered()) continue;
                count += this.getColumnCount(col);
            }
        } else if (component.isRendered()) {
            ++count;
        }
        return count;
    }

    private Properties getProperties() {
        String propertiesId;
        Properties properties;
        String propertiesMapId;
        Table table = this.getTableAncestor();
        if (table == null) {
            this.log("getProperties", "Cannot obtain Properties, Table is null");
            return null;
        }
        FacesContext context = this.getFacesContext();
        Map requestMap = context.getExternalContext().getRequestMap();
        HashMap<String, Properties> propertiesMap = (HashMap<String, Properties>)requestMap.get(propertiesMapId = REQUEST_KEY_PREFIX + table.getClientId(context) + PROPERTIES);
        if (propertiesMap == null) {
            propertiesMap = new HashMap<String, Properties>();
        }
        if ((properties = (Properties)propertiesMap.get(propertiesId = this.getClientId(context))) == null) {
            properties = new Properties();
        }
        propertiesMap.put(propertiesId, properties);
        requestMap.put(propertiesMapId, propertiesMap);
        return properties;
    }

    private int getRowCount() {
        int rowCount;
        Properties properties = this.getProperties();
        int n = rowCount = properties != null ? properties.getRowCount() : -1;
        if (rowCount == -1) {
            rowCount = 0;
            Iterator kids = null;
            TableColumn col = this.getTableColumnAncestor();
            if (col != null) {
                kids = col.getTableColumnChildren();
            } else {
                TableRowGroup group = this.getTableRowGroupAncestor();
                Iterator iterator = kids = group != null ? group.getTableColumnChildren() : null;
            }
            if (kids != null) {
                while (kids.hasNext()) {
                    int result = this.getRowCount((TableColumn)((Object)kids.next()));
                    if (rowCount >= result) continue;
                    rowCount = result;
                }
            }
        }
        properties.setRowCount(rowCount);
        return rowCount;
    }

    private int getRowCount(TableColumn component) {
        int count = 0;
        if (component == null) {
            this.log("getRowCount", "Cannot obtain row count, TableColumn is null");
            return count;
        }
        Iterator kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                int result;
                TableColumn col = (TableColumn)((Object)kids.next());
                if (!col.isRendered() || count >= (result = this.getRowCount(col))) continue;
                count = result;
            }
        }
        return ++count;
    }

    private Class getType() {
        TableRowGroup group = this.getTableRowGroupAncestor();
        if (group == null) {
            this.log("getType", "Cannot obtain data type, TableRowGroup is null");
            return null;
        }
        FieldKey key = null;
        if (this.getAlignKey() instanceof FieldKey) {
            key = (FieldKey)this.getAlignKey();
        } else if (this.getAlignKey() != null) {
            key = group.getFieldKey(this.getAlignKey().toString());
        }
        return key != null ? group.getType(key) : String.class;
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(this.getFacesContext());
    }

    private boolean isColumnFooterRendered() {
        boolean result = false;
        TableRowGroup group = this.getTableRowGroupAncestor();
        if (group == null) {
            this.log("isColumnFooterRendered", "Cannot determine if column footer is rendered, TableRowGroup is null");
            return result;
        }
        Iterator kids = group.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumn col = (TableColumn)((Object)kids.next());
            if (!this.isColumnFooterRendered(col)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isColumnFooterRendered(TableColumn component) {
        UIComponent facet;
        boolean rendered = false;
        if (component == null) {
            this.log("isColumnFooterRendered", "Cannot determine if column footer is rendered, TableColumn is null");
            return rendered;
        }
        Iterator kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn col = (TableColumn)((Object)kids.next());
                if (!this.isColumnFooterRendered(col)) continue;
                return true;
            }
        }
        if ((facet = component.getFacet(COLUMN_FOOTER_FACET)) != null || component.getFooterText() != null) {
            rendered = true;
        }
        return rendered;
    }

    private boolean isColumnHeaderRendered() {
        boolean result = false;
        TableRowGroup group = this.getTableRowGroupAncestor();
        if (group == null) {
            this.log("isColumnHeaderRendered", "Cannot determine if column header is rendered, TableRowGroup is null");
            return result;
        }
        Iterator kids = group.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumn col = (TableColumn)((Object)kids.next());
            if (!this.isColumnHeaderRendered(col)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isColumnHeaderRendered(TableColumn component) {
        UIComponent facet;
        boolean rendered = false;
        if (component == null) {
            this.log("isColumnHeaderRendered", "Cannot determine if column header is rendered, TableColumn is null");
            return rendered;
        }
        Iterator kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn col = (TableColumn)((Object)kids.next());
                if (!this.isColumnHeaderRendered(col)) continue;
                return true;
            }
        }
        if ((facet = component.getFacet(COLUMN_HEADER_FACET)) != null || component.getHeaderText() != null) {
            rendered = true;
        }
        return rendered;
    }

    private boolean isEmptyTable() {
        boolean result = false;
        Table table = this.getTableAncestor();
        TableRowGroup group = this.getTableRowGroupAncestor();
        if (table != null && group != null) {
            int rows = table.getRowCount();
            int headers = table.getColumnHeadersCount();
            result = headers > 1 ? group.getRowCount() <= 1 : rows == 0 || rows == 1;
        }
        return result;
    }

    private boolean isTableColumnFooterRendered() {
        boolean result = false;
        TableRowGroup group = this.getTableRowGroupAncestor();
        if (group == null) {
            this.log("isTableColumnFooterRendered", "Cannot determine if table column footer is rendered, TableRowGroup is null");
            return result;
        }
        Iterator kids = group.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumn col = (TableColumn)((Object)kids.next());
            if (!this.isTableColumnFooterRendered(col)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isTableColumnFooterRendered(TableColumn component) {
        UIComponent facet;
        boolean rendered = false;
        if (component == null) {
            this.log("isTableColumnFooterRendered", "Cannot determine if table column footer is rendered, TableColumn is null");
            return rendered;
        }
        Iterator kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn col = (TableColumn)((Object)kids.next());
                if (!this.isTableColumnFooterRendered(col)) continue;
                return true;
            }
        }
        if ((facet = component.getFacet(TABLE_COLUMN_FOOTER_FACET)) != null || component.getTableFooterText() != null) {
            rendered = true;
        }
        return rendered;
    }

    private void log(String method, String message) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }

    private class Properties {
        private TableColumn tableColumn = null;
        private List tableColumnChildren = null;
        private TableRowGroup tableRowGroup = null;
        private int columnCount = -1;
        private int rowCount = -1;

        public int getColumnCount() {
            return this.columnCount;
        }

        public void setColumnCount(int columnCount) {
            this.columnCount = columnCount;
        }

        private int getRowCount() {
            return this.rowCount;
        }

        private void setRowCount(int rowCount) {
            this.rowCount = rowCount;
        }

        public TableColumn getTableColumnAncestor() {
            return this.tableColumn;
        }

        public void setTableColumnAncestor(TableColumn tableColumn) {
            this.tableColumn = tableColumn;
        }

        public List getTableColumnChildren() {
            return this.tableColumnChildren;
        }

        public void setTableColumnChildren(List tableColumnChildren) {
            this.tableColumnChildren = tableColumnChildren;
        }

        public TableRowGroup getTableRowGroupAncestor() {
            return this.tableRowGroup;
        }

        public void setTableRowGroupAncestor(TableRowGroup tableRowGroup) {
            this.tableRowGroup = tableRowGroup;
        }
    }
}

