/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.Button;
import com.sun.web.ui.component.Icon;
import com.sun.web.ui.component.IconHyperlink;
import com.sun.web.ui.component.Label;
import com.sun.web.ui.component.StaticText;
import com.sun.web.ui.component.Table;
import com.sun.web.ui.component.TableActionsBase;
import com.sun.web.ui.component.TableRowGroup;
import com.sun.web.ui.component.TextField;
import com.sun.web.ui.event.TablePaginationActionListener;
import com.sun.web.ui.event.TableSortActionListener;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ClientSniffer;
import com.sun.web.ui.util.LogUtil;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class TableActions
extends TableActionsBase
implements NamingContainer {
    public static final String ACTIONS_SEPARATOR_ICON_ID = "_actionsSeparatorIcon";
    public static final String ACTIONS_SEPARATOR_ICON_FACET = "actionsSeparatorIcon";
    public static final String CLEAR_SORT_BUTTON_ID = "_clearSortButton";
    public static final String CLEAR_SORT_BUTTON_FACET = "clearSortButton";
    public static final String DESELECT_MULTIPLE_BUTTON_ID = "_deselectMultipleButton";
    public static final String DESELECT_MULTIPLE_BUTTON_FACET = "deselectMultipleButton";
    public static final String DESELECT_SINGLE_BUTTON_ID = "_deselectSingleButton";
    public static final String DESELECT_SINGLE_BUTTON_FACET = "deselectSingleButton";
    public static final String FILTER_LABEL_ID = "_filterLabel";
    public static final String FILTER_LABEL_FACET = "filterLabel";
    public static final String FILTER_SEPARATOR_ICON_ID = "_filterSeparatorIcon";
    public static final String FILTER_SEPARATOR_ICON_FACET = "filterSeparatorIcon";
    public static final String PAGINATE_BUTTON_ID = "_paginateButton";
    public static final String PAGINATE_BUTTON_FACET = "paginateButton";
    public static final String PAGINATE_SEPARATOR_ICON_ID = "_paginateSeparatorIcon";
    public static final String PAGINATE_SEPARATOR_ICON_FACET = "paginateSeparatorIcon";
    public static final String PAGINATION_FIRST_BUTTON_ID = "_paginationFirstButton";
    public static final String PAGINATION_FIRST_BUTTON_FACET = "paginationFirstButton";
    public static final String PAGINATION_LAST_BUTTON_ID = "_paginationLastButton";
    public static final String PAGINATION_LAST_BUTTON_FACET = "paginationLastButton";
    public static final String PAGINATION_NEXT_BUTTON_ID = "_paginationNextButton";
    public static final String PAGINATION_NEXT_BUTTON_FACET = "paginationNextButton";
    public static final String PAGINATION_PAGE_FIELD_ID = "_paginationPageField";
    public static final String PAGINATION_PAGE_FIELD_FACET = "paginationPageField";
    public static final String PAGINATION_PAGES_TEXT_ID = "_paginationPagesText";
    public static final String PAGINATION_PAGES_TEXT_FACET = "paginationPagesText";
    public static final String PAGINATION_PREV_BUTTON_ID = "_paginationPrevButton";
    public static final String PAGINATION_PREV_BUTTON_FACET = "paginationPrevButton";
    public static final String PAGINATION_SUBMIT_BUTTON_ID = "_paginationSubmitButton";
    public static final String PAGINATION_SUBMIT_BUTTON_FACET = "paginationSubmitButton";
    public static final String PREFERENCES_PANEL_TOGGLE_BUTTON_ID = "_preferencesPanelToggleButton";
    public static final String PREFERENCES_PANEL_TOGGLE_BUTTON_FACET = "preferencesPanelToggleButton";
    public static final String SELECT_MULTIPLE_BUTTON_ID = "_selectMultipleButton";
    public static final String SELECT_MULTIPLE_BUTTON_FACET = "selectMultipleButton";
    public static final String SORT_PANEL_TOGGLE_BUTTON_ID = "_sortPanelToggleButton";
    public static final String SORT_PANEL_TOGGLE_BUTTON_FACET = "sortPanelToggleButton";
    public static final String VIEW_ACTIONS_SEPARATOR_ICON_ID = "_viewActionsSeparatorIcon";
    public static final String VIEW_ACTIONS_SEPARATOR_ICON_FACET = "viewActionsSeparatorIcon";
    private Table table = null;

    public Table getTableAncestor() {
        if (this.table == null) {
            TableActions component = this;
            while (component != null) {
                if (!((component = component.getParent()) instanceof Table)) continue;
                this.table = (Table)((Object)component);
                break;
            }
        }
        return this.table;
    }

    public UIComponent getPaginationFirstButton() {
        TableRowGroup group;
        UIComponent facet = this.getFacet(PAGINATION_FIRST_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Table table = this.getTableAncestor();
        TableRowGroup tableRowGroup = group = table != null ? table.getTableRowGroupChild() : null;
        boolean disabled = group != null ? group.getFirst() <= 0 : false;
        IconHyperlink child = new IconHyperlink();
        child.setId(PAGINATION_FIRST_BUTTON_ID);
        child.setIcon(disabled ? "TABLE_PAGINATION_FIRST_DISABLED" : "TABLE_PAGINATION_FIRST");
        child.setBorder(0);
        child.setAlign("top");
        child.setDisabled(disabled);
        child.addActionListener(new TablePaginationActionListener());
        String toolTip = this.getTheme().getMessage("table.pagination.first");
        child.setAlt(toolTip);
        child.setToolTip(toolTip);
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
        } else {
            this.log("getPaginationFirstButton", "Tab index not set, Table is null");
        }
        this.setPaginationFocus(child);
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getPaginationSubmitButton() {
        UIComponent facet = this.getFacet(PAGINATION_SUBMIT_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Button child = new Button();
        child.setId(PAGINATION_SUBMIT_BUTTON_ID);
        child.setText(this.getTheme().getMessage("table.pagination.submit"));
        child.setToolTip(this.getTheme().getMessage("table.pagination.submitPage"));
        child.addActionListener(new TablePaginationActionListener());
        Table table = this.getTableAncestor();
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
        } else {
            this.log("getPaginationSubmitButton", "Tab index not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getPaginationLastButton() {
        TableRowGroup group;
        UIComponent facet = this.getFacet(PAGINATION_LAST_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Table table = this.getTableAncestor();
        TableRowGroup tableRowGroup = group = table != null ? table.getTableRowGroupChild() : null;
        boolean disabled = group != null ? group.getFirst() >= group.getLast() : false;
        IconHyperlink child = new IconHyperlink();
        child.setId(PAGINATION_LAST_BUTTON_ID);
        child.setIcon(disabled ? "TABLE_PAGINATION_LAST_DISABLED" : "TABLE_PAGINATION_LAST");
        child.setBorder(0);
        child.setAlign("top");
        child.setDisabled(disabled);
        child.addActionListener(new TablePaginationActionListener());
        String toolTip = this.getTheme().getMessage("table.pagination.last");
        child.setAlt(toolTip);
        child.setToolTip(toolTip);
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
        } else {
            this.log("getPaginationLastButton", "Tab index not set, Table is null");
        }
        this.setPaginationFocus(child);
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getPaginationNextButton() {
        TableRowGroup group;
        UIComponent facet = this.getFacet(PAGINATION_NEXT_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Table table = this.getTableAncestor();
        TableRowGroup tableRowGroup = group = table != null ? table.getTableRowGroupChild() : null;
        boolean disabled = group != null ? group.getFirst() >= group.getLast() : false;
        IconHyperlink child = new IconHyperlink();
        child.setId(PAGINATION_NEXT_BUTTON_ID);
        child.setIcon(disabled ? "TABLE_PAGINATION_NEXT_DISABLED" : "TABLE_PAGINATION_NEXT");
        child.setBorder(0);
        child.setAlign("top");
        child.setDisabled(disabled);
        child.addActionListener(new TablePaginationActionListener());
        String toolTip = this.getTheme().getMessage("table.pagination.next");
        child.setAlt(toolTip);
        child.setToolTip(toolTip);
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
        } else {
            this.log("getPaginationNextButton", "Tab index not set, Table is null");
        }
        this.setPaginationFocus(child);
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getPaginationPageField() {
        UIComponent facet = this.getFacet(PAGINATION_PAGE_FIELD_FACET);
        if (facet != null) {
            return facet;
        }
        Table table = this.getTableAncestor();
        TableRowGroup group = table != null ? table.getTableRowGroupChild() : null;
        int page = group != null ? group.getPage() : 1;
        TextField child = new TextField();
        child.setId(PAGINATION_PAGE_FIELD_ID);
        child.setText(Integer.toString(page));
        child.setOnKeyPress(this.getPaginationJavascript());
        child.setColumns(3);
        child.setLabelLevel(2);
        child.setLabel(this.getTheme().getMessage("table.pagination.page"));
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
        } else {
            this.log("getPaginationPageField", "Tab index not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getPaginationPagesText() {
        UIComponent facet = this.getFacet(PAGINATION_PAGES_TEXT_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = this.getTheme();
        StaticText child = new StaticText();
        child.setId(PAGINATION_PAGES_TEXT_ID);
        child.setStyleClass(theme.getStyleClass("TblPgnTxt"));
        Table table = this.getTableAncestor();
        if (table != null) {
            child.setText(theme.getMessage("table.pagination.pages", new String[]{Integer.toString(table.getPageCount())}));
        } else {
            this.log("getPaginationPagesText", "Pages text not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getPaginateButton() {
        UIComponent facet = this.getFacet(PAGINATE_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Table table = this.getTableAncestor();
        TableRowGroup group = table != null ? table.getTableRowGroupChild() : null;
        boolean paginated = group != null ? group.isPaginated() : false;
        IconHyperlink child = new IconHyperlink();
        child.setId(PAGINATE_BUTTON_ID);
        child.setIcon(paginated ? "TABLE_SCROLL_PAGE" : "TABLE_PAGINATE");
        child.setBorder(0);
        child.setAlign("top");
        child.addActionListener(new TablePaginationActionListener());
        String toolTip = paginated ? this.getTheme().getMessage("table.pagination.scroll") : this.getTheme().getMessage("table.pagination.paginated");
        child.setAlt(toolTip);
        child.setToolTip(toolTip);
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
        } else {
            this.log("getPaginateButton", "Tab index not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getPaginationPrevButton() {
        TableRowGroup group;
        UIComponent facet = this.getFacet(PAGINATION_PREV_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Table table = this.getTableAncestor();
        TableRowGroup tableRowGroup = group = table != null ? table.getTableRowGroupChild() : null;
        boolean disabled = group != null ? group.getFirst() <= 0 : false;
        IconHyperlink child = new IconHyperlink();
        child.setId(PAGINATION_PREV_BUTTON_ID);
        child.setIcon(disabled ? "TABLE_PAGINATION_PREV_DISABLED" : "TABLE_PAGINATION_PREV");
        child.setBorder(0);
        child.setAlign("top");
        child.setDisabled(disabled);
        child.addActionListener(new TablePaginationActionListener());
        String toolTip = this.getTheme().getMessage("table.pagination.previous");
        child.setAlt(toolTip);
        child.setToolTip(toolTip);
        if (table != null) {
            child.setTabIndex(table.getTabIndex());
        } else {
            this.log("getPaginationPrevButton", "Tab index not set, Table is null");
        }
        this.setPaginationFocus(child);
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getDeselectMultipleButton() {
        UIComponent facet = this.getFacet(DESELECT_MULTIPLE_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Table table = this.getTableAncestor();
        TableRowGroup group = table != null ? table.getTableRowGroupChild() : null;
        boolean paginated = group != null ? group.isPaginated() : false;
        IconHyperlink child = new IconHyperlink();
        child.setId(DESELECT_MULTIPLE_BUTTON_ID);
        child.setIcon("TABLE_DESELECT_MULTIPLE");
        child.setBorder(0);
        child.setAlign("top");
        if (table != null) {
            child.setOnClick(this.getSelectJavascript(table.getDeselectMultipleButtonOnClick(), false));
            child.setTabIndex(table.getTabIndex());
        } else {
            this.log("getDeselectMultipleButton", "Tab index & onClick not set, Table is null");
        }
        String toolTip = this.getTheme().getMessage(paginated ? "table.select.deselectMultiplePaginated" : "table.select.deselectMultiple");
        child.setAlt(toolTip);
        child.setToolTip(toolTip);
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getDeselectSingleButton() {
        UIComponent facet = this.getFacet(DESELECT_SINGLE_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Table table = this.getTableAncestor();
        TableRowGroup group = table != null ? table.getTableRowGroupChild() : null;
        boolean paginated = group != null ? group.isPaginated() : false;
        IconHyperlink child = new IconHyperlink();
        child.setId(DESELECT_SINGLE_BUTTON_ID);
        child.setIcon("TABLE_DESELECT_SINGLE");
        child.setBorder(0);
        child.setAlign("top");
        if (table != null) {
            child.setOnClick(this.getSelectJavascript(table.getDeselectSingleButtonOnClick(), false));
            child.setTabIndex(table.getTabIndex());
        } else {
            this.log("getDeselectSingleButton", "Tab index & onClick not set, Table is null");
        }
        String toolTip = this.getTheme().getMessage(paginated ? "table.select.deselectSinglePaginated" : "table.select.deselectSingle");
        child.setAlt(toolTip);
        child.setToolTip(toolTip);
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getSelectMultipleButton() {
        UIComponent facet = this.getFacet(SELECT_MULTIPLE_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Table table = this.getTableAncestor();
        TableRowGroup group = table != null ? table.getTableRowGroupChild() : null;
        boolean paginated = group != null ? group.isPaginated() : false;
        IconHyperlink child = new IconHyperlink();
        child.setId(SELECT_MULTIPLE_BUTTON_ID);
        child.setIcon("TABLE_SELECT_MULTIPLE");
        child.setBorder(0);
        child.setAlign("top");
        if (table != null) {
            child.setOnClick(this.getSelectJavascript(table.getDeselectMultipleButtonOnClick(), true));
            child.setTabIndex(table.getTabIndex());
        } else {
            this.log("getSelectMultipleButton", "Tab index & onClick not set, Table is null");
        }
        String toolTip = this.getTheme().getMessage(paginated ? "table.select.selectMultiplePaginated" : "table.select.selectMultiple");
        child.setAlt(toolTip);
        child.setToolTip(toolTip);
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getActionsSeparatorIcon() {
        return this.getSeparatorIcon(ACTIONS_SEPARATOR_ICON_ID, ACTIONS_SEPARATOR_ICON_FACET);
    }

    public UIComponent getFilterSeparatorIcon() {
        return this.getSeparatorIcon(FILTER_SEPARATOR_ICON_ID, FILTER_SEPARATOR_ICON_FACET);
    }

    public UIComponent getPaginateSeparatorIcon() {
        return this.getSeparatorIcon(PAGINATE_SEPARATOR_ICON_ID, PAGINATE_SEPARATOR_ICON_FACET);
    }

    public UIComponent getViewActionsSeparatorIcon() {
        return this.getSeparatorIcon(VIEW_ACTIONS_SEPARATOR_ICON_ID, VIEW_ACTIONS_SEPARATOR_ICON_FACET);
    }

    public UIComponent getClearSortButton() {
        UIComponent facet = this.getFacet(CLEAR_SORT_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        IconHyperlink child = new IconHyperlink();
        child.setId(CLEAR_SORT_BUTTON_ID);
        child.setIcon("TABLE_SORT_CLEAR");
        child.setBorder(0);
        child.setAlign("top");
        child.addActionListener(new TableSortActionListener());
        String toolTip = this.getTheme().getMessage("table.viewActions.clearSort");
        child.setAlt(toolTip);
        child.setToolTip(toolTip);
        if (this.table != null) {
            child.setTabIndex(this.table.getTabIndex());
        } else {
            this.log("getClearSortButton", "Tab index not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getFilterLabel() {
        UIComponent facet = this.getFacet(FILTER_LABEL_FACET);
        if (facet != null) {
            return facet;
        }
        Label child = new Label();
        child.setId(FILTER_LABEL_ID);
        child.setText(this.getTheme().getMessage("table.viewActions.filter"));
        child.setLabelLevel(2);
        Table table = this.getTableAncestor();
        if (table != null) {
            child.setLabeledComponent(table.getFacet("filter"));
        } else {
            this.log("getFilterLabel", "Labeled component not set, Table is null");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getPreferencesPanelToggleButton() {
        UIComponent facet = this.getFacet(PREFERENCES_PANEL_TOGGLE_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        IconHyperlink child = new IconHyperlink();
        child.setId(PREFERENCES_PANEL_TOGGLE_BUTTON_ID);
        child.setIcon("TABLE_PREFERENCES_PANEL");
        child.setBorder(0);
        child.setAlign("top");
        Table table = this.getTableAncestor();
        if (table != null) {
            StringBuffer buff = new StringBuffer(128).append("document.getElementById('").append(table.getClientId(this.getFacesContext())).append("').togglePreferencesPanel(); return false");
            child.setOnClick(buff.toString());
            child.setTabIndex(table.getTabIndex());
        } else {
            this.log("getPreferencesPanelToggleButton", "Tab index & onClick not set, Table is null");
        }
        String toolTip = this.getTheme().getMessage("table.viewActions.preferences");
        child.setAlt(toolTip);
        child.setToolTip(toolTip);
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getSortPanelToggleButton() {
        UIComponent facet = this.getFacet(SORT_PANEL_TOGGLE_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        IconHyperlink child = new IconHyperlink();
        child.setId(SORT_PANEL_TOGGLE_BUTTON_ID);
        child.setIcon("TABLE_SORT_PANEL");
        child.setBorder(0);
        child.setAlign("top");
        Table table = this.getTableAncestor();
        if (table != null) {
            StringBuffer buff = new StringBuffer(128).append("document.getElementById('").append(table.getClientId(this.getFacesContext())).append("').toggleSortPanel(); return false");
            child.setOnClick(buff.toString());
            child.setTabIndex(table.getTabIndex());
        } else {
            this.log("getSortPanelToggleButton", "Tab index & onClick not set, Table is null");
        }
        Theme theme = this.getTheme();
        String toolTip = theme.getMessage("table.viewActions.sort");
        child.setAlt(toolTip);
        child.setToolTip(toolTip);
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.table = null;
        super.encodeBegin(context);
    }

    private String getSelectJavascript(String script, boolean checked) {
        Table table;
        StringBuffer buff = new StringBuffer(1024);
        if (script != null) {
            buff.append(script).append(";");
        }
        if ((table = this.getTableAncestor()) != null) {
            buff.append("document.getElementById('").append(table.getClientId(this.getFacesContext())).append("').selectAllRows(").append(checked).append("); return false");
        } else {
            this.log("getSelectJavascript", "Cannot obtain select Javascript, Table is null");
        }
        return buff.toString();
    }

    private UIComponent getSeparatorIcon(String id, String name) {
        UIComponent facet = this.getFacet(name);
        if (facet != null) {
            return facet;
        }
        Icon child = this.getTheme().getIcon("TABLE_ACTIONS_SEPARATOR");
        child.setId(id);
        child.setBorder(0);
        child.setAlign("top");
        this.getFacets().put(child.getId(), child);
        return child;
    }

    private String getPaginationJavascript() {
        ClientSniffer cs = ClientSniffer.getInstance(this.getFacesContext());
        String keyCode = cs.isNav() ? "event.which" : "event.keyCode";
        StringBuffer buff = new StringBuffer(128).append("if (").append(keyCode).append("==13) {");
        if (cs.isNav6() || cs.isNav70()) {
            buff.append("event.cancelBubble = true;");
        }
        buff.append("var e=document.getElementById('").append(this.getClientId(this.getFacesContext()) + ':' + PAGINATION_SUBMIT_BUTTON_ID).append("'); if (e != null) e.click(); return false}");
        return buff.toString();
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(this.getFacesContext());
    }

    private boolean isEmptyTable() {
        int totalRows = this.table.getRowCount();
        return totalRows == 0;
    }

    private boolean isSinglePage() {
        int totalRows = this.table.getRowCount();
        return totalRows < this.table.getRows();
    }

    private boolean isSingleRow() {
        int totalRows = this.table.getRowCount();
        return totalRows == 1;
    }

    private void log(String method, String message) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }

    private void setPaginationFocus(IconHyperlink component) {
        if (component == null || !component.isDisabled()) {
            return;
        }
        FacesContext context = this.getFacesContext();
        String prefix = this.getClientId(context) + ':';
        String id = RenderingUtilities.getLastClientID(context);
        if (id == null) {
            return;
        }
        if (id.equals(prefix + PAGINATION_FIRST_BUTTON_ID) || id.equals(prefix + PAGINATION_LAST_BUTTON_ID) || id.equals(prefix + PAGINATION_NEXT_BUTTON_ID) || id.equals(prefix + PAGINATION_PREV_BUTTON_ID)) {
            RenderingUtilities.setLastClientID(context, prefix + PAGINATION_PAGE_FIELD_ID + "_field");
        }
    }
}

