/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.Button;
import com.sun.web.ui.component.CalendarMonth;
import com.sun.web.ui.component.ComplexComponent;
import com.sun.web.ui.component.DateManager;
import com.sun.web.ui.component.DropDown;
import com.sun.web.ui.component.Label;
import com.sun.web.ui.component.SchedulerBase;
import com.sun.web.ui.component.TextField;
import com.sun.web.ui.component.Time;
import com.sun.web.ui.converter.DateConverter;
import com.sun.web.ui.event.IntervalListener;
import com.sun.web.ui.event.SchedulerPreviewListener;
import com.sun.web.ui.model.ClockTime;
import com.sun.web.ui.model.Option;
import com.sun.web.ui.model.ScheduledEvent;
import com.sun.web.ui.model.scheduler.RepeatInterval;
import com.sun.web.ui.model.scheduler.RepeatIntervalConverter;
import com.sun.web.ui.model.scheduler.RepeatIntervalOption;
import com.sun.web.ui.model.scheduler.RepeatUnit;
import com.sun.web.ui.model.scheduler.RepeatUnitConverter;
import com.sun.web.ui.model.scheduler.RepeatUnitOption;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ThemeUtilities;
import com.sun.web.ui.validator.DateInRangeValidator;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.IntegerConverter;
import javax.faces.validator.Validator;

public class Scheduler
extends SchedulerBase
implements ComplexComponent,
DateManager,
NamingContainer {
    public static final String DATE_PICKER_FACET = "datePicker";
    public static final String DATE_PICKER_ID = "_datePicker";
    public static final String DATE_FACET = "date";
    public static final String DATE_ID = "_date";
    public static final String DATE_LABEL_FACET = "dateLabel";
    public static final String DATE_LABEL_ID = "_dateLabel";
    public static final String START_TIME_LABEL_FACET = "startTimeLabel";
    public static final String START_TIME_LABEL_ID = "_startTimeLabel";
    public static final String END_TIME_LABEL_FACET = "endTimeLabel";
    public static final String END_TIME_LABEL_ID = "_endTimeLabel";
    public static final String START_TIME_FACET = "startTime";
    public static final String START_TIME_ID = "_startTime";
    public static final String END_TIME_FACET = "endTime";
    public static final String END_TIME_ID = "_endTime";
    public static final String REPEAT_LIMIT_LABEL_FACET = "repeatLimitLabel";
    public static final String REPEAT_LIMIT_LABEL_ID = "_repeatLimitLabel";
    public static final String REPEAT_LIMIT_FACET = "repeatLimit";
    public static final String REPEAT_LIMIT_ID = "_repeatLimit";
    public static final String REPEAT_LIMIT_UNIT_FACET = "repeatLimitUnit";
    public static final String REPEAT_LIMIT_UNIT_ID = "_repeatLimitUnit";
    public static final String REPEAT_INTERVAL_LABEL_FACET = "repeatIntervalLabel";
    public static final String REPEAT_INTERVAL_LABEL_ID = "_repeatIntervalLabel";
    public static final String REPEAT_INTERVAL_FACET = "repeatInterval";
    public static final String REPEAT_INTERVAL_ID = "_repeatInterval";
    public static final String PREVIEW_BUTTON_FACET = "previewButton";
    public static final String PREVIEW_BUTTON_ID = "_previewButton";
    public static final String ICON_ID = "_icon";
    public static final String JAVASCRIPT_OBJECT = "_jsObject";
    private static final String VALUE_SUBMITTED = "com.sun.web.ui.SchedulerSubmitted";
    private static final boolean DEBUG = false;

    public CalendarMonth getDatePicker() {
        Object comp = this.getFacet(DATE_PICKER_FACET);
        if (comp == null || !(comp instanceof CalendarMonth)) {
            CalendarMonth datePicker = new CalendarMonth();
            datePicker.setPopup(false);
            datePicker.setId(this.getId().concat(DATE_PICKER_ID));
            this.getFacets().put(DATE_PICKER_FACET, datePicker);
            comp = datePicker;
        }
        ((CalendarMonth)((Object)comp)).setJavaScriptObjectName(this.getJavaScriptObjectName(FacesContext.getCurrentInstance()));
        return (CalendarMonth)((Object)comp);
    }

    public UIComponent getDateLabelComponent(Theme theme) {
        String label = this.getDateLabel();
        if (label == null) {
            label = theme.getMessage("Scheduler.startDate");
        }
        return this.getLabelComponent(label, this.getDateComponent(), DATE_LABEL_FACET, DATE_LABEL_ID);
    }

    public UIComponent getDateComponent() {
        String id = this.getId();
        Object fieldComponent = this.getFacet(DATE_FACET);
        if (fieldComponent == null) {
            fieldComponent = this.createField(DATE_ID, DATE_FACET, 12, this.isRequired());
            ((EditableValueHolder)fieldComponent).setConverter((Converter)new DateConverter());
            ((EditableValueHolder)fieldComponent).addValidator((Validator)new DateInRangeValidator());
        }
        if (fieldComponent instanceof EditableValueHolder && this.isDisabled()) {
            fieldComponent.getAttributes().put("disabled", Boolean.TRUE);
        }
        return fieldComponent;
    }

    public UIComponent getStartTimeLabelComponent(Theme theme) {
        String label = this.getStartTimeLabel();
        if (label == null) {
            label = theme.getMessage("Scheduler.startTime");
        }
        return this.getLabelComponent(label, (UIComponent)this.getStartTimeComponent(), START_TIME_LABEL_FACET, START_TIME_LABEL_ID);
    }

    public Time getStartTimeComponent() {
        return this.getTimeComponent(START_TIME_FACET, START_TIME_ID, this.isRequired(), "Scheduler.startHourTitle", "Scheduler.startMinuteTitle");
    }

    public UIComponent getEndTimeLabelComponent(Theme theme) {
        String label = this.getEndTimeLabel();
        if (label == null) {
            label = theme.getMessage("Scheduler.endTime");
        }
        return this.getLabelComponent(label, (UIComponent)this.getEndTimeComponent(), END_TIME_LABEL_FACET, END_TIME_LABEL_ID);
    }

    public Time getEndTimeComponent() {
        return this.getTimeComponent(END_TIME_FACET, END_TIME_ID, false, "Scheduler.endHourTitle", "Scheduler.endMinuteTitle");
    }

    public UIComponent getRepeatIntervalLabelComponent() {
        return this.getLabelComponent(this.getRepeatIntervalLabel(), (UIComponent)this.getRepeatIntervalComponent(), REPEAT_INTERVAL_LABEL_FACET, REPEAT_INTERVAL_LABEL_ID);
    }

    public DropDown getRepeatIntervalComponent() {
        Object comp = this.getFacet(REPEAT_INTERVAL_FACET);
        if (comp == null || !(comp instanceof DropDown)) {
            DropDown dropDown = new DropDown();
            dropDown.setSubmitForm(true);
            dropDown.setConverter(new RepeatIntervalConverter());
            dropDown.setImmediate(true);
            dropDown.setId(this.getId().concat(REPEAT_INTERVAL_ID));
            dropDown.addActionListener(new IntervalListener());
            this.getFacets().put(REPEAT_INTERVAL_FACET, dropDown);
            comp = dropDown;
        }
        return (DropDown)comp;
    }

    public UIComponent getRepeatLimitLabelComponent() {
        return this.getLabelComponent(this.getRepeatLimitLabel(), this.getRepeatingFieldComponent(), REPEAT_LIMIT_LABEL_FACET, REPEAT_LIMIT_LABEL_ID);
    }

    public UIComponent getRepeatingFieldComponent() {
        String id = this.getId();
        Object fieldComponent = this.getFacet(REPEAT_LIMIT_FACET);
        if (fieldComponent == null) {
            fieldComponent = this.createField(REPEAT_LIMIT_ID, REPEAT_LIMIT_FACET, 3, false);
            IntegerConverter converter = new IntegerConverter();
            ((EditableValueHolder)fieldComponent).setConverter((Converter)converter);
        }
        if (fieldComponent instanceof EditableValueHolder && this.isDisabled()) {
            fieldComponent.getAttributes().put("disabled", Boolean.TRUE);
        }
        return fieldComponent;
    }

    public DropDown getRepeatUnitComponent() {
        Object comp = this.getFacet(REPEAT_LIMIT_UNIT_FACET);
        if (comp == null || !(comp instanceof DropDown)) {
            DropDown dropDown = new DropDown();
            dropDown.setConverter(new RepeatUnitConverter());
            dropDown.setId(this.getId().concat(REPEAT_LIMIT_UNIT_ID));
            this.getFacets().put(REPEAT_LIMIT_UNIT_FACET, dropDown);
            comp = dropDown;
        }
        return (DropDown)comp;
    }

    public Button getPreviewButtonComponent() {
        Object comp = this.getFacet(PREVIEW_BUTTON_FACET);
        if (comp == null && !(comp instanceof Button)) {
            Button button = new Button();
            button.setMini(true);
            button.setPrimary(false);
            button.setImmediate(true);
            button.setId(this.getId().concat(PREVIEW_BUTTON_ID));
            button.addActionListener(new SchedulerPreviewListener());
            this.getFacets().put(PREVIEW_BUTTON_FACET, button);
            comp = button;
        }
        return (Button)comp;
    }

    public void updateRepeatUnitMenu() {
        if (!this.isLimitRepeating()) {
            return;
        }
        DropDown repeatIntervalComp = this.getRepeatIntervalComponent();
        Object value = repeatIntervalComp.getValue();
        if (value == null || !(value instanceof RepeatInterval)) {
            this.disableRepeatLimitComponents();
        } else {
            RepeatInterval ri = (RepeatInterval)value;
            if (ri.getRepresentation().equals("ONETIME")) {
                this.disableRepeatLimitComponents();
            } else {
                this.enableRepeatLimitComponents((RepeatInterval)value);
            }
        }
    }

    public String getPrimaryElementID(FacesContext context) {
        UIComponent comp = this.getDateComponent();
        if (comp instanceof ComplexComponent) {
            return ((ComplexComponent)comp).getPrimaryElementID(context);
        }
        return this.getDateComponent().getClientId(context);
    }

    public Object getRepeatIntervalItems() {
        Option[] optionsObject = super.getRepeatIntervalItems();
        if (optionsObject == null) {
            Option[] options = new Option[]{new RepeatIntervalOption(RepeatInterval.getInstance("ONETIME")), new RepeatIntervalOption(RepeatInterval.getInstance("HOURLY")), new RepeatIntervalOption(RepeatInterval.getInstance("DAILY")), new RepeatIntervalOption(RepeatInterval.getInstance("WEEKLY")), new RepeatIntervalOption(RepeatInterval.getInstance("MONTHLY"))};
            optionsObject = options;
            super.setRepeatIntervalItems(options);
        }
        return optionsObject;
    }

    public Object getRepeatUnitItems() {
        Option[] optionsObject = super.getRepeatUnitItems();
        if (optionsObject == null) {
            Option[] options = new Option[]{new RepeatUnitOption(RepeatUnit.getInstance("HOURS")), new RepeatUnitOption(RepeatUnit.getInstance("DAYS")), new RepeatUnitOption(RepeatUnit.getInstance("WEEKS")), new RepeatUnitOption(RepeatUnit.getInstance("MONTHS"))};
            optionsObject = options;
            super.setRepeatUnitItems(options);
        }
        return optionsObject;
    }

    public DateFormat getDateFormat() {
        return this.getDatePicker().getDateFormat();
    }

    public String getJavaScriptObjectName(FacesContext context) {
        return this.getClientId(context).replace(':', '_').concat(JAVASCRIPT_OBJECT);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.setValid(true);
        this.getFacet(DATE_PICKER_FACET).processDecodes(context);
        this.getFacet(PREVIEW_BUTTON_FACET).processDecodes(context);
        this.getFacet(DATE_FACET).processDecodes(context);
        if (this.isStartTime()) {
            this.getFacet(START_TIME_FACET).processDecodes(context);
        }
        if (this.isEndTime()) {
            this.getFacet(END_TIME_FACET).processDecodes(context);
        }
        if (this.isRepeating()) {
            this.getFacet(REPEAT_INTERVAL_FACET).processDecodes(context);
            if (this.isLimitRepeating()) {
                this.getFacet(REPEAT_LIMIT_FACET).processDecodes(context);
                this.getFacet(REPEAT_LIMIT_UNIT_FACET).processDecodes(context);
            }
        }
        this.setSubmittedValue(VALUE_SUBMITTED);
        if (this.isImmediate()) {
            this.runValidation(context);
        }
    }

    public Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        if (context == null) {
            throw new NullPointerException();
        }
        Iterator kids = this.getFacetsAndChildren();
        UIComponent kid = null;
        while (kids.hasNext()) {
            kid = (UIComponent)kids.next();
            if (!(kid instanceof EditableValueHolder) || ((EditableValueHolder)kid).isValid()) continue;
            String message = ThemeUtilities.getTheme(context).getMessage("Scheduler.invalidInput");
            throw new ConverterException(message);
        }
        Object dateValue = ((EditableValueHolder)this.getDateComponent()).getValue();
        Object startTimeValue = null;
        Object endTimeValue = null;
        if (this.isStartTime()) {
            startTimeValue = this.getStartTimeComponent().getValue();
        }
        if (this.isEndTime()) {
            endTimeValue = this.getEndTimeComponent().getValue();
        }
        ScheduledEvent newValue = this.createScheduledEvent(dateValue, startTimeValue, endTimeValue, context);
        if (this.isRepeating()) {
            RepeatInterval freq;
            boolean valueRepeat = false;
            Object repeatFrequency = this.getRepeatIntervalComponent().getValue();
            if (repeatFrequency != null && repeatFrequency instanceof RepeatInterval && (freq = (RepeatInterval)repeatFrequency).getCalendarField() > -1) {
                valueRepeat = true;
            }
            if (valueRepeat) {
                newValue.setRepeatingEvent(true);
                try {
                    newValue.setRepeatInterval((RepeatInterval)repeatFrequency);
                    if (this.isLimitRepeating()) {
                        Object repeatUnit = this.getRepeatUnitComponent().getValue();
                        if (repeatUnit instanceof RepeatUnit) {
                            newValue.setDurationUnit((RepeatUnit)repeatUnit);
                        } else {
                            newValue.setDurationUnit(null);
                        }
                        Object repeatLimit = ((EditableValueHolder)this.getRepeatingFieldComponent()).getValue();
                        if (repeatLimit instanceof Integer) {
                            newValue.setDuration((Integer)repeatLimit);
                        }
                        newValue.setDuration(null);
                    }
                    newValue.setDurationUnit(null);
                    newValue.setDuration(null);
                }
                catch (Exception ce) {
                    throw new ConverterException();
                }
            } else {
                newValue.setRepeatingEvent(false);
                newValue.setDurationUnit(null);
                newValue.setDuration(null);
            }
        } else {
            newValue.setRepeatingEvent(false);
            newValue.setDurationUnit(null);
            newValue.setDuration(null);
        }
        this.getDatePicker().setValue(newValue);
        return newValue;
    }

    private TextField createField(String id, String facetName, int columns, boolean required) {
        TextField field = new TextField();
        field.setId(this.getId().concat(id));
        field.setColumns(columns);
        field.setTrim(true);
        field.setRequired(required);
        if (this.getTabIndex() > 0) {
            field.setTabIndex(this.getTabIndex());
        }
        this.getFacets().put(facetName, field);
        return field;
    }

    private UIComponent getLabelComponent(String txt, UIComponent labeledComponent, String facet, String id) {
        Object labelComponent = this.getFacet(facet);
        if (labelComponent == null) {
            Label label = new Label();
            label.setId(this.getId().concat(id));
            label.setText(txt);
            label.setLabeledComponent(labeledComponent);
            label.setLabelLevel(2);
            labelComponent = label;
        }
        return labelComponent;
    }

    private Time getTimeComponent(String facet, String id, boolean required, String hourKey, String minutesKey) {
        Object timeComponent = this.getFacet(facet);
        if (timeComponent == null || !(timeComponent instanceof Time)) {
            Time time = new Time();
            time.setTimeZone(this.getTimeZone());
            time.setId(this.getId().concat(id));
            time.setRequired(required);
            time.setHourTooltipKey(hourKey);
            time.setMinutesTooltipKey(minutesKey);
            this.getFacets().put(facet, time);
            timeComponent = time;
        }
        return (Time)((Object)timeComponent);
    }

    private void runValidation(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    private ScheduledEvent createScheduledEvent(Object dateObject, Object startTimeObject, Object endTimeObject, FacesContext context) {
        ScheduledEvent event = null;
        String messageKey = null;
        if (!(dateObject instanceof Date)) {
            messageKey = "Scheduler.invalidDate";
        }
        if (!(startTimeObject instanceof ClockTime)) {
            messageKey = "Scheduler.invalidStartTime";
        }
        if (endTimeObject != null && !(endTimeObject instanceof ClockTime)) {
            messageKey = "Scheduler.invalidEndTime";
        }
        if (messageKey == null) {
            event = new ScheduledEvent();
            Date date = (Date)dateObject;
            ClockTime startTime = (ClockTime)startTimeObject;
            event.setStartTime(this.calculateDate(date, startTime));
            if (endTimeObject != null) {
                ClockTime endTime = (ClockTime)endTimeObject;
                event.setEndTime(this.calculateDate(date, endTime));
                if (event.getEndTime().before(event.getStartTime())) {
                    messageKey = "Scheduler.endBeforeStart";
                    this.getEndTimeComponent().setValid(false);
                }
            }
        }
        if (messageKey != null) {
            String message = ThemeUtilities.getTheme(context).getMessage(messageKey);
            throw new ConverterException(new FacesMessage(message));
        }
        return event;
    }

    private Date calculateDate(Date date, ClockTime time) {
        Calendar calendar = (Calendar)this.getDatePicker().getCalendar().clone();
        calendar.setTime(date);
        calendar.set(11, time.getHour());
        calendar.set(12, time.getMinute());
        return calendar.getTime();
    }

    private void disableRepeatLimitComponents() {
        DropDown dd = this.getRepeatUnitComponent();
        UIComponent comp = this.getRepeatingFieldComponent();
        dd.setDisabled(true);
        dd.setSubmittedValue(null);
        dd.setValue(null);
        comp.getAttributes().put("disabled", Boolean.TRUE);
        ((EditableValueHolder)comp).setValue(null);
        ((EditableValueHolder)comp).setSubmittedValue(null);
    }

    private void enableRepeatLimitComponents(RepeatInterval ri) {
        DropDown dd = this.getRepeatUnitComponent();
        UIComponent comp = this.getRepeatingFieldComponent();
        dd.setValue(ri.getDefaultRepeatUnit());
        dd.setSubmittedValue(null);
        dd.setDisabled(false);
        comp.getAttributes().put("disabled", Boolean.FALSE);
    }

    private void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }
}

