/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.Label;
import com.sun.web.ui.component.ListManager;
import com.sun.web.ui.component.ListSelectorBase;
import com.sun.web.ui.component.StaticText;
import com.sun.web.ui.model.Option;
import com.sun.web.ui.model.OptionGroup;
import com.sun.web.ui.model.Separator;
import com.sun.web.ui.model.list.EndGroup;
import com.sun.web.ui.model.list.ListItem;
import com.sun.web.ui.model.list.StartGroup;
import com.sun.web.ui.util.ConversionUtilities;
import com.sun.web.ui.util.MessageUtil;
import com.sun.web.ui.util.ValueType;
import java.beans.Beans;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class ListSelector
extends ListSelectorBase
implements ListManager {
    private static final boolean DEBUG = false;
    protected ArrayList listItems = null;
    private int separatorLength = 0;
    private static final String READONLY_ID = "_readOnly";
    private static final String LABEL_ID = "_label";
    private static final String READONLY_FACET = "readOnly";
    private static final String LABEL_FACET = "label";
    public static final String VALUE_ID = "_list_value";
    public static final String VALUE_LABEL_ID = "_hiddenlabel";
    public static final String LIST_ID = "_list";

    public void checkSelectionModel(FacesContext context) {
        if (this.isMultiple() && this.valueTypeEvaluator.getValueType() != ValueType.ARRAY) {
            Object[] params = new Object[]{this.toString()};
            String msg = MessageUtil.getMessage("com.sun.web.ui.resources.LogMessages", "Selector.multipleError", params);
            throw new RuntimeException(msg);
        }
    }

    public Iterator getListItems(FacesContext context, boolean rulerAtEnd) throws FacesException {
        this.listItems = new ArrayList();
        this.separatorLength = 0;
        this.processOptions(this.getOptions());
        this.processSelections();
        return this.listItems.iterator();
    }

    public Iterator getListItems() throws FacesException {
        if (this.listItems != null) {
            return this.listItems.iterator();
        }
        this.listItems = new ArrayList();
        this.processOptions(this.getOptions());
        return this.listItems.iterator();
    }

    public int getSeparatorLength() {
        return this.separatorLength;
    }

    protected Option[] getOptions() {
        Option[] options = null;
        Object optionsObject = this.getItems();
        if (optionsObject instanceof Option[]) {
            options = (Option[])optionsObject;
        } else if (optionsObject instanceof Collection) {
            Object[] objects = ((Collection)optionsObject).toArray();
            if (objects == null || objects.length == 0) {
                options = new Option[]{};
            }
            int numObjects = objects.length;
            options = new Option[numObjects];
            for (int counter = 0; counter < numObjects; ++counter) {
                options[counter] = (Option)((Object)objects[counter]);
            }
        } else if (optionsObject instanceof Map) {
            Collection itemsCollection = ((Map)optionsObject).values();
            options = (Option[])itemsCollection.toArray();
        } else {
            options = new Option[]{};
        }
        return options;
    }

    protected void processOptions(Option[] options) {
        int length = options.length;
        for (int counter = 0; counter < length; ++counter) {
            if (options[counter] instanceof OptionGroup) {
                OptionGroup selectionGroup = (OptionGroup)options[counter];
                String groupLabel = selectionGroup.getLabel();
                if ((double)groupLabel.length() * 1.5 > (double)this.separatorLength) {
                    this.separatorLength = (int)((double)groupLabel.length() * 1.5);
                }
                this.listItems.add(new StartGroup(groupLabel));
                this.processOptions(selectionGroup.getOptions());
                this.listItems.add(new EndGroup());
                continue;
            }
            if (options[counter] instanceof Separator) {
                this.listItems.add(options[counter]);
                continue;
            }
            this.listItems.add(this.createListItem(options[counter]));
        }
    }

    protected void processSelections() {
        Object value = this.getSubmittedValue();
        if (value != null) {
            if (value instanceof String[]) {
                String[] obj = (String[])value;
                ArrayList<String> list = new ArrayList<String>(obj.length);
                for (int counter = 0; counter < obj.length; ++counter) {
                    list.add(obj[counter]);
                }
                this.markSelectedListItems(list, false);
                return;
            }
            throw new IllegalArgumentException("Illegal submitted value");
        }
        if (this.valueTypeEvaluator.getValueType() == ValueType.NONE || this.valueTypeEvaluator.getValueType() == ValueType.INVALID) {
            this.markSelectedListItems(new ArrayList(), true);
            return;
        }
        value = this.getValue();
        if (value == null) {
            this.markSelectedListItems(new ArrayList(), true);
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.valueTypeEvaluator.getValueType() == ValueType.ARRAY) {
            int length = Array.getLength(value);
            for (int counter = 0; counter < length; ++counter) {
                list.add(Array.get(value, counter));
            }
            this.markSelectedListItems(list, true);
            return;
        }
        list.add(value);
        this.markSelectedListItems(list, true);
    }

    protected void markSelectedListItems(List list, boolean processed) {
        ListItem option = null;
        Object nextItem = null;
        Iterator items = this.listItems.iterator();
        Iterator selected = null;
        block0: while (items.hasNext()) {
            nextItem = items.next();
            if (!(nextItem instanceof ListItem)) continue;
            option = nextItem;
            option.setSelected(false);
            if (list.isEmpty()) continue;
            selected = list.iterator();
            while (selected.hasNext()) {
                if (processed) {
                    Object o = selected.next();
                    if (!option.getValueObject().equals(o)) continue;
                    option.setSelected(true);
                    list.remove(o);
                    continue block0;
                }
                String s = (String)selected.next();
                if (!s.equals(option.getValue())) continue;
                option.setSelected(true);
                list.remove(s);
                continue block0;
            }
        }
        if (!list.isEmpty() && !Beans.isDesignTime()) {
            String msg = MessageUtil.getMessage("com.sun.web.ui.resources.LogMessages", "List.badValue", new Object[]{this.getClientId(FacesContext.getCurrentInstance())});
            this.log(msg);
        }
    }

    protected ListItem createListItem(Option si) {
        String label = si.getLabel();
        if ((double)label.length() * 1.5 > (double)this.separatorLength) {
            this.separatorLength = (int)((double)label.length() * 1.5);
        }
        ListItem listItem = new ListItem(si.getValue(), label, si.getDescription(), si.isDisabled());
        String valueString = ConversionUtilities.convertValueToString((UIComponent)this, si.getValue());
        listItem.setValue(valueString);
        return listItem;
    }

    public UIComponent getLabelComponent() {
        String id = this.getId();
        UIComponent labelComponent = this.getFacet(LABEL_FACET);
        if (labelComponent == null && this.getLabel() != null && this.getLabel().length() > 0) {
            labelComponent = this.createLabel(this.getLabel());
        }
        return labelComponent;
    }

    public UIComponent getReadOnlyValueComponent() {
        String id = this.getId();
        UIComponent textComponent = this.getFacet(READONLY_FACET);
        if (textComponent == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            textComponent = this.createText(this.getValueAsReadOnly(context));
        }
        return textComponent;
    }

    public String[] getValueAsStringArray(FacesContext context) {
        String[] values = null;
        Object value = this.getSubmittedValue();
        if (value != null) {
            if (value instanceof String[]) {
                return (String[])value;
            }
            if (value instanceof String) {
                values = new String[]{(String)value};
                return values;
            }
        }
        if ((value = this.getValue()) == null) {
            return new String[0];
        }
        if (this.valueTypeEvaluator.getValueType() == ValueType.NONE) {
            return new String[0];
        }
        if (this.valueTypeEvaluator.getValueType() == ValueType.INVALID) {
            return new String[0];
        }
        int counter = 0;
        if (this.valueTypeEvaluator.getValueType() == ValueType.LIST) {
            List list = (List)value;
            counter = list.size();
            values = new String[counter];
            Iterator valueIterator = ((List)value).iterator();
            String valueString = null;
            while (valueIterator.hasNext()) {
                values[counter] = valueString = ConversionUtilities.convertValueToString((UIComponent)this, valueIterator.next());
                ++counter;
            }
        } else if (this.valueTypeEvaluator.getValueType() == ValueType.ARRAY) {
            counter = Array.getLength(value);
            values = new String[counter];
            Object valueObject = null;
            String valueString = null;
            for (int i = 0; i < counter; ++i) {
                valueObject = Array.get(value, i);
                values[i] = valueString = ConversionUtilities.convertValueToString((UIComponent)this, valueObject);
            }
        } else if (this.valueTypeEvaluator.getValueType() == ValueType.OBJECT) {
            values = new String[]{ConversionUtilities.convertValueToString((UIComponent)this, value)};
        }
        return values;
    }

    private UIComponent createLabel(String labelString) {
        if (labelString == null || labelString.length() < 1) {
            return null;
        }
        Label label = new Label();
        label.setId(this.getId().concat(LABEL_ID));
        label.setLabelLevel(this.getLabelLevel());
        label.setText(labelString);
        label.setLabeledComponent((UIComponent)this);
        this.getFacets().put(LABEL_FACET, label);
        return label;
    }

    private UIComponent createText(String string) {
        if (string == null || string.length() < 1) {
            string = new String();
        }
        StaticText text = new StaticText();
        text.setText(string);
        text.setId(this.getId().concat(READONLY_ID));
        this.getFacets().put(READONLY_FACET, text);
        return text;
    }

    public String getPrimaryElementID(FacesContext context) {
        if (this.getFacet(LABEL_FACET) == null) {
            return this.getClientId(context);
        }
        return this.getClientId(context).concat(LIST_ID);
    }

    public String getValueAsReadOnly(FacesContext context, String separator) {
        return "FIX ME!";
    }

    public boolean mainListSubmits() {
        return true;
    }
}

