/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.ComplexComponent;
import com.sun.web.ui.component.Icon;
import com.sun.web.ui.component.LabelBase;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ComponentUtilities;
import com.sun.web.ui.util.LogUtil;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class Label
extends LabelBase {
    public static final String REQUIRED_ID = "_required";
    public static final String REQUIRED_FACET = "required";
    public static final String ERROR_ID = "_error";
    public static final String ERROR_FACET = "error";
    private EditableValueHolder labeledComponent = null;
    private String element = "span";
    private static final boolean DEBUG = false;

    public void setLabeledComponent(UIComponent comp) {
        if (comp == null) {
            this.labeledComponent = null;
        } else if (comp instanceof EditableValueHolder) {
            this.labeledComponent = (EditableValueHolder)comp;
            this.setFor(comp.getClientId(FacesContext.getCurrentInstance()));
            this.element = "label";
        } else {
            if (LogUtil.infoEnabled(Label.class)) {
                FacesContext context = FacesContext.getCurrentInstance();
                LogUtil.info((Object)Label.class, "Label.invalidFor", new Object[]{this.getId(), context.getViewRoot().getViewId(), comp.getId()});
            }
            this.labeledComponent = null;
            this.element = "label";
        }
    }

    public EditableValueHolder getLabeledComponent() {
        if (this.labeledComponent != null) {
            return this.labeledComponent;
        }
        String id = this.getFor();
        if (id == null) {
            this.setLabeledComponent(this.findLabeledChild());
        } else {
            if (id.indexOf(":") > -1 && !id.startsWith(":")) {
                id = ":" + id;
            }
            this.setLabeledComponent(this.findComponent(id));
            this.element = "label";
        }
        return this.labeledComponent;
    }

    public String getLabeledComponentId(FacesContext context) {
        String id = null;
        if (this.labeledComponent != null) {
            if (this.labeledComponent instanceof ComplexComponent) {
                ComplexComponent compComp = (ComplexComponent)this.labeledComponent;
                id = compComp.getPrimaryElementID(context);
            } else {
                UIComponent comp = (UIComponent)this.labeledComponent;
                id = comp.getClientId(context);
            }
        } else {
            UIComponent comp;
            id = this.getFor();
            if (id != null && id.indexOf(":") == -1 && (comp = this.getParent()) instanceof NamingContainer) {
                id = comp.getClientId(context) + ":" + id;
            }
        }
        return id;
    }

    private UIComponent findLabeledChild() {
        List kids = this.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            Object kid = kids.get(i);
            if (!(kid instanceof EditableValueHolder)) continue;
            return (UIComponent)kid;
        }
        return null;
    }

    public UIComponent getRequiredIcon(Theme theme, FacesContext context) {
        UIComponent comp = this.getFacet(REQUIRED_FACET);
        if (comp != null) {
            return comp;
        }
        Icon icon = theme.getIcon("LABEL_REQUIRED_ICON");
        icon.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, REQUIRED_FACET));
        icon.setParent((UIComponent)this);
        icon.setBorder(0);
        return icon;
    }

    public UIComponent getErrorIcon(Theme theme, FacesContext context, boolean valid) {
        UIComponent comp = this.getFacet(ERROR_FACET);
        if (comp != null) {
            return null;
        }
        Icon icon = theme.getIcon("LABEL_INVALID_ICON");
        icon.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, ERROR_FACET));
        icon.setParent((UIComponent)this);
        icon.setBorder(0);
        if (valid) {
            icon.setIcon("DOT");
            icon.setAlt("");
        } else if (this.labeledComponent != null) {
            String labeledCompID = ((UIComponent)this.labeledComponent).getClientId(context);
            Iterator messages = context.getMessages(labeledCompID);
            FacesMessage fm = null;
            StringBuffer msgBuffer = new StringBuffer(200);
            while (messages.hasNext()) {
                fm = (FacesMessage)messages.next();
                msgBuffer.append(fm.getDetail());
                msgBuffer.append(" ");
            }
            icon.setToolTip(msgBuffer.toString());
        }
        return icon;
    }

    public String getElement() {
        return this.element;
    }

    private void log(String s) {
        System.out.println(((Object)((Object)this)).getClass().getName() + "::" + s);
    }

    public int getLabelLevel() {
        int level = super.getLabelLevel();
        if (level < 1 || level > 3) {
            level = 2;
            super.setLabelLevel(level);
        }
        return level;
    }
}

