/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.HelpWindowBase;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class HelpWindow
extends HelpWindowBase {
    public static final String DEFAULT_JSP_PATH = "/com_sun_web_ui/help/";

    public HelpWindow() {
        StringBuffer onClick = new StringBuffer("javascript: ");
        onClick.append("var win = window.open('','help_window','height=500,").append("width=750,top='+((screen.height-(screen.height/1.618))-").append("(500/2))+',left='+((screen.width-750)/2)+',resizable');").append("win.focus()");
        this.setOnClick(onClick.toString());
    }

    public String getUrl() {
        if (super.getUrl() != null) {
            return super.getUrl();
        }
        String jspPath = DEFAULT_JSP_PATH;
        if (this.getJspPathPrefix() != null) {
            jspPath = this.getJspPathPrefix().concat(jspPath);
        } else {
            FacesContext context = FacesContext.getCurrentInstance();
            Application app = context.getApplication();
            ValueBinding vb = app.createValueBinding("#{JavaHelpBean.jspPath}");
            if (vb.getValue(context) != null) {
                jspPath = ((String)vb.getValue(context)).concat(jspPath);
            }
        }
        StringBuffer url = new StringBuffer(jspPath);
        url.append("helpwindow.jsp?windowTitle=").append(this.getWindowTitle() != null ? this.getWindowTitle() : "");
        try {
            int width;
            this.addParameter(url, "helpSetPath", this.getHelpSetPath());
            this.addParameter(url, "helpFile", this.getHelpFile());
            this.addParameter(url, "pageTitle", this.getPageTitle());
            this.addParameter(url, "mastheadUrl", this.getMastheadImageUrl());
            this.addParameter(url, "mastheadDescription", this.getMastheadImageDescription());
            FacesContext context = FacesContext.getCurrentInstance();
            String pathParam = context.getApplication().getViewHandler().getResourceURL(context, jspPath);
            this.addParameter(url, "jspPath", pathParam);
            int height = this.getMastheadImageHeight();
            if (height != -1) {
                this.addParameter(url, "mastheadHeight", String.valueOf(height));
            }
            if ((width = this.getMastheadImageWidth()) != -1) {
                this.addParameter(url, "mastheadWidth", String.valueOf(width));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return url.toString();
    }

    public String getIcon() {
        if (this.isLinkIcon()) {
            return "HREF_LINK";
        }
        return "DOT";
    }

    public String getText() {
        if (super.getText() != null) {
            return super.getText();
        }
        Theme t = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
        return t.getMessage("help.help");
    }

    public String getTarget() {
        if (super.getTarget() != null) {
            return super.getTarget();
        }
        return "help_window";
    }

    private void addParameter(StringBuffer buffer, String name, String value) throws UnsupportedEncodingException {
        if (buffer == null || name == null || value == null) {
            return;
        }
        buffer.append("&").append(name).append("=").append(URLEncoder.encode(value, "UTF-8"));
    }
}

