/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.data.provider.RowKey;
import com.sun.web.ui.component.FormBase;
import com.sun.web.ui.component.TableRowGroup;
import com.sun.web.ui.component.WrapperEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;

public class Form
extends FormBase {
    private VirtualFormDescriptor submittedVirtualForm;
    private static final String VF_DELIM_1 = ",";
    private static final String VF_DELIM_2 = "|";
    private static final String ID_SEP = String.valueOf(':');
    public static final char ID_WILD_CHAR = '*';
    private static final String ID_WILD = String.valueOf('*');
    private transient Map erasedMap = new HashMap();
    private transient Set retainSubmittedValueEvhs = new HashSet();
    private transient Set discardSubmittedValueEvhs = new HashSet();
    public static final int RETAIN_SUBMITTED_VALUE = 1;
    public static final int DISCARD_SUBMITTED_VALUE = 0;
    public static final int RETAIN_UNLESS_VALUE_CHANGES = -1;

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.submittedVirtualForm = null;
        this.erasedMap.clear();
        this.retainSubmittedValueEvhs.clear();
        this.discardSubmittedValueEvhs.clear();
        this.decode(context);
        if (!this.isSubmitted()) {
            return;
        }
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processDecodes(context);
        }
        if (this.submittedVirtualForm != null && !Form.childrenAreKnownToParticipate((UIComponent)this, this.submittedVirtualForm)) {
            this.eraseVirtualFormNonParticipants((UIComponent)this, null, null);
        }
    }

    public void queueEvent(FacesEvent event) {
        UIComponent sourceComp;
        VirtualFormDescriptor virtualFormComponentSubmits;
        FacesEvent relevantEvent = event;
        if (event instanceof WrapperEvent) {
            WrapperEvent wrapperEvent = (WrapperEvent)event;
            relevantEvent = wrapperEvent.getFacesEvent();
        }
        if (relevantEvent instanceof ActionEvent && this.submittedVirtualForm == null && (virtualFormComponentSubmits = this.getVirtualFormComponentSubmits(sourceComp = relevantEvent.getComponent())) != null) {
            this.submittedVirtualForm = virtualFormComponentSubmits;
        }
        super.queueEvent(event);
    }

    public void setSubmittedVirtualForm(VirtualFormDescriptor vfd) {
        if (this.submittedVirtualForm == null && vfd != null) {
            this.submittedVirtualForm = vfd;
        }
    }

    public void setVirtualForms(VirtualFormDescriptor[] vfds) {
        this.setVirtualForms(vfds, true);
    }

    private void setVirtualForms(VirtualFormDescriptor[] vfds, boolean sync) {
        super.setVirtualForms(vfds);
        if (sync) {
            String configStr = Form.generateVirtualFormsConfig(vfds);
            this.setVirtualFormsConfig(configStr, false);
        }
    }

    public void setVirtualFormsConfig(String configStr) {
        this.setVirtualFormsConfig(configStr, true);
    }

    private void setVirtualFormsConfig(String configStr, boolean sync) {
        super.setVirtualFormsConfig(configStr);
        if (sync) {
            VirtualFormDescriptor[] vfds = Form.generateVirtualForms(configStr);
            this.setVirtualForms(vfds, false);
        }
    }

    private VirtualFormDescriptor getVirtualFormComponentSubmitsByFullyQualifiedId(String fqId) {
        if (!Form.isValidFullyQualifiedId(fqId)) {
            return null;
        }
        VirtualFormDescriptor vfd = this.getVirtualFormComponentSubmitsByFullyQualifiedId(fqId, this.getVirtualForms());
        if (vfd != null) {
            return vfd;
        }
        vfd = this.getVirtualFormComponentSubmitsByFullyQualifiedId(fqId, this.getInternalVirtualForms());
        return vfd;
    }

    private VirtualFormDescriptor getVirtualFormComponentSubmitsByFullyQualifiedId(String fqId, VirtualFormDescriptor[] vfds) {
        if (vfds == null || vfds.length < 1) {
            return null;
        }
        String currentFqId = fqId;
        while (currentFqId.length() > 0) {
            for (int v = 0; v < vfds.length; ++v) {
                VirtualFormDescriptor vfd = vfds[v];
                String[] submitters = vfd.getSubmittingIds();
                for (int s = 0; submitters != null && s < submitters.length; ++s) {
                    boolean fqIdMatches;
                    String submitter = submitters[s];
                    if (submitter == null) continue;
                    String wildSuffix = ID_SEP + ID_WILD;
                    if (submitter.endsWith(wildSuffix)) {
                        submitter = submitter.substring(0, submitter.length() - wildSuffix.length());
                    }
                    if (submitter.length() < 1 || !(fqIdMatches = Form.fullyQualifiedIdMatchesPattern(currentFqId, submitter))) continue;
                    return vfd;
                }
            }
            int lastIndexOfSep = currentFqId.lastIndexOf(ID_SEP);
            currentFqId = currentFqId.substring(0, lastIndexOfSep);
        }
        return null;
    }

    private int getVirtualFormCount() {
        VirtualFormDescriptor[] vfds = this.getVirtualForms();
        VirtualFormDescriptor[] ivfds = this.getInternalVirtualForms();
        return (vfds == null ? 0 : vfds.length) + (ivfds == null ? 0 : ivfds.length);
    }

    private VirtualFormDescriptor getVirtualFormComponentSubmits(UIComponent component) {
        if (this.getVirtualFormCount() < 1) {
            return null;
        }
        String fqId = Form.getFullyQualifiedId(component);
        VirtualFormDescriptor vfd = this.getVirtualFormComponentSubmitsByFullyQualifiedId(fqId);
        return vfd;
    }

    public VirtualFormDescriptor getVirtualFormComponentSubmits(String id) {
        if (this.getVirtualFormCount() < 1) {
            return null;
        }
        if (Form.isValidFullyQualifiedId(id)) {
            return this.getVirtualFormComponentSubmitsByFullyQualifiedId(id);
        }
        UIComponent component = this.findComponentById(id);
        return this.getVirtualFormComponentSubmits(component);
    }

    public UIComponent findComponentById(String id) {
        if (id == null) {
            return null;
        }
        if (id.length() == 0 || id.endsWith(ID_WILD) || !id.equals(ID_SEP) && id.endsWith(ID_SEP)) {
            return null;
        }
        String fqId = Form.getFullyQualifiedId((UIComponent)this);
        if (Form.fullyQualifiedIdMatchesPattern(fqId, id)) {
            return this;
        }
        return this.searchKidsRecursivelyForId((UIComponent)this, id);
    }

    private UIComponent searchKidsRecursivelyForId(UIComponent parent, String id) {
        Iterator kids = parent.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            String fqId = Form.getFullyQualifiedId(kid);
            boolean fqIdMatches = Form.fullyQualifiedIdMatchesPattern(fqId, id);
            if (fqIdMatches) {
                return kid;
            }
            UIComponent match = this.searchKidsRecursivelyForId(kid, id);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private boolean participatesInSubmittedVirtualForm(UIComponent component) {
        if (this.submittedVirtualForm == null) {
            return false;
        }
        String fqId = Form.getFullyQualifiedId(component);
        return this.submittedVirtualForm.hasParticipant(fqId);
    }

    public static VirtualFormDescriptor[] generateVirtualForms(String configStr) {
        if (configStr == null) {
            return null;
        }
        if ((configStr = configStr.trim()).length() < 1) {
            return new VirtualFormDescriptor[0];
        }
        StringTokenizer st = new StringTokenizer(configStr, VF_DELIM_1);
        ArrayList<String> vfs = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String vf = st.nextToken();
            if ((vf = vf.trim()).length() <= 0) continue;
            vfs.add(vf);
        }
        ArrayList<VirtualFormDescriptor> descriptors = new ArrayList<VirtualFormDescriptor>();
        for (int i = 0; i < vfs.size(); ++i) {
            String vf = (String)vfs.get(i);
            st = new StringTokenizer(vf, VF_DELIM_2);
            String[] parts = new String[3];
            for (int partIndex = 0; partIndex < parts.length && st.hasMoreTokens(); ++partIndex) {
                String part = st.nextToken();
                if ((part = part.trim()).length() <= 0) continue;
                parts[partIndex] = part;
            }
            if (parts[0] == null) continue;
            VirtualFormDescriptor vfd = new VirtualFormDescriptor();
            vfd.setName(parts[0]);
            descriptors.add(vfd);
            if (parts[1] != null) {
                String pidString = parts[1];
                st = new StringTokenizer(pidString);
                ArrayList<String> pidList = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String pid = st.nextToken();
                    pidList.add(pid.trim());
                }
                String[] pids = pidList.toArray(new String[pidList.size()]);
                vfd.setParticipatingIds(pids);
            }
            if (parts[2] == null) continue;
            String sidString = parts[2];
            st = new StringTokenizer(sidString);
            ArrayList<String> sidList = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String sid = st.nextToken();
                sidList.add(sid.trim());
            }
            String[] sids = sidList.toArray(new String[sidList.size()]);
            vfd.setSubmittingIds(sids);
        }
        return descriptors.toArray(new VirtualFormDescriptor[descriptors.size()]);
    }

    public static String generateVirtualFormsConfig(VirtualFormDescriptor[] descriptors) {
        if (descriptors == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < descriptors.length; ++i) {
            String vf;
            if (descriptors[i] == null || (vf = descriptors[i].toString()).length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(" , ");
            }
            sb.append(vf);
        }
        return sb.toString();
    }

    public static String getFullyQualifiedId(UIComponent component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Form) {
            return ID_SEP;
        }
        String compId = component.getId();
        if (compId == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(compId);
        boolean formEncountered = false;
        for (UIComponent currentComp = component.getParent(); currentComp != null; currentComp = currentComp.getParent()) {
            sb.insert(0, ID_SEP);
            if (currentComp instanceof Form) {
                formEncountered = true;
                break;
            }
            String currentCompId = currentComp.getId();
            if (currentCompId == null) {
                return null;
            }
            sb.insert(0, currentCompId);
        }
        if (formEncountered) {
            return sb.toString();
        }
        return null;
    }

    public static boolean isValidFullyQualifiedId(String id) {
        return id != null && id.startsWith(ID_SEP) && (id.length() == 1 || !id.endsWith(ID_SEP)) && !id.endsWith(ID_WILD) && id.indexOf(32) == -1;
    }

    public static boolean fullyQualifiedIdMatchesPattern(String fqId, String pattern) {
        if (!Form.isValidFullyQualifiedId(fqId)) {
            return false;
        }
        if (pattern == null || pattern.length() < 1 || pattern.indexOf(32) != -1) {
            return false;
        }
        if (pattern.endsWith(ID_SEP) && !pattern.equals(ID_SEP)) {
            return false;
        }
        String wildSuffix = ID_SEP + ID_WILD;
        int indexOfWildInPattern = pattern.indexOf(ID_WILD);
        if (indexOfWildInPattern != -1) {
            if (indexOfWildInPattern != pattern.length() - 1) {
                return false;
            }
            if (!pattern.endsWith(wildSuffix)) {
                return false;
            }
        }
        if (pattern.equals(wildSuffix)) {
            return true;
        }
        if (pattern.endsWith(wildSuffix)) {
            String patternPrefix = pattern.substring(0, pattern.length() - wildSuffix.length());
            if (patternPrefix.startsWith(ID_SEP)) {
                return fqId.equals(patternPrefix) || fqId.startsWith(patternPrefix + ID_SEP);
            }
            return fqId.endsWith(ID_SEP + patternPrefix) || fqId.indexOf(ID_SEP + patternPrefix + ID_SEP) > -1;
        }
        if (pattern.startsWith(ID_SEP)) {
            return fqId.equals(pattern);
        }
        return fqId.endsWith(ID_SEP + pattern);
    }

    public void addInternalVirtualForm(VirtualFormDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        VirtualFormDescriptor[] oldDescriptors = this.getInternalVirtualForms();
        if (oldDescriptors != null) {
            for (int i = 0; i < oldDescriptors.length; ++i) {
                String name;
                if (oldDescriptors[i] == null || (name = oldDescriptors[i].getName()) == null || !name.equals(descriptor.getName())) continue;
                oldDescriptors[i] = descriptor;
                return;
            }
        }
        int oldLength = oldDescriptors != null ? oldDescriptors.length : 0;
        VirtualFormDescriptor[] newDescriptors = new VirtualFormDescriptor[oldLength + 1];
        for (int i = 0; i < oldLength; ++i) {
            newDescriptors[i] = oldDescriptors[i];
        }
        newDescriptors[oldLength] = descriptor;
        this.setInternalVirtualForms(newDescriptors);
    }

    private static boolean childrenAreKnownToParticipate(UIComponent component, VirtualFormDescriptor vfd) {
        if (vfd == null) {
            return false;
        }
        String fqId = Form.getFullyQualifiedId(component);
        if (fqId == null) {
            return false;
        }
        String[] participants = vfd.getParticipatingIds();
        for (int i = 0; participants != null && i < participants.length; ++i) {
            String participant = participants[i];
            String wildSuffix = ID_SEP + ID_WILD;
            if (participant == null || !participant.endsWith(wildSuffix) || !Form.fullyQualifiedIdMatchesPattern(fqId, participant)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eraseVirtualFormNonParticipants(UIComponent parent, Object[] contextualTables, Object[] contextualRows) {
        Map map = this.erasedMap;
        synchronized (map) {
            Iterator kids = parent.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                if (kid instanceof EditableValueHolder && !this.participatesInSubmittedVirtualForm(kid)) {
                    EditableValueHolder kidEvh = (EditableValueHolder)kid;
                    Object submittedValueToErase = kidEvh.getSubmittedValue();
                    Object snapshotValue = kidEvh.getValue();
                    Object[] valuePair = new Object[]{submittedValueToErase, snapshotValue};
                    if (contextualTables == null) {
                        this.erasedMap.put(kidEvh, valuePair);
                    } else {
                        this.addTableValuesEntry(this.erasedMap, kidEvh, 0, contextualTables, contextualRows, valuePair);
                    }
                    kidEvh.setSubmittedValue(null);
                }
                if (Form.childrenAreKnownToParticipate(kid, this.submittedVirtualForm)) continue;
                if (kid instanceof UIData) {
                    UIData kidTable = (UIData)kid;
                    int originalRowIndex = kidTable.getRowIndex();
                    int rowIndex = 0;
                    kidTable.setRowIndex(rowIndex);
                    while (kidTable.isRowAvailable()) {
                        Object[] localContextualTables = Form.appendToArray(contextualTables, kidTable);
                        Object[] localContextualRows = Form.appendToArray(contextualRows, new Integer(rowIndex));
                        this.eraseVirtualFormNonParticipants((UIComponent)kidTable, localContextualTables, localContextualRows);
                        kidTable.setRowIndex(++rowIndex);
                    }
                    kidTable.setRowIndex(originalRowIndex);
                    continue;
                }
                if (kid instanceof TableRowGroup) {
                    TableRowGroup group = (TableRowGroup)kid;
                    RowKey[] rowKeys = group.getRowKeys();
                    RowKey oldRowKey = group.getRowKey();
                    if (rowKeys != null) {
                        for (int i = 0; i < rowKeys.length; ++i) {
                            group.setRowKey(rowKeys[i]);
                            if (!group.isRowAvailable()) continue;
                            Object[] localContextualTables = Form.appendToArray(contextualTables, (Object)group);
                            Object[] localContextualRows = Form.appendToArray(contextualRows, rowKeys[i]);
                            this.eraseVirtualFormNonParticipants((UIComponent)group, localContextualTables, localContextualRows);
                        }
                    }
                    group.setRowKey(oldRowKey);
                    continue;
                }
                this.eraseVirtualFormNonParticipants(kid, contextualTables, contextualRows);
            }
        }
    }

    private void addTableValuesEntry(Map map, Object mapKey, int c, Object[] contextualTables, Object[] contextualRows, Object[] valuePair) {
        TableValues tv = (TableValues)map.get(mapKey);
        if (tv == null) {
            tv = new TableValues(contextualTables[c]);
            map.put(mapKey, tv);
        }
        Map values = tv.getValues();
        if (c == contextualTables.length - 1) {
            values.put(contextualRows[c], valuePair);
        } else {
            this.addTableValuesEntry(values, contextualRows[c], c + 1, contextualTables, contextualRows, valuePair);
        }
    }

    private static Object[] appendToArray(Object[] array, Object item) {
        Object[] result;
        if (array == null) {
            result = new Object[]{item};
        } else {
            result = new Object[array.length + 1];
            System.arraycopy(array, 0, result, 0, array.length);
            result[array.length] = item;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreNonParticipatingSubmittedValues() {
        Map map = this.erasedMap;
        synchronized (map) {
            Iterator iter = this.erasedMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                EditableValueHolder evh = (EditableValueHolder)entry.getKey();
                if (this.discardSubmittedValueEvhs.contains(evh)) continue;
                Object erasedMapValue = entry.getValue();
                if (erasedMapValue instanceof TableValues) {
                    TableValues tv = (TableValues)erasedMapValue;
                    this.restoreTableValues(tv, evh);
                    continue;
                }
                Object[] valuePair = (Object[])erasedMapValue;
                boolean restore = this.retainsSubmittedValue(evh, valuePair[1]);
                if (!restore) continue;
                evh.setSubmittedValue(valuePair[0]);
            }
        }
    }

    private void restoreTableValues(TableValues tv, EditableValueHolder evh) {
        TableRowGroup rowGroup;
        Iterator<Object> rowIterator;
        Object oldRow;
        UIData uidata;
        Object table = tv.getTable();
        Map values = tv.getValues();
        if (table instanceof UIData) {
            uidata = (UIData)table;
            int iOldRow = uidata.getRowIndex();
            oldRow = new Integer(iOldRow);
            ArrayList rowList = new ArrayList();
            rowList.addAll(values.keySet());
            Collections.sort(rowList);
            rowIterator = rowList.iterator();
        } else {
            rowGroup = (TableRowGroup)((Object)table);
            oldRow = rowGroup.getRowKey();
            rowIterator = values.keySet().iterator();
        }
        while (rowIterator.hasNext()) {
            Object row = rowIterator.next();
            if (table instanceof UIData) {
                UIData uidata2 = (UIData)table;
                Integer rowInt = (Integer)row;
                int iRow = rowInt;
                uidata2.setRowIndex(iRow);
            } else {
                TableRowGroup rowGroup2 = (TableRowGroup)((Object)table);
                RowKey rowKey = (RowKey)row;
                rowGroup2.setRowKey(rowKey);
            }
            Object rowValue = values.get(row);
            if (rowValue instanceof TableValues) {
                TableValues rowValueTv = (TableValues)rowValue;
                this.restoreTableValues(rowValueTv, evh);
                continue;
            }
            Object[] valuePair = (Object[])rowValue;
            boolean restore = this.retainsSubmittedValue(evh, valuePair[1]);
            if (!restore) continue;
            evh.setSubmittedValue(valuePair[0]);
        }
        if (table instanceof UIData) {
            uidata = (UIData)table;
            Integer oldRowInt = (Integer)oldRow;
            int iOldRow = oldRowInt;
            uidata.setRowIndex(iOldRow);
        } else {
            rowGroup = (TableRowGroup)((Object)table);
            Object oldRowKey = oldRow;
            rowGroup.setRowKey((RowKey)oldRowKey);
        }
    }

    private boolean retainsSubmittedValue(EditableValueHolder evh, Object snapshotValue) {
        boolean retain = this.retainSubmittedValueEvhs.contains(evh);
        if (!retain) {
            Object currValue = evh.getValue();
            if (snapshotValue == null) {
                if (currValue == null) {
                    retain = true;
                }
            } else if (snapshotValue.equals(currValue)) {
                retain = true;
            }
        }
        return retain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRetainSubmittedValue(EditableValueHolder evh, int retain) {
        if (evh == null) {
            return;
        }
        if (retain != 1 && retain != 0 && retain != -1) {
            throw new IllegalArgumentException("unknown retain code: " + retain);
        }
        Map map = this.erasedMap;
        synchronized (map) {
            if (retain == 1 || retain == -1) {
                this.discardSubmittedValueEvhs.remove(evh);
            }
            if (retain == 0 || retain == -1) {
                this.retainSubmittedValueEvhs.remove(evh);
            }
            if (retain == 1) {
                this.retainSubmittedValueEvhs.add(evh);
            } else if (retain == 0) {
                this.discardSubmittedValueEvhs.add(evh);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRetainSubmittedValue(EditableValueHolder evh) {
        Map map = this.erasedMap;
        synchronized (map) {
            if (this.retainSubmittedValueEvhs.contains(evh)) {
                return 1;
            }
            if (this.discardSubmittedValueEvhs.contains(evh)) {
                return 0;
            }
        }
        return -1;
    }

    public String getEnctype() {
        String encType = super.getEnctype();
        if (encType == null || encType.length() == 0) {
            encType = "application/x-www-form-urlencoded";
            super.setEnctype(encType);
        }
        return encType;
    }

    private class TableValues {
        private Object table;
        private Map values;

        public TableValues(Object table) {
            this.table = table;
            this.values = new HashMap();
        }

        public Object getTable() {
            return this.table;
        }

        public Map getValues() {
            return this.values;
        }
    }

    public static class VirtualFormDescriptor
    implements Serializable {
        private String name;
        private String[] participatingIds;
        private String[] submittingIds;

        public VirtualFormDescriptor() {
        }

        public VirtualFormDescriptor(String name) {
            this.setName(name);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("virtual form name was null");
            }
            if ((name = name.trim()).length() < 1) {
                throw new IllegalArgumentException("virtual form name contained whitespace only");
            }
            this.name = name;
        }

        public String[] getParticipatingIds() {
            return this.participatingIds;
        }

        public void setParticipatingIds(String[] participatingIds) {
            for (int i = 0; participatingIds != null && i < participatingIds.length; ++i) {
                if (participatingIds[i] == null) {
                    throw new IllegalArgumentException("participating id at index " + i + " was null");
                }
                participatingIds[i] = participatingIds[i].trim();
                if (participatingIds[i].length() >= 1) continue;
                throw new IllegalArgumentException("participating id at index " + i + " contained whitespace only");
            }
            this.participatingIds = participatingIds;
        }

        public String[] getSubmittingIds() {
            return this.submittingIds;
        }

        public void setSubmittingIds(String[] submittingIds) {
            for (int i = 0; submittingIds != null && i < submittingIds.length; ++i) {
                if (submittingIds[i] == null) {
                    throw new IllegalArgumentException("submitting id at index " + i + " was null");
                }
                submittingIds[i] = submittingIds[i].trim();
                if (submittingIds[i].length() >= 1) continue;
                throw new IllegalArgumentException("submitting id at index " + i + " contained whitespace only");
            }
            this.submittingIds = submittingIds;
        }

        public boolean isSubmittedBy(String fqId) {
            if (!Form.isValidFullyQualifiedId(fqId)) {
                return false;
            }
            for (int i = 0; this.submittingIds != null && i < this.submittingIds.length; ++i) {
                if (!Form.fullyQualifiedIdMatchesPattern(fqId, this.submittingIds[i])) continue;
                return true;
            }
            return false;
        }

        public boolean hasParticipant(String fqId) {
            if (!Form.isValidFullyQualifiedId(fqId)) {
                return false;
            }
            for (int i = 0; this.participatingIds != null && i < this.participatingIds.length; ++i) {
                if (!Form.fullyQualifiedIdMatchesPattern(fqId, this.participatingIds[i])) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            int i;
            if (this.name == null) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            sb.append(this.name);
            sb.append(" | ");
            for (i = 0; this.participatingIds != null && i < this.participatingIds.length; ++i) {
                sb.append(this.participatingIds[i]);
                sb.append(' ');
            }
            sb.append("| ");
            for (i = 0; this.submittingIds != null && i < this.submittingIds.length; ++i) {
                sb.append(this.submittingIds[i]);
                sb.append(' ');
            }
            return sb.toString().trim();
        }
    }
}

