/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.Button;
import com.sun.web.ui.component.DropDown;
import com.sun.web.ui.component.FileChooserBase;
import com.sun.web.ui.component.HelpInline;
import com.sun.web.ui.component.Label;
import com.sun.web.ui.component.Listbox;
import com.sun.web.ui.component.StaticText;
import com.sun.web.ui.component.TextField;
import com.sun.web.ui.model.FileChooserModel;
import com.sun.web.ui.model.Option;
import com.sun.web.ui.model.ResourceItem;
import com.sun.web.ui.model.ResourceModel;
import com.sun.web.ui.model.ResourceModelException;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ClientSniffer;
import com.sun.web.ui.util.ComponentUtilities;
import com.sun.web.ui.util.ConversionUtilities;
import com.sun.web.ui.util.LogUtil;
import com.sun.web.ui.util.ThemeUtilities;
import com.sun.web.ui.validator.FileChooserFilterValidator;
import com.sun.web.ui.validator.FileChooserLookInValidator;
import com.sun.web.ui.validator.FileChooserSelectValidator;
import com.sun.web.ui.validator.FileChooserSortValidator;
import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.render.Renderer;
import javax.faces.validator.ValidatorException;

public class FileChooser
extends FileChooserBase
implements NamingContainer {
    public static final String ALPHABETIC_ASC = "alphabetica";
    public static final String ALPHABETIC_DSC = "alphabeticd";
    public static final String SIZE_ASC = "sizea";
    public static final String SIZE_DSC = "sized";
    public static final String LASTMODIFIED_ASC = "timea";
    public static final String LASTMODIFIED_DSC = "timed";
    public static final String JSOBJECT = "com.sun.web.ui.FileChooserJS";
    public static final String JAVASCRIPT_PREFIX = "javascript: ";
    public static String FILECHOOSER_SERVERNAME_STATICTEXT_FACET = "serverNameText";
    public static String FILECHOOSER_SERVERNAME_LABEL_FACET = "serverLabel";
    public static String FILECHOOSER_ENTERPRESS_HELP_FACET = "enterPressHelp";
    public static String FILECHOOSER_MULTISELECT_HELP_FACET = "multiSelectHelp";
    public static String FILECHOOSER_LOOKIN_TEXTFIELD_FACET = "lookinField";
    public static String FILECHOOSER_LOOKIN_LABEL_FACET = "lookinLabel";
    public static String FILECHOOSER_LABEL_FACET = "fileChooserLabel";
    public static String FILECHOOSER_FILTERON_TEXTFIELD_FACET = "filterField";
    public static String FILECHOOSER_FILTER_LABEL_FACET = "filterLabel";
    public static String FILECHOOSER_SELECTED_TEXTFIELD_FACET = "selectedField";
    public static String FILECHOOSER_SELECT_LABEL_FACET = "selectedLabel";
    public static String FILECHOOSER_UPLEVEL_BUTTON_FACET = "upButton";
    public static String FILECHOOSER_OPENFOLDER_BUTTON_FACET = "openButton";
    public static String FILECHOOSER_SORTMENU_FACET = "sortMenu";
    public static String FILECHOOSER_HIDDEN_BUTTON_FACET = "hiddenButton";
    public static String FILECHOOSER_LISTBOX_FACET = "listEntries";
    public static String FILECHOOSER_HIDDENFIELD_ID = "_hiddenField";
    private static final String NULLMODEL = "Null model value.";
    private boolean openFolderChanged;
    private boolean filterChanged;
    private String lastOpenFolder;
    private boolean fileAndFolderChooser = false;
    public static final String HYPHEN = "-";

    public String getEscapeChar() {
        return this.getModel().getEscapeChar();
    }

    public String getDelimiterChar() {
        return this.getModel().getDelimiterChar();
    }

    public String getParentFolder() {
        return this.getModel().getParentFolder();
    }

    public void setFileAndFolderChooser(boolean flag) {
        if (flag) {
            super.setFolderChooser(false);
        }
        this.fileAndFolderChooser = flag;
    }

    public boolean isFileAndFolderChooser() {
        return this.fileAndFolderChooser;
    }

    public boolean isFolderChooser() {
        if (this.isFileAndFolderChooser()) {
            return false;
        }
        return super.isFolderChooser();
    }

    public void setFolderChooser(boolean chooser) {
        if (this.isFileAndFolderChooser()) {
            super.setFolderChooser(false);
        } else {
            super.setFolderChooser(chooser);
        }
    }

    public ResourceModel getModel() {
        ResourceModel model = super.getModel();
        if (model == null) {
            this.log(NULLMODEL);
            model = new FileChooserModel();
            Object obj = this.getLookin();
            String currentDir = null;
            if (obj != null) {
                if (obj instanceof File) {
                    currentDir = ((File)obj).getAbsolutePath();
                } else if (obj instanceof String) {
                    currentDir = (String)obj;
                }
            }
            model.setCurrentDir(currentDir);
            this.setModel(model);
        }
        return model;
    }

    public String[] getRoots() {
        return this.getModel().getRoots();
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator<Object> it = this.getFacets().keySet().iterator();
        while (it.hasNext()) {
            UIComponent facet = (UIComponent)this.getFacets().get(it.next());
            facet.processDecodes(context);
        }
        it = this.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            child.processDecodes(context);
        }
        boolean invalid = false;
        EditableValueHolder evh = null;
        evh = (EditableValueHolder)this.getLookInTextField();
        if (evh != null && !evh.isImmediate()) {
            ((UIComponent)evh).processValidators(context);
        }
        invalid = invalid || !evh.isValid();
        evh = (EditableValueHolder)this.getFilterTextField();
        if (evh != null && !evh.isImmediate()) {
            ((UIComponent)evh).processValidators(context);
        }
        invalid = invalid || !evh.isValid();
        evh = (EditableValueHolder)this.getSelectedTextField();
        if (evh != null && !evh.isImmediate()) {
            ((UIComponent)evh).processValidators(context);
        }
        invalid = invalid || !evh.isValid();
        evh = (EditableValueHolder)this.getSortComponent();
        if (evh != null && !evh.isImmediate()) {
            ((UIComponent)evh).processValidators(context);
        }
        invalid = invalid || !evh.isValid();
        evh = (EditableValueHolder)this.getListComponent();
        if (evh != null && !this.isImmediate()) {
            ((UIComponent)evh).processValidators(context);
        }
        invalid = invalid || !evh.isValid();
        this.decode(context);
        if (this.isImmediate()) {
            if (!invalid) {
                this.validate(context);
            } else {
                this.setValid(false);
            }
        } else if (invalid) {
            this.setValid(false);
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator it = this.getFacetsAndChildren();
        Listbox lb = null;
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (child instanceof Listbox) {
                lb = (Listbox)child;
                continue;
            }
            child.processValidators(context);
            if (!(child instanceof EditableValueHolder) || ((EditableValueHolder)child).isValid()) continue;
            this.setValid(false);
        }
        if (lb != null) {
            lb.processValidators(context);
            if (!lb.isValid()) {
                this.setValid(false);
            }
        }
        try {
            if (!this.isImmediate()) {
                this.validate(context);
            }
        }
        catch (RuntimeException rte) {
            context.renderResponse();
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object submittedValue = this.getSubmittedValue();
        if (submittedValue == null) {
            return;
        }
        if (!this.isMultiple() && ((String[])submittedValue).length > 1) {
            FacesMessage fmsg = null;
            if (this.isFolderChooser()) {
                fmsg = this.createFacesMessage("filechooser.tooManyFileErrSum", "filechooser.tooManyFileErrDet", null, null);
            } else if (this.isFileAndFolderChooser()) {
                fmsg = this.createFacesMessage("filechooser.tooManyFileFolderErrSum", "filechooser.tooManyFileFolderErrDet", null, null);
                fmsg = this.createFacesMessage("filechooser.tooManyFolderErrSum", "filechooser.tooManyFolderErrDet", null, null);
            }
            context.addMessage(this.getClientId(context), fmsg);
            this.setValid(false);
            return;
        }
        ResourceModel model = this.getModel();
        this.lastOpenFolder = model.getCurrentDir();
        Object newValue = null;
        try {
            newValue = this.getConvertedValue(context, submittedValue);
        }
        catch (ConverterException ce) {
            this.setValid(false);
        }
        if (!this.lastOpenFolder.equals(model.getCurrentDir())) {
            EditableValueHolder evh = (EditableValueHolder)this.getLookInTextField();
            evh.setSubmittedValue((Object)model.getCurrentDir());
            try {
                ((UIComponent)evh).processValidators(context);
            }
            catch (ValidatorException ve) {
                this.setValid(false);
                evh.setSubmittedValue((Object)this.lastOpenFolder);
                model.setCurrentDir(this.lastOpenFolder);
                return;
            }
        }
        if (this.isValid()) {
            Object previous = this.getValue();
            this.setValue(newValue);
            this.setSubmittedValue(null);
            if (this.compareValues(previous, newValue)) {
                this.queueEvent((FacesEvent)new ValueChangeEvent((UIComponent)this, previous, newValue));
            }
        }
    }

    protected boolean compareValues(Object previous, Object value) {
        if (previous == null || value == null) {
            return super.compareValues(previous, value);
        }
        if (value instanceof Object[]) {
            int length = Array.getLength(value);
            if (Array.getLength(previous) != length) {
                return true;
            }
            for (int i = 0; i < length; ++i) {
                Object newValue = Array.get(value, i);
                Object prevValue = Array.get(previous, i);
                if (newValue == null) {
                    if (prevValue == null) continue;
                    return true;
                }
                if (prevValue == null) {
                    return true;
                }
                if (prevValue.equals(newValue)) continue;
                return true;
            }
            return false;
        }
        return super.compareValues(previous, value);
    }

    public void validateLookInComponent(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        ResourceModel model = this.getModel();
        String lookInValue = (String)value;
        try {
            model.setCurrentDir(lookInValue);
        }
        catch (ResourceModelException cme) {
            ((EditableValueHolder)component).setSubmittedValue(null);
            FacesMessage fmsg = cme.getFacesMessage();
            context.addMessage(this.getClientId(context), fmsg);
            throw new ValidatorException(fmsg);
        }
    }

    public void validateFilterComponent(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        ResourceModel model = this.getModel();
        String filterValue = (String)value;
        String lastFilter = model.getFilterValue();
        try {
            model.setFilterValue(filterValue);
        }
        catch (ResourceModelException cme) {
            ((EditableValueHolder)component).setSubmittedValue(null);
            FacesMessage fmsg = cme.getFacesMessage();
            context.addMessage(this.getClientId(context), fmsg);
            throw new ValidatorException(fmsg);
        }
        this.filterChanged = !lastFilter.equals(model.getFilterValue());
    }

    public void validateSortComponent(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        ResourceModel model = this.getModel();
        String sortValue = (String)value;
        try {
            model.setSortValue(sortValue);
        }
        catch (ResourceModelException cme) {
            ((EditableValueHolder)component).setSubmittedValue(null);
            FacesMessage fmsg = cme.getFacesMessage();
            context.addMessage(this.getClientId(context), fmsg);
            throw new ValidatorException(fmsg);
        }
    }

    public void validateSelectComponent(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (this.openFolderChanged || this.filterChanged) {
            ((EditableValueHolder)component).setSubmittedValue(null);
            ((EditableValueHolder)component).setValid(false);
            return;
        }
        if (value != null || ((String)value).length() > 0) {
            String[] selections = this.decodeSelections((String)value, this.getEscapeChar(), this.getDelimiterChar());
            this.setSubmittedValue(selections);
        }
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueBinding vb = this.getValueBinding("selected");
        if (vb != null) {
            try {
                vb.setValue(context, this.getLocalValue());
                this.setValue(null);
                this.setLocalValueSet(false);
                return;
            }
            catch (FacesException e) {
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, "javax.faces.component.UIInput.CONVERSION", e.getMessage());
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
            catch (IllegalArgumentException e) {
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, "javax.faces.component.UIInput.CONVERSION", e.getMessage());
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
            catch (Exception e) {
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, "javax.faces.component.UIInput.CONVERSION", e.getMessage());
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            return renderer.getConvertedValue(context, (UIComponent)this, submittedValue);
        }
        return this.getConvertedValue(context, (FileChooser)component, submittedValue);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getConvertedValue(FacesContext context, FileChooser chooser, Object submittedValue) throws ConverterException {
        ResourceModel model = chooser.getModel();
        if (submittedValue == null) {
            return null;
        }
        if (!(submittedValue instanceof String[])) {
            String msg = "FileChooser getConvertedValue requires String[] for its submittedValue.";
            this.log(msg);
            throw new ConverterException(msg);
        }
        Object[] chooserValues = null;
        try {
            this.lastOpenFolder = model.getCurrentDir();
            if (this.isFolderChooser()) {
                chooserValues = model.getSelectedContent((String[])submittedValue, true);
            } else if (this.isFileAndFolderChooser()) {
                Object[] fVals = model.getSelectedContent((String[])submittedValue, false);
                Object[] dVals = model.getSelectedContent((String[])submittedValue, true);
                int dsize = 0;
                if (dVals != null) {
                    dsize = dVals.length;
                }
                int fsize = 0;
                if (fVals != null) {
                    fsize = fVals.length;
                }
                if (fsize + dsize > 0) {
                    chooserValues = fVals instanceof File[] ? new File[dsize + fsize] : new Object[dsize + fsize];
                    int k = 0;
                    for (int i = 0; i < dsize; ++i) {
                        chooserValues[k++] = dVals[i];
                    }
                    for (int j = 0; j < fsize; ++j) {
                        chooserValues[k++] = fVals[j];
                    }
                }
            } else {
                chooserValues = model.getSelectedContent((String[])submittedValue, false);
            }
            this.openFolderChanged = !this.lastOpenFolder.equals(model.getCurrentDir());
        }
        catch (ResourceModelException cme) {
            FacesMessage fmsg = cme.getFacesMessage();
            context.addMessage(this.getClientId(context), fmsg);
            throw new ConverterException(fmsg.getDetail() == null ? fmsg.getSummary() : fmsg.getDetail());
        }
        if (chooserValues == null || chooserValues.length == 0) {
            return null;
        }
        if (!(chooserValues instanceof File[])) {
            return chooserValues;
        }
        File[] realChooserValues = (File[])chooserValues;
        boolean isMultiple = this.isMultiple();
        Object value = this.getValue();
        Converter converter = chooser.getConverter();
        if (converter == null) {
            converter = this.getConverterFromValue(value);
        }
        ValueBinding valueBinding = chooser.getValueBinding("value");
        Class<?> vclazz = null;
        if (valueBinding != null) {
            vclazz = valueBinding.getType(context);
        } else if (value != null) {
            vclazz = value.getClass();
        }
        if (vclazz == null) {
            if (isMultiple) {
                if (converter != null) return this.convertFileArrayToObjectArray(context, converter, realChooserValues);
                return realChooserValues;
            }
            if (converter != null) return this.convertFileToObject(context, converter, realChooserValues[0]);
            return realChooserValues[0];
        }
        if (isMultiple) {
            void var12_25;
            if (vclazz.isArray()) {
                if (converter != null) return this.convertFileArrayToObjectArray(context, converter, realChooserValues);
                if (vclazz.getComponentType().isAssignableFrom(File.class)) {
                    return realChooserValues;
                }
                if (!vclazz.getComponentType().isAssignableFrom(String.class)) return null;
                return this.convertFileArrayToStringArray(realChooserValues);
            }
            Object var12_20 = null;
            if (vclazz.isAssignableFrom(ArrayList.class)) {
                ArrayList arrayList = new ArrayList();
                return this.convertFileArrayToList(context, converter, realChooserValues, (List)var12_25);
            }
            if (vclazz.isAssignableFrom(Vector.class)) {
                Vector vector = new Vector();
                return this.convertFileArrayToList(context, converter, realChooserValues, (List)var12_25);
            }
            if (vclazz.isAssignableFrom(LinkedList.class)) {
                LinkedList linkedList = new LinkedList();
                return this.convertFileArrayToList(context, converter, realChooserValues, (List)var12_25);
            }
            try {
                List list = (List)vclazz.newInstance();
                return this.convertFileArrayToList(context, converter, realChooserValues, (List)var12_25);
            }
            catch (Throwable t) {
                throw new ConverterException("FileChooser is configured for multiple selection but the value is not bound to an assignable type.");
            }
        }
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)chooser, this.convertFileToString(realChooserValues[0]));
        }
        if (vclazz.isAssignableFrom(File.class)) {
            return realChooserValues[0];
        }
        if (!vclazz.isAssignableFrom(String.class)) return realChooserValues[0];
        return this.convertFileToString(realChooserValues[0]);
    }

    private Converter getConverterFromValue(Object value) {
        if (value == null) {
            return null;
        }
        Converter converter = null;
        try {
            Class<?> clazz = value.getClass();
            if (this.isMultiple()) {
                if (clazz.isArray()) {
                    clazz = clazz.getComponentType();
                } else if (value instanceof List && ((List)value).size() != 0) {
                    Object listItem = ((List)value).get(0);
                    clazz = listItem != null ? listItem.getClass() : null;
                } else {
                    clazz = null;
                    this.log("Failed to obtain a class for the FileChooser multiple value.");
                    return null;
                }
            }
            if (clazz != null) {
                converter = ConversionUtilities.getConverterForClass(clazz);
            }
        }
        catch (Exception e) {
            String msg = "Failed to obtain a class for FileChooser value.";
            this.log(msg + "\nException: " + e.getStackTrace());
        }
        return converter;
    }

    protected Object convertFileArrayToObjectArray(FacesContext context, Converter converter, File[] fileArray) throws ConverterException {
        if (fileArray == null) {
            return null;
        }
        Object[] objArray = new Object[fileArray.length];
        if (converter == null) {
            for (int i = 0; i < fileArray.length; ++i) {
                objArray[i] = fileArray[i];
            }
        } else {
            for (int i = 0; i < fileArray.length; ++i) {
                objArray[i] = converter.getAsObject(context, (UIComponent)this, this.convertFileToString(fileArray[i]));
            }
        }
        return objArray;
    }

    protected List convertFileArrayToList(FacesContext context, Converter converter, File[] fileArray, List list) throws ConverterException {
        if (list == null) {
            return null;
        }
        if (converter != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                list.add(converter.getAsObject(context, (UIComponent)this, this.convertFileToString(fileArray[i])));
            }
        } else {
            for (int i = 0; i < fileArray.length; ++i) {
                list.add(fileArray[i]);
            }
        }
        return list;
    }

    protected Object convertFileToObject(FacesContext context, Converter converter, File file) throws ConverterException {
        if (converter == null) {
            return file;
        }
        String fileString = this.convertFileToString(file);
        if (fileString == null) {
            return null;
        }
        return converter.getAsObject(context, (UIComponent)this, fileString);
    }

    protected String convertFileToString(File file) {
        return file != null ? file.getAbsolutePath() : null;
    }

    protected String[] convertFileArrayToStringArray(File[] fileArray) {
        if (fileArray == null) {
            return null;
        }
        String[] strArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            strArray[i] = this.convertFileToString(fileArray[i]);
        }
        return strArray;
    }

    protected String[] convertValueToStringArray(FacesContext context, Converter converter, Object value) throws ConverterException {
        if (value == null) {
            return null;
        }
        Class<?> vclazz = value.getClass();
        if (!this.isMultiple()) {
            return new String[]{this.convertValueToString(context, converter, value)};
        }
        if (vclazz.isArray()) {
            return this.convertObjectArrayToStringArray(context, converter, (Object[])value);
        }
        if (value instanceof List) {
            return this.convertObjectListToStringArray(context, converter, (List)value);
        }
        String msg = "FileChooser is configured for multiple selection but the value is not an assignable type.";
        this.log(msg);
        throw new ConverterException(msg);
    }

    protected String convertValueToString(FacesContext context, Converter converter, Object value) throws ConverterException {
        if (value == null) {
            return null;
        }
        if (converter != null) {
            return converter.getAsString(context, (UIComponent)this, value);
        }
        if (value instanceof File) {
            return this.convertFileToString((File)value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        this.log("Resorting to object.toString() to convert single value to String.");
        return value.toString();
    }

    protected String[] convertObjectArrayToStringArray(FacesContext context, Converter converter, Object[] value) throws ConverterException {
        if (value == null) {
            return null;
        }
        if (converter != null) {
            String[] strArray = new String[value.length];
            for (int i = 0; i < value.length; ++i) {
                strArray[i] = converter.getAsString(context, (UIComponent)this, value[i]);
            }
            return strArray;
        }
        if (value instanceof File[]) {
            return this.convertFileArrayToStringArray((File[])value);
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        this.log("Resorting to object.toString() to convert multiple array value to String[].");
        String[] strArray = new String[value.length];
        for (int i = 0; i < value.length; ++i) {
            strArray[i] = value[i].toString();
        }
        return strArray;
    }

    protected String[] convertObjectListToStringArray(FacesContext context, Converter converter, List list) throws ConverterException {
        if (list == null) {
            return null;
        }
        if (converter != null) {
            String[] strArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                strArray[i] = converter.getAsString(context, (UIComponent)this, list.get(i));
            }
            return strArray;
        }
        String[] strArray = new String[list.size()];
        if (list.size() == 0) {
            return strArray;
        }
        Object listItem = list.get(0);
        if (listItem instanceof File) {
            File[] fileArray = new File[list.size()];
            fileArray = list.toArray(fileArray);
            return this.convertFileArrayToStringArray(fileArray);
        }
        if (listItem instanceof String) {
            return list.toArray(strArray);
        }
        this.log("Resorting to object.toString() to convert multiple list value to String[].");
        for (int i = 0; i < list.size(); ++i) {
            strArray[i] = list.get(i).toString();
        }
        return strArray;
    }

    private Listbox populateListComponent(Listbox fileList) {
        ResourceModel model = this.getModel();
        ResourceItem[] items = null;
        items = model.getFolderContent(model.getCurrentDir(), this.isFolderChooser(), false);
        if (items != null && items.length != 0) {
            Option[] optList = new Option[items.length];
            for (int i = 0; i < items.length; ++i) {
                optList[i] = new Option(items[i].getItemKey(), items[i].getItemLabel());
                optList[i].setDisabled(items[i].isItemDisabled());
            }
            fileList.setItems(optList);
        } else {
            this.populateEmptyList(fileList);
        }
        return fileList;
    }

    private void populateEmptyList(Listbox fileList) {
        Theme theme = this.getTheme();
        int fileNameLen = Integer.parseInt(theme.getMessage("filechooser.fileNameLen"));
        int fileSizeLen = Integer.parseInt(theme.getMessage("filechooser.fileSizeLen"));
        int fileDateLen = Integer.parseInt(theme.getMessage("filechooser.fileDateLen"));
        String label = "";
        String value = "0";
        int len = fileNameLen + fileSizeLen + fileDateLen + 10;
        for (int i = 0; i < len; ++i) {
            label = label + HYPHEN;
        }
        Option[] fileEntries = new Option[]{new Option(value, label)};
        fileEntries[0].setDisabled(true);
        fileList.setItems(fileEntries);
    }

    public UIComponent getServerNameText() {
        UIComponent facet = this.getFacet(FILECHOOSER_SERVERNAME_STATICTEXT_FACET);
        if (facet != null) {
            return facet;
        }
        StaticText child = new StaticText();
        child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_SERVERNAME_STATICTEXT_FACET));
        child.setParent((UIComponent)this);
        Theme theme = this.getTheme();
        child.setText(theme.getMessage("filechooser.lookinColumn"));
        child.setStyleClass(theme.getStyleClass("ChoSrvTxt"));
        ResourceModel model = this.getModel();
        String serverName = model.getServerName();
        child.setText(serverName);
        return child;
    }

    public UIComponent getEnterInlineHelp() {
        UIComponent facet = this.getFacet(FILECHOOSER_ENTERPRESS_HELP_FACET);
        if (facet != null) {
            return facet;
        }
        HelpInline child = new HelpInline();
        child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_ENTERPRESS_HELP_FACET));
        child.setParent((UIComponent)this);
        Theme theme = this.getTheme();
        child.setText(theme.getMessage("filechooser.enterKeyHelp"));
        child.setStyleClass(theme.getStyleClass("HlpFldTxt"));
        return child;
    }

    public UIComponent getMultiSelectHelp() {
        if (!this.isMultiple()) {
            return null;
        }
        UIComponent facet = this.getFacet(FILECHOOSER_MULTISELECT_HELP_FACET);
        if (facet != null) {
            return facet;
        }
        HelpInline child = new HelpInline();
        child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_MULTISELECT_HELP_FACET));
        child.setParent((UIComponent)this);
        Theme theme = this.getTheme();
        child.setText(theme.getMessage("filechooser.multiSelectHelp"));
        child.setStyleClass(theme.getStyleClass("HlpFldTxt"));
        return child;
    }

    public UIComponent getServerNameLabel() {
        UIComponent facet = this.getFacet(FILECHOOSER_SERVERNAME_LABEL_FACET);
        if (facet != null) {
            return facet;
        }
        Label child = new Label();
        child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_SERVERNAME_LABEL_FACET));
        child.setParent((UIComponent)this);
        child.setLabelLevel(2);
        Theme theme = this.getTheme();
        child.setText(theme.getMessage("filechooser.serverPrompt"));
        child.setStyleClass(theme.getStyleClass("ChoLblTxt"));
        return child;
    }

    public UIComponent getFileChooserTitle() {
        UIComponent facet = this.getFacet(FILECHOOSER_LABEL_FACET);
        if (facet != null) {
            return facet;
        }
        StaticText child = new StaticText();
        child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_LABEL_FACET));
        child.setParent((UIComponent)this);
        Theme theme = this.getTheme();
        child.setText(theme.getMessage("filechooser.title"));
        return child;
    }

    public UIComponent getLookInTextField() {
        UIComponent facet = this.getFacet(FILECHOOSER_LOOKIN_TEXTFIELD_FACET);
        if (facet != null) {
            return facet;
        }
        TextField child = (TextField)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_LOOKIN_TEXTFIELD_FACET, true);
        if (child == null) {
            child = new TextField();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_LOOKIN_TEXTFIELD_FACET));
            child.addValidator(new FileChooserLookInValidator());
            child.setSubmittedValue(this.getModel().getCurrentDir());
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_LOOKIN_TEXTFIELD_FACET, (UIComponent)child);
        }
        Theme theme = this.getTheme();
        child.setColumns(Integer.parseInt(theme.getMessage("filechooser.lookinColumn")));
        child.setStyleClass(theme.getStyleClass("ChoSrvTxt").concat(" ").concat(theme.getStyleClass("ChoWthTxt")));
        return child;
    }

    public UIComponent getLookInLabel() {
        UIComponent facet = this.getFacet(FILECHOOSER_LOOKIN_LABEL_FACET);
        if (facet != null) {
            return facet;
        }
        Label child = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_LOOKIN_LABEL_FACET, true);
        if (child == null) {
            child = new Label();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_LOOKIN_LABEL_FACET));
            child.setLabelLevel(2);
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_LOOKIN_LABEL_FACET, (UIComponent)child);
        }
        Theme theme = this.getTheme();
        child.setText(theme.getMessage("filechooser.lookin"));
        child.setLabeledComponent(this.getLookInTextField());
        return child;
    }

    public UIComponent getFilterTextField() {
        FacesContext context;
        ClientSniffer sniffer;
        TextField facet = (TextField)this.getFacet(FILECHOOSER_FILTERON_TEXTFIELD_FACET);
        if (facet != null) {
            return facet;
        }
        TextField child = (TextField)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_FILTERON_TEXTFIELD_FACET, true);
        if (child == null) {
            child = new TextField();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_FILTERON_TEXTFIELD_FACET));
            child.addValidator(new FileChooserFilterValidator());
            child.setSubmittedValue(this.getModel().getFilterValue());
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_FILTERON_TEXTFIELD_FACET, (UIComponent)child);
        }
        int size = (sniffer = ClientSniffer.getInstance(context = FacesContext.getCurrentInstance())).isNav6up() ? 32 : 18;
        child.setColumns(size);
        return child;
    }

    public UIComponent getFilterLabel() {
        UIComponent facet = this.getFacet(FILECHOOSER_FILTER_LABEL_FACET);
        if (facet != null) {
            return facet;
        }
        Label child = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_FILTER_LABEL_FACET, true);
        if (child == null) {
            child = new Label();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_FILTER_LABEL_FACET));
            child.setLabelLevel(2);
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_FILTER_LABEL_FACET, (UIComponent)child);
        }
        Theme theme = this.getTheme();
        if (this.isFolderChooser()) {
            child.setText(theme.getMessage("filechooser.folderFilter"));
        } else {
            child.setText(theme.getMessage("filechooser.fileFilter"));
        }
        child.setLabeledComponent(this.getFilterTextField());
        return child;
    }

    public UIComponent getSelectedTextField() {
        UIComponent facet = null;
        facet = this.getFacet(FILECHOOSER_SELECTED_TEXTFIELD_FACET);
        if (facet != null) {
            return facet;
        }
        TextField child = (TextField)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_SELECTED_TEXTFIELD_FACET, true);
        if (child == null) {
            child = new TextField();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_SELECTED_TEXTFIELD_FACET));
            child.addValidator(new FileChooserSelectValidator());
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_SELECTED_TEXTFIELD_FACET, (UIComponent)child);
        }
        Theme theme = this.getTheme();
        if (this.isMultiple()) {
            child.setColumns(Integer.parseInt(theme.getMessage("filechooser.multipleColumn")));
        } else {
            child.setColumns(Integer.parseInt(theme.getMessage("filechooser.singleColumn")));
        }
        if (this.isFolderChooser()) {
            child.setStyleClass(theme.getStyleClass("ChoFdrStl"));
        } else {
            child.setStyleClass(theme.getStyleClass("ChoFilStl"));
        }
        return child;
    }

    public UIComponent getSelectLabel() {
        UIComponent facet = this.getFacet(FILECHOOSER_SELECT_LABEL_FACET);
        if (facet != null) {
            return facet;
        }
        Label child = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_SELECT_LABEL_FACET, true);
        if (child == null) {
            child = new Label();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_SELECT_LABEL_FACET));
            child.setLabelLevel(2);
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_SELECT_LABEL_FACET, (UIComponent)child);
        }
        Theme theme = this.getTheme();
        child.setLabeledComponent(this.getSelectedTextField());
        boolean ismultiple = this.isMultiple();
        String labelKey = null;
        labelKey = this.isFolderChooser() ? (ismultiple ? "filechooser.selectedFolders" : "filechooser.selectedFolder") : (this.isFileAndFolderChooser() ? (ismultiple ? "filechooser.selectedFileAndFolders" : "filechooser.selectedFileAndFolder") : (ismultiple ? "filechooser.selectedFiles" : "filechooser.selectedFile"));
        child.setText(theme.getMessage(labelKey));
        return child;
    }

    public UIComponent getSortComponent() {
        UIComponent facet = this.getFacet(FILECHOOSER_SORTMENU_FACET);
        if (facet != null) {
            return facet;
        }
        DropDown jdd = (DropDown)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_SORTMENU_FACET, true);
        if (jdd == null) {
            jdd = new DropDown();
            jdd.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_SORTMENU_FACET));
            jdd.setSubmitForm(true);
            jdd.setLabelLevel(2);
            jdd.addValidator(new FileChooserSortValidator());
            jdd.setImmediate(true);
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_SORTMENU_FACET, (UIComponent)jdd);
        }
        Theme theme = this.getTheme();
        Option[] sortFields = new Option[]{new Option(ALPHABETIC_ASC, theme.getMessage("filechooser.sortOption1")), new Option(ALPHABETIC_DSC, theme.getMessage("filechooser.sortOption4")), new Option(LASTMODIFIED_ASC, theme.getMessage("filechooser.sortOption2")), new Option(LASTMODIFIED_DSC, theme.getMessage("filechooser.sortOption5")), new Option(SIZE_ASC, theme.getMessage("filechooser.sortOption3")), new Option(SIZE_DSC, theme.getMessage("filechooser.sortOption6"))};
        jdd.setItems(sortFields);
        jdd.setLabel(theme.getMessage("filechooser.sortBy"));
        jdd.setStyleClass(theme.getStyleClass("MnuJmp"));
        ResourceModel model = this.getModel();
        String sortVal = model.getSortValue();
        if (sortVal == null) {
            String sortfield = this.getSortField();
            if (sortfield == null) {
                jdd.setSelected(ALPHABETIC_ASC);
                model.setSortValue(ALPHABETIC_ASC);
            } else {
                String sField = sortfield.trim();
                sField = this.isDescending() ? sField.concat("d") : sField.concat("a");
                jdd.setSelected(sField);
                model.setSortValue(sField);
            }
        } else {
            jdd.setSelected(sortVal);
        }
        return jdd;
    }

    public UIComponent getListComponent() {
        int rows;
        Listbox fileList = (Listbox)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_LISTBOX_FACET, true);
        if (fileList == null) {
            fileList = new Listbox();
            fileList.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_LISTBOX_FACET));
            fileList.setMonospace(true);
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_LISTBOX_FACET, (UIComponent)fileList);
        }
        if ((rows = this.getRows()) <= 0) {
            fileList.setRows(12);
        } else {
            fileList.setRows(rows);
        }
        Theme theme = this.getTheme();
        if (this.isFolderChooser()) {
            fileList.setToolTip(theme.getMessage("filechooser.listTitleFolder"));
        } else if (this.isFileAndFolderChooser()) {
            fileList.setToolTip(theme.getMessage("filechooser.listTitleFileAndFolder"));
        } else {
            fileList.setToolTip(theme.getMessage("filechooser.listTitleFile"));
        }
        fileList.setMultiple(this.isMultiple());
        fileList.setValue(null);
        return this.populateListComponent(fileList);
    }

    public UIComponent getUpLevelButton(boolean disabled) {
        UIComponent facet = this.getFacet(FILECHOOSER_UPLEVEL_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Button child = (Button)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_UPLEVEL_BUTTON_FACET, true);
        if (child == null) {
            child = new Button();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_UPLEVEL_BUTTON_FACET));
            child.setPrimary(false);
            child.setImmediate(true);
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_UPLEVEL_BUTTON_FACET, (UIComponent)child);
        }
        Theme theme = this.getTheme();
        child.setText(theme.getMessage("filechooser.upOneLevel"));
        child.setToolTip(theme.getMessage("filechooser.upOneLevelTitle"));
        child.setDisabled(disabled);
        return child;
    }

    public UIComponent getOpenFolderButton() {
        UIComponent facet = this.getFacet(FILECHOOSER_OPENFOLDER_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Button child = (Button)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_OPENFOLDER_BUTTON_FACET, true);
        if (child == null) {
            child = new Button();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_OPENFOLDER_BUTTON_FACET));
            child.setPrimary(false);
            child.setDisabled(false);
            child.setImmediate(true);
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_OPENFOLDER_BUTTON_FACET, (UIComponent)child);
        }
        Theme theme = this.getTheme();
        child.setText(theme.getMessage("filechooser.openFolder"));
        child.setToolTip(theme.getMessage("filechooser.openFolderTitle"));
        return child;
    }

    public UIComponent getHiddenFCButton() {
        Button child = (Button)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_HIDDEN_BUTTON_FACET, true);
        if (child == null) {
            child = new Button();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_HIDDEN_BUTTON_FACET));
            child.setPrimary(true);
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_HIDDEN_BUTTON_FACET, (UIComponent)child);
        }
        return child;
    }

    public void restoreState(FacesContext _context, Object _state) {
        if (_state == null) {
            return;
        }
        Object[] _values = (Object[])_state;
        super.restoreState(_context, _values[0]);
        this.fileAndFolderChooser = (Boolean)_values[1];
    }

    public Object saveState(FacesContext _context) {
        Object[] _values = new Object[]{super.saveState(_context), this.fileAndFolderChooser ? Boolean.TRUE : Boolean.FALSE};
        return _values;
    }

    public void displayAlert(String summary, String detail, String[] summaryArgs, String[] detailArgs) {
        FacesContext context = FacesContext.getCurrentInstance();
        FacesMessage fmsg = this.createFacesMessage(summary, detail, summaryArgs, detailArgs);
        context.addMessage(this.getClientId(context), fmsg);
    }

    void log(String s) {
        if (LogUtil.fineEnabled(FileChooser.class)) {
            LogUtil.fine(FileChooser.class, s);
        }
    }

    private String getEncodedSelections() {
        Object value = this.getValue();
        Converter converter = this.getConverter();
        if (converter == null) {
            converter = this.getConverterFromValue(value);
        }
        String[] selections = null;
        try {
            selections = this.convertValueToStringArray(FacesContext.getCurrentInstance(), converter, value);
        }
        catch (ConverterException ce) {
            this.log("Failed to convert and encode initial selections.");
        }
        return this.encodeSelections(selections, this.getEscapeChar(), this.getDelimiterChar());
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    private FacesMessage createFacesMessage(String summary, String detail, String[] summaryArgs, String[] detailArgs) {
        FacesContext context = FacesContext.getCurrentInstance();
        Theme theme = ThemeUtilities.getTheme(context);
        String summaryMsg = theme.getMessage(summary, summaryArgs);
        String detailMsg = theme.getMessage(detail, detailArgs);
        FacesMessage fmsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, summaryMsg, detailMsg);
        return fmsg;
    }

    private String encodeSelections(String[] selections, String escapeChar, String delimiter) {
        if (selections == null || selections.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer(this.escapeString(selections[0], escapeChar, delimiter));
        for (int i = 1; i < selections.length; ++i) {
            sb.append(delimiter);
            sb.append(this.escapeString(selections[i], escapeChar, delimiter));
        }
        return sb.toString();
    }

    private String[] decodeSelections(String selections, String escapeChar, String delimiter) {
        if (selections == null) {
            return null;
        }
        char del = delimiter.toCharArray()[0];
        char esc = escapeChar.toCharArray()[0];
        char[] charArray = selections.toCharArray();
        int escseen = 0;
        int ind = 0;
        int j = 0;
        ArrayList<String> strArray = new ArrayList<String>();
        for (int i = 0; i < selections.length(); ++i) {
            if (charArray[i] == del && escseen % 2 == 0) {
                strArray.add(ind++, this.unescapeString(selections.substring(j, i), escapeChar, delimiter));
                j = i + 1;
            }
            if (charArray[i] == esc) {
                ++escseen;
                continue;
            }
            escseen = 0;
        }
        strArray.add(ind, this.unescapeString(selections.substring(j), escapeChar, delimiter));
        return strArray.toArray(new String[strArray.size()]);
    }

    private String escapeString(String s, String escapeChar, String delimiter) {
        String escaped_escapeChar = escapeChar;
        if (escapeChar.equals("\\")) {
            escaped_escapeChar = escapeChar + escapeChar;
        }
        String regEx = escaped_escapeChar;
        String s0 = s.replaceAll(regEx, escaped_escapeChar + escaped_escapeChar);
        regEx = delimiter;
        s0 = s0.replaceAll(regEx, escaped_escapeChar + delimiter);
        return s0;
    }

    private String unescapeString(String s, String escapeChar, String delimiter) {
        String escaped_escapeChar = escapeChar;
        if (escapeChar.equals("\\")) {
            escaped_escapeChar = escapeChar + escapeChar;
        }
        String regEx = escaped_escapeChar + delimiter;
        String s0 = s.replaceAll(regEx, delimiter);
        regEx = escaped_escapeChar + escaped_escapeChar;
        s0 = s0.replaceAll(regEx, escaped_escapeChar);
        return s0;
    }
}

