/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.AddListener;
import com.sun.web.ui.component.Button;
import com.sun.web.ui.component.EditableListBase;
import com.sun.web.ui.component.Label;
import com.sun.web.ui.component.ListManager;
import com.sun.web.ui.component.RemoveListener;
import com.sun.web.ui.component.StaticText;
import com.sun.web.ui.component.TextField;
import com.sun.web.ui.model.list.ListItem;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ConversionUtilities;
import com.sun.web.ui.util.MessageUtil;
import com.sun.web.ui.util.ThemeUtilities;
import com.sun.web.ui.validator.StringLengthValidator;
import java.lang.reflect.Array;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.event.ActionListener;

public class EditableList
extends EditableListBase
implements ListManager {
    public static final String ADD_BUTTON_ID = "_addButton";
    public static final String ADD_BUTTON_FACET = "addButton";
    public static final String REMOVE_BUTTON_ID = "_removeButton";
    public static final String REMOVE_BUTTON_FACET = "removeButton";
    public static final String FIELD_ID = "_field";
    public static final String FIELD_FACET = "field";
    public static final String LIST_LABEL_ID = "_listLabel";
    public static final String LIST_LABEL_FACET = "listLabel";
    public static final String FIELD_LABEL_ID = "_fieldLabel";
    public static final String FIELD_LABEL_FACET = "fieldLabel";
    public static final String READ_ONLY_ID = "_readOnly";
    public static final String READ_ONLY_FACET = "readOnly";
    public static final String HEADER_FACET = "header";
    public static final String FOOTER_FACET = "footer";
    public static final String JSOBJECT = "com.sun.web.ui.EditabelListJS";
    public static final String ADD_FUNCTION = ".add(); ";
    public static final String ENABLE_ADD_FUNCTION = ".enableAdd(); ";
    public static final String SET_ADD_DISABLED_FUNCTION = ".setAddDisabled(false);";
    public static final String ENABLE_REMOVE_FUNCTION = ".enableRemove(); ";
    public static final String UPDATE_BUTTONS_FUNCTION = ".updateButtons(); ";
    private static final String READ_ONLY_SEPARATOR = ", ";
    public static final String SEARCH_FACET = "search";
    public static final String SPACER_STRING = "_";
    private static final int MIN_LENGTH = 20;
    private static final boolean DEBUG = false;
    private TreeMap listItems = null;
    private Collator collator = null;
    private transient Theme theme = null;
    private String selectedValue = null;
    private String[] valuesToRemove = null;

    public int getMaxlLength() {
        int length = super.getMaxLength();
        if (length < 1) {
            length = 25;
            super.setMaxLength(length);
        }
        return length;
    }

    public UIComponent getAddButtonComponent() {
        String id = this.getId();
        Object buttonComponent = this.getFacet(ADD_BUTTON_FACET);
        if (buttonComponent == null) {
            buttonComponent = this.createButton(this.getTheme().getMessage("EditableList.add"), ADD_BUTTON_ID, ADD_BUTTON_FACET, new AddListener());
            ((Button)buttonComponent).setPrimary(true);
        }
        if (buttonComponent != null && this.isDisabled()) {
            buttonComponent.getAttributes().put("disabled", Boolean.TRUE);
        }
        return buttonComponent;
    }

    public UIComponent getRemoveButtonComponent() {
        String id = this.getId();
        Object buttonComponent = this.getFacet(REMOVE_BUTTON_FACET);
        if (buttonComponent == null) {
            buttonComponent = this.createButton(this.getTheme().getMessage("EditableList.remove"), REMOVE_BUTTON_ID, REMOVE_BUTTON_FACET, new RemoveListener());
        }
        if (buttonComponent != null && this.isDisabled()) {
            buttonComponent.getAttributes().put("disabled", Boolean.TRUE);
        }
        return buttonComponent;
    }

    public UIComponent getListLabelComponent() {
        String id = this.getId();
        Object labelComponent = this.getFacet(LIST_LABEL_FACET);
        if (labelComponent == null) {
            String labelString = this.getListLabel();
            if (labelString == null || labelString.length() == 0) {
                labelString = this.getTheme().getMessage("EditableList.defaultListLabel");
            }
            labelComponent = this.createLabel(labelString, LIST_LABEL_ID, LIST_LABEL_FACET);
            ((Label)((Object)labelComponent)).setLabeledComponent((UIComponent)this);
        }
        return labelComponent;
    }

    public UIComponent getFieldLabelComponent() {
        String id = this.getId();
        Object labelComponent = this.getFacet(FIELD_LABEL_FACET);
        if (labelComponent == null) {
            String labelString = this.getFieldLabel();
            if (labelString == null || labelString.length() == 0) {
                labelString = this.getTheme().getMessage("EditableList.defaultFieldLabel");
            }
            labelComponent = this.createLabel(labelString, FIELD_LABEL_ID, FIELD_LABEL_FACET);
            ((Label)((Object)labelComponent)).setLabeledComponent(this.getFieldComponent());
        }
        return labelComponent;
    }

    public UIComponent getFieldComponent() {
        String id = this.getId();
        Object fieldComponent = this.getFacet(FIELD_FACET);
        if (fieldComponent == null) {
            fieldComponent = this.createField(FIELD_ID, FIELD_FACET);
        }
        if (fieldComponent != null && this.isDisabled()) {
            fieldComponent.getAttributes().put("disabled", Boolean.TRUE);
        }
        return fieldComponent;
    }

    protected String getValueAsReadOnly(FacesContext context) throws FacesException {
        StringBuffer valueBuffer = new StringBuffer(200);
        Iterator iterator = this.getListItems(context, false);
        while (iterator.hasNext()) {
            String string = ((ListItem)iterator.next()).getLabel();
            if (string.indexOf("nbsp") > -1) continue;
            valueBuffer.append(string);
            if (!iterator.hasNext()) continue;
            valueBuffer.append(READ_ONLY_SEPARATOR);
        }
        return valueBuffer.toString();
    }

    public UIComponent getReadOnlyValueComponent() {
        String id = this.getId();
        Object textComponent = this.getFacet(READ_ONLY_FACET);
        if (textComponent == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            textComponent = this.createText(this.getValueAsReadOnly(context), READ_ONLY_ID, READ_ONLY_FACET);
        }
        return textComponent;
    }

    public void setConverter(Converter converter) {
        String msg = this.getTheme().getMessage("EditableList.noConversion");
        throw new RuntimeException(msg);
    }

    public String getJavaScriptObjectName() {
        Object o = this.getAttributes().get(JSOBJECT);
        String name = null;
        if (o != null && o instanceof String) {
            name = (String)o;
        } else {
            FacesContext context = FacesContext.getCurrentInstance();
            name = this.getClientId(context).replace(':', '_');
            name = "EditableList_".concat(name);
            this.getAttributes().put(JSOBJECT, name);
        }
        return name;
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    public String getOnChange() {
        StringBuffer onchangeBuffer = new StringBuffer(128);
        onchangeBuffer.append(this.getJavaScriptObjectName());
        onchangeBuffer.append(ENABLE_REMOVE_FUNCTION);
        return onchangeBuffer.toString();
    }

    public String getPrimaryElementID(FacesContext context) {
        return this.getClientId(context).concat("_list");
    }

    public String[] getValuesToRemove() {
        if (this.valuesToRemove == null) {
            return new String[0];
        }
        return this.valuesToRemove;
    }

    public void setValuesToRemove(String[] valuesToRemove) {
        this.valuesToRemove = valuesToRemove;
    }

    private Label createLabel(String labelString, String id, String facetName) {
        if (labelString == null || labelString.length() < 1) {
            labelString = new String();
        }
        Label label = new Label();
        label.setId(this.getId().concat(id));
        label.setText(labelString);
        label.setLabelLevel(this.getLabelLevel());
        this.getFacets().put(facetName, label);
        return label;
    }

    private StaticText createText(String text, String id, String facetName) {
        if (text == null || text.length() < 1) {
            text = new String();
        }
        StaticText field = new StaticText();
        field.setValue(text);
        field.setId(this.getId().concat(id));
        this.getFacets().put(facetName, field);
        return field;
    }

    private TextField createField(String id, String facetName) {
        String jsObjectName = this.getJavaScriptObjectName();
        StringBuffer onkeypressBuffer = new StringBuffer(128);
        onkeypressBuffer.append("if(event.keyCode == 13) { ");
        onkeypressBuffer.append(jsObjectName);
        onkeypressBuffer.append(ADD_FUNCTION);
        onkeypressBuffer.append("return false; } ");
        StringBuffer onfocusBuffer = new StringBuffer(128);
        onfocusBuffer.append(jsObjectName);
        onfocusBuffer.append(SET_ADD_DISABLED_FUNCTION);
        onfocusBuffer.append("return false;");
        StringBuffer onfocuslostBuffer = new StringBuffer(128);
        onfocuslostBuffer.append(jsObjectName);
        onfocuslostBuffer.append(ENABLE_ADD_FUNCTION);
        onfocuslostBuffer.append("return false;");
        TextField field = new TextField();
        field.setId(this.getId().concat(id));
        int columns = this.getMaxLength();
        if (columns < 20) {
            columns = 20;
        }
        field.setColumns(columns);
        field.setOnKeyPress(onkeypressBuffer.toString());
        field.setOnFocus(onfocusBuffer.toString());
        field.setOnBlur(onfocuslostBuffer.toString());
        field.setTrim(true);
        if (this.getFieldValidator() != null) {
            field.setValidator(this.getFieldValidator());
        }
        if (this.getTabIndex() > 0) {
            field.setTabIndex(this.getTabIndex());
        }
        Theme theme = this.getTheme();
        StringLengthValidator strl = new StringLengthValidator(this.getMaxLength(), 1);
        strl.setTooLongMessage(theme.getMessage("EditableList.itemTooLong"));
        strl.setTooShortMessage(theme.getMessage("EditableList.fieldEmpty"));
        field.addValidator(strl);
        this.getFacets().put(facetName, field);
        return field;
    }

    private Button createButton(String text, String id, String facetName, ActionListener actionListener) {
        Button button = new Button();
        button.setId(this.getId().concat(id));
        button.setText(text);
        if (this.getTabIndex() > 0) {
            button.setTabIndex(this.getTabIndex());
        }
        button.setImmediate(true);
        button.addActionListener(actionListener);
        this.getFacets().put(facetName, button);
        return button;
    }

    public Iterator getListItems(FacesContext context, boolean rulerAtEnd) throws FacesException {
        Locale locale = context.getViewRoot().getLocale();
        this.collator = Collator.getInstance(locale);
        this.listItems = new TreeMap(this.collator);
        String lastKey = "";
        String[] currentValues = this.getCurrentValueAsStringArray();
        ListItem listItem = null;
        StringBuffer unsortedKeyBuffer = new StringBuffer("a");
        for (int counter = 0; counter < currentValues.length; ++counter) {
            String currentString = currentValues[counter];
            if (currentString == null) {
                String msg = MessageUtil.getMessage("com.sun.web.ui.resources.LogMessages", "EditableList.badValue", new Object[]{this.getClientId(context)});
                throw new FacesException(msg);
            }
            listItem = new ListItem(currentString);
            listItem.setValue(currentString);
            if (currentString.equals(this.selectedValue)) {
                listItem.setSelected(true);
            }
            if (this.isSorted()) {
                if (this.collator.compare(currentString, lastKey) > 0) {
                    lastKey = currentString;
                }
                this.listItems.put(currentString, listItem);
                continue;
            }
            this.listItems.put(unsortedKeyBuffer.toString(), listItem);
            unsortedKeyBuffer.append("a");
        }
        if (!this.isSorted()) {
            lastKey = unsortedKeyBuffer.toString();
        }
        if (rulerAtEnd) {
            int length = this.getMaxlLength();
            if (length < 20) {
                length = 20;
            }
            StringBuffer labelBuffer = new StringBuffer(length);
            for (int counter = 0; counter < length; ++counter) {
                labelBuffer.append(SPACER_STRING);
            }
            ListItem item = new ListItem(labelBuffer.toString());
            item.setDisabled(true);
            this.listItems.put(lastKey.concat("a"), item);
        }
        return this.listItems.values().iterator();
    }

    private String[] getCurrentValueAsStringArray() {
        Object value = this.getSubmittedValue();
        if (value == null) {
            value = this.getValue();
        }
        if (value == null) {
            return new String[0];
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        String msg = MessageUtil.getMessage("com.sun.web.ui.resources.LogMessages", "EditableList.badValue", new Object[]{this.getClientId(FacesContext.getCurrentInstance())});
        throw new FacesException(msg);
    }

    private void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }

    public Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        if (!(submittedValue instanceof String[])) {
            throw new ConverterException("Submitted value must be a String array");
        }
        String[] rawValues = (String[])submittedValue;
        if (rawValues.length == 0 && ConversionUtilities.renderedNull((UIComponent)this)) {
            return null;
        }
        return submittedValue;
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        UIComponent field = this.getFieldComponent();
        String fieldId = field.getId();
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (fieldId != null && fieldId.equals(kid.getId())) continue;
            kid.processValidators(context);
        }
        this.checkValid(context);
    }

    public void processAddAction() {
        if (FacesContext.getCurrentInstance().getRenderResponse()) {
            return;
        }
        this.selectedValue = null;
        String[] values = this.getCurrentValueAsStringArray();
        Object value = this.getAddedObject();
        if (value == null) {
            return;
        }
        this.selectedValue = value.toString();
        int numValues = values.length;
        String[] newValues = new String[numValues + 1];
        for (int counter = 0; counter < numValues; ++counter) {
            newValues[counter] = values[counter];
        }
        newValues[counter] = this.selectedValue;
        this.setSubmittedValue(newValues);
    }

    public void processRemoveAction() {
        int counter;
        if (FacesContext.getCurrentInstance().getRenderResponse()) {
            return;
        }
        this.selectedValue = null;
        ArrayList<String> items = new ArrayList<String>();
        if (this.getValue() != null) {
            String[] strings = this.getCurrentValueAsStringArray();
            int length = strings.length;
            for (counter = 0; counter < length; ++counter) {
                items.add(strings[counter]);
            }
        }
        String[] valuesToRemove = this.getValuesToRemove();
        for (counter = 0; counter < valuesToRemove.length; ++counter) {
            items.remove(valuesToRemove[counter]);
        }
        String[] newValues = new String[items.size()];
        for (counter = 0; counter < items.size(); ++counter) {
            newValues[counter] = (String)items.get(counter);
        }
        this.setValuesToRemove(null);
        this.setSubmittedValue(newValues);
    }

    private void checkValid(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    private Object getAddedObject() {
        FacesContext context = FacesContext.getCurrentInstance();
        EditableValueHolder field = (EditableValueHolder)this.getFieldComponent();
        ((UIComponent)field).processValidators(context);
        if (!field.isValid()) {
            return null;
        }
        Object value = field.getValue();
        if (value == null || value instanceof String && value.toString().length() == 0) {
            field.setValid(false);
            context.renderResponse();
            String message = ThemeUtilities.getTheme(context).getMessage("EditableList.fieldEmpty");
            context.addMessage(this.getClientId(context), new FacesMessage(message));
            return null;
        }
        field.setValue(null);
        return value;
    }

    public boolean isImmediate() {
        return false;
    }

    protected boolean compareValues(Object previous, Object value) {
        if (previous == null || value == null) {
            return super.compareValues(previous, value);
        }
        if (value instanceof Object[]) {
            int length = Array.getLength(value);
            if (Array.getLength(previous) != length) {
                return true;
            }
            for (int i = 0; i < length; ++i) {
                Object newValue = Array.get(value, i);
                Object prevValue = Array.get(previous, i);
                if (newValue == null) {
                    if (prevValue == null) continue;
                    return true;
                }
                if (prevValue == null) {
                    return true;
                }
                if (prevValue.equals(newValue)) continue;
                return true;
            }
            return false;
        }
        return super.compareValues(previous, value);
    }

    public String[] getValueAsStringArray(FacesContext context) {
        Iterator iterator = this.getListItems(context, false);
        int numItems = this.listItems.size();
        String[] values = new String[numItems];
        for (int counter = 0; counter < numItems; ++counter) {
            values[counter] = ((ListItem)iterator.next()).getValue();
        }
        return values;
    }

    public boolean mainListSubmits() {
        return true;
    }
}

