/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.AddRemoveBase;
import com.sun.web.ui.component.Button;
import com.sun.web.ui.component.Label;
import com.sun.web.ui.component.ListManager;
import com.sun.web.ui.component.StaticText;
import com.sun.web.ui.model.Option;
import com.sun.web.ui.model.OptionGroup;
import com.sun.web.ui.model.Separator;
import com.sun.web.ui.model.list.ListItem;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.MessageUtil;
import com.sun.web.ui.util.ThemeUtilities;
import java.text.Collator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class AddRemove
extends AddRemoveBase
implements ListManager {
    public static final String ADD_BUTTON_ID = "_addButton";
    public static final String ADD_BUTTON_FACET = "addButton";
    public static final String ADDALL_BUTTON_ID = "_addAllButton";
    public static final String ADDALL_BUTTON_FACET = "addAllButton";
    public static final String REMOVE_BUTTON_ID = "_removeButton";
    public static final String REMOVE_BUTTON_FACET = "removeButton";
    public static final String REMOVEALL_BUTTON_ID = "_removeAllButton";
    public static final String REMOVEALL_BUTTON_FACET = "removeAllButton";
    public static final String MOVEUP_BUTTON_ID = "_moveUpButton";
    public static final String MOVEUP_BUTTON_FACET = "moveUpButton";
    public static final String MOVEDOWN_BUTTON_ID = "_moveDownButton";
    public static final String MOVEDOWN_BUTTON_FACET = "moveDownButton";
    public static final String AVAILABLE_LABEL_ID = "_availableLabel";
    public static final String AVAILABLE_LABEL_FACET = "availableLabel";
    public static final String SELECTED_LABEL_ID = "_selectedLabel";
    public static final String SELECTED_LABEL_FACET = "selectedLabel";
    public static final String HEADER_FACET = "header";
    public static final String HEADER_ID = "_header";
    public static final String FOOTER_FACET = "footer";
    public static final String AVAILABLE_ID = "_available";
    public static final String SELECTED_ID = "_selected";
    public static final String JSOBJECT = "com.sun.web.ui.AddRemoveJS";
    public static final String JAVASCRIPT_PREFIX = "javascript: ";
    public static final String RETURN = "return false;";
    public static final String ADD_FUNCTION = ".add(); ";
    public static final String ADDALL_FUNCTION = ".addAll();";
    public static final String REMOVE_FUNCTION = ".remove(); ";
    public static final String REMOVEALL_FUNCTION = ".removeAll(); ";
    public static final String MOVEUP_FUNCTION = ".moveUp(); ";
    public static final String MOVEDOWN_FUNCTION = ".moveDown();";
    public static final String UPDATEBUTTONS_FUNCTION = ".updateButtons(); ";
    public static final String AVAILABLE_ONCHANGE_FUNCTION = ".availableOnChange(); ";
    public static final String SELECTED_ONCHANGE_FUNCTION = ".selectedOnChange(); ";
    public static final String MULTIPLEADDITIONS_FUNCTION = ".allowMultipleAdditions()";
    public static final String SPACER_STRING = "_";
    public static final String SEPARATOR_VALUE = "com.sun.web.ui.separator";
    private TreeMap availableItems = null;
    private TreeMap selectedItems = null;
    private Collator collator = null;
    private String allValues = "";
    private String selectedValues = "";
    private static final boolean DEBUG = false;

    public AddRemove() {
        this.setMultiple(true);
    }

    public int getRows() {
        int rows = super.getRows();
        if (rows < 1) {
            rows = 12;
            super.setRows(rows);
        }
        return rows;
    }

    public String getSeparator() {
        return "|";
    }

    public Iterator getSelectedItems() {
        return this.selectedItems.values().iterator();
    }

    public String getAllValues() {
        return this.allValues;
    }

    public String getSelectedValues() {
        return this.selectedValues;
    }

    public UIComponent getAddButtonComponent(FacesContext context) {
        String id = this.getId();
        Object buttonComponent = this.getFacet(ADD_BUTTON_FACET);
        if (buttonComponent == null) {
            String buttonLabel = this.getTheme().getMessage("AddRemove.add");
            if (!this.isVertical()) {
                buttonLabel = buttonLabel.concat(" > ");
            }
            buttonComponent = this.createButton(buttonLabel, ADD_BUTTON_ID, ADD_BUTTON_FACET);
            ((Button)buttonComponent).setPrimary(true);
            StringBuffer jsBuffer = new StringBuffer(200);
            jsBuffer.append(this.getAttributes().get(JSOBJECT));
            jsBuffer.append(ADD_FUNCTION);
            jsBuffer.append(RETURN);
            ((Button)buttonComponent).setOnClick(jsBuffer.toString());
        }
        if (buttonComponent != null && this.isDisabled()) {
            buttonComponent.getAttributes().put("disabled", Boolean.TRUE);
        }
        return buttonComponent;
    }

    public UIComponent getAddAllButtonComponent() {
        String id = this.getId();
        Object buttonComponent = this.getFacet(ADDALL_BUTTON_FACET);
        if (buttonComponent == null) {
            String buttonLabel = this.getTheme().getMessage("AddRemove.addAll");
            if (!this.isVertical()) {
                buttonLabel = buttonLabel.concat(" >> ");
            }
            buttonComponent = this.createButton(buttonLabel, ADDALL_BUTTON_ID, ADDALL_BUTTON_FACET);
            ((Button)buttonComponent).setPrimary(false);
            StringBuffer jsBuffer = new StringBuffer(200);
            jsBuffer.append(JAVASCRIPT_PREFIX);
            jsBuffer.append(this.getAttributes().get(JSOBJECT));
            jsBuffer.append(ADDALL_FUNCTION);
            jsBuffer.append(RETURN);
            ((Button)buttonComponent).setOnClick(jsBuffer.toString());
        }
        if (buttonComponent != null && this.isDisabled()) {
            buttonComponent.getAttributes().put("disabled", Boolean.TRUE);
        }
        return buttonComponent;
    }

    public UIComponent getRemoveButtonComponent() {
        String id = this.getId();
        Object buttonComponent = this.getFacet(REMOVE_BUTTON_FACET);
        if (buttonComponent == null) {
            String buttonLabel = this.getTheme().getMessage("AddRemove.remove");
            if (!this.isVertical()) {
                buttonLabel = " < ".concat(buttonLabel);
            }
            buttonComponent = this.createButton(buttonLabel, REMOVE_BUTTON_ID, REMOVE_BUTTON_FACET);
            ((Button)buttonComponent).setPrimary(true);
            StringBuffer jsBuffer = new StringBuffer(200);
            jsBuffer.append(JAVASCRIPT_PREFIX);
            jsBuffer.append(this.getAttributes().get(JSOBJECT));
            jsBuffer.append(REMOVE_FUNCTION);
            jsBuffer.append(RETURN);
            ((Button)buttonComponent).setOnClick(jsBuffer.toString());
        }
        if (buttonComponent != null && this.isDisabled()) {
            buttonComponent.getAttributes().put("disabled", Boolean.TRUE);
        }
        return buttonComponent;
    }

    public UIComponent getRemoveAllButtonComponent() {
        String id = this.getId();
        Object buttonComponent = this.getFacet(REMOVEALL_BUTTON_FACET);
        if (buttonComponent == null) {
            String buttonLabel = this.getTheme().getMessage("AddRemove.removeAll");
            if (!this.isVertical()) {
                buttonLabel = " << ".concat(buttonLabel);
            }
            buttonComponent = this.createButton(buttonLabel, REMOVEALL_BUTTON_ID, REMOVEALL_BUTTON_FACET);
            ((Button)buttonComponent).setPrimary(false);
            StringBuffer jsBuffer = new StringBuffer(200);
            jsBuffer.append(JAVASCRIPT_PREFIX);
            jsBuffer.append(this.getAttributes().get(JSOBJECT));
            jsBuffer.append(REMOVEALL_FUNCTION);
            jsBuffer.append(RETURN);
            ((Button)buttonComponent).setOnClick(jsBuffer.toString());
        }
        if (buttonComponent != null && this.isDisabled()) {
            buttonComponent.getAttributes().put("disabled", Boolean.TRUE);
        }
        return buttonComponent;
    }

    public UIComponent getMoveUpButtonComponent() {
        String id = this.getId();
        Object buttonComponent = this.getFacet(MOVEUP_BUTTON_FACET);
        if (buttonComponent == null) {
            buttonComponent = this.createButton(this.getTheme().getMessage("AddRemove.moveUp"), MOVEUP_BUTTON_ID, MOVEUP_BUTTON_FACET);
            ((Button)buttonComponent).setPrimary(false);
            StringBuffer jsBuffer = new StringBuffer(200);
            jsBuffer.append(JAVASCRIPT_PREFIX);
            jsBuffer.append(this.getAttributes().get(JSOBJECT));
            jsBuffer.append(MOVEUP_FUNCTION);
            jsBuffer.append(RETURN);
            ((Button)buttonComponent).setOnClick(jsBuffer.toString());
        }
        if (buttonComponent != null && this.isDisabled()) {
            buttonComponent.getAttributes().put("disabled", Boolean.TRUE);
        }
        return buttonComponent;
    }

    public UIComponent getMoveDownButtonComponent() {
        String id = this.getId();
        Object buttonComponent = this.getFacet(MOVEDOWN_BUTTON_FACET);
        if (buttonComponent == null) {
            buttonComponent = this.createButton(this.getTheme().getMessage("AddRemove.moveDown"), MOVEDOWN_BUTTON_ID, MOVEDOWN_BUTTON_FACET);
            ((Button)buttonComponent).setPrimary(false);
            StringBuffer jsBuffer = new StringBuffer(200);
            jsBuffer.append(JAVASCRIPT_PREFIX);
            jsBuffer.append(this.getAttributes().get(JSOBJECT));
            jsBuffer.append(MOVEDOWN_FUNCTION);
            jsBuffer.append(RETURN);
            ((Button)buttonComponent).setOnClick(jsBuffer.toString());
        }
        if (buttonComponent != null && this.isDisabled()) {
            buttonComponent.getAttributes().put("disabled", Boolean.TRUE);
        }
        return buttonComponent;
    }

    public UIComponent getAvailableLabelComponent() {
        String id = this.getId();
        Object label = this.getFacet(AVAILABLE_LABEL_FACET);
        if (label == null) {
            String labelString = this.getAvailableItemsLabel();
            if (labelString == null || labelString.length() == 0) {
                labelString = this.getTheme().getMessage("AddRemove.available");
            }
            String styleClass = null;
            int labelLevel = 2;
            if (this.getLabel() == null || this.getLabel().length() == 0) {
                styleClass = this.getTheme().getStyleClass("AddRmvLbl");
            } else {
                styleClass = this.getTheme().getStyleClass("AddRmvLbl2");
                labelLevel = 3;
            }
            String forID = this.getClientId(FacesContext.getCurrentInstance()).concat(AVAILABLE_ID);
            label = this.createLabel(labelString, styleClass, forID, labelLevel, AVAILABLE_LABEL_ID, AVAILABLE_LABEL_FACET);
        }
        return label;
    }

    public UIComponent getSelectedLabelComponent() {
        String id = this.getId();
        Object label = this.getFacet(SELECTED_LABEL_FACET);
        if (label == null) {
            String labelString = this.getSelectedItemsLabel();
            if (labelString == null || labelString.length() == 0) {
                labelString = this.getTheme().getMessage("AddRemove.selected");
            }
            String styleClass = null;
            int labelLevel = 2;
            if (this.getLabel() == null || this.getLabel().length() == 0) {
                styleClass = this.getTheme().getStyleClass("AddRmvLbl");
            } else {
                styleClass = this.getTheme().getStyleClass("AddRmvLbl2");
                labelLevel = 3;
            }
            String forID = this.getClientId(FacesContext.getCurrentInstance()).concat(SELECTED_ID);
            label = this.createLabel(labelString, styleClass, forID, labelLevel, SELECTED_LABEL_ID, SELECTED_LABEL_FACET);
        }
        return label;
    }

    public UIComponent getHeaderComponent() {
        String id = this.getId();
        Object label = this.getFacet(HEADER_FACET);
        if (label == null) {
            String labelString = this.getLabel();
            if (labelString == null || labelString.length() == 0) {
                return null;
            }
            String styleClass = this.getTheme().getStyleClass("AddRmvLbl");
            label = this.createLabel(labelString, styleClass, null, 2, HEADER_ID, HEADER_FACET);
            ((Label)((Object)label)).setLabeledComponent((UIComponent)this);
        }
        return label;
    }

    public String getPrimaryElementID(FacesContext context) {
        return this.getClientId(context).concat(AVAILABLE_ID);
    }

    private Label createLabel(String labelString, String styleClass, String forID, int labelLevel, String id, String facetName) {
        if (labelString == null || labelString.length() < 1) {
            labelString = new String();
        }
        Label label = new Label();
        label.setLabelLevel(labelLevel);
        label.setId(this.getId().concat(id));
        label.setText(labelString);
        label.setStyleClass(styleClass);
        if (forID != null) {
            label.setFor(forID);
        }
        this.getFacets().put(facetName, label);
        return label;
    }

    private Button createButton(String text, String id, String facetName) {
        Button button = new Button();
        button.setId(this.getId().concat(id));
        button.setText(text);
        if (this.getTabIndex() > 0) {
            button.setTabIndex(this.getTabIndex());
        }
        button.setPrimary(true);
        this.getFacets().put(facetName, button);
        return button;
    }

    private StaticText createText(String text, String id, String facetName) {
        if (text == null || text.length() < 1) {
            text = new String();
        }
        StaticText field = new StaticText();
        field.setValue(text);
        field.setId(this.getId().concat(id));
        this.getFacets().put(facetName, field);
        return field;
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    public Iterator getListItems(FacesContext context, boolean rulerAtEnd) throws FacesException {
        Locale locale = context.getViewRoot().getLocale();
        this.collator = Collator.getInstance(locale);
        this.collator.setStrength(3);
        this.availableItems = new TreeMap(this.collator);
        this.selectedItems = new TreeMap(this.collator);
        this.processOptions(context, this.collator, locale, rulerAtEnd);
        this.allValues = this.constructValueString(this.availableItems);
        this.processSelections();
        this.selectedValues = this.constructValueString(this.selectedItems, SEPARATOR_VALUE);
        return this.availableItems.values().iterator();
    }

    protected void processOptions(FacesContext context, Collator collator, Locale locale, boolean rulerAtEnd) {
        Option[] options = this.getOptions();
        int length = options.length;
        ListItem listItem = null;
        String label = null;
        String lastKey = "";
        String longestString = "";
        StringBuffer unsortedKeyBuffer = new StringBuffer(100);
        for (int counter = 0; counter < length; ++counter) {
            String msg;
            if (options[counter] instanceof OptionGroup) {
                msg = MessageUtil.getMessage("com.sun.web.ui.resources.LogMessages", "AddRemove.noGrouping");
                this.log(msg);
                continue;
            }
            if (options[counter] instanceof Separator) {
                msg = MessageUtil.getMessage("com.sun.web.ui.resources.LogMessages", "AddRemove.noGrouping");
                this.log(msg);
                continue;
            }
            label = options[counter].getLabel();
            if (label.length() > longestString.length()) {
                longestString = label;
            }
            listItem = this.createListItem(options[counter]);
            if (this.isSorted()) {
                this.availableItems.put(label, listItem);
                if (collator.compare(label, lastKey) <= 0) continue;
                lastKey = label;
                continue;
            }
            unsortedKeyBuffer.append("a");
            this.availableItems.put(unsortedKeyBuffer.toString(), listItem);
            lastKey = unsortedKeyBuffer.toString();
        }
        if (rulerAtEnd) {
            int seplength = longestString.length() + 5;
            StringBuffer labelBuffer = new StringBuffer(seplength);
            for (int counter = 0; counter < seplength; ++counter) {
                labelBuffer.append(SPACER_STRING);
            }
            ListItem item = new ListItem(labelBuffer.toString());
            item.setDisabled(true);
            item.setValue(SEPARATOR_VALUE);
            if (this.isSorted()) {
                lastKey = lastKey.concat("a");
                this.availableItems.put(lastKey, item);
                lastKey = lastKey.concat("a");
                this.selectedItems.put(lastKey, item);
            } else {
                unsortedKeyBuffer.append("a");
                this.availableItems.put(unsortedKeyBuffer.toString(), item);
                unsortedKeyBuffer.append("a");
                this.selectedItems.put(unsortedKeyBuffer.toString(), item);
            }
        }
    }

    private String constructValueString(TreeMap map) {
        return this.constructValueString(map, null);
    }

    private String constructValueString(TreeMap map, String filter) {
        StringBuffer valuesBuffer = new StringBuffer(392);
        Iterator values = map.values().iterator();
        ListItem listItem = null;
        String separator = this.getSeparator();
        valuesBuffer.append(separator);
        while (values.hasNext()) {
            listItem = (ListItem)values.next();
            if (filter != null && listItem.getValue().equals(filter)) continue;
            valuesBuffer.append(listItem.getValue());
            valuesBuffer.append(separator);
        }
        return valuesBuffer.toString();
    }

    public Iterator getSelectedListItems() {
        return this.selectedItems.values().iterator();
    }

    protected void markSelectedListItems(List list, boolean processed) {
        Iterator keys = this.availableItems.keySet().iterator();
        Iterator selected = null;
        Object nextItem = null;
        ListItem listItem = null;
        Object key = null;
        block0: while (keys.hasNext() && !list.isEmpty()) {
            key = keys.next();
            nextItem = this.availableItems.get(key);
            if (!(nextItem instanceof ListItem)) continue;
            listItem = nextItem;
            selected = list.iterator();
            Object selectedValue = null;
            while (selected.hasNext()) {
                boolean match = false;
                selectedValue = selected.next();
                match = processed ? listItem.getValueObject().equals(selectedValue) : selectedValue.toString().equals(listItem.getValue());
                if (!match) continue;
                if (this.isDuplicateSelections() && this.selectedItems.containsKey(key)) {
                    String key2 = key.toString().concat("1");
                    this.selectedItems.put(key2, listItem);
                } else {
                    this.selectedItems.put(key, listItem);
                }
                list.remove(selectedValue);
                if (!this.isDuplicateSelections()) continue block0;
                selected = list.iterator();
            }
        }
        if (!this.isDuplicateSelections()) {
            keys = this.selectedItems.keySet().iterator();
            key = null;
            while (keys.hasNext()) {
                key = keys.next();
                this.availableItems.remove(key);
            }
        }
        if (!list.isEmpty()) {
            String msg = "\tSome selected value(s) for this component is/are not ";
            msg = msg.concat("present on the list of options.");
            this.log(msg);
        }
    }

    public boolean mainListSubmits() {
        return false;
    }
}

