/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.bean;

import com.sun.web.ui.component.Button;
import com.sun.web.ui.component.Hyperlink;
import com.sun.web.ui.component.Markup;
import com.sun.web.ui.component.PanelGroup;
import com.sun.web.ui.component.StaticText;
import com.sun.web.ui.component.TextField;
import com.sun.web.ui.component.Tree;
import com.sun.web.ui.component.TreeNode;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ConversionUtilities;
import com.sun.web.ui.util.HelpUtils;
import com.sun.web.ui.util.LogUtil;
import com.sun.web.ui.util.ThemeUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.help.SearchTOCItem;
import javax.help.TreeItem;
import javax.servlet.http.HttpServletRequest;
import javax.swing.tree.DefaultMutableTreeNode;

public class HelpBackingBean {
    public static final String HELP_CONTENTS_TREE_ID = "helpContentsTree";
    public static final String HELP_INDEX_TREE_ID = "helpIndexTree";
    public static final String CONTENT_FRAME_NAME = "contentFrame";
    private static final String TIPS_FILE = "/com_sun_web_ui/help/tips.jsp";
    private Theme theme = null;
    private Tree contentsTree = null;
    private Tree indexTree = null;
    private PanelGroup searchPanel = null;
    private PanelGroup searchResultsPanel = null;
    private TextField searchField = null;
    private Button searchButton = null;
    private HelpUtils helpUtils = null;
    private String helpSetPath = "";
    private String jspPath = null;
    private int httpPort = -1;
    Hyperlink tipsLink = null;
    String tipsTitle = this.getTheme().getMessage("help.tips");
    String tipsImprove = this.getTheme().getMessage("help.tipsImprove");
    String tipsImprove1 = this.getTheme().getMessage("help.tipsImprove1");
    String tipsImprove2 = this.getTheme().getMessage("help.tipsImprove2");
    String tipsImprove3 = this.getTheme().getMessage("help.tipsImprove3");
    String tipsImprove4 = this.getTheme().getMessage("help.tipsImprove4");
    String tipsNote = this.getTheme().getMessage("help.tipsNote");
    String tipsNoteDetails = this.getTheme().getMessage("help.tipsNoteDetails");
    String tipsSearch = this.getTheme().getMessage("help.tipsSearch");
    String tipsSearch1 = this.getTheme().getMessage("help.tipsSearch1");
    String tipsSearch2 = this.getTheme().getMessage("help.tipsSearch2");
    String tipsSearch3 = this.getTheme().getMessage("help.tipsSearch3");
    String tipsSearch4 = this.getTheme().getMessage("help.tipsSearch4");
    String backButtonText = this.getTheme().getMessage("help.backButtonTitle");
    String forwardButtonText = this.getTheme().getMessage("help.forwardButtonTitle");
    String printButtonText = this.getTheme().getMessage("help.printButtonTitle");
    String contentsText = this.getTheme().getMessage("help.contentsTab");
    String indexText = this.getTheme().getMessage("help.indexTab");
    String searchText = this.getTheme().getMessage("help.searchTab");
    String localizedHelpPath = null;
    private int mastheadImageHeight = -1;
    private int mastheadImageWidth = -1;

    public String getHelpSetPath() {
        FacesContext fc = FacesContext.getCurrentInstance();
        ExternalContext ec = fc.getExternalContext();
        String realPath = ec.getRequestContextPath();
        if (this.helpSetPath != null && this.helpSetPath.length() > 0) {
            realPath = realPath.concat("/").concat(this.helpSetPath).concat("/");
        }
        return realPath;
    }

    public void setHelpSetPath(String path) {
        this.helpSetPath = path;
    }

    public String getJspPath() {
        return this.jspPath;
    }

    public void setJspPath(String path) {
        this.jspPath = path;
    }

    private HelpUtils getHelpUtils() {
        if (this.helpUtils == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
            String requestHelpSetPath = request.getParameter("helpSetPath");
            if (requestHelpSetPath != null) {
                this.setHelpSetPath(requestHelpSetPath);
            }
            this.helpUtils = new HelpUtils(request, this.getHelpSetPath(), this.httpPort);
        }
        return this.helpUtils;
    }

    protected void initTree(Tree tree, ArrayList treeList) {
        HashMap<String, TreeNode> uiNodeMap = new HashMap<String, TreeNode>();
        DefaultMutableTreeNode javaNode = null;
        javax.swing.tree.TreeNode parentJavaNode = null;
        TreeNode uiNode = null;
        TreeNode uiParent = null;
        TreeItem item = null;
        int numUiNodes = -1;
        HashMap<String, String> nodeIDMap = new HashMap<String, String>();
        boolean tocTree = tree.getId().equals(HELP_CONTENTS_TREE_ID);
        int nTreeNodes = treeList.size();
        for (int i = 0; i < nTreeNodes; ++i) {
            javaNode = (DefaultMutableTreeNode)treeList.get(i);
            if (javaNode == null || (item = (TreeItem)javaNode.getUserObject()) == null) continue;
            String jsfId = tocTree ? item.getID().id : "node" + ++numUiNodes;
            String javaNodeId = this.getHelpUtils().getID(javaNode);
            nodeIDMap.put(javaNodeId, jsfId);
            parentJavaNode = javaNode.getParent();
            String parentJavaNodeId = this.getHelpUtils().getID(parentJavaNode);
            String label = item.getName();
            uiNode = new TreeNode();
            uiNode.setTarget(CONTENT_FRAME_NAME);
            uiNode.setId(jsfId);
            uiNode.setText(label);
            String url = this.getHelpUtils().getContentURL(item);
            if (this.getHttpPort() != -1) {
                int portStartIndex = url.indexOf(58, url.indexOf(58) + 1) + 1;
                int portEndIndex = url.indexOf(47, portStartIndex);
                String port = url.substring(portStartIndex, portEndIndex);
                String httpPort = String.valueOf(this.getHttpPort());
                url = url.replaceFirst(port, httpPort);
            }
            uiNode.setUrl(url);
            uiParent = (TreeNode)uiNodeMap.get(nodeIDMap.get(parentJavaNodeId));
            if (uiParent != null) {
                uiParent.getChildren().add(uiNode);
                uiParent.setExpanded(true);
            } else {
                tree.getChildren().add(uiNode);
            }
            uiNodeMap.put(uiNode.getId(), uiNode);
        }
    }

    private void initSearchResultsPanel() {
        this.searchResultsPanel = new PanelGroup();
        this.searchResultsPanel.setId("searchResultsPanel");
    }

    private Theme getTheme() {
        if (this.theme == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            this.theme = ThemeUtilities.getTheme(context);
        }
        return this.theme;
    }

    private void initSearchPanel() {
        this.searchPanel = new PanelGroup();
        this.searchPanel.setId("searchPanel");
        List panelKids = this.searchPanel.getChildren();
        this.searchPanel.setRendered(false);
    }

    public void contentsTabClicked() {
        this.getContentsTree().setRendered(true);
        this.getIndexTree().setRendered(false);
        this.getSearchPanel().setRendered(false);
    }

    public void indexTabClicked() {
        this.getContentsTree().setRendered(false);
        this.getIndexTree().setRendered(true);
        this.getSearchPanel().setRendered(false);
    }

    public void searchTabClicked() {
        this.getContentsTree().setRendered(false);
        this.getIndexTree().setRendered(false);
        this.getSearchPanel().setRendered(true);
    }

    public void doSearch() {
        TextField f = (TextField)this.searchPanel.getChildren().get(0);
        String searchText = ConversionUtilities.convertValueToString((UIComponent)f, f.getValue());
        List resultsKids = this.getSearchResultsPanel().getChildren();
        resultsKids.clear();
        Theme theme = this.getTheme();
        Enumeration searchResults = this.getHelpUtils().doSearch(searchText);
        if (searchResults == null || !searchResults.hasMoreElements()) {
            StaticText text = new StaticText();
            text.setId("noResults");
            text.setStyleClass(theme.getStyleClass("HlpRltDiv"));
            text.setText(theme.getMessage("help.noResultsFound"));
            resultsKids.add(text);
            return;
        }
        int linkId = 0;
        Hyperlink resultLink = null;
        Object markup = null;
        SearchTOCItem item = null;
        while (searchResults.hasMoreElements()) {
            item = (SearchTOCItem)searchResults.nextElement();
            Markup div = new Markup();
            div.setId("div" + linkId);
            div.setTag("div");
            div.setStyle("padding-top:6px; white-space: nowrap");
            resultLink = new Hyperlink();
            resultLink.setId("searchLink" + linkId++);
            resultLink.setUrl(item.getURL().toString());
            resultLink.setText(item.getName());
            resultLink.setTarget(CONTENT_FRAME_NAME);
            resultLink.setStyleClass(theme.getStyleClass("HlpRltDiv"));
            div.getChildren().add(resultLink);
            resultsKids.add(div);
        }
    }

    public Tree getIndexTree() {
        if (this.indexTree == null) {
            this.indexTree = new Tree();
            this.indexTree.setId(HELP_INDEX_TREE_ID);
            this.initTree(this.indexTree, this.getHelpUtils().getIndexTreeList());
            this.indexTree.setRendered(false);
        }
        return this.indexTree;
    }

    public void setIndexTree(Tree tree) {
        this.indexTree = tree;
    }

    public Tree getContentsTree() {
        if (this.contentsTree == null) {
            this.contentsTree = new Tree();
            this.contentsTree.setId(HELP_CONTENTS_TREE_ID);
            this.initTree(this.contentsTree, this.getHelpUtils().getTOCTreeList());
        }
        return this.contentsTree;
    }

    public void setContentsTree(Tree tree) {
        this.contentsTree = tree;
    }

    public PanelGroup getSearchPanel() {
        if (this.searchPanel == null) {
            this.initSearchPanel();
        }
        return this.searchPanel;
    }

    public void setSearchPanel(PanelGroup panel) {
        this.searchPanel = panel;
    }

    public PanelGroup getSearchResultsPanel() {
        if (this.searchResultsPanel == null) {
            this.initSearchResultsPanel();
        }
        return this.searchResultsPanel;
    }

    public void setSearchResultsPanel(PanelGroup panel) {
        this.searchResultsPanel = panel;
    }

    public Hyperlink getTipsLink() {
        if (this.tipsLink == null) {
            this.tipsLink = new Hyperlink();
            this.tipsLink.setId("searchTipsLink");
            this.tipsLink.setText(this.getTheme().getMessage("help.tips"));
            String tipsUrlPrefix = this.getJspPath() != null ? "/".concat(this.getJspPath()) : "";
            this.tipsLink.setUrl(tipsUrlPrefix.concat(TIPS_FILE));
            this.tipsLink.setTarget(CONTENT_FRAME_NAME);
        }
        return this.tipsLink;
    }

    public void setTipsLink(Hyperlink link) {
        this.tipsLink = link;
    }

    public String getTipsTitle() {
        return this.tipsTitle;
    }

    public String getTipsImprove() {
        return this.tipsImprove;
    }

    public String getTipsImprove1() {
        return this.tipsImprove1;
    }

    public String getTipsImprove2() {
        return this.tipsImprove2;
    }

    public String getTipsImprove3() {
        return this.tipsImprove3;
    }

    public String getTipsImprove4() {
        return this.tipsImprove4;
    }

    public String getTipsNote() {
        return this.tipsNote;
    }

    public String getTipsNoteDetails() {
        return this.tipsNoteDetails;
    }

    public String getTipsSearch() {
        return this.tipsSearch;
    }

    public String getTipsSearch1() {
        return this.tipsSearch1;
    }

    public String getTipsSearch2() {
        return this.tipsSearch2;
    }

    public String getTipsSearch3() {
        return this.tipsSearch3;
    }

    public String getTipsSearch4() {
        return this.tipsSearch4;
    }

    public String getBackButtonText() {
        return this.backButtonText;
    }

    public String getForwardButtonText() {
        return this.forwardButtonText;
    }

    public String getPrintButtonText() {
        return this.printButtonText;
    }

    public String getContentsText() {
        return this.contentsText;
    }

    public String getIndexText() {
        return this.indexText;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public String getLocalizedHelpPath() {
        return this.getHelpUtils().getLocalizedHelpPath();
    }

    public void setLocalizedHelpPath(String s) {
        this.localizedHelpPath = s;
    }

    public String getBackButtonIcon() {
        return "HELP_BACK";
    }

    public String getForwardButtonIcon() {
        return "HELP_FORWARD";
    }

    public String getPrintButtonIcon() {
        return "HELP_PRINT";
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int port) {
        this.httpPort = port;
    }

    public int getMastheadImageHeight() {
        int heightRequestParm = this.checkParam("mastheadHeight");
        return heightRequestParm == -1 ? this.mastheadImageHeight : heightRequestParm;
    }

    public void setMastheadImageHeight(int h) {
        this.mastheadImageHeight = h;
    }

    public int getMastheadImageWidth() {
        int widthRequestParm = this.checkParam("mastheadWidth");
        return widthRequestParm == -1 ? this.mastheadImageWidth : widthRequestParm;
    }

    public void setMastheadImageWidth(int w) {
        this.mastheadImageWidth = w;
    }

    private int checkParam(String paramName) {
        block3: {
            FacesContext context = FacesContext.getCurrentInstance();
            Map parms = context.getExternalContext().getRequestParameterMap();
            String paramValue = (String)parms.get(paramName);
            try {
                if (paramValue != null && Integer.parseInt(paramValue) != -1) {
                    return Integer.parseInt(paramValue);
                }
            }
            catch (NumberFormatException nfe) {
                if (!LogUtil.infoEnabled()) break block3;
                LogUtil.info((Object)HelpBackingBean.class, "WEBUI0007", new String[]{paramName});
            }
        }
        return -1;
    }
}

