/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainercommon.descriptor;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentDescriptorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

public class SecurityConstraintDescriptor {
    public static final String PORTLET_COLLECTION = "portlet-collection";
    public static final String USER_DATA_CONSTRAINT = "user-data-constraint";
    public static final String TRANSPORT_GUARANTEE = "transport-guarantee";
    public static final String CONFIDENTIAL = "CONFIDENTIAL";
    public static final String INTEGRAL = "INTEGRAL";
    public static final String NONE = "NONE";
    private List _displayNames = new ArrayList();
    private Map _displayNameMap = new HashMap();
    private List _portletNames = new ArrayList();
    private List _constraintDescs = new ArrayList();
    private String _transGuaranteeType = "NONE";
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$portletcontainercommon$descriptor$SecurityConstraintDescriptor == null ? (class$com$sun$portal$portletcontainercommon$descriptor$SecurityConstraintDescriptor = SecurityConstraintDescriptor.class$("com.sun.portal.portletcontainercommon.descriptor.SecurityConstraintDescriptor")) : class$com$sun$portal$portletcontainercommon$descriptor$SecurityConstraintDescriptor));
    static /* synthetic */ Class class$com$sun$portal$portletcontainercommon$descriptor$SecurityConstraintDescriptor;

    public SecurityConstraintDescriptor(Logger logger) {
    }

    public void load(Element element, Namespace namespace) throws DeploymentDescriptorException {
        List displayNameElements = element.getChildren("display-name", namespace);
        Iterator i = displayNameElements.iterator();
        while (i.hasNext()) {
            Element displayNameElement = (Element)i.next();
            this._displayNames.add(displayNameElement.getTextTrim());
            List attrList = displayNameElement.getAttributes();
            Iterator it = attrList.iterator();
            while (it.hasNext()) {
                Attribute attr = (Attribute)it.next();
                if (!attr.getName().equals("lang")) continue;
                this._displayNameMap.put(attr.getValue(), displayNameElement.getTextTrim());
            }
        }
        List portletCollectionElements = element.getChildren(PORTLET_COLLECTION, namespace);
        Iterator i2 = portletCollectionElements.iterator();
        while (i2.hasNext()) {
            Element portletCollectionElement = (Element)i2.next();
            List portletNameElements = portletCollectionElement.getChildren("portlet-name", namespace);
            Iterator j = portletNameElements.iterator();
            while (j.hasNext()) {
                Element portletNameElement = (Element)j.next();
                String portletName = portletNameElement.getTextTrim();
                this._portletNames.add(portletName);
            }
        }
        Element constraintElement = element.getChild(USER_DATA_CONSTRAINT, namespace);
        if (constraintElement == null) {
            debugLogger.warning("PSPL_PCCCSPPCCD0013");
        } else {
            this._transGuaranteeType = constraintElement.getChildTextTrim(TRANSPORT_GUARANTEE, namespace);
            List descriptionElements = element.getChildren("description", namespace);
            Iterator i3 = descriptionElements.iterator();
            while (i3.hasNext()) {
                Element descriptionElement = (Element)i3.next();
                this._constraintDescs.add(descriptionElement.getTextTrim());
            }
        }
    }

    public List getConstrainedPortlets() {
        return this._portletNames;
    }

    public String getTransportGuaranteeType() {
        return this._transGuaranteeType;
    }

    public List getDisplayNames() {
        return this._displayNames;
    }

    public Map getDisplayNameMap() {
        return this._displayNameMap;
    }

    public List getConstraintDescriptions() {
        return this._constraintDescs;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PortletDescriptor ");
        sb.append(" display names [");
        Iterator iterator = this._displayNames.iterator();
        while (iterator.hasNext()) {
            sb.append((String)iterator.next());
        }
        sb.append(" ]");
        sb.append(" constrained portlet names [");
        Iterator iterator1 = this._portletNames.iterator();
        while (iterator1.hasNext()) {
            sb.append((String)iterator1.next());
        }
        sb.append(" ]");
        if (this._transGuaranteeType != null) {
            sb.append(" transport guarantee type [");
            sb.append(this._transGuaranteeType);
            sb.append(" ]");
            sb.append(" constrained portlet names [");
            Iterator iterator2 = this._constraintDescs.iterator();
            while (iterator2.hasNext()) {
                sb.append((String)iterator2.next());
            }
            sb.append(" ]");
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

