/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainercommon.descriptor;

import com.sun.portal.log.common.PortalLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;
import org.jdom.Namespace;

public class PreferenceDescriptor {
    public static final String PREF_NAME = "name";
    public static final String PREF_VALUE = "value";
    public static final String READ_ONLY = "read-only";
    public static final String MULTI_VALUE = "multi-value";
    private String _prefName;
    private List _prefValues = new ArrayList();
    private List _descriptions = new ArrayList();
    private boolean _readOnly = false;
    private boolean _multiValue = false;
    private String _portletName;
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$portletcontainercommon$descriptor$PreferenceDescriptor == null ? (class$com$sun$portal$portletcontainercommon$descriptor$PreferenceDescriptor = PreferenceDescriptor.class$("com.sun.portal.portletcontainercommon.descriptor.PreferenceDescriptor")) : class$com$sun$portal$portletcontainercommon$descriptor$PreferenceDescriptor));
    static /* synthetic */ Class class$com$sun$portal$portletcontainercommon$descriptor$PreferenceDescriptor;

    public PreferenceDescriptor(Logger logger, String portletName) {
        this._portletName = portletName;
    }

    public void load(Element element, Namespace namespace) {
        Element multiValueElement;
        List prefValueElements;
        this._prefName = element.getChildTextTrim(PREF_NAME, namespace);
        if (this._prefName == null) {
            debugLogger.log(Level.WARNING, "PSPL_PCCCSPPCCD0011", this._portletName);
        }
        if ((prefValueElements = element.getChildren(PREF_VALUE, namespace)).isEmpty()) {
            debugLogger.log(Level.WARNING, "PSPL_PCCCSPPCCD0012", this._prefName);
        } else {
            Iterator i = prefValueElements.iterator();
            while (i.hasNext()) {
                Element prefValueElement = (Element)i.next();
                this._prefValues.add(prefValueElement.getTextTrim());
            }
        }
        List descriptionElements = element.getChildren("description", namespace);
        Iterator i = descriptionElements.iterator();
        while (i.hasNext()) {
            Element descriptionElement = (Element)i.next();
            this._descriptions.add(descriptionElement.getTextTrim());
        }
        String readOnly = element.getChildTextTrim(READ_ONLY, namespace);
        if (readOnly != null && readOnly.equals("true")) {
            this._readOnly = true;
        }
        if ((multiValueElement = element.getChild(MULTI_VALUE, namespace)) != null) {
            this._multiValue = true;
        }
    }

    public String getPrefName() {
        return this._prefName;
    }

    public List getPrefValues() {
        return this._prefValues;
    }

    public String getDescription() {
        String description = null;
        if (!this._descriptions.isEmpty()) {
            description = (String)this._descriptions.get(0);
        }
        return description;
    }

    public List getDescriptions() {
        return this._descriptions;
    }

    public boolean getReadOnly() {
        return this._readOnly;
    }

    public boolean getMultiValueFlag() {
        return this._multiValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PreferenceDescriptor [");
        sb.append(" preference name [");
        if (this._prefName != null) {
            sb.append(this._prefName);
        } else {
            sb.append("NULL");
        }
        sb.append("]");
        sb.append(" preference values [");
        Iterator iterator = this._prefValues.iterator();
        while (iterator.hasNext()) {
            sb.append((String)iterator.next());
        }
        sb.append("]");
        sb.append(" description [");
        if (!this._descriptions.isEmpty()) {
            sb.append((String)this._descriptions.get(0));
        } else {
            sb.append("NULL");
        }
        sb.append("]");
        sb.append(" read-only [");
        if (this._readOnly) {
            sb.append("fase");
        } else {
            sb.append("true");
        }
        sb.append("]");
        sb.append("]");
        sb.append("\n");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

