/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainercommon.descriptor;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.portletcontainercommon.descriptor.PreferenceDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;
import org.jdom.Namespace;

public class PortletPreferencesDescriptor {
    public static final String PREFERENCE = "preference";
    public static final String PREFERENCES_VALIDATOR = "preferences-validator";
    private List _preferenceDescriptors = new ArrayList();
    private String _portletName;
    private String _validatorName;
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$portletcontainercommon$descriptor$PortletPreferencesDescriptor == null ? (class$com$sun$portal$portletcontainercommon$descriptor$PortletPreferencesDescriptor = PortletPreferencesDescriptor.class$("com.sun.portal.portletcontainercommon.descriptor.PortletPreferencesDescriptor")) : class$com$sun$portal$portletcontainercommon$descriptor$PortletPreferencesDescriptor));
    static /* synthetic */ Class class$com$sun$portal$portletcontainercommon$descriptor$PortletPreferencesDescriptor;

    public PortletPreferencesDescriptor(Logger logger, String portletName) {
        this._portletName = portletName;
    }

    public void load(Element element, Namespace namespace) {
        List preferenceElements = element.getChildren(PREFERENCE, namespace);
        if (preferenceElements.isEmpty()) {
            debugLogger.log(Level.WARNING, "PSPL_PCCCSPPCCD0014", this._portletName);
        }
        Iterator iterator = preferenceElements.iterator();
        while (iterator.hasNext()) {
            Element preferenceElement = (Element)iterator.next();
            PreferenceDescriptor preferenceDescriptor = new PreferenceDescriptor(debugLogger, this._portletName);
            preferenceDescriptor.load(preferenceElement, namespace);
            this._preferenceDescriptors.add(preferenceDescriptor);
        }
        this._validatorName = element.getChildTextTrim(PREFERENCES_VALIDATOR, namespace);
    }

    public List getPreferenceDescriptors() {
        return this._preferenceDescriptors;
    }

    public PreferenceDescriptor getPreferenceDescriptor(String preferenceName) {
        PreferenceDescriptor preference = null;
        boolean stop = false;
        Iterator iterator = this._preferenceDescriptors.iterator();
        while (iterator.hasNext() && !stop) {
            PreferenceDescriptor preferenceDescriptor = (PreferenceDescriptor)iterator.next();
            if (!preferenceDescriptor.getPrefName().equals(preferenceName)) continue;
            preference = preferenceDescriptor;
            stop = true;
        }
        return preference;
    }

    public String getPreferencesValidatorName() {
        return this._validatorName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PortletPreferencesDescriptor [");
        Iterator iterator = this._preferenceDescriptors.iterator();
        while (iterator.hasNext()) {
            PreferenceDescriptor preferenceDescriptor = (PreferenceDescriptor)iterator.next();
            sb.append(preferenceDescriptor.toString());
        }
        if (this._validatorName != null) {
            sb.append(" preferences validator name [");
            sb.append(this._validatorName);
            sb.append("] ");
        }
        sb.append("]");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

