/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainercommon.descriptor;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentDescriptorException;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentExtensionDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.InitParamDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletInfoDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletPreferencesDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.SecurityRoleRefDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.SupportsDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

public class PortletDescriptor {
    public static final String PORTLET = "portlet";
    public static final String PORTLET_NAME = "portlet-name";
    public static final String PORTLET_CLASS = "portlet-class";
    public static final String PORTLET_PREFERENCES = "portlet-preferences";
    public static final String INIT_PARAM = "init-param";
    public static final String SUPPORTED_LOCALE = "supported-locale";
    public static final String EXPIRATION_CACHE = "expiration-cache";
    public static final String PORTLET_INFO = "portlet-info";
    public static final String SUPPORTS = "supports";
    public static final String SECURITY_ROLE_REF = "security-role-ref";
    public static final String DEPLOYMENT_EXTENSION = "deployment-extension";
    public static final String RESOURCE_BUNDLE = "resource-bundle";
    public static final int EXPIRATION_CACHE_NOT_DEFINED = -999;
    private String _portletName;
    private String _portletClassName;
    private String _resourceBundle;
    private List _descriptions = new ArrayList();
    private List _displayNames = new ArrayList();
    private Map _descriptionMap = new HashMap();
    private Map _displayNameMap = new HashMap();
    private List _supportedLocales = new ArrayList();
    private PortletPreferencesDescriptor _pPreferencesDescriptor;
    private List _initParamDescriptors = new ArrayList();
    private List _supportsDescriptors = new ArrayList();
    private String _cacheExpiration;
    private PortletInfoDescriptor _infoDescriptor;
    private List _secRoleRefDescriptors = new ArrayList();
    private DeploymentExtensionDescriptor _depExtDescriptor;
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$portletcontainercommon$descriptor$PortletDescriptor == null ? (class$com$sun$portal$portletcontainercommon$descriptor$PortletDescriptor = PortletDescriptor.class$("com.sun.portal.portletcontainercommon.descriptor.PortletDescriptor")) : class$com$sun$portal$portletcontainercommon$descriptor$PortletDescriptor));
    static /* synthetic */ Class class$com$sun$portal$portletcontainercommon$descriptor$PortletDescriptor;

    public PortletDescriptor(Logger logger, DeploymentExtensionDescriptor depExtDescriptor) {
        this._depExtDescriptor = depExtDescriptor;
    }

    public void load(Element element, Namespace namespace) throws DeploymentDescriptorException {
        this._portletName = element.getChildTextTrim(PORTLET_NAME, namespace);
        this._portletClassName = element.getChildTextTrim(PORTLET_CLASS, namespace);
        if (this._portletName == null) {
            debugLogger.warning("PSPL_PCCCSPPCCD0005");
        }
        if (this._portletClassName == null) {
            debugLogger.warning("PSPL_PCCCSPPCCD0006");
        }
        List descriptionElements = element.getChildren("description", namespace);
        Iterator i = descriptionElements.iterator();
        while (i.hasNext()) {
            Element descriptionElement = (Element)i.next();
            this._descriptions.add(descriptionElement.getTextTrim());
            List descList = descriptionElement.getAttributes();
            Iterator dit = descList.iterator();
            while (dit.hasNext()) {
                Attribute dAttr = (Attribute)dit.next();
                if (!dAttr.getName().equals("lang")) continue;
                this._descriptionMap.put(dAttr.getValue(), descriptionElement.getTextTrim());
            }
        }
        List displayNameElements = element.getChildren("display-name", namespace);
        Iterator i2 = displayNameElements.iterator();
        while (i2.hasNext()) {
            Element displayNameElement = (Element)i2.next();
            this._displayNames.add(displayNameElement.getTextTrim());
            List attrList = displayNameElement.getAttributes();
            Iterator it = attrList.iterator();
            while (it.hasNext()) {
                Attribute attr = (Attribute)it.next();
                if (!attr.getName().equals("lang")) continue;
                debugLogger.log(Level.SEVERE, "PSPL_PCCCSPPCCD0007", new Object[]{attr.getName(), attr.getValue()});
                this._displayNameMap.put(attr.getValue(), displayNameElement.getTextTrim());
            }
        }
        List supportedLocaleElements = element.getChildren(SUPPORTED_LOCALE, namespace);
        Iterator i3 = supportedLocaleElements.iterator();
        while (i3.hasNext()) {
            Element supportedLocaleElement = (Element)i3.next();
            this._supportedLocales.add(supportedLocaleElement.getTextTrim());
        }
        List supportsElements = element.getChildren(SUPPORTS, namespace);
        if (supportsElements.isEmpty()) {
            debugLogger.warning("PSPL_PCCCSPPCCD0008");
        } else {
            Iterator i4 = supportsElements.iterator();
            while (i4.hasNext()) {
                Element supportsElement = (Element)i4.next();
                SupportsDescriptor supportsDescriptor = new SupportsDescriptor();
                supportsDescriptor.load(supportsElement, namespace);
                this._supportsDescriptors.add(supportsDescriptor);
            }
        }
        Element pPreferencesElement = element.getChild(PORTLET_PREFERENCES, namespace);
        if (pPreferencesElement != null) {
            this._pPreferencesDescriptor = new PortletPreferencesDescriptor(debugLogger, this._portletName);
            this._pPreferencesDescriptor.load(pPreferencesElement, namespace);
        }
        List initParamElements = element.getChildren(INIT_PARAM, namespace);
        Iterator i5 = initParamElements.iterator();
        while (i5.hasNext()) {
            Element initParamElement = (Element)i5.next();
            InitParamDescriptor initParamDescriptor = new InitParamDescriptor();
            initParamDescriptor.load(initParamElement, namespace);
            this._initParamDescriptors.add(initParamDescriptor);
        }
        this._cacheExpiration = element.getChildTextTrim(EXPIRATION_CACHE, namespace);
        Element infoElement = element.getChild(PORTLET_INFO, namespace);
        if (infoElement != null) {
            this._infoDescriptor = new PortletInfoDescriptor(debugLogger);
            this._infoDescriptor.load(infoElement, namespace);
        }
        List secRoleElements = element.getChildren(SECURITY_ROLE_REF, namespace);
        for (int i6 = 0; i6 < secRoleElements.size(); ++i6) {
            Element secRoleElement = (Element)secRoleElements.get(i6);
            SecurityRoleRefDescriptor secRoleRefDescriptor = new SecurityRoleRefDescriptor(debugLogger);
            secRoleRefDescriptor.load(secRoleElement, namespace);
            this._secRoleRefDescriptors.add(secRoleRefDescriptor);
        }
        this._resourceBundle = element.getChildTextTrim(RESOURCE_BUNDLE, namespace);
    }

    public String getPortletName() {
        return this._portletName;
    }

    public String getClassName() {
        return this._portletClassName;
    }

    public String getDescription() {
        String description = null;
        if (!this._descriptions.isEmpty()) {
            description = (String)this._descriptions.get(0);
        }
        return description;
    }

    public List getDescriptions() {
        return this._descriptions;
    }

    public Map getDescriptionMap() {
        return this._descriptionMap;
    }

    public List getDisplayNames() {
        return this._displayNames;
    }

    public Map getDisplayNameMap() {
        return this._displayNameMap;
    }

    public List getSupportedLocales() {
        return this._supportedLocales;
    }

    public PortletPreferencesDescriptor getPortletPreferencesDescriptor() {
        return this._pPreferencesDescriptor;
    }

    public List getInitParamDescriptors() {
        return this._initParamDescriptors;
    }

    public List getSupportsDescriptors() {
        return this._supportsDescriptors;
    }

    public List getSupportedMimeTypes() {
        ArrayList<String> mimeTypeList = new ArrayList<String>();
        Iterator iterator = this._supportsDescriptors.iterator();
        while (iterator.hasNext()) {
            SupportsDescriptor supportsDescriptor = (SupportsDescriptor)iterator.next();
            mimeTypeList.add(supportsDescriptor.getMimeType());
        }
        return mimeTypeList;
    }

    public List getSupportedPortletModes(String mime) {
        List supportList = null;
        boolean stop = false;
        Iterator iterator = this._supportsDescriptors.iterator();
        while (iterator.hasNext() && !stop) {
            SupportsDescriptor supportsDescriptor = (SupportsDescriptor)iterator.next();
            String mimeType = supportsDescriptor.getMimeType();
            if (mimeType.toLowerCase().equals("*/*")) {
                supportList = supportsDescriptor.getPortletModes();
                stop = true;
                continue;
            }
            if (mimeType.toLowerCase().equals("text/*") && mime.toLowerCase().startsWith("text/")) {
                supportList = supportsDescriptor.getPortletModes();
                stop = true;
                continue;
            }
            if (!supportsDescriptor.getMimeType().equals(mime)) continue;
            supportList = supportsDescriptor.getPortletModes();
            stop = true;
        }
        return supportList;
    }

    public int getCacheExpiration() {
        int retValue = -999;
        if (this._cacheExpiration != null) {
            try {
                retValue = Integer.parseInt(this._cacheExpiration);
            }
            catch (NumberFormatException ne) {
                debugLogger.log(Level.WARNING, "PSPL_PCCCSPPCCD0009", this._portletName);
            }
        }
        return retValue;
    }

    public PortletInfoDescriptor getPortletInfoDescriptor() {
        return this._infoDescriptor;
    }

    public List getSecurityRoleRefDescriptors() {
        return this._secRoleRefDescriptors;
    }

    public boolean sessionEnabled() {
        boolean sessionEnabled = true;
        if (this._depExtDescriptor != null) {
            sessionEnabled = this._depExtDescriptor.sessionEnabled(this.getPortletName());
        }
        return sessionEnabled;
    }

    public LinkedHashMap getGeneratedEvents() {
        return this._depExtDescriptor.getGeneratedEvents();
    }

    public LinkedHashMap getConsumeEvents() {
        return this._depExtDescriptor.getConsumeEvents();
    }

    public String getResourceBundle() {
        return this._resourceBundle;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PortletDescriptor ");
        sb.append(" portlet name [");
        if (this._portletName != null) {
            sb.append(this._portletName);
        } else {
            sb.append("NULL");
        }
        sb.append("]");
        sb.append(" portlet class [");
        if (this._portletClassName != null) {
            sb.append(this._portletClassName);
        } else {
            sb.append("NULL");
        }
        sb.append("]");
        sb.append(" portlet descriptions [");
        Iterator iterator0 = this._descriptions.iterator();
        while (iterator0.hasNext()) {
            sb.append((String)iterator0.next());
        }
        sb.append(" ]");
        sb.append(" portlet display names [");
        Iterator iterator3 = this._displayNames.iterator();
        while (iterator3.hasNext()) {
            sb.append((String)iterator3.next());
        }
        sb.append(" ]");
        sb.append(" portlet supported locales [");
        Iterator iterator5 = this._supportedLocales.iterator();
        while (iterator5.hasNext()) {
            sb.append((String)iterator5.next());
        }
        sb.append(" ]");
        Iterator iterator = this._initParamDescriptors.iterator();
        while (iterator.hasNext()) {
            InitParamDescriptor initParamDescriptor = (InitParamDescriptor)iterator.next();
            sb.append(initParamDescriptor.toString());
            sb.append("\n");
        }
        Iterator iterator1 = this._supportsDescriptors.iterator();
        while (iterator1.hasNext()) {
            SupportsDescriptor supportsDescriptor = (SupportsDescriptor)iterator1.next();
            sb.append(supportsDescriptor.toString());
            sb.append("\n");
        }
        if (this._cacheExpiration != null) {
            sb.append(this._cacheExpiration);
        }
        if (this._infoDescriptor != null) {
            sb.append(this._infoDescriptor.toString());
        }
        if (this._pPreferencesDescriptor != null) {
            sb.append(this._pPreferencesDescriptor.toString());
        }
        Iterator iterator2 = this._secRoleRefDescriptors.iterator();
        while (iterator2.hasNext()) {
            SecurityRoleRefDescriptor secRoleRefDescriptor = (SecurityRoleRefDescriptor)iterator2.next();
            sb.append(secRoleRefDescriptor.toString());
            sb.append("\n");
        }
        sb.append("deployment extension descriptor: [" + this._depExtDescriptor);
        if (this._depExtDescriptor != null) {
            this._depExtDescriptor.toString();
        }
        sb.append(" ]");
        if (this._resourceBundle != null) {
            sb.append(" resource bundle [");
            sb.append(this._resourceBundle);
            sb.append("]");
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

