/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainercommon.descriptor;

import com.sun.portal.portletcontainercommon.descriptor.DeploymentDescriptorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jdom.Element;
import org.jdom.Namespace;

public class DeploymentExtensionDescriptor {
    public static final String SAVE_PREFERENCES_IN_RENDER_PERMISSION = "save-preferences-in-render-permission";
    public static final String EXTENSION_ELEMENT = "extension-element";
    public static final String DEPLOYMENT_EXTENSION = "deployment-extension";
    public static final String SESSION_ENABLED = "session-enabled";
    public static final String EVENTS = "events";
    public static final String GENERATES_EVENTS = "generates-event";
    public static final String CONSUMES_EVENTS = "consumes-event";
    public static final String LISTENER = "listener";
    public static final String LISTENER_CLASS = "listener-class";
    public static final String PROVISION = "provision";
    public static final String MEMBERSHIP = "membership";
    private List _sessionDisabledList = new ArrayList();
    private boolean _savePerferencesPermission = false;
    private Map _extensionProvisionListenerMap = new HashMap();
    private Map _extensionMembershipListenerMap = new HashMap();
    private LinkedHashMap genMap = new LinkedHashMap();
    private LinkedHashMap conMap = new LinkedHashMap();

    public DeploymentExtensionDescriptor(Logger logger) {
    }

    public void load(Element element, Namespace namespace) throws DeploymentDescriptorException {
        Element membershipElement;
        String permission = element.getChildTextTrim(SAVE_PREFERENCES_IN_RENDER_PERMISSION, namespace);
        if (permission != null && permission.equals("1")) {
            this._savePerferencesPermission = true;
        }
        List portletElements = element.getChildren("portlet", namespace);
        Iterator iterator = portletElements.iterator();
        while (iterator.hasNext()) {
            Element portletElement = (Element)iterator.next();
            String portletName = portletElement.getChildTextTrim("portlet-name", namespace);
            List depExtElements = portletElement.getChildren(DEPLOYMENT_EXTENSION, namespace);
            if (!depExtElements.isEmpty()) {
                Iterator iterator1 = depExtElements.iterator();
                while (iterator1.hasNext()) {
                    Element depExtElement = (Element)iterator1.next();
                    List extensionElements = depExtElement.getChildren(EXTENSION_ELEMENT, namespace);
                    String sessionEnabled = null;
                    boolean stop = false;
                    Iterator itor = extensionElements.iterator();
                    while (itor.hasNext() && !stop) {
                        Element extensionElement = (Element)itor.next();
                        sessionEnabled = extensionElement.getChildTextTrim(SESSION_ENABLED, namespace);
                        if (sessionEnabled == null) continue;
                        stop = true;
                    }
                    if (sessionEnabled == null || !sessionEnabled.equals("0")) continue;
                    this._sessionDisabledList.add(portletName);
                }
            }
            ArrayList<String> consumesEvents = new ArrayList<String>();
            ArrayList<String> generatesEvents = new ArrayList<String>();
            List evtElements = portletElement.getChildren(EVENTS, namespace);
            if (!evtElements.isEmpty()) {
                Iterator itEvt = evtElements.iterator();
                while (itEvt.hasNext()) {
                    List conEvtElements;
                    Element evt = (Element)itEvt.next();
                    List genEvtElements = evt.getChildren(GENERATES_EVENTS, namespace);
                    if (genEvtElements != null) {
                        Iterator i = genEvtElements.iterator();
                        while (i.hasNext()) {
                            Element evtElement = (Element)i.next();
                            generatesEvents.add(evtElement.getTextTrim());
                        }
                    }
                    if ((conEvtElements = evt.getChildren(CONSUMES_EVENTS, namespace)) == null) continue;
                    Iterator i = conEvtElements.iterator();
                    while (i.hasNext()) {
                        Element evtElement = (Element)i.next();
                        consumesEvents.add(evtElement.getTextTrim());
                    }
                }
            }
            this.genMap.put(portletName, generatesEvents);
            this.conMap.put(portletName, consumesEvents);
        }
        Element provisionElement = element.getChild(PROVISION, namespace);
        if (provisionElement != null) {
            List listenerElements = provisionElement.getChildren(LISTENER, namespace);
            Iterator listenerElementsIter = listenerElements.iterator();
            while (listenerElementsIter.hasNext()) {
                Element listenerElement = (Element)listenerElementsIter.next();
                String portletName = listenerElement.getChildTextTrim("portlet-name", namespace);
                ArrayList<String> listeners = (ArrayList<String>)this._extensionProvisionListenerMap.get(portletName);
                if (listeners == null) {
                    listeners = new ArrayList<String>();
                }
                listeners.add(listenerElement.getChildTextTrim(LISTENER_CLASS, namespace));
                this._extensionProvisionListenerMap.put(portletName, listeners);
            }
        }
        if ((membershipElement = element.getChild(MEMBERSHIP, namespace)) != null) {
            List listenerElements = membershipElement.getChildren(LISTENER, namespace);
            Iterator listenerElementsIter = listenerElements.iterator();
            while (listenerElementsIter.hasNext()) {
                Element listenerElement = (Element)listenerElementsIter.next();
                String portletName = listenerElement.getChildTextTrim("portlet-name", namespace);
                ArrayList<String> listeners = (ArrayList<String>)this._extensionMembershipListenerMap.get(portletName);
                if (listeners == null) {
                    listeners = new ArrayList<String>();
                }
                listeners.add(listenerElement.getChildTextTrim(LISTENER_CLASS, namespace));
                this._extensionMembershipListenerMap.put(portletName, listeners);
            }
        }
    }

    public LinkedHashMap getGeneratedEvents() {
        return this.genMap;
    }

    public LinkedHashMap getConsumeEvents() {
        return this.conMap;
    }

    public boolean sessionEnabled(String portletName) {
        boolean sessionEnabled = true;
        if (this._sessionDisabledList.contains(portletName)) {
            sessionEnabled = false;
        }
        return sessionEnabled;
    }

    public boolean isSavePreferencesAllowed() {
        return this._savePerferencesPermission;
    }

    public Map getProvisionListenerMap() {
        return this._extensionProvisionListenerMap;
    }

    public Map getMembershipListenerMap() {
        return this._extensionMembershipListenerMap;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DeploymentExtensionDescriptor ");
        Iterator iterator = this._sessionDisabledList.iterator();
        sb.append("[ portlets without session: ");
        while (iterator.hasNext()) {
            sb.append((String)iterator.next()).append(", ");
        }
        sb.append("]");
        sb.append("[ save preferences is allowed: ");
        sb.append(this._savePerferencesPermission);
        sb.append(" ]");
        sb.append("\n");
        sb.append("[ ProvisionListenerMap:");
        sb.append(this.getProvisionListenerMap());
        sb.append(" ]");
        sb.append("\n");
        sb.append("[ MembershipListenerMap:");
        sb.append(this.getMembershipListenerMap());
        sb.append(" ]");
        return sb.toString();
    }
}

