/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainercommon.descriptor;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentDescriptorException;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentExtensionDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletAppDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class DeploymentDescriptorReader {
    public static String PORTLET_SCHEMA_LOCATION = "DDSchemaLocation";
    public static String PORTLET_SCHEMA_FILE = "/portlet.xsd";
    public static String SUN_PORTLET_SCHEMA_FILE = "/sun-portlet.xsd";
    public static String PORTLET_NAMESPACE = "http://java.sun.com/xml/ns/portlet/portlet-app_1_0.xsd";
    public static String SUN_PORTAL_NAMESPACE = "http://www.sun.com/software/xml/ns/portal_server";
    public static String BUILDER_SAX_PARSER = "org.apache.xerces.parsers.SAXParser";
    public static String BUILDER_SAX_PARSER_SUN_INTERNAL = "com.sun.org.apache.xerces.internal.parsers.SAXParser";
    public static String BUILDER_VALIDATION_SCHEMA_FEATURE = "http://apache.org/xml/features/validation/schema";
    public static String BUILDER_SCHEMA_LOC_PROPERTY = "http://apache.org/xml/properties/schema/external-schemaLocation";
    public static final String VALIDATE_SCHEMA = "validate_schema";
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$portletcontainercommon$descriptor$DeploymentDescriptorReader == null ? (class$com$sun$portal$portletcontainercommon$descriptor$DeploymentDescriptorReader = DeploymentDescriptorReader.class$("com.sun.portal.portletcontainercommon.descriptor.DeploymentDescriptorReader")) : class$com$sun$portal$portletcontainercommon$descriptor$DeploymentDescriptorReader));
    private String _portletSchemaLocation;
    static /* synthetic */ Class class$com$sun$portal$portletcontainercommon$descriptor$DeploymentDescriptorReader;

    public DeploymentDescriptorReader(Logger logger, String schemaLocation) {
        this._portletSchemaLocation = schemaLocation;
        debugLogger.log(Level.INFO, "PSPL_PCCCSPPCCD0001", schemaLocation);
    }

    private Element readDeploymentDescriptor(InputStream portletStream, String schemaLocation) throws DeploymentDescriptorException {
        SAXBuilder builder = null;
        String validateString = System.getProperty(VALIDATE_SCHEMA);
        if (validateString != null && validateString.equalsIgnoreCase("true")) {
            String parser = BUILDER_SAX_PARSER_SUN_INTERNAL;
            if (!this.isParserAvailable(parser)) {
                parser = BUILDER_SAX_PARSER;
            }
            builder = new SAXBuilder(parser, true);
            builder.setFeature(BUILDER_VALIDATION_SCHEMA_FEATURE, true);
            builder.setProperty(BUILDER_SCHEMA_LOC_PROPERTY, (Object)schemaLocation);
            debugLogger.log(Level.INFO, "PSPL_PCCCSPPCCD0002", validateString);
        } else {
            builder = new SAXBuilder();
        }
        Element element = null;
        try {
            Document doc = builder.build(portletStream);
            element = doc.getRootElement();
        }
        catch (IOException e) {
            throw new DeploymentDescriptorException("error reading stream", e);
        }
        catch (JDOMException je) {
            debugLogger.log(Level.SEVERE, "PSPL_PCCCSPPCCD0003", je);
            throw new DeploymentDescriptorException("Can not read deployment descriptor", je);
        }
        debugLogger.log(Level.INFO, "PSPL_PCCCSPPCCD0004", element);
        return element;
    }

    private boolean isParserAvailable(String parser) {
        boolean result = true;
        try {
            Class.forName(parser);
        }
        catch (ClassNotFoundException e) {
            result = false;
        }
        return result;
    }

    public PortletAppDescriptor loadPortletAppDescriptor(InputStream portletStream, InputStream extStream) throws DeploymentDescriptorException {
        Element root;
        PortletAppDescriptor appDescriptor = null;
        if (portletStream != null && (root = this.readDeploymentDescriptor(portletStream, PORTLET_NAMESPACE + " " + this._portletSchemaLocation + PORTLET_SCHEMA_FILE)) != null) {
            Namespace namespace = Namespace.getNamespace((String)PORTLET_NAMESPACE);
            appDescriptor = new PortletAppDescriptor(debugLogger, extStream);
            appDescriptor.load(root, namespace, this);
        }
        return appDescriptor;
    }

    public DeploymentExtensionDescriptor loadDeploymentExtensionDescriptor(InputStream extStream) throws DeploymentDescriptorException {
        Element root;
        DeploymentExtensionDescriptor exDescriptor = null;
        if (extStream != null && (root = this.readDeploymentDescriptor(extStream, SUN_PORTAL_NAMESPACE + " " + this._portletSchemaLocation + SUN_PORTLET_SCHEMA_FILE)) != null) {
            Namespace namespace = Namespace.getNamespace((String)SUN_PORTAL_NAMESPACE);
            exDescriptor = new DeploymentExtensionDescriptor(debugLogger);
            exDescriptor.load(root, namespace);
        }
        return exDescriptor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

