/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainercommon;

import java.util.ArrayList;
import java.util.List;

public class PortletPreferencesUtility {
    private static String ARRAY_DELIMITER = "|";
    private static int ARRAY_DELIMITER_LENGTH = 1;
    private static final String NULL_STRING = "@@$$NULL_STRING$$@@";

    public static String getPreferenceString(List prefs) {
        if (prefs != null) {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < prefs.size(); ++i) {
                sb.append(ARRAY_DELIMITER);
                String pref = (String)prefs.get(i);
                if (pref == null) {
                    pref = NULL_STRING;
                }
                sb.append(pref);
            }
            return sb.toString();
        }
        return null;
    }

    public static String getPreferenceString(String[] prefs) {
        if (prefs != null) {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < prefs.length; ++i) {
                sb.append(ARRAY_DELIMITER);
                String pref = prefs[i];
                if (pref == null) {
                    pref = NULL_STRING;
                }
                sb.append(pref);
            }
            return sb.toString();
        }
        return null;
    }

    public static List getPreferenceValues(String pref) {
        ArrayList<String> prefArray = new ArrayList<String>();
        String value = null;
        int end = 0;
        if (pref == null || pref.length() == 0) {
            return prefArray;
        }
        if (!pref.startsWith(ARRAY_DELIMITER)) {
            end = pref.indexOf(ARRAY_DELIMITER);
            if (end != -1) {
                value = pref.substring(0, end);
                if (value.equals(NULL_STRING)) {
                    value = null;
                }
                prefArray.add(value);
            } else if (pref.equals(NULL_STRING)) {
                prefArray.add(null);
            } else {
                prefArray.add(pref);
            }
        }
        while (end != -1) {
            int start = end;
            if ((end = pref.indexOf(ARRAY_DELIMITER, start + ARRAY_DELIMITER_LENGTH)) != -1) {
                value = pref.substring(start + ARRAY_DELIMITER_LENGTH, end);
                if (value.equals(NULL_STRING)) {
                    value = null;
                }
                prefArray.add(value);
                continue;
            }
            if (!pref.endsWith(ARRAY_DELIMITER)) {
                value = pref.substring(start + ARRAY_DELIMITER_LENGTH);
                if (value.equals(NULL_STRING)) {
                    value = null;
                }
                prefArray.add(value);
                continue;
            }
            prefArray.add("");
        }
        return prefArray;
    }
}

