/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.util.os;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.fabric.util.os.OSTasksImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class UnixTasks
extends OSTasksImpl {
    private String finalPatchList = null;
    private static final String CRONTAB = "/usr/bin/crontab";

    public UnixTasks(PSConfigContext globalContext, Logger logger) {
        super(globalContext, logger);
    }

    public void schedule() {
        String event = this.getValue("Minute") + " " + this.getValue("Hour") + " * * " + this.getValue("DayOfTheWeek") + " " + this.getValue("Command");
        try {
            String line;
            String fileName = "/tmp/ps_schedule." + Long.toString(System.currentTimeMillis());
            File f = new File(fileName);
            FileWriter fw = new FileWriter(f);
            Process p = Runtime.getRuntime().exec("/usr/bin/crontab -l");
            InputStream is = p.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            boolean exist = false;
            while ((line = br.readLine()) != null) {
                if (line.equals(event)) {
                    exist = true;
                }
                fw.write(line + "\n");
            }
            if (!exist) {
                fw.write(event + "\n");
            }
            fw.close();
            p = Runtime.getRuntime().exec("/usr/bin/crontab " + fileName);
            p.waitFor();
            f.delete();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.toString());
        }
    }

    public void unschedule() {
        String event = this.getValue("Minute") + " " + this.getValue("Hour") + " * * " + this.getValue("DayOfTheWeek") + " " + this.getValue("Command");
        try {
            String line;
            String fileName = "/tmp/ps_unschedule." + Long.toString(System.currentTimeMillis());
            File f = new File(fileName);
            FileWriter fw = new FileWriter(f);
            Process p = Runtime.getRuntime().exec("/usr/bin/crontab -l");
            InputStream is = p.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                if (line.equals(event)) continue;
                fw.write(line + "\n");
            }
            fw.close();
            p = Runtime.getRuntime().exec("/usr/bin/crontab " + fileName);
            p.waitFor();
            f.delete();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.toString());
        }
    }

    public ArrayList schedules() {
        String requestCommand = this.getValue("Command");
        ArrayList<String> al = new ArrayList<String>();
        try {
            String line;
            Process p = Runtime.getRuntime().exec("/usr/bin/crontab -l");
            InputStream is = p.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] strings = line.split("[ \t]");
                String minute = strings[0];
                String hour = strings[1];
                String day = strings[2];
                String month = strings[3];
                String dayOfTheWeek = strings[4];
                String command = "";
                for (int i = 5; i < strings.length; ++i) {
                    command = command + " " + strings[i];
                }
                if (!command.trim().equals(requestCommand.trim())) continue;
                String schedule = command.trim() + " | " + dayOfTheWeek + "@" + hour + ":" + minute;
                al.add(schedule);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.toString());
        }
        return al;
    }

    private void getFinalPatchList() {
        String command = "/bin/pkginfo";
        this.execUtil.storeOutput(true);
        this.execUtil.exec(command, null);
        String result = this.execUtil.getOutput();
        StringTokenizer tokens = new StringTokenizer(result, "\n");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.indexOf("SUNW") == -1 || token.indexOf("Portal Server") == -1) continue;
            String subStr = token.substring(token.indexOf("SUNW"));
            String pkgName = subStr.substring(0, subStr.indexOf(" "));
            String pkginfoFilePath = "/var/sadm/pkg/" + pkgName + "/pkginfo";
            File pkginfoFile = new File(pkginfoFilePath);
            String patchList = null;
            if (!pkginfoFile.exists() || (patchList = FileUtil.findTextInFile(pkginfoFile, "PATCHLIST=")) == null || patchList.length() == 0 || patchList.substring(10) == null || patchList.substring(10).length() == 0) continue;
            this.finalPatchList = this.finalPatchList + " " + patchList.substring(10);
        }
    }

    public String getPatchInfo() {
        StringBuffer sb = new StringBuffer();
        this.getFinalPatchList();
        if (this.finalPatchList != null && this.finalPatchList.length() != 0) {
            sb.append("\nCurrently, following patches are installed: \n");
            sb.append("------------------------------------------- \n");
            sb.append(this.finalPatchList.substring(1));
        } else {
            sb.append("\nCurrently, there are no patches installed !!\n");
        }
        return sb.toString();
    }

    public String getPatchVerbose() {
        StringBuffer sb = new StringBuffer();
        this.getFinalPatchList();
        if (this.finalPatchList != null && this.finalPatchList.length() != 0) {
            StringTokenizer tokens = new StringTokenizer(this.finalPatchList.substring(1), " ");
            sb.append("\n");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                sb.append(token);
                sb.append("-------------------------------------- \n");
                String patchDir = "/var/sadm/patch/" + token;
                File readmeFile = new File(patchDir + "/README." + token);
                if (!FileUtil.directoryExists(patchDir)) {
                    sb.append("For some unknown reason, no more details about this patch is available. \n");
                    continue;
                }
                if (!readmeFile.exists()) {
                    sb.append(readmeFile + " is not readable or does not exists, no more information available for this patch. \n");
                    continue;
                }
                sb.append(FileUtil.findTextInFile(readmeFile, "Synopsis") + "\n");
            }
        } else {
            sb.append("\nCurrently, there are no patches installed !!\n");
        }
        return sb.toString();
    }
}

