/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.util.os;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.fabric.util.ExecuteUtil;
import com.sun.portal.fabric.util.os.OSTasks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class OSTasksImpl
implements OSTasks {
    private static final String COMMAND_SEPARATOR = "|";
    public HashMap valuesMap = null;
    PSConfigContext context;
    Logger logger;
    ExecuteUtil execUtil;

    public OSTasksImpl(PSConfigContext globalContext, Logger logger) {
        this.context = globalContext;
        this.logger = logger;
        this.execUtil = new ExecuteUtil(logger);
        this.valuesMap = new HashMap();
    }

    public ArrayList getSchedules(String command) {
        this.setValue("Command", command);
        return this.schedules();
    }

    public void scheduling(String action, String mode) {
        String schedules;
        String command;
        StringTokenizer st1 = new StringTokenizer(action, COMMAND_SEPARATOR);
        String string = command = st1.hasMoreTokens() ? st1.nextToken().trim() : "";
        if (command.equals("")) {
            this.logger.log(Level.SEVERE, action + " - no command specified.");
            return;
        }
        String string2 = schedules = st1.hasMoreTokens() ? st1.nextToken().trim() : "";
        if (schedules.equals("")) {
            this.logger.log(Level.SEVERE, action + " - no schedules specified.");
            return;
        }
        StringTokenizer st2 = new StringTokenizer(schedules, ";");
        while (st2.hasMoreTokens()) {
            String minute;
            String hour;
            String time;
            String dayOfTheWeek;
            String schedule = st2.nextToken().trim();
            StringTokenizer st3 = new StringTokenizer(schedule, "@");
            String string3 = dayOfTheWeek = st3.hasMoreTokens() ? st3.nextToken().trim() : "";
            if (dayOfTheWeek.equals("")) {
                this.logger.log(Level.SEVERE, action + " - no day of the week specified.");
                return;
            }
            int dayOfTheWeekValue = new Integer(dayOfTheWeek);
            if (dayOfTheWeekValue < 0 || dayOfTheWeekValue > 6) {
                this.logger.log(Level.SEVERE, action + " - day of the week must be between 0 and 6.");
                return;
            }
            String string4 = time = st3.hasMoreTokens() ? st3.nextToken().trim() : "";
            if (time.equals("")) {
                this.logger.log(Level.SEVERE, action + " - no time specified.");
                return;
            }
            StringTokenizer st4 = new StringTokenizer(time, ":");
            String string5 = hour = st4.hasMoreTokens() ? st4.nextToken().trim() : "";
            if (hour.equals("")) {
                this.logger.log(Level.SEVERE, action + " - no hour specified.");
                return;
            }
            int hourValue = new Integer(hour);
            if (hourValue < 0 || hourValue > 23) {
                this.logger.log(Level.SEVERE, action + " - hour must be between 0 and 23.");
                return;
            }
            String string6 = minute = st4.hasMoreTokens() ? st4.nextToken().trim() : "";
            if (minute.equals("")) {
                this.logger.log(Level.SEVERE, action + " - no minute specified.");
                return;
            }
            int minuteValue = new Integer(minute);
            if (minuteValue < 0 || minuteValue > 59) {
                this.logger.log(Level.SEVERE, action + " - minute must be between 0 and 59.");
                return;
            }
            this.setValue("Command", command);
            this.setValue("DayOfTheWeek", dayOfTheWeek);
            this.setValue("Hour", hour);
            this.setValue("Minute", minute);
            if (mode.equals("schedule")) {
                this.schedule();
                continue;
            }
            this.unschedule();
        }
    }

    public String getValue(String key) {
        if (this.valuesMap.containsKey(key)) {
            return (String)this.valuesMap.get(key);
        }
        return "";
    }

    public void setValue(String key, String value) {
        if (this.valuesMap.containsKey(key)) {
            this.valuesMap.remove(key);
        }
        this.valuesMap.put(key, value);
    }
}

