/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.util.os;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.fabric.util.os.UnixTasks;
import java.io.File;
import java.io.FileWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LinuxTasks
extends UnixTasks {
    private static String fs = System.getProperty("file.separator");

    public LinuxTasks(PSConfigContext globalContext, Logger logger) {
        super(globalContext, logger);
    }

    public void createSymbolicLink(String source, String target) {
        String cmd = "/bin/ln";
        String[] args = new String[]{"-fs", source, target};
        try {
            this.execUtil.exec(cmd, args);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Classpath configuration failed", e);
        }
    }

    public void removeSymbolicLink(String target) {
        String cmd = "/bin/unlink";
        String[] args = new String[]{target};
        try {
            this.execUtil.exec(cmd, args);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error in removing symbolic link " + target + "Classpath configuration failed", e);
        }
    }

    public void addNetFilePAM() {
        String pam = fs + "etc" + fs + "pam.d" + fs + "netfile";
        File pamFile = new File(pam);
        if (pamFile.exists()) {
            this.logger.log(Level.INFO, "NetFile PAM already exists ...");
        } else {
            try {
                pamFile.createNewFile();
                FileWriter fw = new FileWriter(pamFile);
                fw.write("auth        required    //lib//security//pam_unix.so");
                fw.write("account     required    //lib//security//pam_unix.so");
                fw.write("password    required    //lib//security//pam_unix.so");
                fw.write("session     required    //lib//security//pam_unix.so");
                fw.close();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Configuration Error: Error in writing to the NetFile PAM");
            }
        }
    }
}

