/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.util;

import com.sun.portal.fabric.util.XMLJdomFileCreationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLJdomUtil {
    private Document doc = null;
    private Map hash = null;

    public Document getXMLJdomDocument() {
        return this.doc;
    }

    public String getXMLJdomDocumentAsString() {
        String sDocStr = null;
        if (this.doc != null) {
            XMLOutputter xmlOutputter = new XMLOutputter();
            sDocStr = xmlOutputter.outputString(this.doc);
        }
        return sDocStr;
    }

    public Element getChildAsElement(String sChildPath) throws XMLJdomFileCreationException {
        Element elm = null;
        if (sChildPath == null || sChildPath.trim().length() == 0) {
            String sMsg = "sChildPath == Null/Empty";
            throw new XMLJdomFileCreationException(sMsg);
        }
        if (this.hash != null && (elm = (Element)this.hash.get(sChildPath)) != null) {
            return elm;
        }
        String[] sChildPathL = sChildPath.split("@");
        if (sChildPathL.length > 0) {
            Element element = elm = this.doc != null ? this.doc.getRootElement() : null;
            if (elm == null) {
                return null;
            }
            String sRootTagName = elm.getName();
            if (sRootTagName != null && !sRootTagName.equals(sChildPathL[0])) {
                return null;
            }
            for (int i = 1; i < sChildPathL.length; ++i) {
                String sField = sChildPathL[i].trim();
                if ((elm = elm.getChild(sField)) != null) continue;
                return null;
            }
        }
        return elm;
    }

    public Properties getChildAsProperties(String sChildPath) throws XMLJdomFileCreationException {
        Properties sProperties = null;
        Element elm = this.getChildAsElement(sChildPath);
        if (elm != null) {
            sProperties = this.convertElementToProperties(elm);
        }
        return sProperties;
    }

    public List getChildrenAsElementsList(String sParentPath, String sChildTagName) throws XMLJdomFileCreationException {
        List sNodeList = null;
        Element elm = this.getChildAsElement(sParentPath);
        if (elm != null) {
            sNodeList = sChildTagName != null && sChildTagName.length() > 0 ? elm.getChildren(sChildTagName) : elm.getChildren();
        }
        return sNodeList;
    }

    public List getChildrenAsPropertiesList(String sParentPath, String sChildTagName) throws XMLJdomFileCreationException {
        int iSize;
        ArrayList<Properties> sPropList = null;
        List sElmList = this.getChildrenAsElementsList(sParentPath, sChildTagName);
        int n = iSize = sElmList != null ? sElmList.size() : 0;
        if (sElmList != null) {
            sPropList = new ArrayList<Properties>();
            for (int i = 0; i < iSize; ++i) {
                Element elm = (Element)sElmList.get(i);
                sPropList.add(this.convertElementToProperties(elm));
            }
        }
        return sPropList;
    }

    public List getChildrenAsStringList(String sParentPath, String sChildTagName) throws XMLJdomFileCreationException {
        int iSize;
        ArrayList<String> sTextList = null;
        List sElmList = this.getChildrenAsElementsList(sParentPath, sChildTagName);
        int n = iSize = sElmList != null ? sElmList.size() : 0;
        if (sElmList != null) {
            sTextList = new ArrayList<String>();
            for (int i = 0; i < iSize; ++i) {
                Element elm = (Element)sElmList.get(i);
                sTextList.add(this.convertElementToString(elm));
            }
        }
        return sTextList;
    }

    public String getAttribute(String sChildPath, String sAttribName) throws XMLJdomFileCreationException {
        String str = null;
        if (sAttribName == null || sAttribName.length() == 0) {
            String sMsg = "sAttribName == Null/Empty";
            throw new XMLJdomFileCreationException(sMsg);
        }
        Element elm = this.getChildAsElement(sChildPath);
        if (elm != null) {
            str = elm.getAttributeValue(sAttribName);
        }
        return str;
    }

    private Properties convertElementToProperties(Element elm) throws XMLJdomFileCreationException {
        Properties sProperties = null;
        if (elm == null) {
            String sMsg = "elm == Null";
            throw new XMLJdomFileCreationException(sMsg);
        }
        sProperties = new Properties();
        List attrib = elm.getAttributes();
        int iSize = attrib != null ? attrib.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            Attribute attr = (Attribute)attrib.get(i);
            sProperties.setProperty(attr.getName(), attr.getValue());
        }
        return sProperties;
    }

    private String convertElementToString(Element elm) throws XMLJdomFileCreationException {
        String str = null;
        if (elm == null) {
            String sMsg = "elm == Null";
            throw new XMLJdomFileCreationException(sMsg);
        }
        str = elm.getTextTrim();
        return str;
    }

    public Document readXMLFileLessSchemaValidation(String sXMLFile) throws XMLJdomFileCreationException {
        return this.readXMLFile(sXMLFile, false);
    }

    public Document readXMLFile(String sXMLFile) throws XMLJdomFileCreationException {
        return this.readXMLFile(sXMLFile, true);
    }

    private Document readXMLFile(String sXMLFile, boolean bValidate) throws XMLJdomFileCreationException {
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setValidation(bValidate);
            if (bValidate) {
                builder.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            this.doc = builder.build(sXMLFile);
            String message = "The Input XML File '" + sXMLFile + "' is valid.";
        }
        catch (NullPointerException e0) {
            String message = "Please provide the Sample Silent File";
            throw new XMLJdomFileCreationException(e0);
        }
        catch (IOException e1) {
            String message = e1.getMessage();
            throw new XMLJdomFileCreationException(e1);
        }
        catch (JDOMException e2) {
            String message = "The Input XML File is not well formed.";
            throw new XMLJdomFileCreationException(e2);
        }
        return this.doc;
    }

    public void writeXMLFile(String sXMLFile) throws XMLJdomFileCreationException {
        this.writeXMLFile(sXMLFile, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeXMLFile(String sXMLFile, boolean bPrune) throws XMLJdomFileCreationException {
        if (this.doc == null) {
            String sMessage = "doc == null";
            throw new XMLJdomFileCreationException(sMessage);
        }
        FileOutputStream fXMLout = null;
        boolean bGood = false;
        File fXMLFile = null;
        File fXMLFileTemp = null;
        try {
            try {
                fXMLFile = new File(sXMLFile);
                if (fXMLFile.isFile()) {
                    fXMLFile.delete();
                } else if (fXMLFile.isDirectory()) {
                    String sMsg = "'" + sXMLFile + "' is a directory.";
                    throw new XMLJdomFileCreationException(sMsg);
                }
                File fDir = new File("/tmp");
                fXMLFileTemp = File.createTempFile("psconfig", ".tmp", fDir);
                fXMLFileTemp.deleteOnExit();
                XMLOutputter XMLToFile = new XMLOutputter();
                fXMLout = new FileOutputStream(fXMLFileTemp);
                XMLToFile.output(this.doc, (OutputStream)fXMLout);
                fXMLout.flush();
                bGood = true;
            }
            catch (NullPointerException e0) {
                String message = "Please provide the XML Output file.";
                throw new XMLJdomFileCreationException(e0);
            }
            catch (IOException e1) {
                String message = e1.getMessage();
                throw new XMLJdomFileCreationException(e1);
            }
            Object var10_17 = null;
        }
        catch (Throwable throwable) {
            Object var10_18 = null;
            try {
                if (fXMLout != null) throw throwable;
                fXMLout.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new XMLJdomFileCreationException(e);
            }
        }
        try {}
        catch (IOException e) {
            throw new XMLJdomFileCreationException(e);
        }
        if (fXMLout == null) {
            fXMLout.close();
        }
        if (!bGood) return;
        try {
            this.indentXML(fXMLFileTemp, fXMLFile);
            return;
        }
        catch (IOException e0) {
            throw new XMLJdomFileCreationException(e0);
        }
        catch (JDOMException e1) {
            throw new XMLJdomFileCreationException(e1);
        }
        finally {
            fXMLFileTemp.delete();
        }
    }

    public void modifyChild(String sChildPath, String sNewTagName, Properties sNewProps, boolean bCleanContents) throws XMLJdomFileCreationException {
        if (!(sNewTagName != null && sNewTagName.trim().length() != 0 || sNewProps != null || bCleanContents)) {
            String sMsg = "sNewTagName == Null/Empty and sNewProps == Null and bCleanContents=false. At least one of them should be *not* Null/True.";
            throw new XMLJdomFileCreationException(sMsg);
        }
        Element elm = this.getChildAsElement(sChildPath);
        if (sNewTagName != null && sNewTagName.trim().length() > 0) {
            elm.setName(sNewTagName);
        }
        if (bCleanContents) {
            elm.removeContent();
        }
        if (sNewProps != null) {
            Iterator itr = elm.getAttributes().iterator();
            while (itr.hasNext()) {
                Attribute attrib = (Attribute)itr.next();
                itr.remove();
            }
            Enumeration<?> enum1 = sNewProps.propertyNames();
            while (enum1.hasMoreElements()) {
                String sKey = (String)enum1.nextElement();
                String sValue = sNewProps.getProperty(sKey);
                elm.setAttribute(sKey, sValue);
            }
        }
    }

    public int addChild(String sParentPath, String sChildTagName, Object object) throws XMLJdomFileCreationException {
        int iHashCode = -1;
        if (object == null) {
            String sMsg = "object == Null";
            throw new XMLJdomFileCreationException(sMsg);
        }
        Element child = this.convertObjectToElement(sChildTagName, object);
        iHashCode = child.hashCode();
        Element parent = null;
        if (sParentPath == null) {
            if (this.doc != null) {
                String sMsg = "Root Element is already defined. There can be only one root element per document.";
                throw new XMLJdomFileCreationException(sMsg);
            }
            this.doc = new Document(child);
        } else {
            parent = this.getChildAsElement(sParentPath);
            if (parent == null) {
                String sMsg = "No Element was found for tag path '" + sParentPath + "'.";
                throw new XMLJdomFileCreationException(sMsg);
            }
            parent.addContent((Content)child);
        }
        return iHashCode;
    }

    public int[] addChildren(String sParentPath, String sChildTagName, List lObject) throws XMLJdomFileCreationException {
        int iSize;
        int n = iSize = lObject != null ? lObject.size() : 0;
        if (iSize == 0) {
            String sMsg = "lObject == Null/Empty";
            throw new XMLJdomFileCreationException(sMsg);
        }
        if (sChildTagName == null || sChildTagName.trim().length() == 0) {
            String sMsg = "sChildTagName == Null/Empty";
            throw new XMLJdomFileCreationException(sMsg);
        }
        ArrayList<String> lChildTagName = new ArrayList<String>();
        for (int i = 0; i < iSize; ++i) {
            lChildTagName.add(sChildTagName);
        }
        return this.addChildren(sParentPath, lChildTagName, lObject);
    }

    public int[] addChildren(String sParentPath, List lChildTagName, List lObject) throws XMLJdomFileCreationException {
        int iObjectListSize;
        int[] iHashCode = null;
        if (lChildTagName == null) {
            String sMsg = "lChildTagName == Null";
            throw new XMLJdomFileCreationException(sMsg);
        }
        if (lObject == null) {
            String sMsg = "lObject == Null";
            throw new XMLJdomFileCreationException(sMsg);
        }
        int iChildTagNameListSize = lChildTagName.size();
        if (iChildTagNameListSize != (iObjectListSize = lObject.size())) {
            String sMsg = "Size mismatch for Lists lChildTagName & lObject";
            throw new XMLJdomFileCreationException(sMsg);
        }
        if (iObjectListSize > 0) {
            Element parent = this.getChildAsElement(sParentPath);
            iHashCode = new int[iObjectListSize];
            for (int i = 0; i < iObjectListSize; ++i) {
                String sChildTagName = (String)lChildTagName.get(i);
                Object object = lObject.get(i);
                iHashCode[i] = this.addChild(sParentPath, sChildTagName, object);
            }
        }
        return iHashCode;
    }

    public void setNamespace(String sChildPath, String sNamespaceName, String sNamespaceURI, String sAttribName, String sAttribValue) throws XMLJdomFileCreationException {
        if (sNamespaceName == null || sNamespaceName.trim().length() == 0) {
            String sMsg = "sNamespaceName == Null/Empty";
            throw new XMLJdomFileCreationException(sMsg);
        }
        if (sNamespaceURI == null || sNamespaceURI.trim().length() == 0) {
            String sMsg = "sNamespaceURI == Null/Empty";
            throw new XMLJdomFileCreationException(sMsg);
        }
        if (sAttribName == null || sAttribName.trim().length() == 0) {
            String sMsg = "sAttribName == Null/Empty";
            throw new XMLJdomFileCreationException(sMsg);
        }
        Element elm = this.getChildAsElement(sChildPath);
        Namespace xsi = null;
        if (elm != null) {
            xsi = Namespace.getNamespace((String)sNamespaceName, (String)sNamespaceURI);
            elm.addNamespaceDeclaration(xsi);
            String sValue = sAttribValue != null ? sAttribValue : "";
            elm.setAttribute(sAttribName, sValue, xsi);
        }
    }

    public void setAttribute(String sChildPath, String sAttribName, String sAttribValue) throws XMLJdomFileCreationException {
        if (sAttribName == null || sAttribName.trim().length() == 0) {
            String sMsg = "sAttribName == Null/Empty";
            throw new XMLJdomFileCreationException(sMsg);
        }
        Element elm = this.getChildAsElement(sChildPath);
        if (elm != null) {
            String sValue = sAttribValue != null ? sAttribValue : "";
            elm.setAttribute(sAttribName, sValue);
        }
    }

    private Element convertObjectToElement(String sElmTagName, Object object) throws XMLJdomFileCreationException {
        Element elm = null;
        if (object == null) {
            String sMsg = "object == Null";
            throw new XMLJdomFileCreationException(sMsg);
        }
        if (object instanceof Element) {
            elm = (Element)object;
        } else {
            if (sElmTagName == null || sElmTagName.length() == 0) {
                String sMsg = "sElmTagName == Null/Empty";
                throw new XMLJdomFileCreationException(sMsg);
            }
            if (object instanceof String) {
                elm = this.convertStringToElement(sElmTagName, (String)object);
            } else if (object instanceof Properties) {
                elm = this.convertPropertiesToElement(sElmTagName, (Properties)object);
            } else if (object instanceof Map) {
                elm = this.convertMapToElement(sElmTagName, (Map)object);
            } else {
                String sMsg = "Unknown object type";
                throw new XMLJdomFileCreationException(sMsg);
            }
        }
        return elm;
    }

    private Element convertPropertiesToElement(String sElmTagName, Properties sProp) throws XMLJdomFileCreationException {
        Element elm = new Element(sElmTagName);
        Enumeration<?> enum1 = sProp.propertyNames();
        while (enum1.hasMoreElements()) {
            String sKey = (String)enum1.nextElement();
            String sValue = sProp.getProperty(sKey);
            elm.setAttribute(sKey, sValue);
        }
        return elm;
    }

    private Element convertMapToElement(String sElmTagName, Map sMap) throws XMLJdomFileCreationException {
        Element elm = new Element(sElmTagName);
        Iterator itr = sMap.keySet().iterator();
        while (itr.hasNext()) {
            String sKey = (String)itr.next();
            String sValue = (String)sMap.get(sKey);
            elm.setAttribute(sKey, sValue);
        }
        return elm;
    }

    private Element convertStringToElement(String sElmTagName, String str) throws XMLJdomFileCreationException {
        Element elm = new Element(sElmTagName);
        elm.setText(str);
        return elm;
    }

    public void removeChild(String sChildPath) throws XMLJdomFileCreationException {
        Element elm = this.getChildAsElement(sChildPath);
        if (elm != null) {
            elm.detach();
        }
    }

    public void removeAttribute(String sChildPath, String sAttribName) throws XMLJdomFileCreationException {
        if (sAttribName == null || sAttribName.length() == 0) {
            String sMsg = "sAttribName == Null/Empty";
            throw new XMLJdomFileCreationException(sMsg);
        }
        Element elm = this.getChildAsElement(sChildPath);
        if (elm != null) {
            elm.removeAttribute(sAttribName);
        }
    }

    private void indentXML(File inXMLFile, File outXMLFile) throws JDOMException, IOException, FileNotFoundException {
        SAXBuilder sbuilder = new SAXBuilder();
        Document doc = sbuilder.build(inXMLFile);
        FileOutputStream fos = new FileOutputStream(outXMLFile);
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(doc, (OutputStream)fos);
        fos.close();
    }

    private void prepareHash(Element rootElm, String sTagPath) {
        Element myRootElm = null;
        if (rootElm == null) {
            Element element = myRootElm = this.doc != null ? this.doc.getRootElement() : rootElm;
        }
        if (myRootElm != null) {
            String sNewTagPath = sTagPath == null ? "" : sTagPath + "@";
            if (this.hash.get(sNewTagPath = sNewTagPath + myRootElm.getName()) == null) {
                this.hash.put(sNewTagPath, myRootElm);
            }
            Iterator itr = myRootElm.getChildren().iterator();
            while (itr.hasNext()) {
                Element oneLevelDeep = (Element)itr.next();
                this.prepareHash(oneLevelDeep, sNewTagPath);
            }
        }
    }
}

