/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.util;

import com.sun.portal.admin.common.util.AdminUtil;
import com.sun.portal.log.common.PortalLogger;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class NetworkUtil {
    private static Logger configLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$util$NetworkUtil == null ? (class$com$sun$portal$fabric$util$NetworkUtil = NetworkUtil.class$("com.sun.portal.fabric.util.NetworkUtil")) : class$com$sun$portal$fabric$util$NetworkUtil));
    private static LogRecord record;
    static /* synthetic */ Class class$com$sun$portal$fabric$util$NetworkUtil;

    public static boolean isPortValid(String host, String port) {
        try {
            int portno = Integer.parseInt(port);
            Socket socket = new Socket(host, portno);
        }
        catch (ConnectException ex) {
            configLogger.log(Level.INFO, "PSFB_CSPFU0012", new String[]{port, host});
            return false;
        }
        catch (Exception ex) {
            configLogger.log(Level.INFO, "PSFB_CSPFU0012", ex);
            return false;
        }
        configLogger.log(Level.SEVERE, "PSFB_CSPFU0011", new String[]{port, host});
        return true;
    }

    public static boolean isPortUsed(String host, int port) {
        if (port <= 0 || port > 65535) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFU0013", new Integer(port).toString());
            return false;
        }
        try {
            Socket socket = new Socket(host, port);
            OutputStream theOutputStream = socket.getOutputStream();
            InputStream theInputStream = socket.getInputStream();
            theOutputStream.close();
            theOutputStream = null;
            theInputStream.close();
            theInputStream = null;
            socket.close();
            socket = null;
        }
        catch (Exception a) {
            configLogger.log(Level.INFO, "PSFB_CSPFU0011", new String[]{host, new Integer(port).toString()});
            return true;
        }
        configLogger.log(Level.INFO, "PSFB_CSPFU0012", new String[]{host, new Integer(port).toString()});
        return false;
    }

    public static String getNextAvailablePort(String server, String port) {
        String invalid = null;
        int portno = 0;
        if (port == null || port.length() == 0 || port.length() > 5) {
            return invalid;
        }
        try {
            portno = Integer.parseInt(port);
        }
        catch (NumberFormatException nfe) {
            return invalid;
        }
        int trys = 50;
        for (int idx = 0; idx < trys; ++idx) {
            if (!NetworkUtil.isPortUsed(server, portno + idx)) continue;
            return new Integer(portno + idx).toString();
        }
        return invalid;
    }

    public static boolean isHostValid(String host) {
        boolean bRet = true;
        try {
            InetAddress.getByName(host).getHostName();
        }
        catch (Exception ex) {
            if (configLogger.isLoggable(Level.SEVERE)) {
                record = new LogRecord(Level.SEVERE, "PSFB_CSPFU0015");
                record.setLoggerName(configLogger.getName());
                record.setParameters(new String[]{host});
                record.setThrown(ex);
                record.setLoggerName(configLogger.getName());
                configLogger.log(record);
            }
            bRet = false;
        }
        if (bRet) {
            configLogger.log(Level.INFO, "PSFB_CSPFU0014", host);
        } else {
            configLogger.log(Level.INFO, "PSFB_CSPFU0019", host);
        }
        return bRet;
    }

    public static boolean isLocalHost(String host) {
        boolean bRet;
        block5: {
            bRet = false;
            try {
                if (NetworkUtil.isHostValid(host)) {
                    bRet = AdminUtil.isLocal((String)host);
                }
            }
            catch (UnknownHostException e) {
                if (!configLogger.isLoggable(Level.SEVERE)) break block5;
                record = new LogRecord(Level.SEVERE, "PSFB_CSPFU0015");
                record.setLoggerName(configLogger.getName());
                record.setParameters(new String[]{host});
                record.setThrown(e);
                record.setLoggerName(configLogger.getName());
                configLogger.log(record);
            }
        }
        if (bRet) {
            configLogger.log(Level.INFO, "PSFB_CSPFU0020", host);
        } else {
            configLogger.log(Level.INFO, "PSFB_CSPFU0021", host);
        }
        return bRet;
    }

    public static boolean validateIPAddressAndHost(String host, String ipaddress) {
        boolean bRetVal;
        block4: {
            if (ipaddress == null || ipaddress.length() < 7) {
                configLogger.log(Level.INFO, "PSFB_CSPFU0018", new String[]{ipaddress});
                return false;
            }
            bRetVal = false;
            try {
                InetAddress[] hostIPAddressList = InetAddress.getAllByName(host);
                for (int i = 0; i < hostIPAddressList.length; ++i) {
                    String sIPAddress = hostIPAddressList[i].getHostAddress();
                    if (sIPAddress == null || !sIPAddress.equalsIgnoreCase(ipaddress)) continue;
                    configLogger.log(Level.INFO, "PSFB_CSPFU0016", new String[]{host, ipaddress});
                    bRetVal = true;
                    break;
                }
            }
            catch (Exception e) {
                if (!configLogger.isLoggable(Level.SEVERE)) break block4;
                record = new LogRecord(Level.SEVERE, "PSFB_CSPFU0017");
                record.setLoggerName(configLogger.getName());
                record.setParameters(new String[]{host, ipaddress});
                record.setThrown(e);
                record.setLoggerName(configLogger.getName());
                configLogger.log(record);
            }
        }
        return bRetVal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

