/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.util;

import com.sun.portal.fabric.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class LogConfigUtil {
    public static final String fs = File.separator;
    private static final String LOG_DIR_TOKEN = "%LOG_DIR%";
    private static final String ADMIN_LOG_DIR_TOKEN = "%ADMIN_LOG_DIR%";
    private static final String ROOT_LOGGER_TOKEN = "%ROOT_LOGGER%";
    private static final String INSTANCE_ID_TOKEN = "%instanceID";
    private static final String SRA_COMPONENT_TYPE_TOKEN = "%sraComponentType.";
    private static final boolean EXCLUDE_SEARCH = true;
    private static final boolean EXCLUDE_CONSOLE = true;
    private static final boolean EXCLUDE_AUDIT = true;
    private static String logLevel = null;

    public static File getAdminLogConfigFile(String psBaseDir, String logDestDir, String loggerName, boolean excludeAudit) throws IOException {
        String logConfigTemplate = psBaseDir + fs + "template" + fs + "PSLogConfig.properties";
        File logConfigFile = File.createTempFile(loggerName, ".tmp");
        logConfigFile.deleteOnExit();
        LogConfigUtil.copyFileFromTemplate(logConfigTemplate, logConfigFile, true, true, excludeAudit);
        FileUtil.replaceTokenInFile(logConfigFile, ROOT_LOGGER_TOKEN, loggerName);
        FileUtil.replaceTokenInFile(logConfigFile, LOG_DIR_TOKEN, logDestDir);
        if (logLevel == null) {
            String logLevelLine = FileUtil.findTextInFile(logConfigFile, loggerName + ".level");
            int index = logLevelLine.indexOf("=");
            logLevel = index != -1 ? logLevelLine.substring(index + 1).trim() : "SEVERE";
        }
        FileUtil.replaceLineInFile(logConfigFile, loggerName + ".level", loggerName + ".level=FINEST");
        FileUtil.replaceTokenInFile(logConfigFile, SRA_COMPONENT_TYPE_TOKEN, "");
        FileUtil.replaceTokenInFile(logConfigFile, INSTANCE_ID_TOKEN, "");
        FileUtil.makeDir(logDestDir);
        return logConfigFile;
    }

    public static String getDefaultLogLevel() {
        return logLevel;
    }

    public static File getLogConfigFileTemplate(String psBaseDir) throws IOException {
        String loggerName = "debug.com.sun.portal";
        String logConfigTemplate = psBaseDir + fs + "template" + fs + "PSLogConfig.properties";
        File logConfigFile = File.createTempFile(loggerName, ".tmp");
        LogConfigUtil.copyFileFromTemplate(logConfigTemplate, logConfigFile, true, true, true);
        FileUtil.replaceTokenInFile(logConfigFile, ROOT_LOGGER_TOKEN, loggerName);
        FileUtil.replaceTokenInFile(logConfigFile, INSTANCE_ID_TOKEN, "");
        return logConfigFile;
    }

    public static void createPortalLogConfigFile(String psBaseDir, String psDataDir, String portalID) {
        String loggerName = "debug.com.sun.portal";
        String portalDir = psDataDir + fs + "portals" + fs + portalID;
        String portalConfigDir = portalDir + fs + "config";
        String logConfigTemplate = psBaseDir + fs + "template" + fs + "PSLogConfig.properties";
        String logConfigDest = portalConfigDir + fs + "PSLogConfig.properties";
        File logConfigFile = new File(logConfigDest);
        LogConfigUtil.copyFileFromTemplate(logConfigTemplate, logConfigFile, true, false, true);
        String logDir = portalDir + fs + "logs";
        String adminLogDir = psDataDir + fs + "logs" + fs + "admin";
        FileUtil.replaceTokenInFile(logConfigFile, ROOT_LOGGER_TOKEN, loggerName);
        FileUtil.replaceTokenInFile(logConfigFile, LOG_DIR_TOKEN, logDir);
        FileUtil.replaceTokenInFile(logConfigFile, ADMIN_LOG_DIR_TOKEN, adminLogDir);
        FileUtil.replaceTokenInFile(logConfigFile, SRA_COMPONENT_TYPE_TOKEN, "");
        FileUtil.makeDir(logDir);
    }

    public static void createSearchLogConfigFile(String psBaseDir, String searchDataDir, String searchServerID) {
        String loggerName = "debug.com.sun.portal.search";
        String searchDir = searchDataDir + fs + "searchservers" + fs + searchServerID;
        String searchConfigDir = searchDir + fs + "config";
        String logConfigTemplate = psBaseDir + fs + "template" + fs + "PSLogConfig.properties";
        String logConfigDest = searchConfigDir + fs + "SearchLogConfig.properties";
        File logConfigFile = new File(logConfigDest);
        LogConfigUtil.copyFileFromTemplate(logConfigTemplate, logConfigFile, false, true, true);
        String logDir = searchDir + fs + "logs";
        FileUtil.replaceTokenInFile(logConfigFile, ROOT_LOGGER_TOKEN, loggerName);
        FileUtil.replaceTokenInFile(logConfigFile, LOG_DIR_TOKEN, logDir);
        FileUtil.replaceTokenInFile(logConfigFile, SRA_COMPONENT_TYPE_TOKEN, "");
        FileUtil.makeDir(logDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void copyFileFromTemplate(String logConfigTemplate, File logConfigFile, boolean excludeSearch, boolean excludeConsole, boolean excludeAudit) {
        block15: {
            String line;
            BufferedReader inBuff = null;
            PrintWriter outBuff = null;
            inBuff = new BufferedReader(new FileReader(logConfigTemplate));
            outBuff = new PrintWriter(new FileWriter(logConfigFile));
            while ((line = inBuff.readLine()) != null) {
                if (excludeSearch && (line.indexOf(".rdm.") >= 0 || line.indexOf(".rdmserver.") >= 0 || line.indexOf(".rdmgr.") >= 0 || line.indexOf(".autoclassify.") >= 0) || excludeConsole && line.indexOf(".admin.console.") >= 0 || excludeAudit && line.indexOf(".audit.") >= 0) continue;
                outBuff.println(line);
            }
            Object var10_8 = null;
            try {
                if (inBuff != null) {
                    inBuff.close();
                }
                if (outBuff != null) {
                    outBuff.close();
                }
                break block15;
            }
            catch (IOException ignored) {}
            break block15;
            {
                catch (Exception e) {
                    System.out.println("Cannot copy the file from : " + logConfigTemplate + " to " + logConfigFile.getAbsoluteFile());
                    Object var10_9 = null;
                    try {
                        if (inBuff != null) {
                            inBuff.close();
                        }
                        if (outBuff != null) {
                            outBuff.close();
                        }
                        break block15;
                    }
                    catch (IOException ignored) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                try {
                    if (inBuff != null) {
                        inBuff.close();
                    }
                    if (outBuff != null) {
                        outBuff.close();
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

