/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.util;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.util.FileWildFilter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class FileUtil {
    public static final int DELETE_FIRST_OCCURANCE = 1;
    public static final int DELETE_ALL_OCCURANCES = 2;
    public static final int DELETE_FIRST_OCCURANCE_STARTING_WITH = 3;
    public static final int DELETE_ALL_OCCURANCES_STARTING_WITH = 4;
    public static final int APPEND_FIRST_OCCURANCE = 5;
    public static final int APPEND_ALL_OCCURANCES = 6;
    public static final int APPEND_FIRST_OCCURANCE_STARTING_WITH = 7;
    public static final int APPEND_ALL_OCCURANCES_STARTING_WITH = 8;
    public static final int REPLACE_FIRST_OCCURANCE = 9;
    public static final int REPLACE_ALL_OCCURANCES = 10;
    public static final int REPLACE_FIRST_OCCURANCE_STARTING_WITH = 11;
    public static final int REPLACED_ALL_OCCURANCES_STARTING_WITH = 12;
    private static Logger configLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$util$FileUtil == null ? (class$com$sun$portal$fabric$util$FileUtil = FileUtil.class$("com.sun.portal.fabric.util.FileUtil")) : class$com$sun$portal$fabric$util$FileUtil));
    static /* synthetic */ Class class$com$sun$portal$fabric$util$FileUtil;

    public static void debug(String str) {
        System.out.println(str);
    }

    public static FilenameFilter getExtensionFilter(String ext) {
        FileWildFilter filter = FileWildFilter.getExtensionFilter((String)ext, (int)0);
        return filter;
    }

    public static boolean getFiles(File dir, List files) {
        return FileUtil.getFiles(dir, files, null);
    }

    public static boolean getFiles(File dir, List files, String ext) {
        File file;
        if (dir == null || !dir.exists() || files == null) {
            return false;
        }
        FileWildFilter sExtFilter = FileWildFilter.getExtensionFilter((String)ext, (int)2);
        File[] fFileList = dir.listFiles((FilenameFilter)sExtFilter);
        for (int i = 0; i < fFileList.length; ++i) {
            File file2 = fFileList[i];
            if (!file2.isFile()) continue;
            files.add(file2);
        }
        FileWildFilter sDirFilter = FileWildFilter.getDirectoryFilter();
        File[] fDirList = dir.listFiles((FilenameFilter)sDirFilter);
        boolean bRetCode = true;
        for (int i = 0; i < fDirList.length && (bRetCode = FileUtil.getFiles(file = fDirList[i], files, ext)); ++i) {
        }
        return bRetCode;
    }

    public static boolean copyFile(String fromFilename, String toFilename) {
        return FileUtil.copyFile(new File(fromFilename), new File(toFilename), false);
    }

    public static boolean copyFile(File fromFile, File toFile) {
        return FileUtil.copyFile(fromFile, toFile, false);
    }

    public static boolean fileExists(String fileName) {
        try {
            File file = new File(fileName);
            return file.isFile();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean directoryExists(String dirName) {
        try {
            File file = new File(dirName);
            return file.isDirectory();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean makeDir(String dirName) {
        File dir = new File(dirName);
        return dir.exists() ? true : dir.mkdirs();
    }

    public static boolean copyDir(String fromDirName, String toDirName) {
        try {
            File fromDir = new File(fromDirName);
            fromDirName = fromDir.getCanonicalPath();
            File toDir = new File(toDirName);
            toDirName = toDir.getCanonicalPath();
            ArrayList files = new ArrayList();
            if (!FileUtil.getFiles(fromDir, files)) {
                return false;
            }
            if (!FileUtil.makeDir(toDirName)) {
                return false;
            }
            for (int i = 0; i < files.size(); ++i) {
                File from = (File)files.get(i);
                String fromName = from.getAbsolutePath();
                String relativeName = fromName.substring(fromDirName.length(), fromName.length());
                String destName = toDirName + relativeName;
                if (!(from.isFile() ? !FileUtil.copyFile(from, new File(destName), false) : from.isDirectory() && !FileUtil.makeDir(destName))) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean deleteDir(String dirName) {
        return FileUtil.deleteDir(new File(dirName));
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!(file.isFile() ? !file.delete() : file.isDirectory() && !FileUtil.deleteDir(file))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean appendLineInFile(File file, String pattern, String text) {
        return FileUtil.appendLineInFile(file, pattern, text, 6);
    }

    public static boolean appendLineInFile(File file, String pattern, String text, int mode) {
        boolean appendDone = false;
        try {
            File tmpFile = File.createTempFile("appendlineinfile", ".tmp");
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), "UTF-8"));
            String line = null;
            while ((line = in.readLine()) != null) {
                out.write(line);
                out.newLine();
                int index = line.indexOf(pattern);
                boolean startsWithIndex = line.trim().startsWith(pattern);
                if (index < 0) continue;
                switch (mode) {
                    case 5: {
                        if (appendDone) break;
                        out.write(text.toString());
                        out.newLine();
                        appendDone = true;
                        break;
                    }
                    case 6: {
                        out.write(text.toString());
                        out.newLine();
                        break;
                    }
                    case 7: {
                        if (appendDone || !startsWithIndex) break;
                        out.write(text.toString());
                        out.newLine();
                        appendDone = true;
                        break;
                    }
                    case 8: {
                        if (!startsWithIndex) break;
                        out.write(text.toString());
                        out.newLine();
                    }
                }
            }
            in.close();
            out.close();
            return FileUtil.copyFile(tmpFile, file, true);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean replaceLineInFile(File file, String pattern, String text) {
        try {
            File tmpFile = File.createTempFile("replacelineinfile", ".tmp");
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), "UTF-8"));
            boolean replaced = false;
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.indexOf(pattern) >= 0) {
                    out.write(text.toString());
                    out.newLine();
                    replaced = true;
                    continue;
                }
                out.write(line);
                out.newLine();
            }
            in.close();
            out.close();
            if (replaced) {
                FileUtil.copyFile(tmpFile, file, true);
            } else {
                tmpFile.delete();
            }
            return replaced;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean deleteLineInFile(File file, String pattern) {
        return FileUtil.deleteLineInFile(file, pattern, 2);
    }

    public static boolean deleteLineInFile(File file, String pattern, int mode) {
        boolean deleteDone = false;
        try {
            File tmpFile = File.createTempFile("deletelineinfile", ".tmp");
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), "UTF-8"));
            String line = null;
            while ((line = in.readLine()) != null) {
                int index = line.indexOf(pattern);
                boolean startsWithIndex = line.trim().startsWith(pattern);
                switch (mode) {
                    case 1: {
                        if (deleteDone || index == -1) {
                            out.write(line);
                            out.newLine();
                            break;
                        }
                        deleteDone = true;
                        break;
                    }
                    case 2: {
                        if (index != -1) break;
                        out.write(line);
                        out.newLine();
                        break;
                    }
                    case 3: {
                        if (deleteDone || !startsWithIndex) {
                            out.write(line);
                            out.newLine();
                            break;
                        }
                        deleteDone = true;
                        break;
                    }
                    case 4: {
                        if (startsWithIndex) break;
                        out.write(line);
                        out.newLine();
                    }
                }
            }
            in.close();
            out.close();
            return FileUtil.copyFile(tmpFile, file, true);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean deleteSectionInFile(File file, String start, String end) {
        try {
            File tmpFile = File.createTempFile("deletesectioninfile", ".tmp");
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), "UTF-8"));
            String line = null;
            boolean isSection = false;
            boolean isSectionValid = false;
            while ((line = in.readLine()) != null) {
                if (!isSection && line.indexOf(start) >= 0) {
                    isSection = true;
                }
                if (!isSection) {
                    out.write(line);
                    out.newLine();
                }
                if (!isSection || line.indexOf(end) < 0) continue;
                isSectionValid = true;
                isSection = false;
            }
            in.close();
            out.close();
            if (isSectionValid) {
                return FileUtil.copyFile(tmpFile, file, true);
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean appendToFile(File file, String text, boolean checkIfExists) {
        try {
            String line;
            File tmpFile = File.createTempFile("appendlineeof", ".tmp");
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), "UTF-8"));
            boolean found = false;
            while ((line = in.readLine()) != null) {
                if (checkIfExists && line.equals(text)) {
                    found = true;
                }
                out.write(line);
                out.newLine();
            }
            in.close();
            if (!found) {
                out.write(text);
                out.newLine();
            }
            out.close();
            return FileUtil.copyFile(tmpFile, file, true);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String findTextInFile(File file, String text) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            while ((line = in.readLine()) != null) {
                if (line.indexOf(text) < 0) continue;
                in.close();
                return line;
            }
            in.close();
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String findPatternInFile(File file, String pattern) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            while ((line = in.readLine()) != null) {
                if (!line.matches(pattern)) continue;
                in.close();
                return line;
            }
            in.close();
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0236", e);
        }
        return null;
    }

    public static boolean replaceTokenInFile(File origFile, File newFile, String token, String value) {
        return FileUtil.replaceTokensInFile(origFile, newFile, new String[]{token}, new String[]{value});
    }

    public static boolean replaceTokenInFile(File file, String token, String value) {
        return FileUtil.replaceTokensInFile(file, file, new String[]{token}, new String[]{value});
    }

    public static boolean replaceTokensInFile(File file, String[] tokens, String[] values) {
        return FileUtil.replaceTokensInFile(file, file, tokens, values);
    }

    private static boolean replaceTokensInFile(File origFile, File newFile, String[] tokens, String[] values) {
        try {
            String line;
            File tmpFile = File.createTempFile("replacetokeninfile", ".tmp");
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(origFile)));
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tmpFile)));
            Pattern[] p = new Pattern[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                p[i] = Pattern.compile(tokens[i]);
            }
            while ((line = in.readLine()) != null) {
                for (int i = 0; i < tokens.length; ++i) {
                    Matcher m = p[i].matcher(line);
                    if (!m.find()) continue;
                    line = m.replaceAll(values[i]);
                }
                out.write(line);
                out.newLine();
            }
            in.close();
            out.close();
            return FileUtil.copyFile(tmpFile, newFile, true);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String replaceToken(String str, String token, String value) {
        Pattern p = Pattern.compile(token);
        Matcher m = p.matcher(str);
        if (m.find()) {
            str = m.replaceAll(value);
        }
        return str;
    }

    public static String decoratePath(String path) {
        if (System.getProperty("os.name").indexOf("indows") != -1 && path != null && path.indexOf(32) >= 0) {
            StringBuffer quotedPath = new StringBuffer("\"" + path + "\"");
            return quotedPath.toString();
        }
        return path;
    }

    public static String getRandomDirName() {
        Random random = new Random();
        String name = "" + Math.abs(random.nextInt());
        return name.substring(0, Math.min(8, name.length()));
    }

    private static byte[] getByteData(InputStream is) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            byte[] byteBuf = new byte[1024];
            int num = 0;
            while ((num = is.read(byteBuf)) != -1) {
                os.write(byteBuf, 0, num);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return os.toByteArray();
    }

    public static boolean copyFile(File fromFile, File toFile, boolean deleteSourceFile) {
        try {
            File parent = toFile.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            FileInputStream fis = new FileInputStream(fromFile);
            byte[] b = FileUtil.getByteData(fis);
            fis.close();
            FileOutputStream fout = new FileOutputStream(toFile);
            fout.write(b);
            fout.close();
            return deleteSourceFile ? fromFile.delete() : true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static File extractFileFromJar(String jarPath, String filePath) throws IOException, FileNotFoundException {
        String fileName;
        int extIdx;
        JarFile jar = new JarFile(jarPath);
        ZipEntry entry = jar.getEntry(filePath);
        if (null == entry) {
            throw new FileNotFoundException("file:" + filePath + " not in jar file:" + jarPath);
        }
        InputStream inputstream = jar.getInputStream(entry);
        int leafIdx = filePath.lastIndexOf("/");
        if (leafIdx < 0) {
            leafIdx = 0;
        }
        String pfx = (extIdx = (fileName = filePath.substring(leafIdx + 1)).indexOf(46)) > 0 ? fileName.substring(0, extIdx) : fileName;
        String sfx = extIdx > 0 ? fileName.substring(extIdx + 1) : null;
        File extract = File.createTempFile(pfx, sfx);
        FileOutputStream fileoutputstream = new FileOutputStream(extract);
        int length = 0;
        byte[] buffer = new byte[2048];
        while (-1 != length) {
            length = inputstream.read(buffer);
            if (length <= 0) continue;
            fileoutputstream.write(buffer, 0, length);
        }
        inputstream.close();
        fileoutputstream.close();
        jar.close();
        return extract;
    }

    public static void extractJar(String jarPath, String targetPath) throws IOException {
        JarFile jar = new JarFile(jarPath);
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory()) {
                FileUtil.makeDir(targetPath + File.separator + entry.getName());
                continue;
            }
            InputStream inputstream = jar.getInputStream(entry);
            File extract = new File(targetPath + File.separator + entry.getName());
            FileOutputStream fileoutputstream = new FileOutputStream(extract);
            int length = 0;
            byte[] buffer = new byte[2048];
            while (-1 != length) {
                length = inputstream.read(buffer);
                if (length <= 0) continue;
                fileoutputstream.write(buffer, 0, length);
            }
            inputstream.close();
            fileoutputstream.close();
        }
        jar.close();
    }

    public static String extractPatternTillEOL(File file, String key, String separator) {
        String rline = "";
        String answer = "";
        try {
            BufferedReader inBuff = new BufferedReader(new FileReader(file));
            while ((rline = inBuff.readLine()) != null) {
                if (rline.indexOf(key) < 0) continue;
                answer = rline.substring(rline.indexOf(separator) + 1);
                answer = answer.trim();
                break;
            }
        }
        catch (Exception e) {
            FileUtil.debug("Error in extracting pattern.");
        }
        return answer;
    }

    public static String getAttributeValue(File sXMLFile, String xpath, String attr) {
        String attrValue = "";
        String[] childElements = xpath.split("/");
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setValidation(false);
            Document doc = builder.build(sXMLFile);
            Element current = doc.getRootElement();
            String name = "";
            List children = null;
            Iterator iterator = null;
            block3: for (int i = 0; i < childElements.length; ++i) {
                children = current.getChildren();
                iterator = children.iterator();
                while (iterator.hasNext()) {
                    Element child = (Element)iterator.next();
                    name = child.getName();
                    if (!name.equals(childElements[i])) continue;
                    current = child;
                    continue block3;
                }
            }
            attrValue = current.getAttributeValue(attr);
        }
        catch (IOException e) {
        }
        catch (JDOMException e) {
            // empty catch block
        }
        return attrValue;
    }

    public static String createPasswordFile(String data) {
        String passwordFilePath = null;
        Random randomNo = new Random();
        StringBuffer fileData = new StringBuffer();
        fileData.append(data);
        try {
            File passwordFile = File.createTempFile("" + randomNo.nextLong(), "" + randomNo.nextLong());
            passwordFilePath = passwordFile.getAbsolutePath();
            FileWriter fwriter = new FileWriter(passwordFile);
            fwriter.write(fileData.toString());
            fwriter.close();
        }
        catch (IOException ioe) {
            configLogger.log(Level.INFO, "PSFB_CSPFC0209", ioe);
        }
        return passwordFilePath;
    }

    public static String getQuotedKeyValueInText(String key, String text) {
        String keyQuotedValSepRegex;
        String keyValStr;
        String[] tokens;
        if (text == null || text.equals("")) {
            return null;
        }
        int idx = text.indexOf(key);
        if (idx >= 0 && (tokens = (keyValStr = text.substring(idx)).split(keyQuotedValSepRegex = "=\\s*\"|\"\\s+", 3)).length >= 2) {
            return tokens[1];
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

