/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.util;

import com.sun.portal.fabric.util.StreamLogger;
import com.sun.portal.log.common.PortalLogger;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class ExecuteUtil {
    private Logger logger = null;
    private boolean storeOutput = false;
    private boolean storeError = false;
    private String execOutput = null;
    private String execError = null;
    static /* synthetic */ Class class$com$sun$portal$fabric$util$ExecuteUtil;

    public ExecuteUtil(Logger logger) {
        this.logger = logger != null ? logger : PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$util$ExecuteUtil == null ? (class$com$sun$portal$fabric$util$ExecuteUtil = ExecuteUtil.class$("com.sun.portal.fabric.util.ExecuteUtil")) : class$com$sun$portal$fabric$util$ExecuteUtil));
    }

    public void storeOutput(boolean preserve) {
        this.storeOutput = preserve;
    }

    public void storeError(boolean preserve) {
        this.storeError = preserve;
    }

    public String getError() {
        return this.execError;
    }

    public String getOutput() {
        return this.execOutput;
    }

    public int exec(String command, String[] args) {
        return this.exec(command, args, null);
    }

    public int exec(String command, String[] args, String[] envs) {
        int exitVal;
        block17: {
            exitVal = -1;
            this.execOutput = null;
            this.execError = null;
            int size = args == null ? 1 : 1 + args.length;
            File parent = new File(command).getParentFile();
            if (System.getProperty("os.name").indexOf("indows") != -1) {
                size += parent == null ? 2 : 7;
            }
            String[] cmdList = new String[size];
            if (System.getProperty("os.name").indexOf("indows") != -1) {
                if (parent == null) {
                    cmdList[0] = "cmd";
                    cmdList[1] = "/c";
                    cmdList[2] = command;
                    if (args != null) {
                        for (int i = 0; i < args.length; ++i) {
                            cmdList[i + 3] = args[i];
                        }
                    }
                } else {
                    String cmdDir = null;
                    try {
                        cmdDir = parent.getCanonicalPath();
                    }
                    catch (IOException ioe) {
                        cmdDir = "c:";
                    }
                    cmdList[0] = "cmd";
                    cmdList[1] = "/c";
                    cmdList[2] = cmdDir.substring(0, 2);
                    cmdList[3] = "&&";
                    cmdList[4] = "cd";
                    cmdList[5] = cmdDir.substring(2);
                    cmdList[6] = "&&";
                    cmdList[7] = command;
                    if (args != null) {
                        for (int i = 0; i < args.length; ++i) {
                            cmdList[i + 8] = args[i];
                        }
                    }
                }
            } else {
                cmdList[0] = command;
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        cmdList[i + 1] = args[i];
                    }
                }
            }
            try {
                Runtime rt = Runtime.getRuntime();
                Process proc = rt.exec(cmdList, envs);
                StreamLogger procOutputLogger = new StreamLogger(proc.getInputStream(), command + "(Output)", this.logger, this.storeOutput);
                procOutputLogger.run();
                StreamLogger procErrorLogger = new StreamLogger(proc.getErrorStream(), command + "(Error)", this.logger, this.storeError);
                procErrorLogger.run();
                exitVal = this.waitFor(proc);
                this.closeStreams(proc);
                if (this.storeOutput) {
                    this.execOutput = procOutputLogger.getContent();
                }
                if (this.storeError) {
                    this.execError = procErrorLogger.getContent();
                }
            }
            catch (IOException e) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block17;
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFU0003");
                record.setParameters(new String[]{command});
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
        }
        return exitVal;
    }

    private int waitFor(Process process) {
        int exitValue = -1;
        try {
            process.waitFor();
            exitValue = process.exitValue();
        }
        catch (InterruptedException e) {
            process.destroy();
        }
        return exitValue;
    }

    private void closeStreams(Process process) {
        try {
            process.getInputStream().close();
        }
        catch (IOException eyeOhEx) {
            // empty catch block
        }
        try {
            process.getOutputStream().close();
        }
        catch (IOException eyeOhEx) {
            // empty catch block
        }
        try {
            process.getErrorStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

