/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.util;

import com.sun.portal.util.ResourceLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class ClasspathGenUtil {
    private static final String fs = File.separator;
    private static final String SEPARATOR = "/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getClasspath(String inputfile, boolean bReplaceTokens) {
        BufferedReader reader = null;
        StringBuffer cpStrBuf = new StringBuffer();
        ResourceLoader rcl = ResourceLoader.getInstance();
        Properties psConfig = rcl.getProperties("PSConfig.properties");
        InputStream ins = rcl.getResourceAsStream(inputfile);
        InputStreamReader insr = new InputStreamReader(ins);
        reader = new BufferedReader(insr);
        String line = null;
        while ((line = reader.readLine()) != null) {
            line.trim();
            if (line.length() < 1 || line.startsWith("#")) continue;
            if (bReplaceTokens) {
                line = ClasspathGenUtil.processClasspathEntry(line, psConfig);
            }
            cpStrBuf.append(line);
            cpStrBuf.append(File.pathSeparator);
        }
        Object var10_11 = null;
        if (reader == null) return cpStrBuf.toString();
        try {
            reader.close();
            return cpStrBuf.toString();
        }
        catch (IOException ioe) {}
        return cpStrBuf.toString();
        {
            catch (FileNotFoundException fex) {
                Object var10_12 = null;
                if (reader == null) return cpStrBuf.toString();
                try {
                    reader.close();
                    return cpStrBuf.toString();
                }
                catch (IOException ioe) {}
                return cpStrBuf.toString();
            }
            catch (IOException ioex) {
                Object var10_13 = null;
                if (reader == null) return cpStrBuf.toString();
                try {
                    reader.close();
                    return cpStrBuf.toString();
                }
                catch (IOException ioe) {}
                return cpStrBuf.toString();
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static String processClasspathEntry(String entry, Properties psConfig) {
        String tag = "";
        String value = "";
        int index = entry.indexOf(SEPARATOR);
        tag = index > 0 ? entry.substring(0, index) : entry;
        value = psConfig.getProperty(tag);
        if (value != null && value.length() > 1) {
            entry = entry.replaceFirst(tag, value);
        }
        entry = entry.replaceAll(SEPARATOR, fs);
        return entry;
    }

    public static String tagSwapClasspath(String taggedClasspath) {
        StringBuffer cpStrBuf = new StringBuffer();
        try {
            ResourceLoader rcl = ResourceLoader.getInstance();
            Properties psConfig = rcl.getProperties("PSConfig.properties");
            String[] cpElement = taggedClasspath.split(":");
            for (int idx = 0; idx < cpElement.length; ++idx) {
                String entry = cpElement[idx];
                entry.trim();
                if (entry.length() <= 0) continue;
                entry = ClasspathGenUtil.processClasspathEntry(entry, psConfig);
                cpStrBuf.append(entry);
                cpStrBuf.append(File.pathSeparator);
            }
        }
        catch (FileNotFoundException fex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cpStrBuf.toString();
    }
}

