/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.util;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.util.SSOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AMUtil
extends SSOUtil {
    private static final String FS = File.separator;
    private static String ORG_NAMING_ATTR = "o";
    private static String ROLE_NAMING_ATTR = "cn";
    private static String PEOPLE_CONTAINER = "ou=People";
    private static String USER_NAMING_ATTR = "uid";
    private static final String LOCALE_SERVICE = "sunIdentityLocaleService";
    private static final String VERSION = "1.0";
    private static final String RB_CONFIG_ID = "ResourceBundleName";
    private static final String LOCALE_CONFIG_ID = "Locale";
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$util$AMUtil == null ? (class$com$sun$portal$fabric$util$AMUtil = AMUtil.class$("com.sun.portal.fabric.util.AMUtil")) : class$com$sun$portal$fabric$util$AMUtil));
    static /* synthetic */ Class class$com$sun$portal$fabric$util$AMUtil;

    public static void loadServiceSchema(Set filePaths, SSOToken ssoToken) {
        try {
            ServiceManager sm = new ServiceManager(ssoToken);
            if (sm != null && filePaths != null) {
                filePaths.remove(null);
                Iterator itr = filePaths.iterator();
                while (itr.hasNext()) {
                    String schemaXMLPath = (String)itr.next();
                    try {
                        FileInputStream fis = new FileInputStream(schemaXMLPath);
                        sm.registerServices((InputStream)fis);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed loading Service", e);
                    }
                }
            }
        }
        catch (SSOException ssoe) {
            logger.log(Level.SEVERE, "Failed loading Services", ssoe);
        }
        catch (SMSException smse) {
            logger.log(Level.SEVERE, "Failed loading Services", smse);
        }
    }

    public static void deleteServiceSchema(Set svcNames, SSOToken ssoToken) {
        try {
            ServiceManager sm = new ServiceManager(ssoToken);
            if (sm != null && svcNames != null) {
                svcNames.remove(null);
                Iterator itr = svcNames.iterator();
                while (itr.hasNext()) {
                    String svcName = (String)itr.next();
                    try {
                        sm.removeService(svcName, VERSION);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed loading Service", e);
                    }
                }
            }
        }
        catch (SSOException ssoe) {
            logger.log(Level.SEVERE, "Failed loading Services", ssoe);
        }
        catch (SMSException smse) {
            logger.log(Level.SEVERE, "Failed loading Services", smse);
        }
    }

    public static String getOrgNamingAttribute(SSOToken AMSSOToken) throws SSOException {
        return AMUtil.getNamingAttribute(AMSSOToken, 2, ORG_NAMING_ATTR);
    }

    public static String getRoleNamingAttribute(SSOToken AMSSOToken) throws SSOException {
        return AMUtil.getNamingAttribute(AMSSOToken, 6, ROLE_NAMING_ATTR);
    }

    public static String getUserNamingAttribute(SSOToken AMSSOToken) throws SSOException {
        return AMUtil.getNamingAttribute(AMSSOToken, 1, USER_NAMING_ATTR);
    }

    public static String getPeopleContainerNamingAttribute(SSOToken AMSSOToken) throws SSOException {
        return AMUtil.getNamingAttribute(AMSSOToken, 5, PEOPLE_CONTAINER);
    }

    public static void addResourceBundle(String rbName, String locale, Map resourceStrings, SSOToken token) {
        if (rbName == null) {
            return;
        }
        try {
            if (resourceStrings != null && !resourceStrings.isEmpty()) {
                ServiceConfigManager scm = new ServiceConfigManager(token, LOCALE_SERVICE, VERSION);
                ServiceConfig globalConfig = scm.getGlobalConfig(null);
                ServiceConfig rbConfig = globalConfig.getSubConfig(rbName);
                if (rbConfig == null) {
                    globalConfig.addSubConfig(rbName, RB_CONFIG_ID, 0, new HashMap());
                    rbConfig = globalConfig.getSubConfig(rbName);
                }
                if (locale == null) {
                    rbConfig.setAttributes(resourceStrings);
                } else {
                    ServiceConfig localeConfig = rbConfig.getSubConfig(locale);
                    if (localeConfig == null) {
                        rbConfig.addSubConfig(locale, LOCALE_CONFIG_ID, 0, resourceStrings);
                        localeConfig = rbConfig.getSubConfig(locale);
                    } else {
                        localeConfig.setAttributes(resourceStrings);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed loading ResouceBundle", e);
        }
    }

    public static void removeResourceBundle(String rbName, String locale, SSOToken token) {
        if (rbName == null) {
            return;
        }
        try {
            ServiceConfigManager scm = new ServiceConfigManager(token, LOCALE_SERVICE, VERSION);
            ServiceConfig globalConfig = scm.getGlobalConfig(null);
            if (locale == null) {
                globalConfig.removeSubConfig(rbName);
            } else {
                ServiceConfig rbConfig = globalConfig.getSubConfig(rbName);
                if (rbConfig != null) {
                    rbConfig.removeSubConfig(locale);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed removing ResouceBundle", e);
        }
    }

    private static String getNamingAttribute(SSOToken ssoToken, int type, String def) throws SSOException {
        AMStoreConnection amsc;
        try {
            amsc = new AMStoreConnection(ssoToken);
        }
        catch (SSOException e) {
            logger.log(Level.SEVERE, "PSFB_CSPFU0009", e);
            throw e;
        }
        String value = def;
        if (amsc != null) {
            try {
                value = AMStoreConnection.getNamingAttribute((int)type);
            }
            catch (AMException ame) {
                value = def;
            }
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

