/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.util;

import com.sun.portal.fabric.util.ExecuteUtil;
import com.sun.portal.fabric.util.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AMTaskUtil {
    private static final String fs = File.separator;
    private String command;
    private String amAdminDN;
    private String amAdminPassword;
    private File amPasswordFile = null;
    private String amPasswordMode = null;
    private String amPasswordData;
    private Logger logger;
    private ExecuteUtil execUtil;

    public AMTaskUtil(String isBaseDir, String amAdminDN, String amAdminPassword, Logger logger) {
        this.amAdminDN = amAdminDN;
        this.amAdminPassword = amAdminPassword;
        this.logger = logger;
        this.command = isBaseDir + fs + "bin" + fs + "amadmin";
        this.execUtil = new ExecuteUtil(logger);
        this.execUtil.storeOutput(false);
    }

    private void initPasswordData() {
        if (this.amPasswordMode == null) {
            this.amPasswordMode = "--passwordfile";
            try {
                StringBuffer fileData = new StringBuffer();
                fileData.append(this.amAdminPassword);
                Random random = new Random();
                String sTmpFile = "" + random.nextInt();
                this.amPasswordFile = File.createTempFile(sTmpFile, "");
                this.amPasswordFile.deleteOnExit();
                FileWriter fwriter = new FileWriter(this.amPasswordFile);
                fwriter.write(fileData.toString());
                fwriter.close();
                this.amPasswordData = this.amPasswordFile.getAbsolutePath();
            }
            catch (IOException ex) {
                this.logger.log(Level.SEVERE, "Error creating amadmin password file");
                this.amPasswordMode = "--password";
                this.amPasswordData = this.amAdminPassword;
            }
        }
    }

    public void execAMRequests(List requestFiles) {
        if (requestFiles != null && !requestFiles.isEmpty()) {
            this.initPasswordData();
            String[] amAdminArgs = new String[7 + requestFiles.size()];
            amAdminArgs[0] = "--runasdn";
            amAdminArgs[1] = this.amAdminDN;
            amAdminArgs[2] = this.amPasswordMode;
            amAdminArgs[3] = this.amPasswordData;
            amAdminArgs[4] = "--verbose";
            amAdminArgs[5] = "--continue";
            amAdminArgs[6] = "--data";
            Iterator it = requestFiles.iterator();
            int index = 7;
            while (it.hasNext()) {
                amAdminArgs[index] = (String)it.next();
                ++index;
            }
            this.logger.info("Invoking AMAdmin request XMLs: " + requestFiles);
            this.execUtil.exec(this.command, amAdminArgs);
        } else {
            this.logger.info("AMAdmin Requests List is Emtpy");
        }
    }

    public void processRequestXML(String[] tokens, String[] values, List requests, String tmpDir) {
        Iterator itr = requests.iterator();
        ArrayList<String> swappedRequestPaths = new ArrayList<String>();
        String reqTmpDirLoc = tmpDir + fs + FileUtil.getRandomDirName();
        File reqTmpDirDir = new File(reqTmpDirLoc);
        this.logger.log(Level.FINEST, "Creating tmp directory: " + reqTmpDirLoc);
        if (!reqTmpDirDir.mkdirs()) {
            this.logger.log(Level.SEVERE, "Failed creating tmp directory");
        }
        while (itr.hasNext()) {
            String requestFilePath = (String)itr.next();
            File origRequestFile = new File(requestFilePath);
            String origReqName = origRequestFile.getName();
            String xmlReqName = origReqName.replaceAll(".request", ".xml");
            File destRequestFile = new File(reqTmpDirLoc + fs + xmlReqName);
            if (origRequestFile.exists()) {
                this.logger.log(Level.FINEST, "Copying file:" + origRequestFile + " To:" + destRequestFile);
                FileUtil.copyFile(origRequestFile, destRequestFile);
                this.logger.log(Level.FINEST, "Tag Swapping:" + destRequestFile);
                FileUtil.replaceTokensInFile(destRequestFile, tokens, values);
                swappedRequestPaths.add(destRequestFile.getAbsolutePath());
                continue;
            }
            this.logger.log(Level.SEVERE, "Request skipped: " + requestFilePath);
        }
        this.logger.log(Level.FINEST, "Executing tagswapped request XMLs");
        this.execAMRequests(swappedRequestPaths);
        FileUtil.deleteDir(reqTmpDirDir);
    }

    public String execAMRequest(List requestFiles) {
        String result = null;
        if (requestFiles != null && !requestFiles.isEmpty()) {
            this.initPasswordData();
            String[] amAdminArgs = new String[6 + requestFiles.size()];
            amAdminArgs[0] = "--runasdn";
            amAdminArgs[1] = this.amAdminDN;
            amAdminArgs[2] = this.amPasswordMode;
            amAdminArgs[3] = this.amPasswordData;
            amAdminArgs[4] = "--continue";
            amAdminArgs[5] = "--data";
            Iterator it = requestFiles.iterator();
            int index = 6;
            while (it.hasNext()) {
                amAdminArgs[index] = (String)it.next();
                ++index;
            }
            this.logger.info("Invoking AMAdmin request XML: " + requestFiles);
            this.execUtil.storeOutput(true);
            this.execUtil.exec(this.command, amAdminArgs);
            result = this.execUtil.getOutput();
        } else {
            this.logger.info("AMAdmin Requests List is Emtpy");
        }
        return result;
    }
}

