/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.upgrade;

import com.sun.portal.fabric.upgrade.UpgradeException;
import com.sun.portal.fabric.util.ExecuteUtil;
import com.sun.portal.fabric.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.factory.JSSESocketFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UpgradeUtils {
    private static Logger log = null;
    private static ExecuteUtil execUtil = null;
    private static LDAPConnection connection = new LDAPConnection();
    private static FileHandler fh = null;
    private static EraserThread masker = null;
    private static int currentFile = 0;

    public static String getWebContainerType(String version, String ps_deploy_type) {
        String type = null;
        if (version.equals("6.3.1")) {
            if (ps_deploy_type.equals("SUNONE8")) {
                type = "SJSAS81";
            }
            if (ps_deploy_type.equals("IWS")) {
                type = "SJSWS6";
            }
            if (ps_deploy_type.equals("WEBSPHERE")) {
                type = "IBMWAS5";
            }
            if (ps_deploy_type.equals("WEBLOGIC")) {
                type = "BEAWL8";
            }
        }
        return type;
    }

    public static void execAnt(String buildfile, Vector targets, String logfile, String propfile) throws UpgradeException {
        Vector<String> vargs;
        UpgradeUtils.log("Execting Ant for targets " + targets.toString());
        logfile = logfile + "-" + targets.get(0) + ".log";
        File file = new File(buildfile);
        boolean exitVal = false;
        if (file.exists()) {
            vargs = new Vector<String>();
            vargs.add("-buildfile");
            vargs.add(buildfile);
            vargs.add("-logfile");
            vargs.add(logfile);
            if (propfile != null) {
                file = new File(propfile);
                if (!file.exists()) {
                    throw new UpgradeException("Property file:" + propfile + "does not exist");
                }
                vargs.add("-propertyfile");
                vargs.add(propfile);
            }
        } else {
            UpgradeUtils.log("Ant build file " + file + " does not exist.");
            throw new UpgradeException("Ant build file:" + buildfile + "does not exist");
        }
        targets.addAll(vargs);
        String command = System.getProperty("ANT_HOME") + File.separator + "bin" + File.separator + "ant";
        execUtil.storeOutput(false);
        execUtil.exec(command, targets.toArray(new String[0]));
    }

    public static void execAMRequest(Properties prop, String compName, int totalFiles) throws UpgradeException {
        UpgradeUtils.log("Executing Access Manager command line utility for " + compName + " upgrade (" + ++currentFile + " of " + totalFiles + " request" + (totalFiles == 1 ? "" : "s") + ")");
        String command = prop.getProperty("AM_BASEDIR") + File.separator + prop.getProperty("AM_PRODUCT_DIR") + File.separator + "bin" + File.separator + "amadmin";
        String[] args = new String[]{"-u", prop.getProperty("ADMIN_DN"), "-w", prop.getProperty("IDSAME_ADMIN_PASSWORD"), "-v", "-t", prop.getProperty("requestFile")};
        execUtil.storeOutput(true);
        try {
            int exitVal = execUtil.exec(command, args);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "");
                record.setParameters(new String[]{"Request file:", prop.getProperty("requestFile")});
                record.setThrown(e);
                record.setLoggerName(log.getName());
                log.log(record);
            }
            throw new UpgradeException("AM request failed for file " + prop.getProperty("requestFile"), e);
        }
        UpgradeUtils.log("AM Request output : " + execUtil.getOutput());
    }

    public static void execAMResourceBundleRequest(Properties prop, String compName) throws UpgradeException {
        System.out.println("Executing Access Manager command line resource bundle sub command for " + compName + " upgrade ");
        String command = prop.getProperty("AM_BASEDIR") + File.separator + prop.getProperty("AM_PRODUCT_DIR") + File.separator + "bin" + File.separator + "amadmin";
        String[] args = new String[]{"-u", prop.getProperty("ADMIN_DN"), "-w", prop.getProperty("IDSAME_ADMIN_PASSWORD"), "-v", "--addresourcebundle", prop.getProperty("requestFile"), "--resourceName", prop.getProperty("resourceBundleFile")};
        execUtil.storeOutput(true);
        try {
            execUtil.exec(command, args);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "");
                record.setParameters(new String[]{"Request file:", prop.getProperty("resourceBundleFile")});
                record.setThrown(e);
                record.setLoggerName(log.getName());
                log.log(record);
            }
            throw new UpgradeException("Access Manager request failed for file " + prop.getProperty("resourceBundleFile"), e);
        }
        UpgradeUtils.log("Access Manager Resource Bundle Request output : " + execUtil.getOutput());
    }

    public static void execLDAPModify(Properties prop, String compName) throws UpgradeException {
        System.out.println("Executing LDAP Modify command for " + compName + " upgrade ");
        String command = prop.getProperty("AM_BASEDIR") + File.separator + prop.getProperty("AM_PRODUCT_DIR") + File.separator + "bin" + File.separator + "ldapmodify";
        String[] args = new String[]{"-h", prop.getProperty("DS_HOST"), "-p", prop.getProperty("DS_PORT"), "-D", prop.getProperty("DS_DIRMGR_DN"), "-w", prop.getProperty("DS_DIRMGR_PASSWORD"), "-f", prop.getProperty("ldifFile")};
        execUtil.storeOutput(true);
        try {
            execUtil.exec(command, args);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "");
                record.setParameters(new String[]{"LDAP Modify file:", prop.getProperty("ldifFile")});
                record.setThrown(e);
                record.setLoggerName(log.getName());
                log.log(record);
            }
            throw new UpgradeException("LDAP Modify failed for file " + prop.getProperty("ldifFile"), e);
        }
        UpgradeUtils.log("LDAP Modify output : " + execUtil.getOutput());
    }

    public static void preparePSAMBackupScript(Properties prop, File backUpScript) {
        System.out.println("Executing PortalServer Directory server backup..");
        FileUtil.replaceTokenInFile(backUpScript, "AM_BASEDIR", prop.getProperty("AM_BASEDIR"));
        FileUtil.replaceTokenInFile(backUpScript, "AM_PRODUCT_DIR", prop.getProperty("AM_PRODUCT_DIR"));
        FileUtil.replaceTokenInFile(backUpScript, "DS_HOST", prop.getProperty("DS_HOST"));
        FileUtil.replaceTokenInFile(backUpScript, "DS_PORT", prop.getProperty("DS_PORT"));
        FileUtil.replaceTokenInFile(backUpScript, "DS_DIRMGR_DN", prop.getProperty("DS_DIRMGR_DN"));
        FileUtil.replaceTokenInFile(backUpScript, "DS_DIRMGR_PASSWORD", prop.getProperty("DS_DIRMGR_PASSWORD"));
        FileUtil.replaceTokenInFile(backUpScript, "ORG_DN", prop.getProperty("ORG_DN"));
    }

    public static void execPSInstall(Properties prop) throws UpgradeException {
        System.out.println("Executing psinstall command for upgrade ");
        String command = prop.getProperty("psinstallShFile");
        String[] args = new String[]{"-s", prop.getProperty("psinstallFile")};
        execUtil.storeOutput(true);
        try {
            execUtil.exec(command, args);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "");
                record.setParameters(new String[]{"LDAP Modify file:", prop.getProperty("ldifFile")});
                record.setThrown(e);
                record.setLoggerName(log.getName());
                log.log(record);
            }
            throw new UpgradeException("psinstall failed", e);
        }
        UpgradeUtils.log("psinstall output : " + execUtil.getOutput());
    }

    static String parseCertInfo(String certStr, String info) {
        String infoValue = "";
        String[] tokens = certStr.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].startsWith(info + "=")) continue;
            int add = 1;
            if (info.equals("C")) {
                add = 0;
            }
            infoValue = tokens[i].substring(tokens[i].indexOf("=") + (add + 1), tokens[i].length() - add);
        }
        return infoValue;
    }

    static String getLocalSystemIPAddress() {
        String ipAddrStr = "";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            byte[] ipAddr = addr.getAddress();
            for (int i = 0; i < ipAddr.length; ++i) {
                if (i > 0) {
                    ipAddrStr = ipAddrStr + ".";
                }
                ipAddrStr = ipAddrStr + (ipAddr[i] & 0xFF);
            }
            UpgradeUtils.log("IP Address of the System is : " + ipAddrStr);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ipAddrStr;
    }

    static String getStartInstanceStatus(String stat) {
        if (stat.equals("Y")) {
            return "true";
        }
        return "false";
    }

    static String[] returnFileListEndingWith(String dirStr, String startpat, String[] endpatterns) {
        String[] consolidatedFileNamesList = null;
        ArrayList<String> consolidatedFileNamesArrayList = new ArrayList<String>();
        String[] fileslist = null;
        int totalFileCount = 0;
        for (int i = 0; i < endpatterns.length; ++i) {
            fileslist = UpgradeUtils.returnFileListEndingWith(dirStr, startpat, endpatterns[i]);
            totalFileCount += fileslist.length;
            for (int j = 0; j < fileslist.length; ++j) {
                consolidatedFileNamesArrayList.add(fileslist[j]);
            }
        }
        consolidatedFileNamesList = new String[totalFileCount];
        consolidatedFileNamesArrayList.toArray(consolidatedFileNamesList);
        return consolidatedFileNamesList;
    }

    static String[] returnFileListHavingPattern(String dirStr, final String regexpat) {
        File dir = new File(dirStr);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (regexpat != null) {
                    return Pattern.matches(regexpat, name);
                }
                return false;
            }
        };
        File[] children = dir.listFiles(filter);
        String[] filenames = new String[children.length];
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                filenames[i] = children[i].getAbsolutePath();
            }
        }
        return filenames;
    }

    static String[] returnFileListEndingWith(String dirStr, final String startpat, final String endpattern) {
        File dir = new File(dirStr);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (startpat != null && endpattern != null) {
                    return name.startsWith(startpat) && name.endsWith(endpattern);
                }
                if (endpattern != null) {
                    return name.endsWith(endpattern);
                }
                if (startpat != null) {
                    return name.startsWith(startpat);
                }
                return false;
            }
        };
        File[] children = dir.listFiles(filter);
        String[] filenames = new String[children.length];
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                filenames[i] = children[i].getAbsolutePath();
            }
        }
        return filenames;
    }

    static String[] returnFileList(String dirStr, String pat, int matchmode) {
        return null;
    }

    public static void log(String msg) {
        UpgradeUtils.log(1, msg);
    }

    public static void log(int severity, String msg) {
        if (severity == 2) {
            log.warning(msg);
        }
        if (severity == 3) {
            log.severe(msg);
        }
        if (severity == 1) {
            log.info(msg);
        }
        if (severity == 3) {
            log.finest(msg);
        }
    }

    public static boolean removeService(Properties prop, String serviceName) {
        boolean success;
        block3: {
            success = false;
            String command = prop.getProperty("AM_BASEDIR") + File.separator + prop.getProperty("AM_PRODUCT_DIR") + File.separator + "bin" + File.separator + "amadmin";
            String[] args = new String[]{"-u", prop.getProperty("ADMIN_DN"), "-w", prop.getProperty("IDSAME_ADMIN_PASSWORD"), "-r", serviceName};
            execUtil.storeOutput(true);
            try {
                execUtil.exec(command, args);
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.SEVERE)) break block3;
                LogRecord record = new LogRecord(Level.SEVERE, "");
                record.setParameters(new String[]{"Service remove request name:", serviceName});
                record.setThrown(e);
                record.setLoggerName(log.getName());
                log.log(record);
            }
        }
        String output = execUtil.getOutput();
        UpgradeUtils.log("AM Service remove request output : " + output);
        if (output.indexOf("Success") != -1) {
            success = true;
        }
        return success;
    }

    public static boolean isRPMInstalled(String rpm) {
        boolean success = false;
        String command = "rpm";
        String[] args = new String[]{"-q", rpm};
        execUtil.storeOutput(true);
        execUtil.exec(command, args);
        String result = execUtil.getOutput();
        UpgradeUtils.log("RPM Query Output for " + rpm + " is " + result);
        success = result != null && result.startsWith(rpm);
        return success;
    }

    public static boolean isSunOSPatchApplied(String patchID) {
        boolean success = false;
        String command = "patchadd";
        String[] args = new String[]{"-p"};
        execUtil.storeOutput(true);
        execUtil.exec(command, args);
        String result = execUtil.getOutput();
        String[] tokens = result.split("\n");
        int len = tokens.length;
        for (int i = 0; i < len; ++i) {
            if (tokens[i].indexOf("Patch: " + patchID) == -1) continue;
            success = true;
            break;
        }
        UpgradeUtils.log("Patch " + patchID + " found=" + success);
        return success;
    }

    public static boolean isLinuxPatchApplied(String patchID) {
        boolean success = false;
        String[] tokens = patchID.split(":");
        String ID = tokens[0];
        for (int i = 1; i < tokens.length && (success = UpgradeUtils.isRPMInstalled(tokens[0], true)); ++i) {
        }
        UpgradeUtils.log("Patch " + ID + " found=" + success);
        return success;
    }

    public static boolean isRPMInstalled(String rpm, boolean checkVersion) {
        boolean success = false;
        String[] tokens = rpm.split("-");
        String rpmName = "";
        for (int i = 0; i < tokens.length - 2; ++i) {
            rpmName = rpmName + tokens[i] + "-";
        }
        boolean rpmInstalled = UpgradeUtils.isRPMInstalled(rpmName = rpmName.substring(0, rpmName.length() - 1));
        if (rpmInstalled) {
            int i;
            String command = "rpm";
            String[] args = new String[]{"-q", "--queryformat", "RELEASE=%{RELEASE}", rpmName};
            execUtil.storeOutput(true);
            execUtil.exec(command, args);
            String release = execUtil.getOutput();
            args[2] = "VERSION=%{VERSION}";
            execUtil.storeOutput(true);
            execUtil.exec(command, args);
            String version = execUtil.getOutput();
            version = version != null && version.startsWith("VERSION=") ? version.trim().substring(8) : "";
            int releaseInt = 0;
            if (release != null && release.startsWith("RELEASE=")) {
                release = release.trim().substring(8, 10);
                releaseInt = new Integer(release);
            }
            String[] givenVersionConstituents = tokens[tokens.length - 2].split("\\.");
            String[] givenReleaseConstituents = tokens[tokens.length - 1].split("\\.");
            String[] installedVersionConstituents = version.split("\\.");
            String[] installedReleaseConstituents = release.split("\\.");
            success = true;
            for (i = 0; i < givenVersionConstituents.length; ++i) {
                if (installedVersionConstituents[i] == null || Integer.parseInt(installedVersionConstituents[i]) >= Integer.parseInt(givenVersionConstituents[i])) continue;
                success = false;
                break;
            }
            if (success) {
                for (i = 0; i < givenReleaseConstituents.length; ++i) {
                    if (installedVersionConstituents[i] == null || Integer.parseInt(installedReleaseConstituents[i]) >= Integer.parseInt(givenReleaseConstituents[i])) continue;
                    success = false;
                    break;
                }
            }
        }
        UpgradeUtils.log("RPM " + rpm + "of same or higher version found :" + success);
        return success;
    }

    public static boolean isPackageInstalled(String pkg) {
        String command = "/bin/pkginfo";
        execUtil.storeOutput(true);
        execUtil.exec(command, null);
        String result = execUtil.getOutput();
        UpgradeUtils.log("Checking for installed package  " + pkg);
        String[] tokens = result.split("\n");
        int len = tokens.length;
        for (int i = 0; i < len; ++i) {
            String pkginfoFilePath;
            File pkginfoFile;
            if (tokens[i].indexOf(pkg) == -1 || !(pkginfoFile = new File(pkginfoFilePath = "/var/sadm/pkg/" + pkg + "/pkginfo")).exists()) continue;
            UpgradeUtils.log("Found package:" + pkg);
            return true;
        }
        return false;
    }

    static void removeLogHandler() {
        if (fh != null) {
            fh.close();
        }
    }

    public static boolean hasCommandOption(String[] args, String opt) {
        boolean ret = false;
        if (args != null) {
            for (int i = 1; i < args.length; ++i) {
                if (!args[i].equalsIgnoreCase(opt)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static String getCommandOptionValue(String[] args, String opt) {
        String ret = null;
        if (args != null) {
            for (int i = 1; i < args.length; ++i) {
                if (!args[i].equalsIgnoreCase(opt)) continue;
                ret = args[i + 1];
                break;
            }
        }
        return ret;
    }

    public static void setLogger(Logger logger) {
        log = logger;
    }

    public static void setExecUtil(ExecuteUtil exec) {
        execUtil = exec;
    }

    boolean isWebContainerServerRunning() {
        return false;
    }

    static boolean isDirectoryServerRunning(String host, int port) {
        try {
            connection.connect(host, port);
            connection.disconnect();
        }
        catch (LDAPException e) {
            return false;
        }
        return true;
    }

    static boolean isDirectoryManagerCredentialValid(String host, int port, String DN, String password) {
        return UpgradeUtils.validateCredentials(host, port, DN, password);
    }

    static boolean isAccessManagerAdminCredentialValid(String host, int port, String DN, String password) {
        return UpgradeUtils.validateCredentials(host, port, DN, password);
    }

    static boolean isAccessManagerLDAPUserCredentialValid(String host, int port, String DN, String password) {
        return UpgradeUtils.validateCredentials(host, port, DN, password);
    }

    static boolean validateCredentials(String host, int port, String userName, String credentials) {
        try {
            connection.connect(host, port);
            connection.authenticate(userName, credentials);
            connection.disconnect();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static String promptUser(String s) {
        String[] args = new String[]{s};
        String command = "/bin/echo";
        execUtil.exec(command, args);
        String resp = UpgradeUtils.readUserResponse();
        if (resp == null) {
            resp = "";
        }
        return resp;
    }

    static String readUserResponse() {
        BufferedReader myIn = new BufferedReader(new InputStreamReader(System.in));
        String s = null;
        try {
            s = myIn.readLine();
        }
        catch (IOException e) {
            System.err.println("Error reading input from user ");
        }
        return s;
    }

    public static String getPatchKey() {
        if (System.getProperty("os.name").indexOf("SunOS") != -1 && System.getProperty("os.arch").indexOf("sparc") != -1) {
            return "solaris.sparc.patches";
        }
        if (System.getProperty("os.name").indexOf("Linux") != -1) {
            return "linux.x86.patches";
        }
        return "solaris.x86.patches";
    }

    public static String readInput(String prompt) {
        if (prompt != null) {
            System.out.print(prompt);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String input = "";
        try {
            input = in.readLine();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return input;
    }

    public static String readPassword(String prompt) {
        masker = new EraserThread(prompt);
        Thread mask = new Thread(masker);
        mask.setPriority(10);
        mask.start();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String password = "";
        try {
            password = in.readLine();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        masker.stopMasking();
        masker = null;
        return password;
    }

    public static void getAMSpecialUsersDN() {
    }

    public static String getPSBaseDirOnLinux() {
        String command = "rpm";
        String[] args = new String[]{"-q", "--queryformat", "BASEDIR=%{INSTALLPREFIX}", "sun-portal-configurator"};
        execUtil.storeOutput(true);
        execUtil.exec(command, args);
        String result = execUtil.getOutput();
        UpgradeUtils.log("RPM query results PS Base directory=" + result);
        result = result != null && result.startsWith("BASEDIR=") ? result.trim().substring(8) : null;
        UpgradeUtils.log("PS BASEDIR is " + result);
        return result;
    }

    public static String getAMBaseDirOnLinux() {
        String command = "rpm";
        String[] args = new String[]{"-q", "--queryformat", "BASEDIR=%{INSTALLPREFIX}", "sun-identity-sdk"};
        execUtil.storeOutput(true);
        execUtil.exec(command, args);
        String result = execUtil.getOutput();
        UpgradeUtils.log("RPM query results AM Base directory=" + result);
        result = result != null && result.startsWith("BASEDIR=") ? result.trim().substring(8) : null;
        UpgradeUtils.log("AM BASEDIR is " + result);
        return result;
    }

    static String getPSVersion(String psProdDir, boolean psInstalled) {
        String version = null;
        String propFile = psInstalled ? "PSversion.properties" : "SRAversion.properties";
        String versionProperty = psInstalled ? "productversion" : "version";
        Properties versionProp = new Properties();
        try {
            versionProp.load(new FileInputStream(new File(psProdDir + File.separator + "lib" + File.separator + propFile)));
            version = versionProp.getProperty(versionProperty);
            UpgradeUtils.log("Detected PS/SRA Version as " + version);
        }
        catch (Exception e) {
            UpgradeUtils.log("Error in detecting the PS/SRA version:" + e);
        }
        return version;
    }

    static String getPSVersionOnLinux() {
        String command = "rpm";
        String[] args = new String[]{"-q", "--queryformat", "RELEASE=%{RELEASE}", "sun-portal-configurator"};
        execUtil.storeOutput(true);
        execUtil.exec(command, args);
        String release = execUtil.getOutput();
        UpgradeUtils.log("RPM query result for release=" + release);
        args[2] = "VERSION=%{VERSION}";
        execUtil.storeOutput(true);
        execUtil.exec(command, args);
        String version = execUtil.getOutput();
        UpgradeUtils.log("RPM query result for version=" + version);
        version = version != null && version.startsWith("VERSION=") ? version.trim().substring(8) : "";
        UpgradeUtils.log("version=" + version);
        int releaseInt = 0;
        if (release != null && release.startsWith("RELEASE=")) {
            release = release.trim().substring(8, 10);
            releaseInt = new Integer(release);
        }
        UpgradeUtils.log("release=" + releaseInt);
        if (version.startsWith("6.3") && releaseInt <= 25) {
            return "6.3.1";
        }
        return "JES4";
    }

    public static String getGatewayJDKDir(String gwConfigPropFileDir) throws IOException {
        Properties prop = null;
        String jdkdir = null;
        String[] platformConfs = UpgradeUtils.returnFileListHavingPattern(gwConfigPropFileDir, "^platform.conf.\\w*$");
        for (int i = 0; i < platformConfs.length; ++i) {
            prop = new Properties();
            prop.load(new FileInputStream(platformConfs[i]));
            jdkdir = prop.getProperty("gateway.jdk.dir");
            if (jdkdir != null) break;
        }
        return jdkdir;
    }

    public static void addSRAElementNodes(File sXMLFile, String xpath, String elementNodeName, String[] platformConfs, String sraLogPassword, String startInstanceStatus) throws IOException, JDOMException {
        org.jdom.Element rootElement;
        String[] childElements = xpath.split("/");
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        doc = builder.build(sXMLFile);
        org.jdom.Element rootElementCopy = rootElement = doc.getRootElement();
        for (int i = 0; i < childElements.length; ++i) {
            rootElementCopy = rootElementCopy.getChild(childElements[i]);
        }
        Properties prop = null;
        String profile = "portal.server.instance";
        String protocol = "gateway.protocol";
        String host = "gateway.host";
        String port = "gateway.port";
        String ipaddress = "gateway.bindipaddress";
        if (elementNodeName.equals("NetletProxy")) {
            port = "netletproxy.port";
        } else if (elementNodeName.equals("RewriterProxy")) {
            port = "rewriterproxy.port";
        }
        org.jdom.Element[] SRAComponentNode = new org.jdom.Element[platformConfs.length];
        org.jdom.Element[] SRAInstance = new org.jdom.Element[platformConfs.length];
        for (int i = 0; i < platformConfs.length; ++i) {
            UpgradeUtils.log("platform conf files " + i + " = " + platformConfs[i]);
            prop = new Properties();
            prop.load(new FileInputStream(platformConfs[i]));
            SRAComponentNode[i] = new org.jdom.Element(elementNodeName);
            String profileName = prop.getProperty(profile);
            if (profileName == null) continue;
            SRAComponentNode[i].setAttribute("Profile", profileName);
            SRAInstance[i] = new org.jdom.Element("SRAInstance");
            SRAInstance[i].setAttribute("Protocol", prop.getProperty(protocol));
            SRAInstance[i].setAttribute("Host", prop.getProperty(host));
            SRAInstance[i].setAttribute("Port", prop.getProperty(port));
            SRAInstance[i].setAttribute("IPAddress", prop.getProperty(ipaddress));
            SRAInstance[i].setAttribute("LogUserPassword", sraLogPassword);
            SRAInstance[i].setAttribute("StartInstance", startInstanceStatus);
            SRAComponentNode[i].addContent("\n  ");
            SRAComponentNode[i].addContent("    ");
            SRAComponentNode[i].addContent((Content)SRAInstance[i]);
            SRAComponentNode[i].addContent("\n  ");
            rootElementCopy.addContent((Content)SRAComponentNode[i]);
            rootElementCopy.addContent("\n  ");
        }
        XMLOutputter serializer = new XMLOutputter();
        serializer.output(doc, (Writer)new FileWriter(sXMLFile));
    }

    static void addSRACertificateInfoElement(File sXMLFile, String xpath, String CERT_INFO, String CERT_DB_PASSWORD) throws IOException, JDOMException {
        org.jdom.Element rootElement;
        String[] childElements = xpath.split("/");
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        doc = builder.build(sXMLFile);
        org.jdom.Element SRACertificateInfoParentElement = rootElement = doc.getRootElement();
        for (int i = 0; i < childElements.length; ++i) {
            SRACertificateInfoParentElement = SRACertificateInfoParentElement.getChild(childElements[i]);
        }
        org.jdom.Element SRACert = new org.jdom.Element("CertificateInformation");
        SRACert.setAttribute("Organization", UpgradeUtils.parseCertInfo(CERT_INFO, "OU"));
        SRACert.setAttribute("Division", UpgradeUtils.parseCertInfo(CERT_INFO, "O"));
        SRACert.setAttribute("CityOrLocality", UpgradeUtils.parseCertInfo(CERT_INFO, "L"));
        SRACert.setAttribute("StateProvince", UpgradeUtils.parseCertInfo(CERT_INFO, "ST"));
        SRACert.setAttribute("CountryCode", UpgradeUtils.parseCertInfo(CERT_INFO, "C"));
        SRACert.setAttribute("CertificateDatabasePassword", CERT_DB_PASSWORD);
        SRACertificateInfoParentElement.addContent("\n  ");
        SRACertificateInfoParentElement.addContent((Content)SRACert);
        SRACertificateInfoParentElement.addContent("\n  ");
        XMLOutputter serializer = new XMLOutputter();
        serializer.output(doc, (Writer)new FileWriter(sXMLFile));
    }

    static void processDPUpdates(File dp, File dpChanges, String type) {
        String dpInstruction = null;
        String[] dpInstructionParsed = null;
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            org.w3c.dom.Document document = builder.parse(dp);
            XPath xpath = XPathFactory.newInstance().newXPath();
            boolean i = false;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(dpChanges)));
            while ((dpInstruction = in.readLine()) != null) {
                dpInstructionParsed = dpInstruction.split("::");
                if (dpInstructionParsed == null || dpInstructionParsed.length <= 1) continue;
                String xp = dpInstructionParsed[0];
                if (dpInstructionParsed[0].equalsIgnoreCase(type + "_DP_MODIFYNODE")) {
                    String attrValue = "";
                    if (dpInstructionParsed.length == 4) {
                        attrValue = dpInstructionParsed[3];
                    }
                    UpgradeUtils.modifyNode(document, dpInstructionParsed[1], dpInstructionParsed[2], attrValue, dp.getAbsolutePath());
                    continue;
                }
                if (dpInstructionParsed[0].equalsIgnoreCase(type + "_DP_ADDNODE")) {
                    UpgradeUtils.addNode(document, dpInstructionParsed[1], dpInstructionParsed[2], dp.getAbsolutePath());
                    continue;
                }
                if (!dpInstructionParsed[0].equalsIgnoreCase(type + "_DP_DELETENODE")) continue;
                UpgradeUtils.deleteNode(document, dpInstructionParsed[1], dp.getAbsolutePath());
            }
        }
        catch (Exception e) {
            UpgradeUtils.log("DP change exception " + e);
        }
    }

    private static void modifyNode(org.w3c.dom.Document document, String xp, String attr, String val, String outputFile) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            Element dummyNode = (Element)xpath.evaluate(xp, document, XPathConstants.NODE);
            NodeList matchedNodes = (NodeList)xpath.evaluate(xp, document, XPathConstants.NODESET);
            int no_of_matched_nodes = 0;
            if (matchedNodes != null) {
                no_of_matched_nodes = matchedNodes.getLength();
            }
            Element[] selectedNode = new Element[no_of_matched_nodes];
            if (no_of_matched_nodes > 0) {
                dummyNode.setAttribute(attr, val);
                for (int i = 0; i < no_of_matched_nodes; ++i) {
                    selectedNode[i] = (Element)matchedNodes.item(i);
                    selectedNode[i].setAttribute(attr, val);
                }
            }
            TransformerFactory xformFactory = TransformerFactory.newInstance();
            Transformer idTransform = xformFactory.newTransformer();
            DOMSource input = new DOMSource(document);
            FileOutputStream fs = new FileOutputStream(outputFile);
            StreamResult output = new StreamResult(fs);
            idTransform.transform(input, output);
            fs.flush();
            fs.close();
        }
        catch (Exception e) {
            UpgradeUtils.log("" + e);
        }
    }

    private static void addNode(org.w3c.dom.Document document, String xp, String element, String outputFile) {
        DocumentFragment frag = UpgradeUtils.getXmlNode(document, element);
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            Element dummyNode = (Element)xpath.evaluate(xp, document, XPathConstants.NODE);
            NodeList matchedNodes = (NodeList)xpath.evaluate(xp, document, XPathConstants.NODESET);
            int no_of_matched_nodes = 0;
            if (matchedNodes != null) {
                no_of_matched_nodes = matchedNodes.getLength();
            }
            Element[] selectedNode = new Element[no_of_matched_nodes];
            if (no_of_matched_nodes > 0) {
                dummyNode.appendChild(frag);
                for (int i = 0; i < no_of_matched_nodes; ++i) {
                    selectedNode[i] = (Element)matchedNodes.item(i);
                    selectedNode[i].appendChild(frag);
                }
            }
            TransformerFactory xformFactory = TransformerFactory.newInstance();
            Transformer idTransform = xformFactory.newTransformer();
            DOMSource input = new DOMSource(document);
            FileOutputStream fs = new FileOutputStream(outputFile);
            StreamResult output = new StreamResult(fs);
            idTransform.transform(input, output);
            fs.flush();
            fs.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private static void deleteNode(org.w3c.dom.Document document, String xp, String outputFile) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            Element dummyNode = (Element)xpath.evaluate(xp, document, XPathConstants.NODE);
            NodeList matchedNodes = (NodeList)xpath.evaluate(xp, document, XPathConstants.NODESET);
            int no_of_matched_nodes = 0;
            if (matchedNodes != null) {
                no_of_matched_nodes = matchedNodes.getLength();
            }
            Element[] selectedNode = new Element[no_of_matched_nodes];
            if (no_of_matched_nodes > 0) {
                for (int i = 0; i < no_of_matched_nodes; ++i) {
                    selectedNode[i] = (Element)matchedNodes.item(i);
                    selectedNode[i].getParentNode().removeChild(selectedNode[i]);
                    document.normalize();
                }
            }
            TransformerFactory xformFactory = TransformerFactory.newInstance();
            Transformer idTransform = xformFactory.newTransformer();
            DOMSource input = new DOMSource(document);
            FileOutputStream fs = new FileOutputStream(outputFile);
            StreamResult output = new StreamResult(fs);
            idTransform.transform(input, output);
            fs.flush();
            fs.close();
        }
        catch (Exception e) {
            UpgradeUtils.log("Delete Node failed for:" + xp);
            UpgradeUtils.log("" + e);
        }
    }

    public static DocumentFragment getXmlNode(org.w3c.dom.Document doc, String fragment) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            org.w3c.dom.Document d = factory.newDocumentBuilder().parse(new InputSource(new StringReader(fragment)));
            Node node = doc.importNode(d.getDocumentElement(), false);
            DocumentFragment docfrag = doc.createDocumentFragment();
            docfrag.appendChild(node);
            return docfrag;
        }
        catch (SAXException e) {
        }
        catch (ParserConfigurationException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String getJESInstallerWizardID(File psinstallShFile) {
        String installerID;
        block2: {
            installerID = "";
            String command = psinstallShFile.getAbsolutePath();
            String[] args = new String[]{"-nodisplay", "-id"};
            execUtil.storeOutput(true);
            try {
                execUtil.exec(command, args);
                installerID = execUtil.getOutput().trim();
                UpgradeUtils.log("Installer ID : " + installerID);
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.SEVERE)) break block2;
                LogRecord record = new LogRecord(Level.SEVERE, "");
                record.setParameters(new String[]{"Could not obtain Installer ID:"});
                record.setThrown(e);
                record.setLoggerName(log.getName());
                log.log(record);
            }
        }
        return installerID;
    }

    public static void setSSLLDAPConnection(boolean sslEnabled) {
        if (sslEnabled) {
            connection = new LDAPConnection((LDAPSocketFactory)new JSSESocketFactory(null));
        }
    }

    private static class EraserThread
    implements Runnable {
        private boolean stop;

        public EraserThread(String prompt) {
            System.out.print(prompt);
        }

        public void run() {
            this.stop = true;
            char c = ' ';
            boolean star = false;
            while (this.stop) {
                System.out.print("\b" + c);
                try {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
                catch (InterruptedException ie) {
                    UpgradeUtils.log("Password masking thread failed!");
                }
            }
        }

        public void stopMasking() {
            this.stop = false;
        }
    }
}

