/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.upgrade;

import com.sun.portal.fabric.upgrade.UpgradeConstants;
import com.sun.portal.fabric.upgrade.UpgradeException;
import com.sun.portal.fabric.upgrade.UpgradeUtils;
import com.sun.portal.fabric.util.ExecuteUtil;
import com.sun.portal.fabric.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class PSUpgrade {
    private static String PS_BASEDIR = null;
    private String PS_CONFIG_DIR;
    private String PS_VAR_DIR;
    private String PS_JDKDIR;
    private String PS_DEPLOY_TYPE;
    private String IDSAME_BASEDIR;
    private String PS_DEPLOY_URI;
    private String PS_DS_HOST;
    private static String PS_DS_DIRMGR_DN;
    private String PS_DS_PORT;
    private String PS_SERVER_PROTOCOL;
    private String HOST_NAME;
    private String HOST_NAME_PORT;
    private String ADMIN_DN = null;
    private String ROOT_DN = null;
    private String ORG_DN = null;
    private String SCHEMA_DN = "cn=schema";
    private String PEOPLE_DN = null;
    private static boolean PORTAL_INSTALLED;
    private static boolean SRA_INSTALLED;
    private static boolean GATEWAY_INSTALLED;
    private static boolean NETLET_PROXY_INSTALLED;
    private static boolean REWRITER_PROXY_INSTALLED;
    private String PS_INSTALL_SCRIPT_LOCATION;
    private String PS_PROTOCOL;
    private String PS_PRODUCT_DIR;
    private String AM_BASEDIR;
    private String RWP_SELF_SIGNED_CERT;
    private String NLP_PROTOCOL;
    private String GW_LOAD_BALANCER_URL;
    private String GW_SERVER_PROTOCOL;
    private String GW_IDSAME_ORG_DN;
    private String GW_CREATE_IS_INSTANCE;
    private String GW_BASEDIR;
    private String GW_GATEWAY_PROFILE;
    private String START_GATEWAY;
    private String GW_IP;
    private String GW_SELF_SIGNED_CERT;
    private String GW_IDSAME_PASSWORD_KEY;
    private String GW_DEPLOY_URI;
    private String GW_PORT;
    private String GW_CERT_INFO;
    private String GW_PROTOCOL;
    private String GW_HOST;
    private String NLP_IP;
    private String NLP_CERT_INFO;
    private String NLP_IDSAME_PASSWORD_KEY;
    private String NLP_GATEWAY_PROFILE;
    private String NLP_BASEDIR;
    private String NLP_LOAD_BALANCER_URL;
    private String NLP_SELF_SIGNED_CERT;
    private String NLP_PORT;
    private String START_NETLETPROXY;
    private String NLP_HOST;
    private String RWP_PROTOCOL;
    private String RWP_IP;
    private String CERT_INFO;
    private String RWP_IDSAME_PASSWORD_KEY;
    private String RWP_GATEWAY_PROFILE;
    private String RWP_BASEDIR;
    private String RWP_LOAD_BALANCER_URL;
    private String RWP_PORT;
    private String START_REWRITERPROXY;
    private String RWP_HOST;
    private String PS_ETC_DIR;
    private String SRA_GW_PROTOCOL;
    private String SRA_SERVER_DOMAIN;
    private String GW_DOMAIN;
    private String SRA_LOAD_BALANCER_URL;
    private String SRA_ASSIGN_SERVICE;
    private String SRA_USE_WEBPROXY;
    private String SRA_GATEWAY_PROFILE;
    private String SRA_GW_PORT;
    private String PS_DEPLOY_INSTANCE;
    private String PS_DEPLOY_INSTANCE_DIR;
    private String PS_IDSAME_AMSERVER;
    private String PS_DEPLOY_JDK_DIR;
    private String PS_DEPLOY_ADMIN_PROTOCOL;
    private String PS_DEPLOY_ADMIN_PORT;
    private String PS_DEPLOY_PRODUCT_DIR;
    private String PS_DEPLOY_NODE;
    private String PS_DEPLOY_PROJECT_DIR;
    private String PS_DEPLOY_VIRTUAL_HOST;
    private String PS_JDK_DIR;
    private String PS_DEPLOY_ADMIN_HOST;
    private String PS_DEPLOY_ADMIN;
    private String PS_LOAD_BALANCER_URL;
    private String PS_DEPLOY_DOMAIN;
    private String AM_PRODUCT_DIR;
    private String AM_CONFIG_DIR;
    private String AM_VAR_DIR;
    private String PS_DEPLOY_DOCROOT;
    private String PS_DEPLOY_CELL;
    private String PS_DEPLOY_DIR;
    private String PS_AMCONSOLE;
    private static final String LOGFILE = "upgrade.log";
    private File upgradePropFile;
    private File upgradeAntFile;
    private String upgradeAntFilePathStr;
    private String upgradePropFilePathStr;
    private Properties AMConfigProps;
    private Properties psInstallationProps;
    private Properties amInstallationProps;
    private static String DS_DIRMGR_PASSWORD;
    private static String IDSAME_ADMIN_PASSWORD;
    private static String IDSAME_LDAP_USER_PASSWORD;
    private static String CERT_DB_PASSWORD;
    private static String WEB_CONTAINER_ADMIN_PASSWORD;
    private static String SRA_LOG_USER_PASSWORD;
    private static String WEB_CONTAINER_MASTER_PASSWORD;
    private static File silentJESInstall;
    private String PS_70_PRODUCT_DIR = null;
    private String PS_PRODUCT_DIR_OLD = null;
    private String PS_70_DATA_DIR = null;
    private String PS_70_CONFIG_DIR = null;
    private String PS_DATA_DIR_OLD = null;
    private String PS_CONFIG_DIR_OLD = null;
    private static File configFile;
    private String PS_DEPLOY_MANAGED_SERVER = null;
    private static boolean DEBUG;
    private String wcAdminPasswordFilePath = "";
    String fs = File.separator;
    private static Logger log;
    private static ExecuteUtil execUtil;
    private static FileHandler fh;
    private static String AM_SPECIAL_USER_DN;
    private static String AM_LDAP_USER_DN;
    private static String PS_PRODUCT_VERSION;
    private static String RESOURCE_DIR;
    private boolean linuxOS = false;
    private boolean sunOS = false;
    private static String PS_DS_SSL_ENABLED;

    public PSUpgrade() {
        execUtil = new ExecuteUtil(log);
        UpgradeUtils.setExecUtil(execUtil);
        String OSStr = System.getProperty("os.name");
        this.log("Operating System query result: " + OSStr);
        this.linuxOS = OSStr.indexOf("Linux") != -1;
        this.sunOS = OSStr.indexOf("SunOS") != -1;
        this.log("Operating System SunOS=: " + this.sunOS);
        this.log("Operating System linuxOS=: " + this.linuxOS);
        this.psInstallationProps = new Properties();
        this.amInstallationProps = new Properties();
    }

    public static void main(String[] args) {
        String passwordsfile = null;
        File passwordFile = null;
        if (args.length < 1) {
            System.out.println("Usuage: java -jar upgrade.jar <passwordfile>");
            System.exit(0);
        } else {
            passwordsfile = args[0];
            passwordFile = new File(passwordsfile);
            if (!passwordFile.exists()) {
                System.out.println("Usuage: java -jar upgrade.jar <file>");
                System.exit(0);
            }
        }
        PSUpgrade ps = new PSUpgrade();
        try {
            ps.init(passwordFile);
        }
        catch (UpgradeException e) {
            ps.log("Failed to initialize:" + e.getMessage());
            System.out.println("Failed to initialize. Check log file /var/tmp" + File.separator + LOGFILE + " for details");
            System.exit(0);
        }
        DEBUG = UpgradeUtils.hasCommandOption(args, "-debug");
        if (!DEBUG) {
            passwordFile.delete();
        }
        if (!(PORTAL_INSTALLED || SRA_INSTALLED || GATEWAY_INSTALLED || NETLET_PROXY_INSTALLED || REWRITER_PROXY_INSTALLED)) {
            ps.log("Portal Server or its components installation not detected. Nothing to upgrade.");
            System.out.println("Portal Server installation not detected. Nothing to upgrade!!");
            System.exit(0);
        }
        if (!PORTAL_INSTALLED && (GATEWAY_INSTALLED || NETLET_PROXY_INSTALLED || REWRITER_PROXY_INSTALLED) && ((PS_DS_DIRMGR_DN = UpgradeUtils.readInput("Please enter the Directory Server Admin DN ( cn=Directory Manager ) :")) == null || PS_DS_DIRMGR_DN.equals(""))) {
            PS_DS_DIRMGR_DN = "cn=Directory Manager";
        }
        while (DS_DIRMGR_PASSWORD == null || DS_DIRMGR_PASSWORD.equals("")) {
            DS_DIRMGR_PASSWORD = UpgradeUtils.readPassword("Please enter the Directory Server Admin(" + PS_DS_DIRMGR_DN + ") password :");
            ps.psInstallationProps.setProperty("DS_DIRMGR_PASSWORD", DS_DIRMGR_PASSWORD);
        }
        while (IDSAME_ADMIN_PASSWORD == null || IDSAME_ADMIN_PASSWORD.equals("")) {
            IDSAME_ADMIN_PASSWORD = UpgradeUtils.readPassword("Please enter the Access Manager Admin password : ");
            ps.psInstallationProps.setProperty("IDSAME_ADMIN_PASSWORD", IDSAME_ADMIN_PASSWORD);
        }
        while (IDSAME_LDAP_USER_PASSWORD == null || IDSAME_LDAP_USER_PASSWORD.equals("")) {
            IDSAME_LDAP_USER_PASSWORD = UpgradeUtils.readPassword("Please enter the Directory Server ldapuser password : ");
            ps.psInstallationProps.setProperty("IDSAME_LDAP_USER_PASSWORD", IDSAME_LDAP_USER_PASSWORD);
        }
        if (PS_PRODUCT_VERSION.startsWith("6.3.1")) {
            RESOURCE_DIR = UpgradeConstants.RESOURCE_DIR_JES3;
            ps.createJESSilentInstallFile();
        } else {
            ps.log("No JES3 or JES4 Portal Server installation detected.This upgrade software intended for upgrade from JES3 or JES4 PS installation only:\t");
            System.out.println("Failed to initialize. Check log file /var/tmp" + File.separator + LOGFILE + " for details");
            ps.destroy();
            System.exit(0);
        }
        configFile = ps.generateConfigFile();
        if (DEBUG) {
            System.out.println("The config file is created at " + configFile.getAbsoluteFile());
        }
        ps.setPSConfigSchemaLocation(configFile);
        ps.removeUninstalledComponents(configFile);
        try {
            System.out.println("Performing Pre Upgrade operations:");
            System.out.println("---------------------------------");
            ps.preupgrade();
        }
        catch (UpgradeException e) {
            ps.log("Failed to complete pre Upgrade steps:\t" + e.getMessage());
            System.out.println("Failed to initialize. Check log file /var/tmp" + File.separator + LOGFILE + " for details");
            ps.destroy();
            System.exit(0);
        }
        try {
            System.out.println("Performing Upgrade operations:");
            System.out.println("-----------------------------");
            ps.upgrade();
        }
        catch (UpgradeException e) {
            ps.log("Failed to complete Upgrade steps:\t" + e.getMessage());
            System.out.println("Failed to complete Upgrade steps. Check log file /var/tmp" + File.separator + LOGFILE + " for details");
            ps.destroy();
            System.exit(0);
        }
        try {
            System.out.println("Performing Post Upgrade operations:");
            System.out.println("----------------------------------");
            ps.postupgrade();
        }
        catch (UpgradeException e) {
            ps.log("Failed to complete Post Upgrade steps:\t" + e.getMessage());
            System.out.println("Failed to complete Post Upgrade steps. Check log file /var/tmp" + File.separator + LOGFILE + " for details");
            ps.destroy();
            System.exit(0);
        }
        ps.destroy();
    }

    void setPSConfigSchemaLocation(File f) {
        FileUtil.replaceTokenInFile(f, "PSCONFIG_XSD", "file://" + this.PS_70_PRODUCT_DIR + this.fs + "lib" + this.fs + "psconfig.xsd");
    }

    boolean removeUninstalledComponents(File f) {
        Document doc = null;
        Element elem = null;
        Element comp = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(f);
            elem = doc.getRootElement();
        }
        catch (Exception e) {
            // empty catch block
        }
        Element ComponentsToConfigure = elem.getChild("Configure").getChild("PortalConfiguration").getChild("ComponentsToConfigure");
        Element PortalConfiguration = elem.getChild("Configure").getChild("PortalConfiguration");
        Element PortalServer = elem.getChild("Configure").getChild("PortalConfiguration").getChild("PortalServer");
        Element PortalServerInstance2 = elem.getChild("Configure").getChild("PortalConfiguration").getChild("PortalServer").getChild("Instance");
        Element SearchServer = elem.getChild("Configure").getChild("PortalConfiguration").getChild("SearchServer");
        List list = null;
        Iterator it = null;
        if (!NETLET_PROXY_INSTALLED) {
            list = ComponentsToConfigure.getChildren();
            it = list.iterator();
            while (it.hasNext()) {
                comp = (Element)it.next();
                if (!comp.getText().equals("netletproxy")) continue;
                ComponentsToConfigure.removeContent((Content)comp);
                break;
            }
        }
        if (!SRA_INSTALLED) {
            list = ComponentsToConfigure.getChildren();
            it = list.iterator();
            while (it.hasNext()) {
                comp = (Element)it.next();
                if (!comp.getText().equals("sracore")) continue;
                ComponentsToConfigure.removeContent((Content)comp);
                break;
            }
        }
        if (!GATEWAY_INSTALLED) {
            list = ComponentsToConfigure.getChildren();
            it = list.iterator();
            while (it.hasNext()) {
                comp = (Element)it.next();
                if (!comp.getText().equals("gateway")) continue;
                ComponentsToConfigure.removeContent((Content)comp);
                break;
            }
        }
        if (!PORTAL_INSTALLED) {
            list = ComponentsToConfigure.getChildren();
            it = list.iterator();
            while (it.hasNext()) {
                comp = (Element)it.next();
                if (!comp.getText().equals("portalserver")) continue;
                ComponentsToConfigure.removeContent((Content)comp);
                break;
            }
            PortalServer.removeContent((Content)PortalServerInstance2);
            PortalConfiguration.removeContent((Content)SearchServer);
        }
        if (!REWRITER_PROXY_INSTALLED) {
            list = ComponentsToConfigure.getChildren();
            it = list.iterator();
            while (it.hasNext()) {
                comp = (Element)it.next();
                if (!comp.getText().equals("rewriterproxy")) continue;
                ComponentsToConfigure.removeContent((Content)comp);
                break;
            }
        }
        try {
            XMLOutputter serializer = new XMLOutputter();
            serializer.output(doc, (Writer)new FileWriter(f));
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return false;
    }

    private void initPasswords(File passwordFilename) throws UpgradeException {
        try {
            this.psInstallationProps.load(new FileInputStream(passwordFilename));
            IDSAME_ADMIN_PASSWORD = (String)this.psInstallationProps.get("IDSAME_ADMIN_PASSWORD");
            DS_DIRMGR_PASSWORD = (String)this.psInstallationProps.get("DS_DIRMGR_PASSWORD");
            IDSAME_LDAP_USER_PASSWORD = (String)this.psInstallationProps.get("IDSAME_LDAP_USER_PASSWORD");
            WEB_CONTAINER_ADMIN_PASSWORD = (String)this.psInstallationProps.get("WEB_CONTAINER_ADMIN_PASSWORD");
            WEB_CONTAINER_MASTER_PASSWORD = (String)this.psInstallationProps.get("WEB_CONTAINER_MASTER_PASSWORD");
            CERT_DB_PASSWORD = (String)this.psInstallationProps.get("CERT_DB_PASSWORD");
            SRA_LOG_USER_PASSWORD = (String)this.psInstallationProps.get("SRA_LOG_USER_PASSWORD");
        }
        catch (IOException e) {
            this.log("Unable to create passwords file");
            throw new UpgradeException("Unable to create passwords file", e);
        }
    }

    private void initAMConfigDetails() throws UpgradeException {
        int index;
        this.AMConfigProps = new Properties();
        String AMSDKDir = "SUNWam";
        if (this.linuxOS) {
            AMSDKDir = "sun" + this.fs + "identity";
        }
        String AMConfileFile = null;
        try {
            AMConfileFile = this.AM_CONFIG_DIR + this.fs + "opt" + this.fs + AMSDKDir + this.fs + "config" + this.fs + "AMConfig.properties";
            this.AMConfigProps.load(new FileInputStream(AMConfileFile));
        }
        catch (IOException e) {
            throw new UpgradeException("Trying to load" + AMConfileFile + ". Could not fetch values from AMConfig.properties\n.", e);
        }
        this.PS_DS_HOST = this.AMConfigProps.getProperty("com.iplanet.am.directory.host");
        this.PS_DS_PORT = this.AMConfigProps.getProperty("com.iplanet.am.directory.port");
        PS_DS_SSL_ENABLED = this.AMConfigProps.getProperty("com.iplanet.am.directory.ssl.enabled");
        this.ADMIN_DN = this.AMConfigProps.getProperty("com.sun.identity.authentication.super.user");
        this.ROOT_DN = this.AMConfigProps.getProperty("com.iplanet.am.rootsuffix");
        this.ORG_DN = this.AMConfigProps.getProperty("com.iplanet.am.defaultOrg");
        if (!this.ORG_DN.equals(this.ROOT_DN)) {
            this.ORG_DN = this.ORG_DN + "," + this.ROOT_DN;
        }
        this.PEOPLE_DN = "ou=People," + this.ORG_DN;
        String userDNs = this.AMConfigProps.getProperty("com.sun.identity.authentication.special.users");
        if (userDNs == null) {
            userDNs = "cn=dsameuser,ou=DSAME Users," + this.ORG_DN;
        }
        AM_SPECIAL_USER_DN = (index = userDNs.indexOf("|")) < 0 ? userDNs : userDNs.substring(0, index);
        AM_LDAP_USER_DN = AM_SPECIAL_USER_DN.replaceFirst("dsameuser", "amldapuser");
    }

    public void initPortalInstallationDetails() throws UpgradeException {
        System.out.println("Loading current installation properties file.... ");
        this.log("Loading current installation properties file.... ");
        String sunPortalDir = null;
        try {
            if (this.sunOS) {
                sunPortalDir = "SUNWportal";
                this.amInstallationProps.load(new FileInputStream("/var/sadm/pkg/SUNWamsdk/pkginfo"));
                this.AM_BASEDIR = this.amInstallationProps.getProperty("BASEDIR", "/opt");
                this.AM_PRODUCT_DIR = this.amInstallationProps.getProperty("PRODUCT_DIR", "SUNWam");
                this.AM_CONFIG_DIR = this.amInstallationProps.getProperty("ETC_DIR", "/etc");
                this.AM_VAR_DIR = this.amInstallationProps.getProperty("VAR_DIR", "/var");
                this.psInstallationProps.load(new FileInputStream("/var/sadm/pkg/SUNWpscfg/pkginfo"));
                PS_BASEDIR = this.psInstallationProps.getProperty("BASEDIR");
                this.PS_PRODUCT_DIR = this.psInstallationProps.getProperty("PRODUCT_DIR");
                this.PS_PRODUCT_DIR_OLD = PS_BASEDIR + this.fs + this.PS_PRODUCT_DIR;
                this.PS_70_PRODUCT_DIR = PS_BASEDIR + this.fs + sunPortalDir;
                this.PS_ETC_DIR = this.psInstallationProps.getProperty("ETC_DIR", "/etc");
                this.PS_VAR_DIR = this.psInstallationProps.getProperty("VAR_DIR", "/var");
                this.PS_CONFIG_DIR_OLD = this.PS_ETC_DIR + this.fs + "opt" + this.fs + "SUNWps";
                this.PS_DATA_DIR_OLD = this.PS_VAR_DIR + this.fs + this.fs + "opt" + this.fs + "SUNWps";
            } else if (this.linuxOS) {
                sunPortalDir = "sun" + this.fs + "portal";
                this.AM_BASEDIR = UpgradeUtils.getAMBaseDirOnLinux();
                this.AM_PRODUCT_DIR = "identity";
                this.AM_CONFIG_DIR = "/etc";
                this.AM_VAR_DIR = "/var";
                PS_BASEDIR = UpgradeUtils.getPSBaseDirOnLinux();
                this.PS_PRODUCT_DIR = "portal";
                this.PS_70_PRODUCT_DIR = PS_BASEDIR + this.fs + "portal";
                this.PS_ETC_DIR = "/etc";
                this.PS_VAR_DIR = "/var";
                this.PS_CONFIG_DIR_OLD = this.PS_ETC_DIR + this.fs + "opt" + this.fs + "sun" + this.fs + "portal";
                this.PS_DATA_DIR_OLD = this.PS_VAR_DIR + this.fs + this.fs + "opt" + this.fs + "sun" + this.fs + "portal";
                this.PS_PRODUCT_DIR_OLD = this.PS_70_PRODUCT_DIR;
            }
            PS_PRODUCT_VERSION = UpgradeUtils.getPSVersion(this.PS_PRODUCT_DIR_OLD, PORTAL_INSTALLED);
            if (PS_PRODUCT_VERSION == null) {
                throw new UpgradeException("Could not determine PS Version! Cannot proceed.");
            }
            this.PS_70_DATA_DIR = this.PS_VAR_DIR + this.fs + "opt" + this.fs + sunPortalDir;
            this.PS_70_CONFIG_DIR = this.PS_ETC_DIR + this.fs + "opt" + this.fs + sunPortalDir;
            this.psInstallationProps.setProperty("PS_PRODUCT_VERSION", PS_PRODUCT_VERSION);
            this.psInstallationProps.setProperty("PS_70_PRODUCT_DIR", this.PS_70_PRODUCT_DIR);
            this.psInstallationProps.setProperty("PS_70_DATA_DIR", this.PS_70_DATA_DIR);
            this.psInstallationProps.setProperty("PS_70_CONFIG_DIR", this.PS_70_CONFIG_DIR);
            this.psInstallationProps.setProperty("PS_CONFIG_DIR_OLD", this.PS_CONFIG_DIR_OLD);
            this.psInstallationProps.setProperty("PS_PRODUCT_DIR_OLD", this.PS_PRODUCT_DIR_OLD);
            this.psInstallationProps.setProperty("PS_DATA_DIR_OLD", this.PS_DATA_DIR_OLD);
            this.log("\n");
            this.log("Current installation properties:\nConfig Directory:" + this.PS_CONFIG_DIR_OLD + "\n" + "Data Directory:" + this.PS_DATA_DIR_OLD + "\n" + "Product Directory:" + this.PS_PRODUCT_DIR_OLD + "\n");
            this.psInstallationProps.setProperty("AM_PRODUCT_DIR", this.AM_PRODUCT_DIR);
            this.psInstallationProps.setProperty("AM_BASEDIR", this.AM_BASEDIR);
            if (PORTAL_INSTALLED) {
                String psConfigPropFile = this.PS_CONFIG_DIR_OLD + this.fs + "PSConfig.properties";
                this.psInstallationProps.load(new FileInputStream(psConfigPropFile));
                this.PS_JDKDIR = this.psInstallationProps.getProperty("JDK_DIR", "");
                this.PS_DEPLOY_TYPE = this.psInstallationProps.getProperty("DEPLOY_TYPE");
                this.PS_DEPLOY_URI = this.psInstallationProps.getProperty("DEPLOY_URI");
                this.PS_DS_HOST = this.psInstallationProps.getProperty("DS_HOST");
                PS_DS_DIRMGR_DN = this.psInstallationProps.getProperty("DS_DIRMGR_DN");
                this.PS_DS_PORT = this.psInstallationProps.getProperty("DS_PORT");
                this.PS_SERVER_PROTOCOL = this.psInstallationProps.getProperty("SERVER_PROTOCOL");
                this.HOST_NAME = this.psInstallationProps.getProperty("PS_HOST");
                this.HOST_NAME_PORT = this.psInstallationProps.getProperty("PS_PORT");
                this.PS_DEPLOY_INSTANCE = this.psInstallationProps.getProperty("DEPLOY_INSTANCE", "");
                this.PS_DEPLOY_INSTANCE_DIR = this.psInstallationProps.getProperty("DEPLOY_INSTANCE_DIR", "");
                this.PS_IDSAME_AMSERVER = this.psInstallationProps.getProperty("IDSAME_AMSERVER");
                this.PS_DEPLOY_JDK_DIR = this.psInstallationProps.getProperty("DEPLOY_JDK_DIR", "");
                this.PS_DEPLOY_ADMIN_PROTOCOL = this.psInstallationProps.getProperty("DEPLOY_ADMIN_PROTOCOL", "");
                this.PS_DEPLOY_ADMIN_PORT = this.psInstallationProps.getProperty("DEPLOY_ADMIN_PORT", "");
                this.PS_DEPLOY_PRODUCT_DIR = this.psInstallationProps.getProperty("DEPLOY_DIR", "");
                this.PS_DEPLOY_NODE = this.psInstallationProps.getProperty("DEPLOY_NODE", "");
                this.PS_DEPLOY_PROJECT_DIR = this.psInstallationProps.getProperty("DEPLOY_PROJECT_DIR", "");
                this.PS_DEPLOY_VIRTUAL_HOST = this.psInstallationProps.getProperty("DEPLOY_VIRTUAL_HOST", "");
                this.PS_JDK_DIR = this.psInstallationProps.getProperty("JDK_DIR", "");
                this.PS_DEPLOY_ADMIN_HOST = this.psInstallationProps.getProperty("DEPLOY_ADMIN_HOST", "");
                this.PS_DEPLOY_ADMIN = this.psInstallationProps.getProperty("DEPLOY_ADMIN", "");
                this.PS_LOAD_BALANCER_URL = this.psInstallationProps.getProperty("LOAD_BALANCER_URL", "");
                this.PS_DEPLOY_DOMAIN = this.psInstallationProps.getProperty("DEPLOY_DOMAIN", "");
                this.PS_AMCONSOLE = this.psInstallationProps.getProperty("IDSAME_AMCONSOLE", "");
                this.PS_DEPLOY_DOCROOT = this.psInstallationProps.getProperty("DEPLOY_DOCROOT", "");
                this.PS_DEPLOY_CELL = this.psInstallationProps.getProperty("DEPLOY_CELL", "");
                this.PS_DEPLOY_DIR = this.psInstallationProps.getProperty("DEPLOY_DIR", "");
                this.PS_DEPLOY_DOMAIN = this.psInstallationProps.getProperty("DEPLOY_DOMAIN", "");
                this.PS_PROTOCOL = this.psInstallationProps.getProperty("PS_PROTOCOL", "http");
                this.PS_DEPLOY_MANAGED_SERVER = this.psInstallationProps.getProperty("MANAGED_SERVER", "false");
            }
            if (SRA_INSTALLED) {
                String sraConfigPropFile = null;
                sraConfigPropFile = this.sunOS ? this.PS_ETC_DIR + this.fs + "opt" + this.fs + "SUNWps" + this.fs + "SRAConfig.properties" : this.PS_ETC_DIR + this.fs + "opt" + this.fs + "sun" + this.fs + "portal" + this.fs + "SRAConfig.properties";
                this.psInstallationProps.load(new FileInputStream(sraConfigPropFile));
                this.SRA_GW_PORT = this.psInstallationProps.getProperty("GW_PORT");
                this.SRA_GATEWAY_PROFILE = this.psInstallationProps.getProperty("SRA_GATEWAY_PROFILE");
                this.SRA_USE_WEBPROXY = this.psInstallationProps.getProperty("USE_WEBPROXY");
                this.SRA_GW_PROTOCOL = this.psInstallationProps.getProperty("GW_PROTOCOL");
                this.SRA_SERVER_DOMAIN = this.psInstallationProps.getProperty("SERVER_DOMAIN");
                this.GW_DOMAIN = this.psInstallationProps.getProperty("GW_DOMAIN");
                this.SRA_LOAD_BALANCER_URL = this.psInstallationProps.getProperty("LOAD_BALANCER_URL");
                this.SRA_ASSIGN_SERVICE = this.psInstallationProps.getProperty("ASSIGN_SERVICE");
            }
            String GW_NLP_RWPConfigPropFileDir = this.getGW_NLP_RWPPropertiesFileDir();
            if (GATEWAY_INSTALLED) {
                String gwConfigPropFile = null;
                gwConfigPropFile = GW_NLP_RWPConfigPropFileDir + this.fs + "GWConfig.properties";
                this.psInstallationProps.load(new FileInputStream(gwConfigPropFile));
                this.GW_GATEWAY_PROFILE = this.psInstallationProps.getProperty("GW_GATEWAY_PROFILE");
                this.GW_BASEDIR = this.psInstallationProps.getProperty("GW_BASEDIR");
                this.GW_CREATE_IS_INSTANCE = this.psInstallationProps.getProperty("CREATE_IS_INSTANCE");
                this.START_GATEWAY = this.psInstallationProps.getProperty("START_GATEWAY");
                this.GW_IDSAME_ORG_DN = this.psInstallationProps.getProperty("IDSAME_ORG_DN");
                this.GW_SERVER_PROTOCOL = this.psInstallationProps.getProperty("SERVER_PROTOCOL");
                this.GW_LOAD_BALANCER_URL = this.psInstallationProps.getProperty("LOAD_BALANCER_URL");
                this.GW_IP = this.psInstallationProps.getProperty("GW_IP");
                this.GW_SELF_SIGNED_CERT = this.psInstallationProps.getProperty("SELF_SIGNED_CERT");
                this.GW_IDSAME_PASSWORD_KEY = this.psInstallationProps.getProperty("IDSAME_PASSWORD_KEY");
                this.GW_DEPLOY_URI = this.psInstallationProps.getProperty("DEPLOY_URI");
                this.GW_PORT = this.psInstallationProps.getProperty("GW_PORT");
                this.CERT_INFO = this.psInstallationProps.getProperty("CERT_INFO");
                this.GW_PROTOCOL = this.psInstallationProps.getProperty("GW_PROTOCOL");
                this.GW_HOST = this.psInstallationProps.getProperty("GW_HOST");
                if (this.PS_JDKDIR == null || this.PS_JDKDIR.length() < 1) {
                    this.PS_JDKDIR = UpgradeUtils.getGatewayJDKDir(GW_NLP_RWPConfigPropFileDir);
                }
                this.HOST_NAME = this.GW_HOST;
            }
            if (NETLET_PROXY_INSTALLED) {
                String nlpConfigPropFile = null;
                if (this.sunOS) {
                    nlpConfigPropFile = GW_NLP_RWPConfigPropFileDir + this.fs + "NLPConfig.properties";
                } else if (this.linuxOS) {
                    nlpConfigPropFile = GW_NLP_RWPConfigPropFileDir + this.fs + "NLPConfig.properties";
                }
                this.psInstallationProps.load(new FileInputStream(nlpConfigPropFile));
                this.NLP_PROTOCOL = this.psInstallationProps.getProperty("NLP_PROTOCOL");
                this.NLP_IP = this.psInstallationProps.getProperty("NLP_IP");
                this.CERT_INFO = this.psInstallationProps.getProperty("CERT_INFO");
                this.NLP_IDSAME_PASSWORD_KEY = this.psInstallationProps.getProperty("IDSAME_PASSWORD_KEY");
                this.NLP_GATEWAY_PROFILE = this.psInstallationProps.getProperty("NLP_GATEWAY_PROFILE");
                this.NLP_BASEDIR = this.psInstallationProps.getProperty("NLP_BASEDIR");
                this.NLP_LOAD_BALANCER_URL = this.psInstallationProps.getProperty("LOAD_BALANCER_URL");
                this.NLP_SELF_SIGNED_CERT = this.psInstallationProps.getProperty("SELF_SIGNED_CERT");
                this.NLP_PORT = this.psInstallationProps.getProperty("NLP_PORT");
                this.START_NETLETPROXY = this.psInstallationProps.getProperty("START_NETLETPROXY");
                this.NLP_HOST = this.psInstallationProps.getProperty("NLP_HOST");
                if (this.PS_JDKDIR == null || this.PS_JDKDIR.length() < 1) {
                    this.PS_JDKDIR = UpgradeUtils.getGatewayJDKDir(GW_NLP_RWPConfigPropFileDir);
                }
                this.HOST_NAME = this.NLP_HOST;
            }
            if (REWRITER_PROXY_INSTALLED) {
                String rwpConfigPropFile = null;
                if (this.sunOS) {
                    rwpConfigPropFile = GW_NLP_RWPConfigPropFileDir + this.fs + "RWPConfig.properties";
                } else if (this.linuxOS) {
                    rwpConfigPropFile = GW_NLP_RWPConfigPropFileDir + this.fs + "RWPConfig.properties";
                }
                this.psInstallationProps.load(new FileInputStream(rwpConfigPropFile));
                this.RWP_PROTOCOL = this.psInstallationProps.getProperty("RWP_PROTOCOL");
                this.RWP_IP = this.psInstallationProps.getProperty("RWP_IP");
                this.CERT_INFO = this.psInstallationProps.getProperty("CERT_INFO");
                this.RWP_IDSAME_PASSWORD_KEY = this.psInstallationProps.getProperty("IDSAME_PASSWORD_KEY");
                this.RWP_GATEWAY_PROFILE = this.psInstallationProps.getProperty("RWP_GATEWAY_PROFILE");
                this.RWP_BASEDIR = this.psInstallationProps.getProperty("RWP_BASEDIR");
                this.RWP_LOAD_BALANCER_URL = this.psInstallationProps.getProperty("LOAD_BALANCER_URL");
                this.RWP_SELF_SIGNED_CERT = this.psInstallationProps.getProperty("SELF_SIGNED_CERT");
                this.RWP_PORT = this.psInstallationProps.getProperty("RWP_PORT");
                this.START_REWRITERPROXY = this.psInstallationProps.getProperty("START_REWRITERPROXY");
                this.RWP_HOST = this.psInstallationProps.getProperty("RWP_HOST");
                if (this.PS_JDKDIR == null || this.PS_JDKDIR.length() < 1) {
                    this.PS_JDKDIR = UpgradeUtils.getGatewayJDKDir(GW_NLP_RWPConfigPropFileDir);
                }
                this.HOST_NAME = this.RWP_HOST;
            }
        }
        catch (Exception e) {
            this.psInstallationProps = null;
            this.log("Unable to load Existing Installation properties");
            throw new UpgradeException("Unable to load Existing Installation properties", e);
        }
    }

    private String getGW_NLP_RWPPropertiesFileDir() {
        String GW_NLP_RWPConfigPropFileDir = null;
        if (this.sunOS) {
            GW_NLP_RWPConfigPropFileDir = this.PS_ETC_DIR + this.fs + "opt" + this.fs + "SUNWps";
        } else if (this.linuxOS) {
            GW_NLP_RWPConfigPropFileDir = this.PS_ETC_DIR + this.fs + "opt" + this.fs + "sun" + this.fs + "portal";
        }
        return GW_NLP_RWPConfigPropFileDir;
    }

    public static void createPSInstallSilentFileForJESUpgrade(String basedir) throws UpgradeException {
        System.out.println("Creating PS7.0 Silent Installation file.... ");
        String componentsToInstall = "";
        if (PORTAL_INSTALLED) {
            componentsToInstall = componentsToInstall + "1,";
        }
        if (SRA_INSTALLED) {
            componentsToInstall = componentsToInstall + "2,";
        }
        if (GATEWAY_INSTALLED) {
            componentsToInstall = componentsToInstall + "3,";
        }
        if (NETLET_PROXY_INSTALLED) {
            componentsToInstall = componentsToInstall + "4,";
        }
        if (REWRITER_PROXY_INSTALLED) {
            componentsToInstall = componentsToInstall + "5";
        }
        try {
            File tmpFile = File.createTempFile("psinstallfile", "silent");
            FileWriter fw = new FileWriter(tmpFile);
            fw.write("BASEDIR=" + basedir + "\n");
            fw.write("COMPONENTS=" + componentsToInstall + "\n");
            fw.close();
            silentJESInstall = new File(tmpFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new UpgradeException("Could not create the ps install silent file", e);
        }
    }

    private void createJESSilentInstallFile() {
        int i;
        silentJESInstall = null;
        try {
            if (this.sunOS) {
                silentJESInstall = FileUtil.extractFileFromJar(RESOURCE_DIR + this.fs + "upgraderesource.jar", "jes4silentinstall_SunOS.txt");
            } else if (this.linuxOS) {
                silentJESInstall = FileUtil.extractFileFromJar(RESOURCE_DIR + this.fs + "upgraderesource.jar", "jes4silentinstall_Linux.txt");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashSet<String> componentsToInstall = new HashSet<String>();
        String[] array = new String[]{""};
        if (PORTAL_INSTALLED) {
            array = UpgradeConstants.JES4_SILENT_INSTALL_COMPONENT_PORTAL_SERVER.split(",");
            for (i = 0; i < array.length; ++i) {
                componentsToInstall.add(array[i]);
            }
        }
        if (SRA_INSTALLED) {
            array = UpgradeConstants.JES4_SILENT_INSTALL_COMPONENT_SRA.split(",");
            for (i = 0; i < array.length; ++i) {
                componentsToInstall.add(array[i]);
            }
        }
        if (GATEWAY_INSTALLED) {
            array = UpgradeConstants.JES4_SILENT_INSTALL_COMPONENT_GATEWAY.split(",");
            for (i = 0; i < array.length; ++i) {
                componentsToInstall.add(array[i]);
            }
        }
        if (NETLET_PROXY_INSTALLED) {
            array = UpgradeConstants.JES4_SILENT_INSTALL_COMPONENT_NETLET.split(",");
            for (i = 0; i < array.length; ++i) {
                componentsToInstall.add(array[i]);
            }
        }
        if (REWRITER_PROXY_INSTALLED) {
            array = UpgradeConstants.JES4_SILENT_INSTALL_COMPONENT_REWRITER.split(",");
            for (i = 0; i < array.length; ++i) {
                componentsToInstall.add(array[i]);
            }
        }
        String[] componentsName = componentsToInstall.toArray(new String[componentsToInstall.size()]);
        String PSP_SELECTED_COMPONENTS = "PSP_SELECTED_COMPONENTS = ";
        for (int i2 = 0; i2 < componentsName.length; ++i2) {
            PSP_SELECTED_COMPONENTS = PSP_SELECTED_COMPONENTS + componentsName[i2] + ",";
        }
        PSP_SELECTED_COMPONENTS = PSP_SELECTED_COMPONENTS.substring(0, PSP_SELECTED_COMPONENTS.length() - 1);
        FileUtil.replaceLineInFile(silentJESInstall, "PSP_SELECTED_COMPONENTS", PSP_SELECTED_COMPONENTS);
        FileUtil.replaceLineInFile(silentJESInstall, "CMN_HOST_NAME", "CMN_HOST_NAME = " + this.HOST_NAME);
        FileUtil.replaceLineInFile(silentJESInstall, "CMN_IPADDRESS", "CMN_IPADDRESS = " + UpgradeUtils.getLocalSystemIPAddress());
        FileUtil.replaceLineInFile(silentJESInstall, "PS_SERVER_HOST", "PS_SERVER_HOST = " + this.HOST_NAME.split("\\.")[0] + ".");
        FileUtil.replaceLineInFile(silentJESInstall, "SRA_SERVER_HOST", "SRA_SERVER_HOST = " + this.HOST_NAME);
        FileUtil.replaceLineInFile(silentJESInstall, "CMN_PS_INSTALLDIR", "CMN_PS_INSTALLDIR = " + PS_BASEDIR);
        FileUtil.replaceLineInFile(silentJESInstall, "CMN_SRA_INSTALLDIR", "CMN_SRA_INSTALLDIR = " + PS_BASEDIR);
        File psinstallShFile = new File(RESOURCE_DIR + this.fs + ".." + this.fs + ".." + this.fs + ".." + this.fs + ".." + this.fs + ".." + this.fs + ".." + this.fs + "installer");
        String wizardId = UpgradeUtils.getJESInstallerWizardID(psinstallShFile);
        FileUtil.replaceTokenInFile(silentJESInstall, "WIZARD_ID", wizardId);
    }

    public static String setAttributeValue(File sXMLFile, String xpath, String attr, String val) throws IOException, JDOMException {
        Element rootElement;
        String attrValue = "";
        String[] childElements = xpath.split("/");
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        doc = builder.build(sXMLFile);
        Element rootElementCopy = rootElement = doc.getRootElement();
        for (int i = 0; i < childElements.length; ++i) {
            rootElementCopy = rootElementCopy.getChild(childElements[i]);
        }
        rootElementCopy.setAttribute(attr, val);
        XMLOutputter serializer = new XMLOutputter();
        serializer.output(doc, (Writer)new FileWriter(sXMLFile));
        return attrValue;
    }

    public File generateConfigFile() {
        File configfile = null;
        String GW_NLP_RWPConfigPropFileDir = this.getGW_NLP_RWPPropertiesFileDir();
        try {
            String[] platformConfs;
            configfile = FileUtil.extractFileFromJar(RESOURCE_DIR + this.fs + "upgraderesource.jar", "psconfigupgrade.xml");
            this.log("Config File is: " + configfile.getAbsolutePath() + "\n");
            this.log("Portal Server host name: " + this.HOST_NAME + "\n");
            PSUpgrade.setAttributeValue(configfile, "Configure", "ConfigurationHostName", this.HOST_NAME);
            PSUpgrade.setAttributeValue(configfile, "Configure/SharedComponents", "JavaHome", this.PS_JDKDIR);
            if (this.linuxOS) {
                PSUpgrade.setAttributeValue(configfile, "Configure/SharedComponents", "CacaoProdDir", "/opt/sun/cacao");
                PSUpgrade.setAttributeValue(configfile, "Configure/SharedComponents", "CacaoConfigDir", "/etc/opt/sun/cacao");
                PSUpgrade.setAttributeValue(configfile, "Configure/SharedComponents", "SharedLibDir", "/opt/sun/share/lib");
                PSUpgrade.setAttributeValue(configfile, "Configure/SharedComponents", "PrivateLibDir", "/opt/sun/private/share/lib");
                PSUpgrade.setAttributeValue(configfile, "Configure/SharedComponents", "JDMKLibDir", "/opt/sun/jdmk/5.1/lib");
                PSUpgrade.setAttributeValue(configfile, "Configure/SharedComponents", "NSSLibDir", "/opt/sun/private/lib");
                PSUpgrade.setAttributeValue(configfile, "Configure/SharedComponents", "JSSJarDir", "/opt/sun/private/share/lib");
                PSUpgrade.setAttributeValue(configfile, "Configure/SharedComponents", "WebNFSLibDir", "/opt/sun/webnfs");
                PSUpgrade.setAttributeValue(configfile, "Configure/SharedComponents", "DerbyLibDir", "/opt/sun/share/lib/Derby");
                PSUpgrade.setAttributeValue(configfile, "Configure/SharedComponents", "AntHomeDir", "/opt/sun");
                PSUpgrade.setAttributeValue(configfile, "Configure/SharedComponents", "AntLibDir", "/opt/sun/lib");
                PSUpgrade.setAttributeValue(configfile, "Configure/SharedComponents", "RegistryLibDir", "/opt/sun/SUNWsoar/lib");
            }
            String AMSDKDir = null;
            if (this.sunOS) {
                AMSDKDir = "SUNWam";
            } else if (this.linuxOS) {
                AMSDKDir = "sun" + this.fs + "identity";
            }
            PSUpgrade.setAttributeValue(configfile, "Configure/AccessManager/InstallationDirectory", "ProdDir", this.AM_BASEDIR + this.fs + this.AM_PRODUCT_DIR);
            PSUpgrade.setAttributeValue(configfile, "Configure/AccessManager/InstallationDirectory", "DataDir", this.AM_VAR_DIR + this.fs + "opt" + this.fs + AMSDKDir);
            PSUpgrade.setAttributeValue(configfile, "Configure/AccessManager/InstallationDirectory", "ConfigDir", this.AM_CONFIG_DIR + this.fs + "opt" + this.fs + AMSDKDir + this.fs + "config");
            PSUpgrade.setAttributeValue(configfile, "Configure/AccessManager/UserCredentials", "AdministratorUID", this.ADMIN_DN);
            PSUpgrade.setAttributeValue(configfile, "Configure/AccessManager/UserCredentials", "AdministratorUserPassword", IDSAME_ADMIN_PASSWORD);
            PSUpgrade.setAttributeValue(configfile, "Configure/AccessManager/UserCredentials", "LDAPUserId", "amldapuser");
            PSUpgrade.setAttributeValue(configfile, "Configure/AccessManager/UserCredentials", "LDAPUserIdPassword", IDSAME_LDAP_USER_PASSWORD);
            PSUpgrade.setAttributeValue(configfile, "Configure/AccessManager/UserCredentials", "DirectoryManagerDn", PS_DS_DIRMGR_DN);
            PSUpgrade.setAttributeValue(configfile, "Configure/AccessManager/UserCredentials", "DirectoryManagerPassword", DS_DIRMGR_PASSWORD);
            PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/InstallationDirectory", "ProdDir", this.PS_70_PRODUCT_DIR);
            PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/InstallationDirectory", "DataDir", this.PS_70_DATA_DIR);
            PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/InstallationDirectory", "ConfigDir", this.PS_70_CONFIG_DIR);
            if (PORTAL_INSTALLED || SRA_INSTALLED) {
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer", "SearchServerID", "UpgradedSearch");
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "Host", this.HOST_NAME);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "Port", this.HOST_NAME_PORT);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "Scheme", this.PS_PROTOCOL);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "WebContainerInstallDir", this.PS_DEPLOY_PRODUCT_DIR);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "WebContainerInstanceName", this.PS_DEPLOY_INSTANCE);
                if (this.PS_DEPLOY_TYPE.equals("IWS")) {
                    PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "WebContainerInstanceDir", this.PS_DEPLOY_PRODUCT_DIR + this.fs + "https-" + this.PS_DEPLOY_INSTANCE);
                } else {
                    PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "WebContainerInstanceDir", this.PS_DEPLOY_INSTANCE_DIR);
                }
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "WebContainerDocRoot", this.PS_DEPLOY_DOCROOT);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "WebContainerAdminHost", this.PS_DEPLOY_ADMIN_HOST);
                if (!this.PS_DEPLOY_TYPE.equalsIgnoreCase("IWS")) {
                    PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "WebContainerAdminPort", this.PS_DEPLOY_ADMIN_PORT);
                    PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "WebContainerAdminScheme", this.PS_DEPLOY_ADMIN_PROTOCOL);
                    PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "WebContainerAdminUid", this.PS_DEPLOY_ADMIN);
                }
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "WebContainerAdminPassword", WEB_CONTAINER_ADMIN_PASSWORD);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "WebContainerMasterPassword", WEB_CONTAINER_MASTER_PASSWORD);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "WebContainerCertificateDBPassword", CERT_DB_PASSWORD);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "WebContainerDomainName", this.PS_DEPLOY_DOMAIN);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "WebContainerJDKDir", this.PS_DEPLOY_JDK_DIR);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "WebContainerDeployCell", this.PS_DEPLOY_CELL);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "WebContainerDeployNode", this.PS_DEPLOY_NODE);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "WebContainerManagedServer", this.PS_DEPLOY_MANAGED_SERVER);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SearchServer/WebContainerProperties", "WebContainerType", UpgradeUtils.getWebContainerType("6.3.1", this.PS_DEPLOY_TYPE));
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer", "PortalID", "Upgraded");
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer", "SearchServerID", "UpgradedSearch");
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer", "PortalAccessURL", this.PS_PROTOCOL + "://" + this.HOST_NAME + ":" + this.HOST_NAME_PORT + this.PS_DEPLOY_URI);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer", "PortalWebappURI", this.PS_DEPLOY_URI);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "Host", this.HOST_NAME);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "Port", this.HOST_NAME_PORT);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "Scheme", this.PS_PROTOCOL);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "WebContainerInstallDir", this.PS_DEPLOY_PRODUCT_DIR);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "WebContainerInstanceName", this.PS_DEPLOY_INSTANCE);
                if (this.PS_DEPLOY_TYPE.equals("IWS")) {
                    PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "WebContainerInstanceDir", this.PS_DEPLOY_PRODUCT_DIR + this.fs + "https-" + this.PS_DEPLOY_INSTANCE);
                } else {
                    PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "WebContainerInstanceDir", this.PS_DEPLOY_INSTANCE_DIR);
                }
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "WebContainerDocRoot", this.PS_DEPLOY_DOCROOT);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "WebContainerAdminHost", this.PS_DEPLOY_ADMIN_HOST);
                if (!this.PS_DEPLOY_TYPE.equalsIgnoreCase("IWS")) {
                    PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "WebContainerAdminPort", this.PS_DEPLOY_ADMIN_PORT);
                    PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "WebContainerAdminScheme", this.PS_DEPLOY_ADMIN_PROTOCOL);
                    PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "WebContainerAdminUid", this.PS_DEPLOY_ADMIN);
                }
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "WebContainerAdminPassword", WEB_CONTAINER_ADMIN_PASSWORD);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "WebContainerMasterPassword", WEB_CONTAINER_MASTER_PASSWORD);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "WebContainerCertificateDBPassword", CERT_DB_PASSWORD);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "WebContainerDomainName", this.PS_DEPLOY_DOMAIN);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "WebContainerJDKDir", this.PS_DEPLOY_JDK_DIR);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "WebContainerDeployCell", this.PS_DEPLOY_CELL);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "WebContainerDeployNode", this.PS_DEPLOY_NODE);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "WebContainerManagedServer", this.PS_DEPLOY_MANAGED_SERVER);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer/Instance/WebContainerProperties", "WebContainerType", UpgradeUtils.getWebContainerType("6.3.1", this.PS_DEPLOY_TYPE));
            }
            if (SRA_INSTALLED) {
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SecureRemoteAccessCore", "GatewayProtocol", this.SRA_GW_PROTOCOL);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SecureRemoteAccessCore", "PortalServerDomain", this.SRA_SERVER_DOMAIN);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SecureRemoteAccessCore", "GatewayPort", this.SRA_GW_PORT);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SecureRemoteAccessCore", "GatewayProfileName", this.SRA_GATEWAY_PROFILE);
                PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/SecureRemoteAccessCore", "LogUserPassword", SRA_LOG_USER_PASSWORD);
            }
            if (GATEWAY_INSTALLED) {
                if (!PORTAL_INSTALLED) {
                    PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer", "PortalAccessURL", this.GW_LOAD_BALANCER_URL);
                }
                platformConfs = UpgradeUtils.returnFileListHavingPattern(GW_NLP_RWPConfigPropFileDir, "^platform.conf.\\w*$");
                UpgradeUtils.addSRAElementNodes(configfile, "Configure/PortalConfiguration", "Gateway", platformConfs, SRA_LOG_USER_PASSWORD, UpgradeUtils.getStartInstanceStatus(this.START_GATEWAY));
            }
            if (NETLET_PROXY_INSTALLED) {
                if (!PORTAL_INSTALLED) {
                    PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer", "PortalAccessURL", this.NLP_LOAD_BALANCER_URL);
                }
                platformConfs = UpgradeUtils.returnFileListHavingPattern(GW_NLP_RWPConfigPropFileDir, "^platform.conf.\\w*$");
                UpgradeUtils.addSRAElementNodes(configfile, "Configure/PortalConfiguration", "NetletProxy", platformConfs, SRA_LOG_USER_PASSWORD, UpgradeUtils.getStartInstanceStatus(this.START_NETLETPROXY));
            }
            if (REWRITER_PROXY_INSTALLED) {
                if (!PORTAL_INSTALLED) {
                    PSUpgrade.setAttributeValue(configfile, "Configure/PortalConfiguration/PortalServer", "PortalAccessURL", this.RWP_LOAD_BALANCER_URL);
                }
                platformConfs = UpgradeUtils.returnFileListHavingPattern(GW_NLP_RWPConfigPropFileDir, "^platform.conf.\\w*$");
                UpgradeUtils.addSRAElementNodes(configfile, "Configure/PortalConfiguration", "RewriterProxy", platformConfs, SRA_LOG_USER_PASSWORD, UpgradeUtils.getStartInstanceStatus(this.START_REWRITERPROXY));
            }
            if (SRA_INSTALLED || REWRITER_PROXY_INSTALLED || NETLET_PROXY_INSTALLED || GATEWAY_INSTALLED) {
                UpgradeUtils.addSRACertificateInfoElement(configfile, "Configure/PortalConfiguration", this.CERT_INFO, CERT_DB_PASSWORD);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return configfile;
    }

    void init(File initfile) throws UpgradeException {
        System.out.println("Gathering system details...");
        System.out.println("Checking for installed components...");
        System.out.println("....................................\n");
        this.log("Checking for installed components...");
        if (this.sunOS) {
            PORTAL_INSTALLED = UpgradeUtils.isPackageInstalled("SUNWps");
            SRA_INSTALLED = UpgradeUtils.isPackageInstalled("SUNWpsnf");
            GATEWAY_INSTALLED = UpgradeUtils.isPackageInstalled("SUNWpsgw");
            NETLET_PROXY_INSTALLED = UpgradeUtils.isPackageInstalled("SUNWpsnlp");
            REWRITER_PROXY_INSTALLED = UpgradeUtils.isPackageInstalled("SUNWpsrwp");
        } else if (this.linuxOS) {
            PORTAL_INSTALLED = UpgradeUtils.isRPMInstalled("sun-portal-core");
            SRA_INSTALLED = UpgradeUtils.isRPMInstalled("sun-portal-netfile");
            GATEWAY_INSTALLED = UpgradeUtils.isRPMInstalled("sun-portal-gateway");
            NETLET_PROXY_INSTALLED = UpgradeUtils.isRPMInstalled("sun-portal-netletproxy");
            REWRITER_PROXY_INSTALLED = UpgradeUtils.isRPMInstalled("sun-portal-rewriterproxy");
        }
        if (PORTAL_INSTALLED) {
            System.out.println("Detected Portal Installation.");
            this.log("Detected Portal Installation");
            this.psInstallationProps.setProperty("PORTAL_INSTALLED", "" + PORTAL_INSTALLED);
        }
        if (SRA_INSTALLED) {
            System.out.println("Detected SRA Installation.");
            this.log("Detected SRA Installation");
            this.psInstallationProps.setProperty("SRA_INSTALLED", "" + SRA_INSTALLED);
        }
        if (GATEWAY_INSTALLED) {
            System.out.println("Detected Gateway Installation.");
            this.log("Detected Gateway Installation");
            this.psInstallationProps.setProperty("GATEWAY_INSTALLED", "" + GATEWAY_INSTALLED);
        }
        if (NETLET_PROXY_INSTALLED) {
            System.out.println("Detected Netlet Proxy Installation.");
            this.log("Detected Netlet Proxy Installation");
            this.psInstallationProps.setProperty("NETLET_PROXY_INSTALLED", "" + NETLET_PROXY_INSTALLED);
        }
        if (REWRITER_PROXY_INSTALLED) {
            System.out.println("Detected Rewriter Proxy Installation.");
            this.log("Detected Rewriter Proxy Installation");
            this.psInstallationProps.setProperty("REWRITER_PROXY_INSTALLED", "" + REWRITER_PROXY_INSTALLED);
        }
        this.initPortalInstallationDetails();
        this.initAMConfigDetails();
        if (PS_DS_SSL_ENABLED.equalsIgnoreCase("true")) {
            UpgradeUtils.setSSLLDAPConnection(true);
        }
        this.psInstallationProps.setProperty("ORG_DN", this.ORG_DN);
        this.psInstallationProps.setProperty("ADMIN_DN", this.ADMIN_DN);
        this.psInstallationProps.setProperty("PS_70_PRODUCT_DIR", this.PS_70_PRODUCT_DIR);
        if (PORTAL_INSTALLED || SRA_INSTALLED) {
            WEB_CONTAINER_ADMIN_PASSWORD = UpgradeUtils.readPassword("Please enter the Web Container Admin password : ");
        }
        if (WEB_CONTAINER_ADMIN_PASSWORD == null) {
            WEB_CONTAINER_ADMIN_PASSWORD = "";
        }
        this.psInstallationProps.setProperty("WEB_CONTAINER_ADMIN_PASSWORD", WEB_CONTAINER_ADMIN_PASSWORD);
        if ((PORTAL_INSTALLED || SRA_INSTALLED) && this.PS_DEPLOY_TYPE.equals("SUNONE8")) {
            try {
                System.out.println("Portal Server is installed on Sun Java System Application Server.");
                WEB_CONTAINER_MASTER_PASSWORD = UpgradeUtils.readPassword("Please enter the Web Container Master password : ");
                if (WEB_CONTAINER_MASTER_PASSWORD == null) {
                    WEB_CONTAINER_MASTER_PASSWORD = "";
                }
                this.psInstallationProps.setProperty("WEB_CONTAINER_MASTER_PASSWORD", WEB_CONTAINER_MASTER_PASSWORD);
                String masterFilePath = this.createASPasswordFile();
                this.psInstallationProps.setProperty("WEB_CONTAINER_MASTER_PASSWORD_FILE", masterFilePath);
            }
            catch (IOException e) {
                this.log("Unable to create AS 8.1 master password file.");
                throw new UpgradeException("Unable to create AS 8.1 master password file.");
            }
        }
        if ((PORTAL_INSTALLED || SRA_INSTALLED) && this.PS_DEPLOY_TYPE.equals("WEBSPHERE")) {
            String wasJACLFilePath = "";
            try {
                wasJACLFilePath = this.createWebSphereUndeployFile();
            }
            catch (IOException e) {
                this.log("Unable to create Websphere jacl file for undeploy.");
                throw new UpgradeException("Unable to create Websphere jacl file for undeploy.");
            }
            this.psInstallationProps.setProperty("UNDEPL0Y_JACL_FILE", wasJACLFilePath);
        }
        if ((PORTAL_INSTALLED || SRA_INSTALLED) && this.PS_DEPLOY_TYPE.equals("WEBLOGIC")) {
            try {
                System.out.println("Portal Server is installed on BEA Weblogic Server.");
                WEB_CONTAINER_ADMIN_PASSWORD = UpgradeUtils.readPassword("Please enter the Web Container Admin password : ");
                while (WEB_CONTAINER_ADMIN_PASSWORD == null) {
                    WEB_CONTAINER_ADMIN_PASSWORD = UpgradeUtils.readPassword("Please enter the Web Container Admin password : ");
                    this.psInstallationProps.setProperty("WEB_CONTAINER_ADMIN_PASSWORD", WEB_CONTAINER_ADMIN_PASSWORD);
                }
            }
            catch (Exception e) {
                this.log("Unable to set BEA Admin password");
                throw new UpgradeException("Unable to set BEA Admin password");
            }
        }
        if (GATEWAY_INSTALLED || NETLET_PROXY_INSTALLED || REWRITER_PROXY_INSTALLED) {
            CERT_DB_PASSWORD = UpgradeUtils.readPassword("Please enter the SRA Certificate DB password : ");
            while (CERT_DB_PASSWORD == null) {
                CERT_DB_PASSWORD = UpgradeUtils.readPassword("Please enter the SRA Certificate DB password : ");
                this.psInstallationProps.setProperty("CERT_DB_PASSWORD", CERT_DB_PASSWORD);
            }
            SRA_LOG_USER_PASSWORD = UpgradeUtils.readPassword("Please enter the SRA Log user password : ");
            this.psInstallationProps.setProperty("CERT_DB_PASSWORD", CERT_DB_PASSWORD);
            this.psInstallationProps.setProperty("SRA_LOG_USER_PASSWORD", SRA_LOG_USER_PASSWORD);
        }
    }

    void preupgrade() throws UpgradeException {
        this.checkPreRequisites();
        Vector<String> v = new Vector<String>();
        this.prepareUpgradePropertiesFile();
        this.prepareUpgradeAntFile();
        v.add("preupgrade");
        FileUtil.replaceLineInFile(this.upgradePropFile, "psinstallFile=", "psinstallFile=" + silentJESInstall.getAbsolutePath());
        String psInstallScript = null;
        psInstallScript = this.sunOS ? "psinstallSunOSSparc" : (this.linuxOS ? "psinstallLinuxSparc" : "psinstallSunOSX86");
        File psinstallShFile = new File(RESOURCE_DIR + this.fs + ".." + this.fs + ".." + this.fs + ".." + this.fs + ".." + this.fs + ".." + this.fs + ".." + this.fs + "installer");
        this.log("The JES PS 7.0 Installer executable is:" + psinstallShFile.getAbsolutePath());
        FileUtil.replaceLineInFile(this.upgradePropFile, "psinstallShFile=", "psinstallShFile=" + psinstallShFile.getAbsolutePath());
        System.out.println("Backing up existing installation..");
        try {
            File psBackupShFile = FileUtil.extractFileFromJar(RESOURCE_DIR + this.fs + "upgraderesource.jar", "psambackup.sh");
            UpgradeUtils.preparePSAMBackupScript(this.psInstallationProps, psBackupShFile);
            FileUtil.replaceLineInFile(this.upgradePropFile, "psBackUpScript=", "psBackUpScript=" + psBackupShFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new UpgradeException("Could not back up existing installation! ", e);
        }
        try {
            File removePortalRPMsShFile = FileUtil.extractFileFromJar(RESOURCE_DIR + this.fs + "upgraderesource.jar", "removePortalRpms.sh");
            FileUtil.replaceLineInFile(this.upgradePropFile, "removePortalRPMsScript=", "removePortalRPMsScript=" + removePortalRPMsShFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new UpgradeException("Could not remove existing portal rpms! ", e);
        }
        catch (Exception e) {
            throw new UpgradeException("Could not remove existing portal rpms! ", e);
        }
        System.out.println("Installing 7.0 packages...");
        UpgradeUtils.execAnt(this.upgradeAntFilePathStr, v, "/var/tmp" + this.fs + LOGFILE + "-" + "preupgrade", this.upgradePropFilePathStr);
    }

    private void checkPreRequisites() throws UpgradeException {
        boolean success = UpgradeUtils.isDirectoryServerRunning(this.PS_DS_HOST, Integer.parseInt(this.PS_DS_PORT));
        if (!success) {
            System.out.println("Make sure the directory server " + this.PS_DS_HOST + "on port " + this.PS_DS_PORT + " is running");
            throw new UpgradeException("Unable to connect to the directory server");
        }
        success = UpgradeUtils.isAccessManagerAdminCredentialValid(this.PS_DS_HOST, Integer.parseInt(this.PS_DS_PORT), this.ADMIN_DN, IDSAME_ADMIN_PASSWORD);
        if (!success) {
            System.out.println("Invalid Access Manager credentials !!");
            throw new UpgradeException("Unable to authenticate with the Access Manager username or password");
        }
        success = UpgradeUtils.isDirectoryManagerCredentialValid(this.PS_DS_HOST, Integer.parseInt(this.PS_DS_PORT), PS_DS_DIRMGR_DN, DS_DIRMGR_PASSWORD);
        if (!success) {
            System.out.println("Invalid Directory Server Admin credentials !!");
            throw new UpgradeException("Unable to authenticate with the given LDAP Server directory manager username or password");
        }
        success = UpgradeUtils.isAccessManagerLDAPUserCredentialValid(this.PS_DS_HOST, Integer.parseInt(this.PS_DS_PORT), AM_LDAP_USER_DN, IDSAME_LDAP_USER_PASSWORD);
        if (!success) {
            System.out.println("Invalid Access Manager ldap user credentials !!");
            throw new UpgradeException("Unable to authenticate with the Access Manager ldapusername or password");
        }
        if (this.sunOS && !(success = this.checkInstalledPatches())) {
            System.out.println("Required Patches not installed. !!");
            throw new UpgradeException("Required patches not installed on this system. Upgrade will not commence.");
        }
    }

    private void prepareUpgradePropertiesFile() throws UpgradeException {
        try {
            this.upgradePropFile = FileUtil.extractFileFromJar(RESOURCE_DIR + this.fs + "upgraderesource.jar", "upgrade.properties");
            this.upgradePropFilePathStr = this.upgradePropFile.getAbsolutePath();
            this.psInstallationProps.store(new FileOutputStream(this.upgradePropFile, true), null);
        }
        catch (IOException e) {
            throw new UpgradeException("Could not fetch or store properties file from upgraderesource.jar", e);
        }
    }

    private void prepareUpgradeAntFile() throws UpgradeException {
        try {
            this.upgradeAntFile = FileUtil.extractFileFromJar(RESOURCE_DIR + this.fs + "upgraderesource.jar", "upgrade.xml");
            this.upgradeAntFilePathStr = this.upgradeAntFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new UpgradeException("Could not fetch ant file from upgraderesource.jar", e);
        }
    }

    void postupgrade() throws UpgradeException {
        int i;
        int i2;
        int i3;
        this.log("Commencing post Upgrade operations......\n\n");
        Vector<String> antTargets = new Vector<String>();
        Vector files = new Vector();
        antTargets.add("postupgrade");
        UpgradeUtils.execAnt(this.upgradeAntFilePathStr, antTargets, "/var/tmp" + this.fs + LOGFILE + "-" + "postupgrade", this.upgradePropFilePathStr);
        try {
            this.copyAllAMFilesToVarTmp(RESOURCE_DIR);
        }
        catch (IOException e) {
            throw new UpgradeException("Failed to copy the Access Manager request/resource bundle/ldif files:\n", e);
        }
        String[] amrequestfiles = null;
        String fileNamePattern = null;
        int fileCount = 0;
        if (PORTAL_INSTALLED) {
            fileNamePattern = "\\w*PSRequest[\\d]{1,3}.xml$";
            amrequestfiles = UpgradeUtils.returnFileListHavingPattern("/var/tmp", fileNamePattern);
            fileCount = amrequestfiles.length;
            for (i3 = 0; i3 < fileCount; ++i3) {
                this.psInstallationProps.setProperty("requestFile", amrequestfiles[i3]);
                FileUtil.replaceTokenInFile(new File(amrequestfiles[i3]), "ORG_DN", this.ORG_DN);
                UpgradeUtils.execAMRequest(this.psInstallationProps, "Portal Server", fileCount);
            }
        }
        if (SRA_INSTALLED) {
            fileNamePattern = "\\w*SRARequest[\\d]{1,3}.xml$";
            amrequestfiles = UpgradeUtils.returnFileListHavingPattern("/var/tmp", fileNamePattern);
            fileCount = amrequestfiles.length;
            for (i3 = 0; i3 < fileCount; ++i3) {
                this.psInstallationProps.setProperty("requestFile", amrequestfiles[i3]);
                FileUtil.replaceTokenInFile(new File(amrequestfiles[i3]), "ORG_DN", this.ORG_DN);
                UpgradeUtils.execAMRequest(this.psInstallationProps, "SRA", fileCount);
            }
            fileNamePattern = "\\w*GWRequest[\\d]{1,3}.xml$";
            amrequestfiles = UpgradeUtils.returnFileListHavingPattern("/var/tmp", fileNamePattern);
            fileCount = amrequestfiles.length;
            for (i3 = 0; i3 < fileCount; ++i3) {
                this.psInstallationProps.setProperty("requestFile", amrequestfiles[i3]);
                FileUtil.replaceTokenInFile(new File(amrequestfiles[i3]), "ORG_DN", this.ORG_DN);
                UpgradeUtils.execAMRequest(this.psInstallationProps, "Gateway", fileCount);
            }
            fileNamePattern = "\\w*NLPRequest[\\d]{1,3}.xml$";
            amrequestfiles = UpgradeUtils.returnFileListHavingPattern("/var/tmp", fileNamePattern);
            fileCount = amrequestfiles.length;
            for (i3 = 0; i3 < fileCount; ++i3) {
                this.psInstallationProps.setProperty("requestFile", amrequestfiles[i3]);
                FileUtil.replaceTokenInFile(new File(amrequestfiles[i3]), "ORG_DN", this.ORG_DN);
                UpgradeUtils.execAMRequest(this.psInstallationProps, "Netlet Proxy", fileCount);
            }
            fileNamePattern = "\\w*RWPRequest[\\d]{1,3}.xml$";
            amrequestfiles = UpgradeUtils.returnFileListHavingPattern("/var/tmp", fileNamePattern);
            fileCount = amrequestfiles.length;
            for (i3 = 0; i3 < fileCount; ++i3) {
                this.psInstallationProps.setProperty("requestFile", amrequestfiles[i3]);
                FileUtil.replaceTokenInFile(new File(amrequestfiles[i3]), "ORG_DN", this.ORG_DN);
                UpgradeUtils.execAMRequest(this.psInstallationProps, "Rewriter Proxy", fileCount);
            }
        }
        String[] amResourceBundleFiles = null;
        if (PORTAL_INSTALLED) {
            fileNamePattern = "\\w*PortalServer.res$";
            amResourceBundleFiles = UpgradeUtils.returnFileListHavingPattern("/var/tmp", fileNamePattern);
            fileCount = amResourceBundleFiles.length;
            for (i2 = 0; i2 < fileCount; ++i2) {
                this.psInstallationProps.setProperty("resourceName", amResourceBundleFiles[i2].substring(0, amResourceBundleFiles[i2].indexOf(".")));
                this.psInstallationProps.setProperty("resourceBundleFile", amResourceBundleFiles[i2]);
                UpgradeUtils.execAMResourceBundleRequest(this.psInstallationProps, "Portal Server");
            }
        }
        if (SRA_INSTALLED) {
            fileNamePattern = "\\w*SRA.res$";
            amResourceBundleFiles = UpgradeUtils.returnFileListHavingPattern("/var/tmp", fileNamePattern);
            fileCount = amResourceBundleFiles.length;
            for (i2 = 0; i2 < fileCount; ++i2) {
                this.psInstallationProps.setProperty("resourceName", amResourceBundleFiles[i2].substring(0, amResourceBundleFiles[i2].indexOf(".")));
                this.psInstallationProps.setProperty("resourceBundleFile", amResourceBundleFiles[i2]);
                UpgradeUtils.execAMResourceBundleRequest(this.psInstallationProps, "Portal Server");
            }
            fileNamePattern = "\\w*srapGateway.res$";
            amResourceBundleFiles = UpgradeUtils.returnFileListHavingPattern("/var/tmp", fileNamePattern);
            fileCount = amResourceBundleFiles.length;
            for (i2 = 0; i2 < fileCount; ++i2) {
                this.psInstallationProps.setProperty("resourceName", amResourceBundleFiles[i2].substring(0, amResourceBundleFiles[i2].indexOf(".")));
                this.psInstallationProps.setProperty("resourceBundleFile", amResourceBundleFiles[i2]);
                UpgradeUtils.execAMResourceBundleRequest(this.psInstallationProps, "Portal Server");
            }
            fileNamePattern = "\\w*srapNetlet.res$";
            amResourceBundleFiles = UpgradeUtils.returnFileListHavingPattern("/var/tmp", fileNamePattern);
            fileCount = amResourceBundleFiles.length;
            for (i2 = 0; i2 < fileCount; ++i2) {
                this.psInstallationProps.setProperty("resourceName", amResourceBundleFiles[i2].substring(0, amResourceBundleFiles[i2].indexOf(".")));
                this.psInstallationProps.setProperty("resourceBundleFile", amResourceBundleFiles[i2]);
                UpgradeUtils.execAMResourceBundleRequest(this.psInstallationProps, "Portal Server");
            }
            fileNamePattern = "\\w*srapRewriter.res$";
            amResourceBundleFiles = UpgradeUtils.returnFileListHavingPattern("/var/tmp", fileNamePattern);
            fileCount = amResourceBundleFiles.length;
            for (i2 = 0; i2 < fileCount; ++i2) {
                this.psInstallationProps.setProperty("resourceName", amResourceBundleFiles[i2].substring(0, amResourceBundleFiles[i2].indexOf(".")));
                this.psInstallationProps.setProperty("resourceBundleFile", amResourceBundleFiles[i2]);
                UpgradeUtils.execAMResourceBundleRequest(this.psInstallationProps, "Portal Server");
            }
        }
        String[] ldapModifyLdifFiles = null;
        if (PORTAL_INSTALLED) {
            fileNamePattern = "^ldapmodify\\w*PortalServer.ldif$";
            ldapModifyLdifFiles = UpgradeUtils.returnFileListHavingPattern("/var/tmp", fileNamePattern);
            fileCount = ldapModifyLdifFiles.length;
            for (i = 0; i < fileCount; ++i) {
                this.psInstallationProps.setProperty("ldifFile", ldapModifyLdifFiles[i]);
                UpgradeUtils.execLDAPModify(this.psInstallationProps, "Portal Server");
            }
        }
        if (SRA_INSTALLED) {
            fileNamePattern = "^ldapmodify\\w*SRA.ldif$";
            ldapModifyLdifFiles = UpgradeUtils.returnFileListHavingPattern("/var/tmp", fileNamePattern);
            fileCount = ldapModifyLdifFiles.length;
            for (i = 0; i < fileCount; ++i) {
                this.psInstallationProps.setProperty("ldifFile", ldapModifyLdifFiles[i]);
                UpgradeUtils.execLDAPModify(this.psInstallationProps, "SRA");
            }
            fileNamePattern = "^ldapmodify\\w*Gateway.ldif$";
            ldapModifyLdifFiles = UpgradeUtils.returnFileListHavingPattern("/var/tmp", fileNamePattern);
            fileCount = ldapModifyLdifFiles.length;
            for (i = 0; i < fileCount; ++i) {
                this.psInstallationProps.setProperty("ldifFile", ldapModifyLdifFiles[i]);
                UpgradeUtils.execLDAPModify(this.psInstallationProps, "Gateway");
            }
            fileNamePattern = "^ldapmodify\\w*Netlet.ldif$";
            ldapModifyLdifFiles = UpgradeUtils.returnFileListHavingPattern("/var/tmp", fileNamePattern);
            fileCount = ldapModifyLdifFiles.length;
            for (i = 0; i < fileCount; ++i) {
                this.psInstallationProps.setProperty("ldifFile", ldapModifyLdifFiles[i]);
                UpgradeUtils.execLDAPModify(this.psInstallationProps, "Netlet");
            }
            fileNamePattern = "^ldapmodify\\w*Rewriter.ldif$";
            ldapModifyLdifFiles = UpgradeUtils.returnFileListHavingPattern("/var/tmp", fileNamePattern);
            fileCount = ldapModifyLdifFiles.length;
            for (i = 0; i < fileCount; ++i) {
                this.psInstallationProps.setProperty("ldifFile", ldapModifyLdifFiles[i]);
                UpgradeUtils.execLDAPModify(this.psInstallationProps, "Rewriter");
            }
        }
        String[] service = null;
        String services = null;
        File amServicesRemovalFile = null;
        boolean serviceRemoved = false;
        Properties servicesProp = new Properties();
        try {
            amServicesRemovalFile = FileUtil.extractFileFromJar(RESOURCE_DIR + this.fs + "upgraderesource.jar", "servicesremove.txt");
            servicesProp.load(new FileInputStream(amServicesRemovalFile));
        }
        catch (IOException e) {
            this.log("Unable to load Services to remove file:" + amServicesRemovalFile);
        }
        if (SRA_INSTALLED) {
            services = servicesProp.getProperty("SRA.services.remove");
            this.log("SRA Services to remove:" + services);
            if (services != null) {
                service = services.split(",");
                for (int i4 = 0; i4 < service.length; ++i4) {
                    serviceRemoved = UpgradeUtils.removeService(this.psInstallationProps, service[i4]);
                    if (!serviceRemoved) {
                        System.out.println("One or more Service Removal failed. See log for details");
                        this.log(" Service Removal failed for:" + service[i4]);
                        continue;
                    }
                    this.log("Service Removal succeeded for:" + service[i4]);
                }
            } else {
                serviceRemoved = true;
            }
        }
        try {
            this.updateSearch(this.PS_DATA_DIR_OLD + this.fs + "SUNWps" + this.fs + "https-" + this.PS_DEPLOY_INSTANCE + this.fs + "portal", this.PS_70_DATA_DIR + this.fs + "SUNWportal" + this.fs + "searchservers" + this.fs + "UpgradedSearch");
        }
        catch (Exception e) {
            this.log("Could not migrate Search data! :" + e);
        }
    }

    private void copyAllAMFilesToVarTmp(String resourceDir) throws IOException {
        String[] filesEndingWith = new String[]{".xml", ".res", ".ldif"};
        String[] amfiles = UpgradeUtils.returnFileListEndingWith(RESOURCE_DIR, null, filesEndingWith);
        int fileCount = amfiles.length;
        File[] file = new File[fileCount];
        File dest = new File("/var/tmp");
        for (int i = 0; i < fileCount; ++i) {
            file[i] = new File(amfiles[i]);
            this.copy(file[i], new File(dest, file[i].getName()));
        }
    }

    void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    void mkdir(String root, String child) throws Exception {
        File d = new File(root, child);
        if (d.isDirectory()) {
            return;
        }
        if (!d.mkdir()) {
            throw new Exception("Cannot create directory: " + root + File.separator + child);
        }
    }

    public boolean rmdir(File path) {
        if (path.isDirectory()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.rmdir(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    void upgrade() throws UpgradeException {
        this.log("Performing Upgrade:");
        Vector<String> v = new Vector<String>();
        v.add("upgrade");
        FileUtil.replaceLineInFile(this.upgradePropFile, "psconfigFile=", "psconfigFile=" + configFile.getAbsolutePath());
        this.log("Configuring Portal Server 7.0 ....");
        this.log("Configuration file : " + configFile.getAbsolutePath());
        System.out.println("Configuring Portal Server 7.0...");
        String amadminPasswordFilePath = null;
        try {
            amadminPasswordFilePath = this.createAMAdminPasswordFile();
            FileUtil.replaceLineInFile(this.upgradePropFile, "AM_ADMIN_PASSWORD_FILE=", "AM_ADMIN_PASSWORD_FILE=" + amadminPasswordFilePath);
        }
        catch (IOException e) {
            System.out.println("Creating AM admin password file failed.\n. See log file for more details");
            this.log("SEVERE Creating AM admin password file failed.Deploying portletsamples.war needs to be performed manually after upgrade completes.\nDP updates also need to be performed manually.\n\n");
        }
        UpgradeUtils.execAnt(this.upgradeAntFilePathStr, v, "/var/tmp" + this.fs + LOGFILE, this.upgradePropFilePathStr);
        File DPChanges = null;
        File globalDP = null;
        File orgDP = null;
        try {
            System.out.println("Performing desktop profile updates...");
            DPChanges = FileUtil.extractFileFromJar(UpgradeConstants.RESOURCE_DIR_JES3 + "/" + "upgraderesource.jar", "DPChanges.txt");
            globalDP = new File("/var/tmp/PSUpgradeDPGlobal.xml");
            FileUtil.deleteLineInFile(globalDP, "<!DOCTYPE DisplayProfile SYSTEM", 1);
            UpgradeUtils.processDPUpdates(globalDP, DPChanges, "GLOBAL");
            orgDP = new File("/var/tmp/PSUpgradeDPOrg.xml");
            FileUtil.deleteLineInFile(orgDP, "<!DOCTYPE DisplayProfile SYSTEM", 1);
            FileUtil.replaceTokenInFile(orgDP, "/etc/opt/SUNWps/desktop", "/var/opt/SUNWportal/portals/Upgraded/desktop");
            UpgradeUtils.processDPUpdates(orgDP, DPChanges, "ORG");
            FileUtil.appendLineInFile(globalDP, "<?xml", "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n<!DOCTYPE DisplayProfile SYSTEM \"jar://resources/psdp.dtd\">\n<DisplayProfile version=\"1.0\" priority=\"0\">", 5);
            FileUtil.appendLineInFile(orgDP, "<?xml", "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n<!DOCTYPE DisplayProfile SYSTEM \"jar://resources/psdp.dtd\">\n<DisplayProfile version=\"1.0\" priority=\"10\">", 5);
            FileUtil.deleteLineInFile(globalDP, "<?xml", 1);
            FileUtil.deleteLineInFile(orgDP, "<?xml", 1);
        }
        catch (IOException e) {
            this.log("Could not update DP as per file contents of " + DPChanges.getAbsolutePath());
            this.log("Error: " + e.toString());
        }
        catch (Exception e) {
            this.log("Could not update DP as per file contents of " + DPChanges.getAbsolutePath());
            this.log("Error: " + e.toString());
        }
    }

    String createASPasswordFile() throws IOException {
        StringBuffer fileData = new StringBuffer();
        fileData.append("AS_ADMIN_PASSWORD=" + WEB_CONTAINER_ADMIN_PASSWORD + "\n");
        if (WEB_CONTAINER_MASTER_PASSWORD != null && WEB_CONTAINER_MASTER_PASSWORD.length() > 0) {
            fileData.append("AS_ADMIN_MASTERPASSWORD=" + WEB_CONTAINER_MASTER_PASSWORD + "\n");
        }
        Date curDate = new Date();
        String sTmpFile = "" + curDate.getTime();
        File appPasswordFile = File.createTempFile(sTmpFile, "");
        appPasswordFile.deleteOnExit();
        this.wcAdminPasswordFilePath = appPasswordFile.getAbsolutePath();
        FileWriter fwriter = new FileWriter(appPasswordFile);
        fwriter.write(fileData.toString());
        fwriter.close();
        return this.wcAdminPasswordFilePath;
    }

    String createAMAdminPasswordFile() throws IOException {
        StringBuffer fileData = new StringBuffer();
        fileData.append(IDSAME_ADMIN_PASSWORD + "\n");
        Date curDate = new Date();
        String sTmpFile = "" + curDate.getTime();
        File amadminPasswordFile = File.createTempFile(sTmpFile, "");
        amadminPasswordFile.deleteOnExit();
        String amadminPasswordFilePath = amadminPasswordFile.getAbsolutePath();
        FileWriter fwriter = new FileWriter(amadminPasswordFile);
        fwriter.write(fileData.toString());
        fwriter.close();
        return amadminPasswordFilePath;
    }

    String createPSAdminPasswordFile() throws IOException {
        StringBuffer fileData = new StringBuffer();
        fileData.append(IDSAME_ADMIN_PASSWORD);
        Date curDate = new Date();
        String sTmpFile = "" + curDate.getTime();
        File psadminPasswordFile = File.createTempFile(sTmpFile, "");
        psadminPasswordFile.deleteOnExit();
        String psadminPasswordFilePath = psadminPasswordFile.getAbsolutePath();
        FileWriter fwriter = new FileWriter(psadminPasswordFile);
        fwriter.write(fileData.toString());
        fwriter.close();
        return psadminPasswordFilePath;
    }

    public String createWebSphereUndeployFile() throws IOException {
        File tmpFile = null;
        tmpFile = File.createTempFile("undeploy", ".jacl");
        StringBuffer command = new StringBuffer();
        command.append("$AdminApp uninstall ");
        command.append("APP_URI");
        command.append(" {-node ");
        command.append(this.PS_DEPLOY_NODE);
        command.append(" -cell ");
        command.append(this.PS_DEPLOY_CELL);
        command.append(" -server ");
        command.append(this.PS_DEPLOY_INSTANCE);
        command.append("}");
        FileUtil.appendToFile(tmpFile, command.toString(), false);
        command = new StringBuffer();
        command.append("$AdminConfig save");
        FileUtil.appendToFile(tmpFile, command.toString(), false);
        return FileUtil.decoratePath(tmpFile.getAbsolutePath());
    }

    boolean checkInstalledPatches() {
        boolean success;
        block7: {
            success = true;
            String[] patchIDs = null;
            File patchIDsFile = null;
            try {
                patchIDsFile = FileUtil.extractFileFromJar(RESOURCE_DIR + this.fs + "upgraderesource.jar", "patches.txt");
                Properties patchProp = new Properties();
                patchProp.load(new FileInputStream(patchIDsFile));
                String patches = patchProp.getProperty(UpgradeUtils.getPatchKey());
                this.log("Checking for required pacthes..." + patches);
                if (patches != null) {
                    patchIDs = patches.split(",");
                    for (int i = 0; i < patchIDs.length; ++i) {
                        if (this.sunOS) {
                            success = UpgradeUtils.isSunOSPatchApplied(patchIDs[i]);
                        } else if (this.linuxOS) {
                            success = UpgradeUtils.isLinuxPatchApplied(patchIDs[i]);
                        }
                        if (success) continue;
                        System.out.println(" Required patch " + patchIDs[i] + "not applied. You may download it from SunSolve.\n" + "Please read README file to see if there are other required patches.");
                        this.log(" Required patch " + patchIDs[i] + " not applied. You may download it from SunSolve.");
                        break block7;
                    }
                    break block7;
                }
                success = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return success;
    }

    void log(String msg) {
        UpgradeUtils.log(msg);
    }

    void destroy() {
        UpgradeUtils.removeLogHandler();
        this.upgradeAntFile.delete();
    }

    String getInfo() {
        return "Portal Server 7.0 Upgrade, Supports PS6.3.1 to 7.0";
    }

    public void updateSearch(String oldServerRoot, String serverRoot) {
        File dir = new File(serverRoot + File.separator + "config");
        if (dir.isDirectory()) {
            try {
                this.copy(new File(oldServerRoot + File.separator + "config" + File.separator + "taxonomy.rdm"), new File(serverRoot + File.separator + "config" + File.separator + "taxonomy.rdm"));
            }
            catch (Exception e) {
                System.err.println("Exception: " + e);
            }
            try {
                this.copy(new File(oldServerRoot + File.separator + "config" + File.separator + "filterrules.conf"), new File(serverRoot + File.separator + "config" + File.separator + "filterrules.conf"));
            }
            catch (Exception e) {
                System.err.println("Exception: " + e);
            }
            dir = new File(oldServerRoot + File.separator + "db");
            if (dir.isDirectory()) {
                int i;
                try {
                    this.rmdir(new File(serverRoot + File.separator + "db"));
                    this.mkdir(serverRoot, "db");
                }
                catch (Exception e) {
                    System.err.println("Exception: " + e);
                }
                try {
                    String[] command = new String[]{serverRoot + File.separator + "run-cs-cli", "rdmgr", "-T", "-I"};
                    Process p = Runtime.getRuntime().exec(command);
                    p.waitFor();
                }
                catch (Exception e) {
                    System.err.println("Exception: " + e);
                }
                ArrayList<String> databases = new ArrayList<String>();
                File[] files = dir.listFiles();
                for (i = 0; i < files.length; ++i) {
                    if (!files[i].isDirectory() || files[i].getName().equalsIgnoreCase("root") || files[i].getName().equalsIgnoreCase("taxonomy")) continue;
                    databases.add(files[i].getName());
                }
                for (i = 0; i < databases.size(); ++i) {
                    String name = (String)databases.get(i);
                    try {
                        String[] persistentExportCommand = new String[]{oldServerRoot + File.separator + "run-cs-cli", "rdmgr", "-U", "-P", "-y", name};
                        Process p = Runtime.getRuntime().exec(persistentExportCommand);
                        this.execOutToFile(p.getInputStream(), serverRoot + File.separator + "tmp" + File.separator + name + ".p");
                        String[] nonPersistentExportCommand = new String[]{oldServerRoot + File.separator + "run-cs-cli", "rdmgr", "-U", "-N", "-y", name};
                        p = Runtime.getRuntime().exec(nonPersistentExportCommand);
                        this.execOutToFile(p.getInputStream(), serverRoot + File.separator + "tmp" + File.separator + name + ".np");
                        String[] persistentImportCommand = new String[]{serverRoot + File.separator + "run-cs-cli", "rdmgr", "-D", "-P", "-y", name, serverRoot + File.separator + "tmp" + File.separator + name + ".p"};
                        p = Runtime.getRuntime().exec(persistentImportCommand);
                        p.waitFor();
                        String[] nonPersistentImportCommand = new String[]{serverRoot + File.separator + "run-cs-cli", "rdmgr", "-D", "-N", "-y", name, serverRoot + File.separator + "tmp" + File.separator + name + ".np"};
                        p = Runtime.getRuntime().exec(nonPersistentImportCommand);
                        p.waitFor();
                        File d = new File(oldServerRoot + File.separator + "db" + File.separator + name);
                        files = d.listFiles();
                        for (int j = 0; j < files.length; ++j) {
                            if (files[j].getName().equalsIgnoreCase("rd.db")) continue;
                            this.copy(new File(files[j].getAbsolutePath()), new File(serverRoot + File.separator + "db" + File.separator + name + File.separator + files[j].getName()));
                        }
                        continue;
                    }
                    catch (Exception e) {
                        System.err.println("Exception: " + e);
                    }
                }
            }
        }
    }

    private void execOutToFile(InputStream is, String path) throws Exception {
        int returnValue;
        FileOutputStream fos = new FileOutputStream(path);
        byte[] buffer = new byte[10240];
        while ((returnValue = is.read(buffer)) >= 0) {
            fos.write(buffer, 0, returnValue);
        }
        fos.close();
    }

    static {
        DS_DIRMGR_PASSWORD = null;
        IDSAME_ADMIN_PASSWORD = null;
        IDSAME_LDAP_USER_PASSWORD = null;
        CERT_DB_PASSWORD = "";
        WEB_CONTAINER_ADMIN_PASSWORD = "";
        SRA_LOG_USER_PASSWORD = null;
        WEB_CONTAINER_MASTER_PASSWORD = "";
        silentJESInstall = null;
        configFile = null;
        DEBUG = false;
        log = null;
        execUtil = null;
        fh = null;
        AM_SPECIAL_USER_DN = null;
        AM_LDAP_USER_DN = null;
        PS_PRODUCT_VERSION = null;
        RESOURCE_DIR = null;
        PS_DS_SSL_ENABLED = null;
        try {
            log = Logger.getLogger("PSUpgrade.class");
            fh = new FileHandler("/var/tmp" + File.separator + LOGFILE, true);
            fh.setFormatter(new SimpleFormatter());
            Handler[] logHandlers = log.getHandlers();
            for (int i = 0; i < logHandlers.length; ++i) {
                logHandlers[i].close();
                log.removeHandler(logHandlers[i]);
            }
            log.setUseParentHandlers(false);
            log.addHandler(fh);
            UpgradeUtils.setLogger(log);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }
}

