/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks.scheduler;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.fabric.util.os.OSTasks;
import com.sun.portal.fabric.util.os.OSTasksFactory;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SchedulerTask {
    private Logger logger;
    private OSTasks osTasks;

    public SchedulerTask(PSConfigContext cc, Logger logger) {
        this.logger = logger;
        OSTasksFactory osTasksFactory = OSTasksFactory.getInstance();
        this.osTasks = OSTasksFactory.getOSTasks(cc, logger);
    }

    public void schedule(ArrayList actions) {
        for (int i = 0; i < actions.size(); ++i) {
            String action = (String)actions.get(i);
            try {
                this.osTasks.scheduling(action, "schedule");
                continue;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.toString());
            }
        }
    }

    public void unschedule(ArrayList actions) {
        for (int i = 0; i < actions.size(); ++i) {
            String action = (String)actions.get(i);
            try {
                this.osTasks.scheduling(action, "unschedule");
                continue;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.toString());
            }
        }
    }

    public ArrayList getSchedules(String command) {
        try {
            return this.osTasks.getSchedules(command);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.toString());
            return new ArrayList();
        }
    }
}

