/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import java.util.Iterator;
import java.util.Set;
import javax.naming.Context;
import weblogic.jndi.Environment;
import weblogic.management.MBeanHome;
import weblogic.management.configuration.JDBCConnectionPoolMBean;
import weblogic.management.configuration.JDBCTxDataSourceMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.ServerStartMBean;
import weblogic.management.configuration.TargetMBean;

public class WeblogicServerHelper {
    public static void main(String[] args) throws Exception {
        System.out.println("Indise  WeblogicServerHelper main\n" + args.length);
        if (args.length < 2 || !args[0].equalsIgnoreCase("-method")) {
            throw new Exception("Usuage: WeblogicServerHelper -method <methodname> [-params < > < > ...] ");
        }
        if (args[1].equals("setManagedServerClasspath")) {
            if (args.length < 5) {
                throw new Exception("Usuage: WeblogicServerHelper -method setManagedServerClasspath -params adminurl username password instancename classpath ");
            }
            WeblogicServerHelper.setManagedServerClasspath(args[3], args[4], args[5], args[6], args[7]);
        }
        if (args[1].equals("setTargetsToDatasources")) {
            WeblogicServerHelper.setTargetsToDatasources(args[3], args[4], args[5], args[6], args[7]);
        }
        if (args[1].equals("setTargetsToConnectionPools")) {
            WeblogicServerHelper.setTargetsToConnectionPools(args[3], args[4], args[5], args[6]);
        }
    }

    public static void setManagedServerClasspath(String url, String username, String password, String wcTargetInstance, String classpath) throws Exception {
        try {
            Environment env = new Environment();
            env.setProviderUrl(url);
            env.setSecurityPrincipal(username);
            env.setSecurityCredentials((Object)password);
            Context ctx = env.getInitialContext();
            MBeanHome home = (MBeanHome)ctx.lookup("weblogic.management.adminhome");
            Set allServerStartMBeans = home.getMBeansByType("ServerStart");
            Iterator itr = allServerStartMBeans.iterator();
            while (itr.hasNext()) {
                ServerStartMBean mbean = (ServerStartMBean)itr.next();
                String oldClasspath = mbean.getClassPath();
                if (!mbean.getName().equals(wcTargetInstance)) continue;
                if (oldClasspath != null) {
                    classpath = classpath + ":" + oldClasspath;
                }
                mbean.setClassPath(classpath);
            }
        }
        catch (Exception e) {
            throw new Exception("Unable to set Managed server start classpath: " + e.toString());
        }
    }

    public static void setTargetsToDatasources(String url, String username, String password, String wcTargetInstance, String jndiName) throws Exception {
        try {
            Environment env = new Environment();
            env.setProviderUrl(url);
            env.setSecurityPrincipal(username);
            env.setSecurityCredentials((Object)password);
            Context ctx = env.getInitialContext();
            MBeanHome home = (MBeanHome)ctx.lookup("weblogic.management.adminhome");
            Set allServerMBeans = home.getMBeansByType("Server");
            ServerMBean serverMbean = null;
            Iterator itr = allServerMBeans.iterator();
            while (itr.hasNext() && !(serverMbean = (ServerMBean)itr.next()).getName().equals(wcTargetInstance)) {
            }
            Set allDataSourceMBeans = home.getMBeansByType("JDBCTxDataSource");
            Iterator itr2 = allDataSourceMBeans.iterator();
            while (itr2.hasNext()) {
                JDBCTxDataSourceMBean mbean = (JDBCTxDataSourceMBean)itr2.next();
                if (!mbean.getJNDIName().equals(jndiName)) continue;
                mbean.addTarget((TargetMBean)serverMbean);
            }
        }
        catch (Exception e) {
            throw new Exception("Unable to add targets to the datasources: " + e.toString());
        }
    }

    public static void setTargetsToConnectionPools(String url, String username, String password, String wcTargetInstance) throws Exception {
        try {
            Environment env = new Environment();
            env.setProviderUrl(url);
            env.setSecurityPrincipal(username);
            env.setSecurityCredentials((Object)password);
            Context ctx = env.getInitialContext();
            MBeanHome home = (MBeanHome)ctx.lookup("weblogic.management.adminhome");
            Set allServerMBeans = home.getMBeansByType("Server");
            ServerMBean serverMbean = null;
            Iterator itr = allServerMBeans.iterator();
            while (itr.hasNext() && !(serverMbean = (ServerMBean)itr.next()).getName().equals(wcTargetInstance)) {
            }
            Set allConnectionPoolMBeans = home.getMBeansByType("JDBCConnectionPool");
            Iterator itr2 = allConnectionPoolMBeans.iterator();
            while (itr2.hasNext()) {
                JDBCConnectionPoolMBean mbean = (JDBCConnectionPoolMBean)itr2.next();
                mbean.addTarget((TargetMBean)serverMbean);
            }
        }
        catch (Exception e) {
            throw new Exception("Unable to add targets to the connection pool: " + e.toString());
        }
    }
}

