/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.sun.portal.admin.common.util.AdminUtil;
import com.sun.portal.fabric.tasks.BEAWL8Impl;
import com.sun.portal.fabric.tasks.ConfigurationException;
import com.sun.portal.fabric.tasks.IBMWAS5Impl;
import com.sun.portal.fabric.tasks.JESAS7Impl;
import com.sun.portal.fabric.tasks.JESAS81Impl;
import com.sun.portal.fabric.tasks.JESWS6Impl;
import com.sun.portal.fabric.tasks.ValidationException;
import com.sun.portal.fabric.tasks.WebContainer;
import com.sun.portal.fabric.tasks.WebContainerBase;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class WebContainerFactory {
    private WebContainerFactory() {
    }

    public static WebContainer getWebContainer(Map attributes, Logger logger, boolean bValidate) throws ConfigurationException, IllegalArgumentException {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes=null");
        }
        if (logger == null) {
            throw new IllegalArgumentException("logger=null");
        }
        String type = (String)attributes.get("WebContainerType");
        if (type == null || type.length() <= 0) {
            throw new ConfigurationException("Invalid Web Container Type=null");
        }
        WebContainerBase wc = null;
        try {
            if (type.equals("IBMWAS5")) {
                wc = new IBMWAS5Impl(attributes, logger);
            } else if (type.equals("BEAWL8")) {
                wc = new BEAWL8Impl(attributes, logger);
            } else if (type.equals("SJSAS7")) {
                wc = new JESAS7Impl(attributes, logger);
            } else if (type.equals("SJSAS81")) {
                wc = new JESAS81Impl(attributes, logger);
            } else if (type.equals("SJSWS6")) {
                wc = new JESWS6Impl(attributes, logger);
            } else {
                throw new ConfigurationException("Invalid Web Container Type = " + type);
            }
            if (bValidate) {
                String sHostName = (String)attributes.get("Host");
                boolean bIsLocalHost = false;
                try {
                    bIsLocalHost = AdminUtil.isLocal((String)sHostName);
                }
                catch (UnknownHostException e) {
                    wc = null;
                    if (logger.isLoggable(Level.SEVERE)) {
                        LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0081");
                        record.setParameters(new String[]{sHostName});
                        record.setThrown(e);
                        record.setLoggerName(logger.getName());
                        logger.log(record);
                    }
                    throw new ConfigurationException(e);
                }
                if (bIsLocalHost) {
                    wc.validate();
                } else {
                    logger.log(Level.INFO, "PSFB_CSPFT0080", new String[]{sHostName});
                }
            }
            wc.postValidationInit();
        }
        catch (ValidationException e) {
            wc = null;
            if (logger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, e.getMessage());
                record.setThrown(e);
                record.setLoggerName(logger.getName());
                logger.log(record);
            }
            throw new ConfigurationException(e);
        }
        return wc;
    }
}

