/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.fabric.tasks.ConfigDataPlayback;
import com.sun.portal.fabric.tasks.ConfigDataRecorder;
import com.sun.portal.fabric.tasks.ConfigDataRecorderPlaybackException;
import com.sun.portal.fabric.tasks.ConfigurationException;
import com.sun.portal.fabric.tasks.ValidationException;
import com.sun.portal.fabric.tasks.WebContainer;
import com.sun.portal.fabric.tasks.WebContainerTasks;
import com.sun.portal.fabric.util.ClasspathGenUtil;
import com.sun.portal.fabric.util.ExecuteUtil;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.fabric.util.NetworkUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public abstract class WebContainerBase
implements WebContainer,
WebContainerTasks {
    private String derbyHost = null;
    private String derbyPort = null;
    private String databaseName = null;
    protected String wcType = null;
    protected String wcPrintableInstanceName = null;
    protected Logger logger = null;
    protected ExecuteUtil execUtil = null;
    protected Map wcAttributes = null;
    protected String domainID = null;
    protected String portalID = null;
    protected String instanceID = null;
    static final String DOMAIN_ID = "com.sun.portal.domain.id";
    static final String PORTAL_ID = "com.sun.portal.portal.id";
    static final String INSTANCE_ID = "com.sun.portal.instance.id";
    static final String PORTAL_TEST_JAR = "ps_util.jar";

    protected WebContainerBase(Map webContainerProperties, Logger logger) {
        this.logger = logger;
        this.execUtil = new ExecuteUtil(logger);
        this.wcAttributes = webContainerProperties;
        this.wcType = (String)this.wcAttributes.get("WebContainerType");
        this.domainID = (String)this.wcAttributes.get(DOMAIN_ID);
        if (this.portalID == null) {
            this.portalID = (String)this.wcAttributes.get(PORTAL_ID);
        }
        this.instanceID = (String)this.wcAttributes.get("Name");
    }

    public void configure(PSConfigContext configContext) throws ConfigurationException {
        block8: {
            try {
                this.doIdentitySDKConfig(configContext);
                if (!this.isPortalConfigured()) {
                    String sPSLibDir = configContext.getPSBaseDir() + WebContainer.fs + "lib";
                    String sPortalConfigDataDir = configContext.getPSDataDir() + WebContainer.fs + "portals" + WebContainer.fs + this.portalID + WebContainer.fs + "config";
                    try {
                        ConfigDataRecorder recorder = new ConfigDataRecorder(sPSLibDir, sPortalConfigDataDir, this.logger);
                        if (!recorder.isRecordingFound()) {
                            String classpath = ClasspathGenUtil.getClasspath("server.classpath", false);
                            this.logger.log(Level.FINEST, "WebContainer Classpath :" + classpath);
                            recorder.doRecordPath("classpath", classpath);
                            recorder.doRecordJVMOption(PORTAL_ID, this.portalID);
                            recorder.doRecordJVMOption(INSTANCE_ID, "@INSTANCE_ID@");
                            recorder.doRecordJVMOption("com.sun.portal.log.config.file", sPortalConfigDataDir + WebContainer.fs + "PSLogConfig.properties");
                            recorder.doRecordJVMOption("jdbc.drivers", "org.apache.derby.jdbc.ClientDriver");
                            recorder.doRecordJVMOption("java.awt.headless", "true");
                            recorder.doRecordResources(sPortalConfigDataDir);
                            recorder.doRecordPath("native_lib_path", sPSLibDir);
                            recorder.saveRecording();
                        }
                        HashMap<String, String> valueMap = new HashMap<String, String>();
                        valueMap.put("@INSTANCE_ID@", this.instanceID);
                        valueMap.put("ps.config.location", configContext.getPSConfigDir());
                        valueMap.put("ps.product.location", configContext.getPSBaseDir());
                        valueMap.put("shared.lib.location", configContext.getSharedLibsDir());
                        valueMap.put("derby.lib.location", configContext.getDerbyLibDir());
                        String cacaoBaseDir = configContext.getCacaoBaseDir();
                        if (System.getProperty("os.name").indexOf("inux") > 0) {
                            cacaoBaseDir = cacaoBaseDir + "/share";
                        }
                        valueMap.put("cacao.product.location", cacaoBaseDir);
                        ConfigDataPlayback player = new ConfigDataPlayback(sPSLibDir, sPortalConfigDataDir, this.logger, this, valueMap);
                        if (!player.isRecordingFound()) {
                            String msg = "Recording missing for portal '" + this.portalID + "'.";
                            throw new ConfigurationException(msg);
                        }
                        player.doPlayback();
                    }
                    catch (ConfigDataRecorderPlaybackException e) {
                        throw new ConfigurationException(e);
                    }
                    this.createSymbolicLinks(configContext);
                    this.doMiscTasks(configContext);
                    break block8;
                }
                this.logger.log(Level.INFO, "PSFB_CSPFT0034", new String[]{this.wcType, this.wcPrintableInstanceName});
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block8;
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0035");
                record.setParameters(new String[]{this.wcType, this.wcPrintableInstanceName});
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
        }
    }

    public void unconfigure(PSConfigContext configContext) throws ConfigurationException {
        block4: {
            try {
                String classpath = ClasspathGenUtil.getClasspath("server.classpath", true);
                if (this.removeClasspath(classpath)) {
                    this.removeJVMOption(PORTAL_ID, this.portalID);
                    this.removeJVMOption(INSTANCE_ID, this.instanceID);
                    this.removeJVMOption("com.sun.portal.log.config.file", configContext.getPSDataDir() + WebContainer.fs + "portals" + WebContainer.fs + this.portalID + WebContainer.fs + "config" + WebContainer.fs + "PSLogConfig.properties");
                    this.removeJVMOption("java.awt.headless", "true");
                    this.deleteResource(configContext.getPSDataDir() + WebContainer.fs + "portals" + WebContainer.fs + this.portalID + WebContainer.fs + "config");
                    this.removeNativeLibraryPath(configContext.getPSBaseDir() + WebContainer.fs + "lib");
                    this.deleteSymbolicLinks(configContext);
                    this.undoMiscTasks(configContext);
                } else {
                    this.logger.log(Level.INFO, "PSFB_CSPFT0036", new String[]{this.wcType, this.wcPrintableInstanceName});
                }
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block4;
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0037");
                record.setParameters(new String[]{this.wcType, this.wcPrintableInstanceName});
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
        }
    }

    public boolean configureApp(String configDir, PSConfigContext configContext, String sPortalID) throws ConfigurationException {
        boolean ret = true;
        try {
            String jvm;
            File jvmFile;
            String sPSLibDir = configContext.getPSBaseDir() + WebContainer.fs + "lib";
            this.portalID = sPortalID;
            String sPortalConfigDataDir = configContext.getPSDataDir() + WebContainer.fs + "portals" + WebContainer.fs + this.portalID + WebContainer.fs + "config";
            ConfigDataRecorder recorder = new ConfigDataRecorder(sPSLibDir, sPortalConfigDataDir, this.logger);
            String serverCP = configDir + WebContainer.fs + "server.classpath";
            File scpFile = new File(serverCP);
            if (scpFile.exists()) {
                String classpath = ClasspathGenUtil.getClasspath(serverCP, true);
                recorder.doRecordPath("classpath", classpath);
                ret = this.appendClasspath(classpath);
                this.logger.log(Level.INFO, "PSFB_CSPFT0093", new String[]{classpath, ":" + ret});
                if (!ret) {
                    return ret;
                }
            }
            if ((jvmFile = new File(jvm = configDir + WebContainer.fs + "jvmoptions.properties")).exists()) {
                try {
                    FileInputStream in = new FileInputStream(jvmFile);
                    if (in != null) {
                        Properties props = new Properties();
                        props.load(in);
                        Enumeration<Object> enumeration = props.keys();
                        while (enumeration.hasMoreElements()) {
                            String option = (String)enumeration.nextElement();
                            String value = props.getProperty(option);
                            recorder.doRecordJVMOption(option, value);
                            ret = this.addJVMOption(option, value);
                            this.logger.log(Level.INFO, "PSFB_CSPFT0096", new String[]{option, value, ":" + ret});
                            if (ret) continue;
                            return ret;
                        }
                        ((InputStream)in).close();
                    }
                }
                catch (IOException e) {
                    ret = false;
                }
            }
            recorder.doRecordResources(configDir);
            this.createResource(configDir, sPSLibDir);
            recorder.saveRecording();
        }
        catch (ConfigDataRecorderPlaybackException e) {
            throw new ConfigurationException(e);
        }
        return ret;
    }

    public void configureSearch(String classpath, PSConfigContext configContext) throws ConfigurationException {
        this.appendClasspath(classpath);
        this.setNativeLibraryPath(configContext.getPSBaseDir() + WebContainer.fs + "lib");
        this.stop();
        this.start();
    }

    public void unconfigureSearch(String classpath, PSConfigContext configContext) throws ConfigurationException {
        this.removeClasspath(classpath);
    }

    public void deploy(String warFile, String uri) throws ConfigurationException {
        RuntimeException e = new RuntimeException("Method 'deploy' NOT implemented.");
        throw e;
    }

    public void undeploy(String uri) throws ConfigurationException {
        RuntimeException e = new RuntimeException("Method 'undeploy' NOT implemented.");
        throw e;
    }

    public void start() throws ConfigurationException {
        RuntimeException e = new RuntimeException("Method 'start' NOT implemented.");
        throw e;
    }

    public void stop() throws ConfigurationException {
        RuntimeException e = new RuntimeException("Method 'stop' NOT implemented.");
        throw e;
    }

    public void validate() throws ValidationException {
        RuntimeException e = new RuntimeException("Method 'validate' NOT implemented.");
        throw e;
    }

    public void postValidationInit() throws ConfigurationException {
        RuntimeException e = new RuntimeException("Method 'postValidate' NOT implemented.");
        throw e;
    }

    protected boolean checkDirExists(String token, String value) {
        File dir = null;
        try {
            dir = new File(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            dir = null;
        }
        boolean bIsDir = dir != null ? dir.isDirectory() : false;
        String sLogMsgID = bIsDir ? "PSFB_CSPFT0001" : "PSFB_CSPFT0002";
        Level logLevel = bIsDir ? Level.INFO : Level.SEVERE;
        this.logger.log(logLevel, sLogMsgID, new String[]{this.wcType, token, value});
        return bIsDir;
    }

    protected String getFilteredClassPath(String sourceCP, String filterListCP) {
        StringBuffer filteredCP = new StringBuffer();
        String[] sourceJars = sourceCP.split(File.pathSeparator);
        for (int idx = 0; idx < sourceJars.length; ++idx) {
            if (filterListCP.indexOf(sourceJars[idx]) >= 0) continue;
            filteredCP.append(sourceJars[idx]).append(File.pathSeparator);
        }
        return filteredCP.toString();
    }

    protected String getMergedClassPath(String sourceCP, String targetCP) {
        StringBuffer mergedCP = new StringBuffer();
        mergedCP.append(this.getFilteredClassPath(sourceCP, targetCP));
        mergedCP.append(targetCP);
        return mergedCP.toString();
    }

    protected boolean checkFileExists(String token, String value) {
        File file = null;
        try {
            file = new File(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            file = null;
        }
        boolean bIsFile = file != null ? file.isFile() : false;
        String sLogMsgID = bIsFile ? "PSFB_CSPFT0094" : "PSFB_CSPFT0095";
        Level logLevel = bIsFile ? Level.INFO : Level.SEVERE;
        this.logger.log(logLevel, sLogMsgID, new String[]{this.wcType, token, value});
        return bIsFile;
    }

    private boolean validateHostNamePort(String host, String portno, String sHostPassMsgID, String sHostFailMsgID, String sPortPassMsgID, String sPortFailMsgID) {
        boolean bIsValid = NetworkUtil.isHostValid(host);
        Level logLevel = bIsValid ? Level.INFO : Level.SEVERE;
        String sLogMsgID = bIsValid ? sHostPassMsgID : sHostFailMsgID;
        this.logger.log(logLevel, sLogMsgID, new String[]{this.wcType, host});
        if (bIsValid) {
            bIsValid = NetworkUtil.isPortValid(host, portno);
            logLevel = bIsValid ? Level.INFO : Level.SEVERE;
            sLogMsgID = bIsValid ? sPortPassMsgID : sPortFailMsgID;
            this.logger.log(logLevel, sLogMsgID, new String[]{this.wcType, host, portno});
        }
        return bIsValid;
    }

    protected boolean validateInstanceHostNamePort(String host, String port) {
        return this.validateHostNamePort(host, port, "PSFB_CSPFT0004", "PSFB_CSPFT0005", "PSFB_CSPFT0008", "PSFB_CSPFT0009");
    }

    protected boolean validateAdminHostNamePort(String adminHost, String adminPort) {
        return this.validateHostNamePort(adminHost, adminPort, "PSFB_CSPFT0006", "PSFB_CSPFT0007", "PSFB_CSPFT0010", "PSFB_CSPFT0011");
    }

    protected boolean checkNotNull(String token, String value) {
        return this.checkNotNull(token, value, false);
    }

    protected boolean checkNotNull(String token, String value, boolean secure) {
        boolean bRet = true;
        if (value == null) {
            this.logger.log(Level.SEVERE, "PSFB_CSPFT0003", new String[]{this.wcType, token});
            bRet = false;
        } else {
            String printValue = secure ? value.replaceAll(".", "*") : value;
            this.logger.log(Level.INFO, "PSFB_CSPFT0033", new String[]{this.wcType, token, printValue});
        }
        return bRet;
    }

    protected boolean checkNotNullOrEmpty(String token, String value) {
        boolean bRet = true;
        if (value == null || value.length() <= 0) {
            this.logger.log(Level.SEVERE, "PSFB_CSPFT0032", new String[]{this.wcType, token});
            bRet = false;
        } else {
            this.logger.log(Level.INFO, "PSFB_CSPFT0033", new String[]{this.wcType, token, value});
        }
        return bRet;
    }

    public void createResource(Element resource, String psLibDir) {
        if (resource != null) {
            this.processURL(resource.getAttributeValue("url"));
            String resourceName = resource.getAttributeValue("name");
            int startIndex = resourceName.indexOf("/");
            if (startIndex >= 0) {
                resourceName = resourceName.substring(startIndex + 1);
            }
            String poolName = resourceName + "Pool";
            this.configResource(resource, this.derbyHost, this.derbyPort, this.databaseName, poolName, psLibDir);
        }
    }

    public void createResource(String sConfigDir, String psLibDir) {
        try {
            File confDir = new File(sConfigDir);
            ArrayList datasourceFiles = new ArrayList();
            FileUtil.getFiles(confDir, datasourceFiles, "datasource");
            int iDataSourceFiles = datasourceFiles != null ? datasourceFiles.size() : 0;
            for (int i = 0; i < iDataSourceFiles; ++i) {
                File datasource = (File)datasourceFiles.get(i);
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(datasource.getAbsolutePath());
                this.logger.log(Level.INFO, "PSFB_CSPFT0085", datasource.getAbsolutePath());
                this.createResource(doc.getRootElement(), psLibDir);
            }
        }
        catch (JDOMException e) {
            this.logger.log(Level.SEVERE, "PSFB_CSPFT0089", new String[]{sConfigDir, e.getMessage()});
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "PSFB_CSPFT0084", new String[]{sConfigDir, e.getMessage()});
        }
    }

    public void deleteResource(String configDir) {
        try {
            File confDir = new File(configDir);
            Vector datasourceFiles = new Vector();
            FileUtil.getFiles(confDir, datasourceFiles, "datasource");
            if (datasourceFiles != null) {
                for (int i = 0; i < datasourceFiles.size(); ++i) {
                    File datasource = (File)datasourceFiles.get(i);
                    SAXBuilder builder = new SAXBuilder();
                    Document doc = builder.build(datasource.getAbsolutePath());
                    this.logger.log(Level.INFO, "PSFB_CSPFT0085", datasource.getAbsolutePath());
                    Element root = doc.getRootElement();
                    String poolName = null;
                    String jndiName = root.getAttributeValue("name");
                    if (jndiName.indexOf("/") != -1) {
                        int startIndx = jndiName.indexOf("/") + 1;
                        poolName = jndiName.substring(startIndx) + "Pool";
                    } else {
                        poolName = jndiName + "Pool";
                    }
                    this.unConfigResource(jndiName, poolName);
                }
            }
        }
        catch (JDOMException e) {
            this.logger.log(Level.SEVERE, "PSFB_CSPFT0089", new String[]{configDir, e.getMessage()});
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "PSFB_CSPFT0084", new String[]{configDir, e.getMessage()});
        }
    }

    private void processURL(String url) {
        int beginIndx = url.indexOf("//");
        String subStr = url.substring(beginIndx + 2);
        int endIndx = subStr.indexOf(":");
        int indx1 = subStr.indexOf(";");
        int indx = subStr.indexOf("/");
        if (endIndx == -1) {
            endIndx = subStr.indexOf("/");
            this.derbyPort = "1527";
        } else {
            this.derbyPort = subStr.substring(endIndx + 1, indx);
        }
        this.derbyHost = subStr.substring(0, endIndx);
        this.databaseName = indx1 == -1 ? subStr.substring(indx + 1) : subStr.substring(indx + 1, indx1);
        this.logger.log(Level.INFO, "PSFB_CSPFT0086", new String[]{this.derbyHost, this.derbyPort, this.databaseName});
    }

    public Logger getLogger() {
        return this.logger;
    }
}

