/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.sun.portal.fabric.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class UploadInfo {
    private String mName = null;
    private long mSize = 0L;
    private File mFile = null;
    private FileOutputStream mOutputStream = null;
    public static final String STRING_UNDERSCORE = "_";

    public UploadInfo(String fileName, long fileSize, String tempFileDir) throws IOException {
        this.mName = fileName;
        this.mSize = fileSize;
        this.mFile = this.createTempFile(tempFileDir);
        this.mOutputStream = new FileOutputStream(this.mFile, true);
    }

    private File createTempFile(String tempDir) {
        String tempFileName = this.mName + STRING_UNDERSCORE + this.mSize + STRING_UNDERSCORE + FileUtil.getRandomDirName();
        tempDir = tempDir + File.separator + "tmp";
        this.mFile = new File(tempDir, tempFileName);
        this.mName = tempDir + File.separator + tempFileName;
        return this.mFile;
    }

    public String getName() {
        return this.mName;
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.mOutputStream.write(bytes);
    }

    public boolean deleteFile() {
        try {
            this.mOutputStream.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        boolean retStatus = this.mFile.delete();
        return retStatus;
    }
}

