/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.fabric.tasks.ConfigurationException;
import com.sun.portal.fabric.tasks.WebContainer;
import com.sun.portal.fabric.tasks.WebContainerFactory;
import com.sun.portal.fabric.util.AMTaskUtil;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.fabric.util.LogConfigUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SearchSetup {
    private static final String searchServerDomainDirName = "searchservers";
    private static final String templateWarfileName = "rdm.war";
    private static final String fs = File.separator;
    private String javaHomeDirName = null;
    private String jssnssDirName = null;
    private String ktSearchDirName = null;
    private String isBaseDirName = null;
    private String psDirName = null;
    private String psConfDirName = null;
    private String psDataDirName = null;
    private String searchServerID = null;
    private String uri = null;
    private Properties webContainerProperties = null;
    private String amAdminUserDN = null;
    private String amAdminPassword = null;
    private PSConfigContext configContext = null;
    private boolean isWindows = false;
    private Logger logger = null;

    public SearchSetup(Logger logger) {
        this.logger = logger;
        this.isWindows = this.isWindowsOS();
    }

    public void configuration(PSConfigContext configContext, String searchServerID) {
        this.configContext = configContext;
        this.javaHomeDirName = configContext.getJavaHome();
        this.jssnssDirName = configContext.getJSSNSSLibDir();
        this.ktSearchDirName = configContext.getPrivateSharedLibsDir();
        this.psDirName = configContext.getPSBaseDir();
        this.psDataDirName = configContext.getPSDataDir();
        this.searchServerID = searchServerID;
        try {
            this.configureInstance();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to configure new search server", e);
        }
    }

    public void deployment(PSConfigContext configContext, String searchServerID, String uri, Properties webContainerProperties) {
        this.configContext = configContext;
        this.isBaseDirName = configContext.getISBaseDir();
        this.psDirName = configContext.getPSBaseDir();
        this.psConfDirName = configContext.getPSConfigDir();
        this.psDataDirName = configContext.getPSDataDir();
        this.searchServerID = searchServerID;
        this.uri = uri;
        this.webContainerProperties = webContainerProperties;
        this.amAdminUserDN = configContext.getAdminUserDN();
        this.amAdminPassword = AdminServerUtil.getPassword();
        try {
            this.configureWebContainer();
            this.copyWar();
            this.configureWar();
            this.deployWar();
        }
        catch (ConfigurationException ce) {
            this.logger.log(Level.SEVERE, null, ce);
        }
        catch (IllegalArgumentException iae) {
            this.logger.log(Level.SEVERE, null, iae);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to deploy new search server", e);
        }
    }

    public void redeployment(PSConfigContext configContext, String searchServerID, String uri, Properties webContainerProperties) {
        this.configContext = configContext;
        this.isBaseDirName = configContext.getISBaseDir();
        this.psDirName = configContext.getPSBaseDir();
        this.psConfDirName = configContext.getPSConfigDir();
        this.psDataDirName = configContext.getPSDataDir();
        this.searchServerID = searchServerID;
        this.uri = uri;
        this.webContainerProperties = webContainerProperties;
        this.amAdminUserDN = configContext.getAdminUserDN();
        this.amAdminPassword = AdminServerUtil.getPassword();
        try {
            this.undeployWar();
            this.copyWar();
            this.configureWar();
            this.deployWar();
        }
        catch (ConfigurationException ce) {
            this.logger.log(Level.SEVERE, null, ce);
        }
        catch (IllegalArgumentException iae) {
            this.logger.log(Level.SEVERE, null, iae);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to redeploy search server", e);
        }
    }

    public void delete(PSConfigContext configContext, String searchServerID, String uri, Properties webContainerProperties) {
        this.configContext = configContext;
        this.psDirName = configContext.getPSBaseDir();
        this.psDataDirName = configContext.getPSDataDir();
        this.searchServerID = searchServerID;
        this.uri = uri;
        this.webContainerProperties = webContainerProperties;
        try {
            this.undeployWar();
        }
        catch (ConfigurationException ce) {
            this.logger.log(Level.SEVERE, null, ce);
        }
        catch (IllegalArgumentException iae) {
            this.logger.log(Level.SEVERE, null, iae);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to delete search server", e);
        }
        String dirName = this.psDataDirName + fs + searchServerDomainDirName + fs + searchServerID;
        FileUtil.deleteDir(dirName);
    }

    private void configureInstance() throws Exception {
        String dirName = this.psDataDirName + fs + searchServerDomainDirName + fs + this.searchServerID;
        FileUtil.makeDir(dirName + fs + "config");
        FileUtil.makeDir(dirName + fs + "logs");
        FileUtil.makeDir(dirName + fs + "robot");
        FileUtil.makeDir(dirName + fs + "tmp");
        FileUtil.makeDir(dirName + fs + "db");
        this.createServerRdm(dirName);
        if (this.isWindows) {
            this.createScript(dirName, "run-cs-cli.bat", "%*");
            this.createJavaScript(dirName, "StartRobot.bat", "com.sun.portal.search.admin.cli.RobotController \"" + dirName + "\" start");
            this.createJavaScript(dirName, "StopRobot.bat", "com.sun.portal.search.admin.cli.RobotController \"" + dirName + "\" stop");
        } else {
            this.createScript(dirName, "run-cs-cli", "\"$@\"");
            this.createJavaScript(dirName, "StartRobot", "com.sun.portal.search.admin.cli.RobotController \"" + dirName + "\" start");
            this.createJavaScript(dirName, "StopRobot", "com.sun.portal.search.admin.cli.RobotController \"" + dirName + "\" stop");
        }
        this.createConfigurationFile(dirName, "search.conf");
        this.createConfigurationFile(dirName, "robot.conf");
        this.createConfigurationFile(dirName, "filter.conf");
        this.createConfigurationFile(dirName, "import.conf");
        this.createConfigurationFile(dirName, "filterrules.conf");
        this.createConfigurationFile(dirName, "classification.conf");
        this.createConfigurationFile(dirName, "convert.conf");
        this.createConfigurationFile(dirName, "mime.types");
        this.createConfigurationFile(dirName, "schema.rdm");
        this.createConfigurationFile(dirName, "taxonomy.rdm");
        this.createConfigurationFile(dirName, "converter.cfg");
        this.createConfigurationFile(dirName, "converter.template");
        LogConfigUtil.createSearchLogConfigFile(this.psDirName, this.psDataDirName, this.searchServerID);
        this.logger.log(Level.FINEST, "Created search log config file PSLogConfig.properties");
        String emptyFileName = dirName + fs + "tmp" + fs + "empty";
        FileOutputStream emptyFile = new FileOutputStream(emptyFileName);
        emptyFile.close();
        String[] action = new String[]{dirName + fs + "run-cs-cli", "rdmgr", "-q", emptyFileName};
        if (this.isWindows) {
            action[0] = dirName + fs + "run-cs-cli.bat";
            action[1] = "rdmgr.bat";
        }
        Runtime.getRuntime().exec(action);
        action[2] = "-T";
        action[3] = dirName + fs + "config" + fs + "taxonomy.rdm";
        Runtime.getRuntime().exec(action);
    }

    private void createServerRdm(String dirName) throws Exception {
        String line;
        String[] action = new String[]{this.psDirName + fs + "lib" + fs + "buildsd"};
        String[] envs = new String[]{"LD_LIBRARY_PATH=" + this.psDirName + fs + "lib"};
        Process proc = Runtime.getRuntime().exec(action, envs);
        BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(dirName + fs + "config" + fs + "server.rdm")));
        while ((line = br.readLine()) != null) {
            pw.println(line);
        }
        pw.close();
        br.close();
    }

    private void createScript(String dirName, String script, String command) throws Exception {
        String binDirName = this.psDirName + fs + "bin";
        String libDirName = this.psDirName + fs + "lib";
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(dirName + fs + script)));
        if (this.isWindows) {
            pw.println("@echo off");
        } else {
            pw.println("#!/bin/sh");
        }
        pw.println("");
        if (this.isWindows) {
            pw.println("set PATH=" + binDirName + ";" + libDirName + ";%PATH%");
            pw.println("cd \"" + dirName + "\"");
            pw.println(command);
        } else {
            pw.println("LD_LIBRARY_PATH=" + libDirName + ":" + libDirName + fs + "filter" + ":/usr/lib/mps:/usr/lib/lwp:/opt/sun/private/lib:${LD_LIBRARY_PATH}");
            pw.println("export LD_LIBRARY_PATH");
            pw.println("PATH=" + binDirName + ":" + libDirName + ":${PATH}");
            pw.println("export PATH");
            pw.println("cd \"" + dirName + "\"; " + command);
        }
        pw.close();
        if (!this.isWindows) {
            String[] action = new String[]{"/bin/chmod", "700", dirName + fs + script};
            Runtime.getRuntime().exec(action);
        }
    }

    private void createJavaScript(String dirName, String script, String command) throws Exception {
        String binDirName = this.psDirName + fs + "bin";
        String libDirName = this.psDirName + fs + "lib";
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(dirName + fs + script)));
        if (this.isWindows) {
            pw.println("@echo off");
        } else {
            pw.println("#!/bin/sh");
        }
        pw.println("");
        if (this.isWindows) {
            pw.println("set PATH=" + libDirName + ";%PATH%");
        } else {
            pw.println(". " + libDirName + fs + "psEnv.sh");
        }
        String java = this.javaHomeDirName + fs + "bin" + fs + "java ";
        String classpath = "-cp $CLASSPATH:" + libDirName + fs + "searchadmin.jar ";
        String defines = "";
        if (this.isWindows) {
            String winDirName = System.getProperty("os.name").equals("Windows XP") ? "C:\\WINDOWS" : "C:\\WINNT";
            String systemRoot = System.getProperty("SYSTEMROOT");
            if (systemRoot == null) {
                systemRoot = winDirName;
            }
            pw.println("set SYSTEMROOT=" + systemRoot);
            String comSpec = System.getProperty("ComSpec");
            if (comSpec == null) {
                comSpec = winDirName + "\\system32\\cmd.exe";
            }
            pw.println("set COMSPEC=" + comSpec);
            defines = "-DSYSTEMROOT=%SYSTEMROOT% -DCOMSPEC=%COMSPEC% ";
        }
        pw.println(java + classpath + defines + command);
        pw.close();
        if (!this.isWindows) {
            String[] action = new String[]{"/bin/chmod", "700", dirName + fs + script};
            Runtime.getRuntime().exec(action);
        }
    }

    private void createConfigurationFile(String dirName, String fileName) throws Exception {
        String line;
        String binDirName = this.psDirName + fs + "bin";
        String libDirName = this.psDirName + fs + "lib";
        String srcDirName = this.psDirName + fs + "samples" + fs + "config";
        String destDirName = dirName + fs + "config";
        BufferedReader br = new BufferedReader(new FileReader(srcDirName + fs + fileName));
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(destDirName + fs + fileName)));
        while ((line = br.readLine()) != null) {
            line = FileUtil.replaceToken(line, "\\$CSROOT", dirName);
            line = FileUtil.replaceToken(line, "\\$CSBIN", binDirName);
            line = FileUtil.replaceToken(line, "\\$CSLIB", libDirName);
            line = FileUtil.replaceToken(line, "\\$CSJSSNSSLIB", this.jssnssDirName);
            pw.println(line);
        }
        br.close();
        pw.close();
    }

    private void configureWebContainer() throws Exception {
        HashMap<Object, Object> attributes = new HashMap<Object, Object>(this.webContainerProperties);
        WebContainer wc = WebContainerFactory.getWebContainer(attributes, this.logger, true);
        wc.configureSearch(this.psDirName + fs + "lib" + fs + "db.jar", this.configContext);
    }

    private void copyWar() throws Exception {
        String srcDirName = this.psDirName + fs + "export";
        String srcFileName = srcDirName + fs + templateWarfileName;
        String destDirName = this.psDataDirName + fs + searchServerDomainDirName + fs + this.searchServerID + fs + "war";
        String destFileName = destDirName + fs + this.uri + ".war";
        File destFile = new File(destFileName);
        if (destFile.exists()) {
            destFile.delete();
        }
        FileUtil.makeDir(destDirName);
        FileUtil.copyFile(srcFileName, destFileName);
    }

    private void configureWar() throws Exception {
        BufferedInputStream bis;
        JarEntry je;
        String destFileName;
        String srcFileName;
        byte[] buffer;
        String warDirName = this.psDataDirName + fs + searchServerDomainDirName + fs + this.searchServerID + fs + "war";
        File originalFile = new File(warDirName + fs + this.uri + ".war");
        JarFile originalJarFile = new JarFile(originalFile);
        File newFile = new File(warDirName + fs + this.uri + ".war.new");
        JarOutputStream newJarFile = new JarOutputStream(new FileOutputStream(newFile));
        Enumeration<JarEntry> entries = originalJarFile.entries();
        while (entries.hasMoreElements()) {
            int bytesRead;
            JarEntry entry = entries.nextElement();
            InputStream is = originalJarFile.getInputStream(entry);
            if (entry.getName().equals("WEB-INF/web.xml")) {
                String line;
                JarEntry newEntry = new JarEntry("WEB-INF/web.xml");
                newJarFile.putNextEntry(newEntry);
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                StringBuffer sb = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    line = FileUtil.replaceToken(line, "%PS_CONFIG_DIR%", this.psConfDirName);
                    line = FileUtil.replaceToken(line, "%PS_VAR_DIR%", this.psDataDirName);
                    line = FileUtil.replaceToken(line, "%DOMAIN_DIR%", searchServerDomainDirName);
                    line = FileUtil.replaceToken(line, "%SEARCHSERVER_DIR%", this.searchServerID);
                    sb.append(line + "\n");
                }
                newJarFile.write(sb.toString().getBytes(), 0, sb.length());
                continue;
            }
            newJarFile.putNextEntry(entry);
            buffer = new byte[1024];
            while ((bytesRead = is.read(buffer)) != -1) {
                newJarFile.write(buffer, 0, bytesRead);
            }
        }
        try {
            int bytesRead;
            srcFileName = this.configContext.getPrivateSharedLibsDir() + fs + "ktsearch.jar";
            destFileName = "WEB-INF" + fs + "lib" + fs + "ktsearch.jar";
            je = new JarEntry(destFileName);
            newJarFile.putNextEntry(je);
            buffer = new byte[1024];
            bis = new BufferedInputStream(new FileInputStream(srcFileName), buffer.length);
            while ((bytesRead = bis.read(buffer, 0, buffer.length)) != -1) {
                newJarFile.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            int bytesRead;
            srcFileName = this.psDirName + fs + "lib" + fs + "pslogcommon.jar";
            destFileName = "WEB-INF" + fs + "lib" + fs + "pslogcommon.jar";
            je = new JarEntry(destFileName);
            newJarFile.putNextEntry(je);
            buffer = new byte[1024];
            bis = new BufferedInputStream(new FileInputStream(srcFileName), buffer.length);
            while ((bytesRead = bis.read(buffer, 0, buffer.length)) != -1) {
                newJarFile.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        originalJarFile.close();
        newJarFile.close();
        originalFile.delete();
        newFile.renameTo(originalFile);
    }

    private void deployWar() throws Exception {
        String warDirName = this.psDataDirName + fs + searchServerDomainDirName + fs + this.searchServerID + fs + "war";
        HashMap<Object, Object> attributes = new HashMap<Object, Object>(this.webContainerProperties);
        WebContainer wc = WebContainerFactory.getWebContainer(attributes, this.logger, true);
        wc.deploy(warDirName + fs + this.uri + ".war", "/" + this.uri);
        String protocol = (String)attributes.get("Scheme");
        String host = (String)attributes.get("Host");
        String port = (String)attributes.get("Port");
        this.RegisterSearchSearch(protocol + "://" + host + ":" + port + "/" + this.uri);
    }

    private void undeployWar() throws Exception {
        HashMap<Object, Object> attributes = new HashMap<Object, Object>(this.webContainerProperties);
        WebContainer wc = WebContainerFactory.getWebContainer(attributes, this.logger, true);
        wc.undeploy("/" + this.uri);
        String protocol = (String)attributes.get("Scheme");
        String host = (String)attributes.get("Host");
        String port = (String)attributes.get("Port");
        this.UnregisterSearchSearch(protocol + "://" + host + ":" + port + "/" + this.uri);
    }

    private boolean isWindowsOS() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Windows");
    }

    private void RegisterSearchSearch(String url) throws Exception {
        String fileName = this.psDataDirName + fs + searchServerDomainDirName + fs + this.searchServerID + fs + "tmp" + fs + "register.xml";
        File file = new File(fileName);
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        pw.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        pw.println("<!DOCTYPE Requests");
        pw.println("    PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\"");
        pw.println("    \"jar://com/iplanet/am/admin/cli/amAdmin.dtd\"");
        pw.println(">");
        pw.println("<Requests>");
        pw.println("  <SchemaRequests serviceName=\"SunPortalSearchService\" SchemaType=\"global\">");
        pw.println("    <AddDefaultValues>");
        pw.println("      <AttributeValuePair>");
        pw.println("        <Attribute name=\"sunPortalSearchInstances\"/>");
        pw.println("        <Value>" + url + "</Value>");
        pw.println("      </AttributeValuePair>");
        pw.println("    </AddDefaultValues>");
        pw.println("  </SchemaRequests>");
        pw.println("</Requests>");
        pw.close();
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(fileName);
        AMTaskUtil amtu = new AMTaskUtil(this.isBaseDirName, this.amAdminUserDN, this.amAdminPassword, this.logger);
        amtu.execAMRequests(paths);
    }

    private void UnregisterSearchSearch(String url) throws Exception {
        String fileName = this.psDataDirName + fs + searchServerDomainDirName + fs + this.searchServerID + fs + "tmp" + fs + "unregister.xml";
        File file = new File(fileName);
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        pw.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        pw.println("<!DOCTYPE Requests");
        pw.println("    PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\"");
        pw.println("    \"jar://com/iplanet/am/admin/cli/amAdmin.dtd\"");
        pw.println(">");
        pw.println("<Requests>");
        pw.println("  <SchemaRequests serviceName=\"SunPortalSearchService\" SchemaType=\"global\">");
        pw.println("    <RemovePartialDefaultValues>");
        pw.println("      <AttributeValuePair>");
        pw.println("        <Attribute name=\"sunPortalSearchInstances\"/>");
        pw.println("        <Value>" + url + "</Value>");
        pw.println("      </AttributeValuePair>");
        pw.println("    </RemovePartialDefaultValues>");
        pw.println("  </SchemaRequests>");
        pw.println("</Requests>");
        pw.close();
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(fileName);
        AMTaskUtil amtu = new AMTaskUtil(this.isBaseDirName, this.amAdminUserDN, this.amAdminPassword, this.logger);
        amtu.execAMRequests(paths);
    }
}

