/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.sun.portal.fabric.tasks.ConfigurationException;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.util.DTDResolver;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class PortalWar {
    private static final String FS = File.separator;
    private static final char SEPARATOR = '/';
    private static final char DELIMITER = '|';
    private static final String DOCTYPE_PUBLIC = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    private static final String DOCTYPE_SYSTEM = "http://java.sun.com/dtd/web-app_2_3.dtd";
    private String productDir = null;
    private String psDataDir = null;
    private String psConfigDir = null;
    private String shareLibLoc = null;
    private String commonWebSrc = null;
    private String portalDir = null;
    private String searchDir = null;
    private String portalWebSrc = null;
    private String tempDir = null;
    private String tempWebSrc = null;
    private String portalWarDir = null;
    private String portalWar = null;
    private Properties psConfigProps = new Properties();
    private Logger logger = null;

    public PortalWar(String portalId, String psConfigFile, Logger logger) throws ConfigurationException {
        try {
            FileInputStream fis = new FileInputStream(psConfigFile);
            this.psConfigProps.load(fis);
            fis.close();
        }
        catch (IOException ioe) {
            throw new ConfigurationException(ioe);
        }
        this.logger = logger;
        this.productDir = this.psConfigProps.getProperty("ps.product.location");
        this.psDataDir = this.psConfigProps.getProperty("ps.data.location");
        this.psConfigDir = this.psConfigProps.getProperty("ps.config.location");
        this.shareLibLoc = this.psConfigProps.getProperty("shared.lib.location");
        this.tempDir = this.psDataDir + FS + "tmp" + FS + FileUtil.getRandomDirName();
        this.commonWebSrc = this.productDir + FS + "web-src";
        this.tempWebSrc = this.tempDir + FS + "web-src";
        this.portalDir = this.psDataDir + FS + "portals" + FS + portalId;
        this.searchDir = this.psDataDir + FS + "searchservers" + FS + portalId;
        this.portalWebSrc = this.portalDir + FS + "web-src";
    }

    public void create(String warFileName) throws ConfigurationException {
        this.portalWarDir = this.portalDir + FS + "war";
        this.portalWar = warFileName != null && warFileName.endsWith(".war") ? this.portalWarDir + FS + warFileName : this.portalWarDir + FS + "portal.war";
        this.importExternalFiles();
        this.mergeWebXml();
        this.createWarFile();
    }

    private void mergeWebXml() throws ConfigurationException {
        String fName;
        File mergedWebXMLFile;
        ArrayList webXMLFilesVector = new ArrayList(100);
        String webXMLFilesDirPath = this.commonWebSrc + FS + "WEB-INF" + FS + "xml";
        this.logger.log(Level.FINEST, "Getting all files from" + webXMLFilesDirPath + " to create portal war");
        File webXmlFilesDir = new File(webXMLFilesDirPath);
        FileUtil.getFiles(webXmlFilesDir, webXMLFilesVector, "xml");
        webXMLFilesDirPath = this.portalWebSrc + FS + "WEB-INF" + FS + "xml";
        this.logger.log(Level.FINEST, "Getting all files from" + webXMLFilesDirPath + " to create portal war");
        webXmlFilesDir = new File(webXMLFilesDirPath);
        if (webXmlFilesDir.isDirectory()) {
            FileUtil.getFiles(webXmlFilesDir, webXMLFilesVector, "xml");
        }
        if ((mergedWebXMLFile = new File(fName = this.tempWebSrc + FS + "WEB-INF" + FS + "web.xml")).exists()) {
            this.logger.log(Level.FINEST, "Deleting previous file " + fName);
            mergedWebXMLFile.delete();
        }
        this.logger.log(Level.FINEST, "Merging xmls to generate new file " + fName);
        this.mergeWebXMLFiles(webXMLFilesVector, mergedWebXMLFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importExternalFiles() throws ConfigurationException {
        BufferedReader reader = null;
        try {
            try {
                String importFile = this.productDir + FS + "lib" + FS + "war.import";
                this.logger.log(Level.FINEST, "Processing " + importFile);
                File warImport = new File(importFile);
                reader = new BufferedReader(new FileReader(warImport));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#")) {
                        this.logger.log(Level.FINEST, "Skipping comment: " + line);
                        continue;
                    }
                    String[] srcDest = line.split("\\|");
                    if (srcDest.length != 2) {
                        this.logger.log(Level.FINEST, "Skipping incorrect format: " + line);
                        continue;
                    }
                    String src = srcDest[0];
                    String dest = srcDest[1];
                    int index = src.indexOf(47);
                    if (index == -1) {
                        this.logger.log(Level.SEVERE, "Invalid line in war.import: " + line);
                        throw new ConfigurationException("Illegal war.import file");
                    }
                    String key = src.substring(0, index);
                    src = src.substring(index);
                    src = this.psConfigProps.getProperty(key, key) + src;
                    src = src.replace('/', File.separatorChar);
                    dest = this.tempWebSrc + FS + dest;
                    dest = dest.replace('/', File.separatorChar);
                    if (FileUtil.directoryExists(src)) {
                        this.logger.log(Level.FINEST, "Copying " + src + " to " + dest);
                        FileUtil.copyDir(src, dest);
                        continue;
                    }
                    this.logger.log(Level.FINEST, "Copying " + src + " to " + dest);
                    FileUtil.copyFile(src, dest);
                }
                this.logger.log(Level.FINEST, "Completed processing " + importFile);
            }
            catch (FileNotFoundException fex) {
                throw new ConfigurationException(fex.toString());
            }
            catch (IOException ioex) {
                throw new ConfigurationException(ioex.toString());
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new ConfigurationException(ioe.toString());
            }
        }
        try {}
        catch (IOException ioe) {
            throw new ConfigurationException(ioe.toString());
        }
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void createWarFile() throws ConfigurationException {
        ZipOutputStream jar = null;
        try {
            try {
                File psWar = new File(this.portalWar);
                if (psWar.exists()) {
                    this.logger.log(Level.FINEST, "Deleting existing file " + this.portalWar);
                    psWar.delete();
                }
                this.logger.log(Level.FINEST, "Creating file " + psWar);
                FileOutputStream dest = new FileOutputStream(psWar);
                try {
                    jar = new JarOutputStream(new BufferedOutputStream(dest));
                }
                catch (IOException ioe) {
                    dest.close();
                    throw new ConfigurationException(ioe);
                }
                byte[] data = new byte[1024];
                ArrayList fileList = new ArrayList(100);
                ArrayList entryList = new ArrayList(100);
                this.logger.log(Level.FINEST, "Copying " + this.portalWebSrc + " to " + this.tempWebSrc);
                FileUtil.copyDir(this.portalWebSrc, this.tempWebSrc);
                this.logger.log(Level.FINEST, "Copying " + this.commonWebSrc + " to " + this.tempWebSrc);
                FileUtil.copyDir(this.commonWebSrc, this.tempWebSrc);
                this.getFiles(new File(this.tempWebSrc), "", fileList, entryList);
                Iterator fileIter = fileList.iterator();
                Iterator entryIter = entryList.iterator();
                while (fileIter.hasNext() && entryIter.hasNext()) {
                    File file = (File)fileIter.next();
                    JarEntry entry = new JarEntry((String)entryIter.next());
                    ((JarOutputStream)jar).putNextEntry(entry);
                    if (file.isDirectory()) continue;
                    BufferedInputStream origin = new BufferedInputStream(new FileInputStream(file), data.length);
                    try {
                        int bytesRead;
                        while ((bytesRead = origin.read(data, 0, data.length)) != -1) {
                            jar.write(data, 0, bytesRead);
                        }
                    }
                    finally {
                        origin.close();
                        jar.closeEntry();
                    }
                }
                this.logger.log(Level.FINEST, "Created " + this.portalWar);
            }
            catch (IOException ioe) {
                this.logger.log(Level.SEVERE, "Error during war file generation-" + ioe.getMessage());
                throw new ConfigurationException(ioe);
            }
            Object var15_16 = null;
            try {
                try {
                    jar.close();
                }
                catch (IOException ioe) {
                    this.logger.log(Level.SEVERE, "Error during war file generation-" + ioe.getMessage());
                    throw new ConfigurationException(ioe);
                }
                Object var18_18 = null;
                this.logger.log(Level.FINEST, "Deleting dir " + this.tempDir);
                FileUtil.deleteDir(this.tempDir);
                return;
            }
            catch (Throwable throwable) {
                Object var18_19 = null;
                this.logger.log(Level.FINEST, "Deleting dir " + this.tempDir);
                FileUtil.deleteDir(this.tempDir);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            try {}
            catch (Throwable throwable2) {
                Object var18_21 = null;
                this.logger.log(Level.FINEST, "Deleting dir " + this.tempDir);
                FileUtil.deleteDir(this.tempDir);
                throw throwable2;
            }
            try {}
            catch (IOException ioe) {
                this.logger.log(Level.SEVERE, "Error during war file generation-" + ioe.getMessage());
                throw new ConfigurationException(ioe);
            }
            jar.close();
            Object var18_20 = null;
            this.logger.log(Level.FINEST, "Deleting dir " + this.tempDir);
            FileUtil.deleteDir(this.tempDir);
            throw throwable;
        }
    }

    private void getFiles(File startDir, String jarPath, List fileList, List entryList) {
        File[] files = startDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            fileList.add(file);
            if (file.isFile()) {
                entryList.add(jarPath + file.getName());
                continue;
            }
            if (!file.isDirectory()) continue;
            String currPath = jarPath + file.getName() + "/";
            entryList.add(currPath);
            this.getFiles(file, currPath, fileList, entryList);
        }
    }

    private void mergeWebXMLFiles(List webXMLFiles, File mergedWebXMLFile) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            DTDResolver dtdReso = new DTDResolver();
            db.setEntityResolver((EntityResolver)dtdReso);
            db.setErrorHandler((ErrorHandler)dtdReso);
            File webXML = new File(this.commonWebSrc + FS + "WEB-INF" + FS + "xml" + FS + "web.xml");
            Document destDoc = db.parse(new InputSource(new InputStreamReader((InputStream)new FileInputStream(webXML), "UTF-8")));
            webXMLFiles.remove(webXML);
            int iWebXMLFilesSize = webXMLFiles != null ? webXMLFiles.size() : 0;
            for (int i = 0; i < iWebXMLFilesSize; ++i) {
                File currXMLFile = (File)webXMLFiles.get(i);
                FileInputStream currFIS = new FileInputStream(currXMLFile);
                InputStreamReader currISR = new InputStreamReader((InputStream)currFIS, "UTF-8");
                this.logger.log(Level.FINEST, "Parsing File: " + currXMLFile.getName());
                Document doc = db.parse(new InputSource(currISR));
                NodeList nodeList1 = doc.getChildNodes();
                int iNodeList1Size = nodeList1.getLength();
                for (int j = 0; j < iNodeList1Size; ++j) {
                    NodeList nodeList2 = nodeList1.item(j).getChildNodes();
                    int iNodeList2Size = nodeList2.getLength();
                    for (int k = 0; k < iNodeList2Size; ++k) {
                        this.mergeNodesIntoParentDoc(destDoc, nodeList2.item(k));
                    }
                }
            }
            NodeList nodeList1 = destDoc.getChildNodes();
            int iNodeList1Size = nodeList1.getLength();
            for (int i = 0; i < iNodeList1Size; ++i) {
                NodeList nodeList2 = nodeList1.item(i).getChildNodes();
                int iNodeList2Size = nodeList2.getLength();
                for (int j = 0; j < iNodeList2Size; ++j) {
                    Node testNode = nodeList2.item(j);
                    if (!(testNode instanceof Element) || testNode.hasChildNodes()) continue;
                    destDoc.getDocumentElement().removeChild(testNode);
                }
            }
            DocumentType doctype = destDoc.getDoctype();
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("doctype-public", DOCTYPE_PUBLIC);
            t.setOutputProperty("doctype-system", DOCTYPE_SYSTEM);
            DOMSource ds = new DOMSource(destDoc);
            StringWriter sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            t.transform(ds, sr);
            FileOutputStream xmlOutStream = new FileOutputStream(mergedWebXMLFile);
            xmlOutStream.write(sw.getBuffer().toString().getBytes("UTF-8"));
            xmlOutStream.flush();
            xmlOutStream.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Merging WebXML snippets FAILED", e);
        }
    }

    private void mergeNodesIntoParentDoc(Document destDoc, Node node) {
        boolean found = false;
        if (node instanceof Element) {
            String sNodeName = node.getNodeName();
            NodeList nodeList1 = destDoc.getChildNodes();
            int iNodeList1Size = nodeList1.getLength();
            for (int i = 0; i < iNodeList1Size; ++i) {
                NodeList nodeList2 = nodeList1.item(i).getChildNodes();
                int iNodeList2Size = nodeList2.getLength();
                for (int j = 0; j < iNodeList2Size; ++j) {
                    Node testNode = nodeList2.item(j);
                    if (testNode.getNodeName().equals(sNodeName)) {
                        found = true;
                        continue;
                    }
                    if (!found) continue;
                    destDoc.getDocumentElement().insertBefore(destDoc.importNode(node, true), testNode);
                    return;
                }
            }
        }
        if (found) {
            destDoc.getDocumentElement().insertBefore(destDoc.importNode(node, true), null);
        }
    }
}

