/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.fabric.util.os.OSTasks;
import com.sun.portal.fabric.util.os.OSTasksFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortalVersion {
    static final String fs = File.separator;
    private PSConfigContext cc;
    private OSTasks osTasks;
    private Logger logger;

    public PortalVersion(PSConfigContext cc, Logger logger) {
        OSTasksFactory osTasksFactory = OSTasksFactory.getInstance();
        this.cc = cc;
        this.logger = logger;
        this.osTasks = OSTasksFactory.getOSTasks(cc, logger);
    }

    public String getVersion() throws PSMBeanException {
        String psBaseDir = this.cc.getPSBaseDir();
        String psVersionPath = psBaseDir + fs + "lib" + fs + "PSversion.properties";
        File psVersionFile = new File(psVersionPath);
        StringBuffer sb = new StringBuffer(256);
        if (!psVersionFile.exists()) {
            Object[] tokens = new Object[]{psVersionFile};
            throw new PSMBeanException("error.psadmin.file.not.found", tokens);
        }
        String build = FileUtil.findTextInFile(psVersionFile, "build=");
        String productName = FileUtil.findTextInFile(psVersionFile, "productname=");
        String productVersion = FileUtil.findTextInFile(psVersionFile, "productversion=");
        sb.append(build.substring(6)).append(" ").append(productName.substring(12)).append(" ").append(productVersion.substring(15));
        return sb.toString();
    }

    public String getVersionFromJar(String jarFilePath) throws PSMBeanException {
        StringBuffer sb;
        block9: {
            sb = new StringBuffer(256);
            String versionFilePath = null;
            try {
                versionFilePath = "META-INF" + fs + "MANIFEST.MF";
                File versionFile = FileUtil.extractFileFromJar(jarFilePath, versionFilePath);
                if (versionFile.exists()) {
                    String build = FileUtil.findTextInFile(versionFile, "Created-At:");
                    String productName = FileUtil.findTextInFile(versionFile, "Product:");
                    String productVersion = FileUtil.findTextInFile(versionFile, "Version:");
                    while (productVersion != null && productVersion.length() >= 7 && !productVersion.substring(0, 7).equals("Version")) {
                        FileUtil.deleteLineInFile(versionFile, productVersion.substring(0, 6));
                        productVersion = FileUtil.findTextInFile(versionFile, "Version:");
                    }
                    if (build != null && build.length() >= 12) {
                        sb.append(build.substring(12)).append(" ");
                    }
                    if (productName != null && build.length() >= 9) {
                        sb.append(productName.substring(9)).append(" ");
                    }
                    if (productVersion != null && productVersion.length() >= 9) {
                        sb.append(productVersion.substring(9));
                    }
                    if (sb.toString().length() <= 0) {
                        Object[] tokens = new Object[]{jarFilePath};
                        throw new PSMBeanException("admin.error.version.info.not.found", tokens);
                    }
                    break block9;
                }
                Object[] tokens = new Object[]{jarFilePath};
                throw new PSMBeanException("admin.error.version.info.not.found", tokens);
            }
            catch (FileNotFoundException fe) {
                Object[] tokens = new Object[]{versionFilePath};
                this.logger.log(Level.SEVERE, "Failure in getting the Portal Server Version from jar", fe);
                throw new PSMBeanException("admin.error.version.file.not.found", tokens);
            }
            catch (IOException ie) {
                Object[] tokens = new Object[]{jarFilePath};
                this.logger.log(Level.SEVERE, "Failure in getting the Portal Server Version from jar", ie);
                throw new PSMBeanException("admin.error.version.info.not.found", tokens);
            }
        }
        return sb.toString();
    }

    public String getPatchInfo() throws PSMBeanException {
        String patchInfo = this.osTasks.getPatchInfo();
        if (patchInfo != null && patchInfo.length() != 0) {
            return patchInfo;
        }
        throw new PSMBeanException("admin.error.patch.info.not.found");
    }

    public String getPatchVerbose() throws PSMBeanException {
        String patchInfo = this.osTasks.getPatchVerbose();
        if (patchInfo != null && patchInfo.length() != 0) {
            return patchInfo;
        }
        throw new PSMBeanException("admin.error.patch.info.not.found");
    }
}

