/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.fabric.tasks.ConfigurationException;
import com.sun.portal.fabric.tasks.MonitoringConfigurationHelper;
import com.sun.portal.fabric.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortalInstance {
    private String portalID;
    private String instanceID;
    private String host;
    private String containerType;
    private PSConfigContext context;
    private Logger logger;
    public static final String fs = File.separator;

    public PortalInstance(String portalID, String instanceID, String host, String containerType, PSConfigContext context, Logger logger) {
        this.portalID = portalID;
        this.instanceID = instanceID;
        this.host = host;
        this.containerType = containerType;
        this.context = context;
        this.logger = logger;
    }

    public void setupInstanceConfigFiles() throws ConfigurationException {
        String portalDir = this.context.getPSDataDir() + fs + "portals" + fs + this.portalID;
        String portalConfigDir = portalDir + fs + "config";
        String instConfigDir = portalConfigDir + fs + this.instanceID;
        String instTemplateDir = this.context.getPSBaseDir() + fs + "template" + fs + "instance";
        File iconfDir = new File(instConfigDir);
        iconfDir.mkdirs();
        FileUtil.makeDir(instConfigDir);
        this.copyInstanceConfigurationFiles(instTemplateDir, instConfigDir);
        ArrayList files = new ArrayList();
        if (FileUtil.getFiles(iconfDir, files)) {
            for (int i = 0; i < files.size(); ++i) {
                File configFile = (File)files.get(i);
                String[] tokens = new String[]{"%PORTAL_ID%", "%PORTAL_DIR%", "%PORTAL_CONFIG_DIR%", "%INSTANCE_ID%", "%INSTANCE_CONFIG_DIR%", "%PS_DIR%"};
                String[] values = new String[]{this.portalID, portalDir, portalConfigDir, this.instanceID, instConfigDir, this.context.getPSBaseDir()};
                boolean replaced = FileUtil.replaceTokensInFile(configFile, tokens, values);
                if (replaced) continue;
                this.logger.log(Level.SEVERE, "Failed to replace tokens in " + configFile.getAbsolutePath());
                throw new ConfigurationException("Failed to replace tokens in " + configFile.getAbsolutePath());
            }
        } else {
            this.logger.log(Level.SEVERE, "Failed to copy portal instance configuration templates");
            throw new ConfigurationException("Failed to copy portal instance configuration templates");
        }
        this.configureMonitoring();
    }

    private void copyInstanceConfigurationFiles(String instanceTemplateDir, String instanceConfigDir) {
        int i;
        File templateDir = new File(instanceTemplateDir);
        ArrayList templateFiles = new ArrayList();
        ArrayList<String> srcFiles = new ArrayList<String>();
        ArrayList<String> dstFiles = new ArrayList<String>();
        if (FileUtil.getFiles(templateDir, templateFiles)) {
            for (i = 0; i < templateFiles.size(); ++i) {
                File file = (File)templateFiles.get(i);
                String fileName = file.getName();
                String filePfx = fileName.substring(0, fileName.indexOf(46));
                String fileSfx = fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length());
                String instConfFile = filePfx + "." + this.containerType + "." + fileSfx;
                String defConfFile = filePfx + "." + fileSfx;
                if (FileUtil.fileExists(instanceTemplateDir + fs + instConfFile)) {
                    if (srcFiles.contains(instConfFile)) continue;
                    srcFiles.add(instConfFile);
                    dstFiles.add(defConfFile);
                    continue;
                }
                if (!FileUtil.fileExists(instanceTemplateDir + fs + defConfFile) || srcFiles.contains(defConfFile)) continue;
                srcFiles.add(defConfFile);
                dstFiles.add(defConfFile);
            }
        }
        for (i = 0; i < srcFiles.size(); ++i) {
            FileUtil.copyFile(instanceTemplateDir + fs + (String)srcFiles.get(i), instanceConfigDir + fs + (String)dstFiles.get(i));
        }
    }

    private void configureMonitoring() {
        String monPropFile = this.context.getPSDataDir() + fs + "portals" + fs + this.portalID + fs + "config" + fs + this.instanceID + fs + "monitoring.properties";
        MonitoringConfigurationHelper.configurePropertyFile(monPropFile, this.host, this.context, this.logger);
    }
}

