/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class PortalFileHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFilesystem(String portalDir, String output, Logger logger) {
        block12: {
            if (!portalDir.endsWith(File.separator)) {
                portalDir = portalDir + File.separator;
            }
            File outputFile = new File(output);
            ArrayList fileList = new ArrayList(100);
            PortalFileHandler.getFiles(new File(portalDir), fileList);
            try {
                if (outputFile.exists()) {
                    outputFile.delete();
                }
                byte[] buf = new byte[1024];
                FileOutputStream dest = new FileOutputStream(output);
                ZipOutputStream out = new ZipOutputStream(dest);
                try {
                    Iterator itr = fileList.iterator();
                    while (itr.hasNext()) {
                        File file = (File)itr.next();
                        String fpath = file.getAbsolutePath();
                        FileInputStream in = new FileInputStream(fpath);
                        String zipEntryPath = fpath.replaceAll(portalDir, "");
                        try {
                            int len;
                            out.putNextEntry(new ZipEntry(zipEntryPath));
                            while ((len = in.read(buf)) > 0) {
                                out.write(buf, 0, len);
                            }
                        }
                        finally {
                            out.closeEntry();
                            in.close();
                        }
                    }
                }
                finally {
                    out.close();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error occured creating zipFile", e);
                if (!outputFile.exists()) break block12;
                outputFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFilesystem(String portalDir, String portalZip, Logger logger) {
        if (!portalDir.endsWith(File.separator)) {
            portalDir = portalDir + File.separator;
        }
        try {
            ZipFile zip = new ZipFile(portalZip);
            Enumeration<? extends ZipEntry> en = zip.entries();
            try {
                while (en.hasMoreElements()) {
                    ZipEntry entry = en.nextElement();
                    if (entry == null) continue;
                    InputStream entryStream = zip.getInputStream(entry);
                    try {
                        File outFile = new File(portalDir + entry.getName());
                        File parent = outFile.getParentFile();
                        if (!parent.exists()) {
                            parent.mkdirs();
                        }
                        FileOutputStream file = new FileOutputStream(outFile);
                        try {
                            int bytesRead;
                            byte[] buffer = new byte[1024];
                            while ((bytesRead = entryStream.read(buffer)) != -1) {
                                file.write(buffer, 0, bytesRead);
                            }
                        }
                        finally {
                            file.close();
                        }
                    }
                    finally {
                        entryStream.close();
                    }
                }
            }
            finally {
                zip.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error occured creating zipFile", e);
        }
    }

    private static void getFiles(File startDir, List fileList) {
        File[] files = startDir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    PortalFileHandler.getFiles(file, fileList);
                    continue;
                }
                fileList.add(file);
            }
        }
    }
}

