/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.iplanet.sso.SSOToken;
import com.sun.portal.fabric.tasks.ConfigurationException;
import com.sun.portal.fabric.util.AMUtil;
import com.sun.portal.fabric.util.AntUtil;
import com.sun.portal.fabric.util.ClasspathGenUtil;
import com.sun.portal.fabric.util.ExecuteUtil;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.fabric.util.LogConfigUtil;
import com.sun.portal.util.LDAPUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class Portal {
    private String isBaseDir;
    private String psBaseDir;
    private String psDataDir;
    private String psConfigDir;
    private String psExportLocation;
    private String psLibLocation;
    private String psTmpDir;
    private Logger logger;
    public static final String fs = File.separator;
    private AntUtil antUtil;

    public Portal(String psBaseDir, String psDataDir, String psConfigDir, String isBaseDir, Logger logger) {
        this.psBaseDir = psBaseDir;
        this.psDataDir = psDataDir;
        this.psConfigDir = psConfigDir;
        this.isBaseDir = isBaseDir;
        this.logger = logger;
        this.psExportLocation = psBaseDir + fs + "export";
        this.psLibLocation = psBaseDir + fs + "lib";
        this.psTmpDir = psDataDir + fs + "tmp";
        this.antUtil = new AntUtil(psDataDir);
    }

    public void configurePortal(String portalID, SSOToken ssoToken, String dsHost, String dsPort, String userDataStoreMgr, String userDataStoreMgrCredentials, boolean dsSecure) throws ConfigurationException {
        String[] tokens = new String[]{"%PORTAL_ID%"};
        String tValue = "Upgraded".equals(portalID) ? "" : portalID;
        String[] values = new String[]{tValue};
        String randomDir = FileUtil.getRandomDirName();
        String cPortalTmpDirLoc = this.psTmpDir + fs + randomDir;
        this.logger.log(Level.FINEST, "Creating temp dir " + cPortalTmpDirLoc + " for portal " + portalID);
        File cPortalTmpDir = new File(cPortalTmpDirLoc);
        if (!cPortalTmpDir.mkdirs()) {
            throw new ConfigurationException("Could not create directory " + cPortalTmpDirLoc);
        }
        LDAPConnection conn = LDAPUtil.getLDAPConnection((String)dsHost, (String)dsPort, (String)userDataStoreMgr, (String)userDataStoreMgrCredentials, (boolean)dsSecure);
        try {
            Set portalSvcs = this.getPortalServices();
            Iterator svcsItr = portalSvcs.iterator();
            this.logger.log(Level.FINEST, "Parsing the file that associates Services to LDIF");
            String svcLDIFMapperLocation = this.psLibLocation + fs + "ServiceLDIFMap.properties";
            Properties svcToLDIFFileMap = new Properties();
            svcToLDIFFileMap.load(new FileInputStream(svcLDIFMapperLocation));
            this.logger.log(Level.FINEST, "Parsing the file that associate Services to XMLs");
            String svcXMLMapperLocation = this.psLibLocation + fs + "ServiceXMLMap.properties";
            Properties svcToXmlFileMap = new Properties();
            svcToXmlFileMap.load(new FileInputStream(svcXMLMapperLocation));
            HashSet<String> svcXmlFilePaths = new HashSet<String>();
            while (svcsItr.hasNext()) {
                String copyToPath;
                String svcName = (String)svcsItr.next();
                String svcLDIFFile = svcToLDIFFileMap.getProperty(svcName, "");
                svcLDIFFile.trim();
                String[] ldifFileNames = null;
                if (svcLDIFFile.length() > 0) {
                    ldifFileNames = svcLDIFFile.split("[\\s]+");
                }
                int iSize0 = ldifFileNames != null ? ldifFileNames.length : 0;
                for (int i = 0; i < iSize0; ++i) {
                    String svcLDIFFileName = ldifFileNames[i];
                    String svcLDIFPath = this.psExportLocation + fs + "ldif" + fs + svcLDIFFileName;
                    copyToPath = cPortalTmpDirLoc + fs + svcLDIFFileName;
                    File svcLDIF = new File(svcLDIFPath);
                    File copiedLDIFFile = new File(copyToPath);
                    FileUtil.copyFile(svcLDIF, copiedLDIFFile);
                    FileUtil.replaceTokensInFile(copiedLDIFFile, tokens, values);
                    this.logger.log(Level.FINEST, "Loading Objectclasses defined in: " + copiedLDIFFile);
                    try {
                        LDAPUtil.loadLDIF((String)copyToPath, (LDAPConnection)conn);
                        continue;
                    }
                    catch (LDAPException ldape) {
                        throw new ConfigurationException("Failed to load objectclasses", ldape);
                    }
                }
                String svcSchemaXMLFile = svcToXmlFileMap.getProperty(svcName, "");
                if (!svcSchemaXMLFile.equals("")) {
                    String svcXMLFilePath = this.psExportLocation + fs + "service" + fs + svcSchemaXMLFile;
                    File svcXMLFile = new File(svcXMLFilePath);
                    if (svcXMLFile.exists()) {
                        copyToPath = cPortalTmpDirLoc + fs + svcSchemaXMLFile;
                        File copiedSvcXMLFile = new File(copyToPath);
                        this.logger.log(Level.FINEST, "Copying file: " + svcXMLFile + "To :" + copiedSvcXMLFile);
                        FileUtil.copyFile(svcXMLFile, copiedSvcXMLFile);
                        this.logger.log(Level.FINEST, "Tag Swapping file: " + copiedSvcXMLFile);
                        FileUtil.replaceTokensInFile(copiedSvcXMLFile, tokens, values);
                        this.logger.log(Level.FINEST, "Added" + copiedSvcXMLFile + "to list of services that will be loaded");
                        svcXmlFilePaths.add(copyToPath);
                        continue;
                    }
                    this.logger.log(Level.INFO, "Schema XML file associated with Service:" + svcName + " is not installed");
                    continue;
                }
                this.logger.log(Level.SEVERE, "No Schema XML file associated with Service:" + svcName);
            }
            this.logger.log(Level.FINEST, "Loading Svcs for portal:" + portalID);
            AMUtil.loadServiceSchema(svcXmlFilePaths, ssoToken);
            this.logger.log(Level.FINEST, "Loading I18N for Portal" + portalID);
            File rbLoc = new File(this.psExportLocation + fs + "locale");
            File[] localeFileList = rbLoc.listFiles();
            for (int i = 0; i < localeFileList.length; ++i) {
                try {
                    String fname = localeFileList[i].getName();
                    String fPath = localeFileList[i].getAbsolutePath();
                    String fileLocale = null;
                    if (!fname.startsWith("psPortalServices") || !fname.endsWith(".properties")) continue;
                    Properties props = new Properties();
                    FileInputStream fis = new FileInputStream(fPath);
                    props.load(fis);
                    Set<Object> keys = props.keySet();
                    Iterator<Object> itr = keys.iterator();
                    while (itr.hasNext()) {
                        String key = (String)itr.next();
                        String value = props.getProperty(key);
                        value = value.replaceAll("%PORTAL_ID%", portalID);
                        props.setProperty(key, value);
                    }
                    int beginFileLocale = fname.indexOf(95) + 1;
                    int endFileLocale = fname.indexOf(".properties");
                    if (beginFileLocale > 0) {
                        fileLocale = fname.substring(beginFileLocale, endFileLocale);
                    }
                    String resBndleName = "ps" + portalID + "Services";
                    AMUtil.addResourceBundle(resBndleName, fileLocale, props, ssoToken);
                    continue;
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Loading Locale Failed", e);
                }
            }
            this.logger.log(Level.FINEST, "Deleting temp dir " + cPortalTmpDirLoc + "created for portal " + portalID);
            if (!FileUtil.deleteDir(cPortalTmpDirLoc)) {
                this.logger.log(Level.SEVERE, "Could not delete directory " + cPortalTmpDirLoc);
            }
            String portalDir = this.psDataDir + fs + "portals" + fs + portalID;
            String portalWARDir = portalDir + fs + "war";
            File warDir = new File(portalWARDir);
            warDir.mkdirs();
            String consoleWar = "psconsole.war";
            String consoleWarSrc = this.psBaseDir + fs + "admin" + fs + consoleWar;
            if (new File(consoleWarSrc).exists()) {
                FileUtil.copyFile(consoleWarSrc, portalWARDir + fs + consoleWar);
            }
            this.setupPortalConfigFiles(portalID);
            String configDataDir = portalDir + fs + "config";
            this.configureBackend(configDataDir);
        }
        catch (FileNotFoundException fnfe) {
            throw new ConfigurationException("Configuration Files are missing", fnfe);
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Failed to read configuration", ioe);
        }
    }

    private void setupPortalConfigFiles(String portalID) throws IOException {
        String psConfigPath = this.psConfigDir + fs + "PSConfig.properties";
        String portalDir = this.psDataDir + fs + "portals" + fs + portalID;
        String portalConfigDir = portalDir + fs + "config";
        String portalTemplateDir = this.psBaseDir + fs + "template" + fs + "portal";
        String derbyPropPath = this.psDataDir + fs + "derby" + fs + "derby.properties";
        File pcDir = new File(portalConfigDir);
        pcDir.mkdirs();
        FileUtil.copyDir(portalTemplateDir, portalConfigDir);
        Properties derbyProps = new Properties();
        derbyProps.load(new FileInputStream(derbyPropPath));
        Properties psConfig = new Properties();
        psConfig.load(new FileInputStream(psConfigPath));
        String derbyHostName = derbyProps.getProperty("derby.drda.host", "localhost");
        String derbyPort = derbyProps.getProperty("derby.drda.portNumber", "1527");
        String derbyDriverLoc = psConfig.getProperty("derby.lib.location", "");
        String[] tmpTokens = new String[]{"%PORTAL_ID%", "%PS_CONFIG_DIR%", "%DERBY_HOST%", "%DERBY_PORT%", "%DERBY_LIB_DIR%"};
        String[] tmpValues = new String[]{portalID, this.psConfigDir, derbyHostName, derbyPort, derbyDriverLoc};
        File tokensPropFile = new File(portalConfigDir + fs + "tokens.properties");
        FileUtil.replaceTokensInFile(tokensPropFile, tmpTokens, tmpValues);
        HashMap<Object, Object> tokenMap = new HashMap<Object, Object>();
        tokenMap.put("%PS_DIR%", this.psBaseDir);
        tokenMap.put("%PS_VAR_DIR%", this.psDataDir);
        tokenMap.put("%PORTAL_DIR%", portalDir);
        tokenMap.put("%PORTAL_CONFIG_DIR%", portalConfigDir);
        tokenMap.put("%PORTAL_ID%", portalID);
        if (tokensPropFile.exists()) {
            Properties tokenProp = new Properties();
            tokenProp.load(new FileInputStream(tokensPropFile));
            tokenMap.putAll(tokenProp);
            tokensPropFile.delete();
        }
        this.logger.log(Level.FINEST, "Portal Configuartion Tokens/Value Map: " + tokenMap);
        String[] tokens = new String[tokenMap.size()];
        String[] values = new String[tokenMap.size()];
        Iterator itr = tokenMap.entrySet().iterator();
        int ctr = 0;
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            tokens[ctr] = (String)entry.getKey();
            values[ctr] = (String)entry.getValue();
            ++ctr;
        }
        ArrayList files = new ArrayList();
        if (FileUtil.getFiles(pcDir, files)) {
            for (int i = 0; i < files.size(); ++i) {
                File configFile = (File)files.get(i);
                boolean replaced = FileUtil.replaceTokensInFile(configFile, tokens, values);
                if (replaced) continue;
                this.logger.log(Level.SEVERE, "Failed to replace tokens in " + configFile.getAbsolutePath());
                throw new IOException("Failed to replace tokens in " + configFile.getAbsolutePath());
            }
        } else {
            this.logger.log(Level.SEVERE, "Failed to copy portal configuration templates");
            throw new IOException("Failed to copy portal configuration templates");
        }
        String desktopConfigDest = portalConfigDir + fs + "desktopconfig.properties";
        File desktopConfig = new File(desktopConfigDest);
        String templateDir = portalDir + fs + "desktop";
        String cpath = ClasspathGenUtil.getClasspath("jspcompiler.classpath", true);
        cpath = templateDir + "/default/tld:" + cpath;
        FileUtil.replaceTokenInFile(desktopConfig, "jspCompilerWARClassPath=", "jspCompilerWARClassPath=" + cpath);
        this.logger.log(Level.FINEST, "Replaced tokens in " + desktopConfig);
        LogConfigUtil.createPortalLogConfigFile(this.psBaseDir, this.psDataDir, portalID);
        this.logger.log(Level.FINEST, "Created portal log config file PSLogConfig.properties");
    }

    private Set getPortalServices() throws IOException {
        this.logger.log(Level.FINEST, "Fetching the list of Portal Services");
        String svcConfLocation = this.psLibLocation + fs + "PSServiceConfig.properties";
        Properties svcConf = new Properties();
        svcConf.load(new FileInputStream(svcConfLocation));
        String portalSvcList = svcConf.getProperty("PortalServices", "");
        portalSvcList.trim();
        String[] portalSvc = null;
        if (portalSvcList.length() > 0) {
            portalSvc = portalSvcList.split("[\\s]+");
        }
        int iSize0 = portalSvc != null ? portalSvc.length : 0;
        HashSet<String> portalSvcs = new HashSet<String>();
        for (int i = 0; i < iSize0; ++i) {
            portalSvcs.add(portalSvc[i]);
        }
        return portalSvcs;
    }

    public String createDesktopPar() throws ConfigurationException {
        String createPar = this.psBaseDir + fs + "bin" + fs + "psadmin";
        String desktopParSrc = this.psBaseDir + fs + "par-src" + fs + "default-portal";
        String desktopParLoc = this.psTmpDir + fs + "desktop.par";
        File desktopParFile = new File(desktopParLoc);
        if (desktopParFile.exists()) {
            desktopParFile.delete();
        }
        ExecuteUtil execUtil = new ExecuteUtil(this.logger);
        execUtil.storeOutput(true);
        String[] args = new String[]{"create-par", "--dir", desktopParSrc, desktopParLoc};
        execUtil.exec(createPar, args);
        if (desktopParFile.exists()) {
            return desktopParFile.getPath();
        }
        throw new ConfigurationException("Errors Creating PAR file");
    }

    public void configureBackend(String configDataDir) {
        try {
            File sqlFile = new File(configDataDir + fs + "00community.sql");
            File dbadminFile = new File(configDataDir + fs + "portal.dbadmin");
            if (sqlFile.exists() && dbadminFile.exists()) {
                File file = File.createTempFile("backend", ".xml");
                FileWriter fw = new FileWriter(file);
                fw.write("<project name=\"sqlframework\" default=\"init\" basedir=\".\">\n");
                fw.write("  <target name=\"init\">\n");
                fw.write("      <property name=\"build.dir\" value=\"" + configDataDir + "\"/>\n");
                fw.write("      <available file=\"${build.dir}/config.xml\" property=\"xml.present\"/>\n");
                fw.write("  </target>\n");
                fw.write("  <target name=\"execute_sql\" depends=\"init\">\n");
                fw.write("      <property file=\"${build.dir}/portal.dbadmin\"/>\n");
                fw.write("      <sql\n");
                fw.write("          driver=\"${db.driver}\"\n");
                fw.write("          url=\"${community.db.url}\"\n");
                fw.write("          userid=\"${community.db.user}\"\n");
                fw.write("          password=\"${community.db.password}\"\n");
                fw.write("          classpath=\"${db.driver.classpath}\">\n");
                fw.write("          <fileset dir=\"${build.dir}\">\n");
                fw.write("              <include name=\"*.sql\"/>\n");
                fw.write("          </fileset>\n");
                fw.write("      </sql>\n");
                fw.write("  </target>\n");
                fw.write("  <target name=\"config_backend\" if=\"xml.present\" depends=\"execute_sql\">\n");
                fw.write("      <ant antfile=\"${build.dir}/config.xml\" target=\"configure\"/>\n");
                fw.write("  </target>\n");
                fw.write("</project>\n");
                fw.close();
                if (file.exists()) {
                    Vector<String> targets = new Vector<String>();
                    targets.add("config_backend");
                    this.antUtil.runant(file.getAbsolutePath(), targets, "config.backend", null, null);
                }
            } else {
                this.logger.log(Level.INFO, configDataDir + fs + "00community.sql" + " & " + configDataDir + fs + "portal.dbadmin" + " does not exists.");
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "config_backend failed" + e);
        }
    }

    public void unconfigurePortal(String portalID, SSOToken ssoToken) throws ConfigurationException {
        try {
            Set portalSvcs = this.getPortalServices();
            HashSet<String> toDelete = new HashSet<String>();
            Iterator iter = portalSvcs.iterator();
            while (iter.hasNext()) {
                String svcName = (String)iter.next();
                svcName = svcName.replaceAll("%PORTAL_ID%", portalID);
                toDelete.add(svcName);
            }
            this.logger.log(Level.FINEST, "Deleting Services for Portal=" + portalID);
            AMUtil.deleteServiceSchema(toDelete, ssoToken);
            String portalRBName = "ps" + portalID + "Services";
            AMUtil.removeResourceBundle(portalRBName, null, ssoToken);
            this.logger.log(Level.FINEST, "Deleting File data Portal=" + portalID);
            String portalDir = this.psDataDir + fs + "portals" + fs + portalID;
            FileUtil.deleteDir(portalDir);
        }
        catch (FileNotFoundException fnfe) {
            throw new ConfigurationException("Configuration Files are missing", fnfe);
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Failed to read configuration", ioe);
        }
    }
}

