/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.fabric.util.ClasspathGenUtil;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.fabric.util.NetworkUtil;
import com.sun.portal.monitoring.MonitoringConfiguration;
import com.sun.portal.monitoring.MonitoringException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MonitoringConfigurationHelper {
    public static String fs = File.separator;
    private static String KEY_JMX_MP_PORT = "com.sun.portal.monitoring.security.ssl.SslContext.port";
    private static String KEY_NEXT_AVAIL_JMX_MP_PORT = "com.sun.portal.fabric.tasks.MonitoringConfigurationHelper.ssl.SslContext.next.available.port";

    public static void configurePropertyFile(String monitoringPropertiesFile, String host, PSConfigContext context, Logger logger) {
        try {
            String nonDelegateesKey;
            String nonDelegatees;
            String delegateesKey;
            String delegatees;
            String monitoringPortConfigFile = context.getPSConfigDir() + fs + "MonitoringPortConfig.properties";
            Properties portConfigProperties = new Properties();
            portConfigProperties.load(new FileInputStream(monitoringPortConfigFile));
            Properties properties = new Properties();
            properties.load(new FileInputStream(monitoringPropertiesFile));
            String nextAvailableJmxMpPort = portConfigProperties.getProperty(KEY_NEXT_AVAIL_JMX_MP_PORT);
            String jmxMpPort = properties.getProperty(KEY_JMX_MP_PORT);
            nextAvailableJmxMpPort = NetworkUtil.getNextAvailablePort(host, nextAvailableJmxMpPort);
            if (nextAvailableJmxMpPort != null && !nextAvailableJmxMpPort.equals(jmxMpPort)) {
                FileUtil.replaceTokenInFile(new File(monitoringPropertiesFile), jmxMpPort, nextAvailableJmxMpPort);
                logger.log(Level.INFO, "Configured JMX MP port in <" + monitoringPropertiesFile + "> as " + nextAvailableJmxMpPort);
            }
            int nextPort = 0;
            try {
                nextPort = Integer.parseInt(nextAvailableJmxMpPort) + 1;
                FileUtil.replaceTokenInFile(new File(monitoringPortConfigFile), nextAvailableJmxMpPort, new Integer(nextPort).toString());
                logger.log(Level.INFO, "Next available JMX MP port is set as " + nextPort);
            }
            catch (NumberFormatException nfe) {
                logger.log(Level.SEVERE, "Failed to update port in " + monitoringPortConfigFile, nfe);
            }
            String contextCPKey = "com.sun.portal.monitoring.MonitoringContext.class.path";
            String contextCP = properties.getProperty(contextCPKey);
            if (contextCP != null && !contextCP.trim().equals("")) {
                String tagSwappedContextCP = ClasspathGenUtil.tagSwapClasspath(contextCP);
                logger.log(Level.INFO, "key:" + contextCPKey + ":value:" + tagSwappedContextCP);
                FileUtil.replaceLineInFile(new File(monitoringPropertiesFile), contextCPKey + "=", contextCPKey + "=" + tagSwappedContextCP);
            }
            if ((delegatees = properties.getProperty(delegateesKey = "com.sun.portal.monitoring.MonitoringContext.class.path.delegatees")) != null) {
                String tagSwappedDelegatees = ClasspathGenUtil.tagSwapClasspath(delegatees);
                logger.log(Level.INFO, "key:" + delegateesKey + ":value:" + tagSwappedDelegatees);
                if (!delegatees.equals(tagSwappedDelegatees)) {
                    FileUtil.replaceLineInFile(new File(monitoringPropertiesFile), delegateesKey + "=", delegateesKey + "=" + tagSwappedDelegatees);
                }
            }
            if ((nonDelegatees = properties.getProperty(nonDelegateesKey = "com.sun.portal.monitoring.MonitoringContext.class.path.non.delegatees")) != null) {
                String tagSwappedNonDelegatees = ClasspathGenUtil.tagSwapClasspath(nonDelegatees);
                logger.log(Level.INFO, "key:" + nonDelegateesKey + ":value:" + tagSwappedNonDelegatees);
                if (!nonDelegatees.equals(tagSwappedNonDelegatees)) {
                    FileUtil.replaceLineInFile(new File(monitoringPropertiesFile), nonDelegateesKey + "=", nonDelegateesKey + "=" + tagSwappedNonDelegatees);
                }
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Failed to configure Monitoring properties " + monitoringPropertiesFile, ex);
        }
        try {
            MonitoringConfiguration mconfig = new MonitoringConfiguration();
            String[] params = new String[]{monitoringPropertiesFile, "setUp"};
            logger.log(Level.INFO, "Calling MonitoringConfiguration to setUp with:" + monitoringPropertiesFile);
            mconfig.process(params);
        }
        catch (MonitoringException mex) {
            logger.log(Level.SEVERE, "Failed to configure Monitoring:" + monitoringPropertiesFile, mex);
        }
    }
}

